/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.typescript.modules;

import com.intellij.javascript.nodejs.PackageJsonData;
import com.intellij.lang.javascript.frameworks.modules.JSModulePathSubstitution;
import com.intellij.lang.javascript.frameworks.modules.JSPathMappingsUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.ObjectUtils;
import com.intellij.util.text.SemVer;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class TypeScriptTypingsMapper {
    private static final String PACKAGE_JSON = "package.json";
    private static final String TYPESCRIPT_PACKAGE = "typescript";

    @Contract(value="!null,_,_,_->!null")
    public static String substituteTypings(@Nullable String path2, @NotNull VirtualFile packageJson, @NotNull PackageJsonData data, boolean useTypeScriptPackage) {
        Map<String, List<JSModulePathSubstitution>> mappings;
        if (packageJson == null) {
            TypeScriptTypingsMapper.$$$reportNull$$$0(0);
        }
        if (data == null) {
            TypeScriptTypingsMapper.$$$reportNull$$$0(1);
        }
        if ((mappings = data.getTypingsVersionMappings()).isEmpty()) {
            return path2;
        }
        if (Objects.equals(data.getName(), "@types/react")) {
            return path2;
        }
        VirtualFile module = packageJson.getParent();
        SemVer tsVersion = TypeScriptTypingsMapper.detectTypeScriptVersion(module, useTypeScriptPackage);
        if (tsVersion == null) {
            return path2;
        }
        for (Map.Entry<String, List<JSModulePathSubstitution>> entry : mappings.entrySet()) {
            String version2 = entry.getKey();
            if (!new TypeScriptRange(version2).isMatched(tsVersion)) continue;
            return JSPathMappingsUtil.substituteStarForMapping(StringUtil.trimStart((String)((String)ObjectUtils.notNull((Object)path2, (Object)"index")), (String)"./"), entry.getValue());
        }
        return path2;
    }

    @Nullable
    public static SemVer detectTypeScriptVersion(@Nullable VirtualFile module, boolean useTypeScriptPackage) {
        if (module == null) {
            return null;
        }
        VirtualFile nodeModulesCandidate = module.getParent();
        if (!"node_modules".contentEquals(nodeModulesCandidate.getNameSequence())) {
            nodeModulesCandidate = nodeModulesCandidate.getParent();
        }
        if (nodeModulesCandidate == null) {
            return null;
        }
        return TypeScriptTypingsMapper.detectTypeScriptSemVer(nodeModulesCandidate, useTypeScriptPackage);
    }

    @NotNull
    private static SemVer detectTypeScriptSemVer(@NotNull VirtualFile nodeModules, boolean checkTypeScriptPackage) {
        PackageJsonData packageJsonData;
        SemVer semVer;
        VirtualFile packageJson;
        VirtualFile typescript;
        if (nodeModules == null) {
            TypeScriptTypingsMapper.$$$reportNull$$$0(2);
        }
        if (checkTypeScriptPackage && (typescript = nodeModules.findChild(TYPESCRIPT_PACKAGE)) != null && (packageJson = typescript.findChild(PACKAGE_JSON)) != null && (semVer = (packageJsonData = PackageJsonData.getOrCreate(packageJson)).getVersion()) != null) {
            SemVer semVer2 = semVer;
            if (semVer2 == null) {
                TypeScriptTypingsMapper.$$$reportNull$$$0(3);
            }
            return semVer2;
        }
        SemVer semVer3 = Objects.requireNonNull(SemVer.parseFromText((String)"5.4.3"));
        if (semVer3 == null) {
            TypeScriptTypingsMapper.$$$reportNull$$$0(4);
        }
        return semVer3;
    }

    private static Sign getSign(@NotNull String range) {
        if (range == null) {
            TypeScriptTypingsMapper.$$$reportNull$$$0(5);
        }
        for (Sign value : Sign.values()) {
            if (!range.startsWith(value.sign())) continue;
            return value;
        }
        return Sign.EQ;
    }

    private static String normalizeVersion(@NotNull String version2) {
        int i;
        if (version2 == null) {
            TypeScriptTypingsMapper.$$$reportNull$$$0(6);
        }
        if ((i = StringUtil.countChars((CharSequence)version2, (char)'.')) >= 2) {
            return version2;
        }
        String postfix = StringUtil.repeat((String)".0", (int)(2 - i));
        return version2 + postfix;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 3, 4 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "packageJson";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "data";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "nodeModules";
                break;
            }
            case 3: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/typescript/modules/TypeScriptTypingsMapper";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "range";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "version";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/typescript/modules/TypeScriptTypingsMapper";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "detectTypeScriptSemVer";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "substituteTypings";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "detectTypeScriptSemVer";
                break;
            }
            case 3: 
            case 4: {
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "getSign";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "normalizeVersion";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 3, 4 -> new IllegalStateException(string);
        };
    }

    public static final class TypeScriptRange {
        @Nullable
        private final SemVer myRightVersion;
        @NotNull
        public final Sign mySign;

        public TypeScriptRange(@NotNull String range) {
            if (range == null) {
                TypeScriptRange.$$$reportNull$$$0(0);
            }
            this.mySign = TypeScriptTypingsMapper.getSign(range);
            this.myRightVersion = SemVer.parseFromText((String)TypeScriptTypingsMapper.normalizeVersion(StringUtil.trimStart((String)range, (String)this.mySign.sign())));
        }

        public boolean isMatched(@NotNull SemVer semVer) {
            if (semVer == null) {
                TypeScriptRange.$$$reportNull$$$0(1);
            }
            return this.myRightVersion != null && this.mySign.isMatched(semVer, this.myRightVersion);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "range";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "semVer";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/lang/typescript/modules/TypeScriptTypingsMapper$TypeScriptRange";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "isMatched";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    /*
     * Uses 'sealed' constructs - enablewith --sealed true
     */
    static enum Sign {
        GT_EQ{

            @Override
            @NotNull
            String sign() {
                return ">=";
            }

            @Override
            boolean isMatched(@NotNull SemVer leftVersion, @NotNull SemVer rightVersion) {
                if (leftVersion == null) {
                    1.$$$reportNull$$$0(0);
                }
                if (rightVersion == null) {
                    1.$$$reportNull$$$0(1);
                }
                return leftVersion.isGreaterOrEqualThan(rightVersion);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[3];
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[0] = "leftVersion";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[0] = "rightVersion";
                        break;
                    }
                }
                objectArray[1] = "com/intellij/lang/typescript/modules/TypeScriptTypingsMapper$Sign$1";
                objectArray[2] = "isMatched";
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        }
        ,
        LT_EQ{

            @Override
            @NotNull
            String sign() {
                return "<=";
            }

            @Override
            boolean isMatched(@NotNull SemVer leftVersion, @NotNull SemVer rightVersion) {
                if (leftVersion == null) {
                    2.$$$reportNull$$$0(0);
                }
                if (rightVersion == null) {
                    2.$$$reportNull$$$0(1);
                }
                return rightVersion.isGreaterOrEqualThan(leftVersion);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[3];
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[0] = "leftVersion";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[0] = "rightVersion";
                        break;
                    }
                }
                objectArray[1] = "com/intellij/lang/typescript/modules/TypeScriptTypingsMapper$Sign$2";
                objectArray[2] = "isMatched";
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        }
        ,
        GT{

            @Override
            @NotNull
            String sign() {
                return ">";
            }

            @Override
            boolean isMatched(@NotNull SemVer leftVersion, @NotNull SemVer rightVersion) {
                if (leftVersion == null) {
                    3.$$$reportNull$$$0(0);
                }
                if (rightVersion == null) {
                    3.$$$reportNull$$$0(1);
                }
                return !leftVersion.equals((Object)rightVersion) && leftVersion.isGreaterOrEqualThan(rightVersion);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[3];
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[0] = "leftVersion";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[0] = "rightVersion";
                        break;
                    }
                }
                objectArray[1] = "com/intellij/lang/typescript/modules/TypeScriptTypingsMapper$Sign$3";
                objectArray[2] = "isMatched";
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        }
        ,
        LT{

            @Override
            @NotNull
            String sign() {
                return "<";
            }

            @Override
            boolean isMatched(@NotNull SemVer leftVersion, @NotNull SemVer rightVersion) {
                if (leftVersion == null) {
                    4.$$$reportNull$$$0(0);
                }
                if (rightVersion == null) {
                    4.$$$reportNull$$$0(1);
                }
                return !leftVersion.equals((Object)rightVersion) && rightVersion.isGreaterOrEqualThan(leftVersion);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[3];
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[0] = "leftVersion";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[0] = "rightVersion";
                        break;
                    }
                }
                objectArray[1] = "com/intellij/lang/typescript/modules/TypeScriptTypingsMapper$Sign$4";
                objectArray[2] = "isMatched";
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        }
        ,
        EQ{

            @Override
            @NotNull
            String sign() {
                return "=";
            }

            @Override
            boolean isMatched(@NotNull SemVer leftVersion, @NotNull SemVer rightVersion) {
                if (leftVersion == null) {
                    5.$$$reportNull$$$0(0);
                }
                if (rightVersion == null) {
                    5.$$$reportNull$$$0(1);
                }
                return leftVersion.equals((Object)rightVersion);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[3];
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[0] = "leftVersion";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[0] = "rightVersion";
                        break;
                    }
                }
                objectArray[1] = "com/intellij/lang/typescript/modules/TypeScriptTypingsMapper$Sign$5";
                objectArray[2] = "isMatched";
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        };


        @NotNull
        abstract String sign();

        abstract boolean isMatched(@NotNull SemVer var1, @NotNull SemVer var2);
    }
}

