/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.typescript.lsp;

import com.intellij.concurrency.SensitiveProgressWrapper;
import com.intellij.lang.javascript.JavaScriptBundle;
import com.intellij.lang.javascript.library.typings.TypeScriptExternalDefinitionsRegistry;
import com.intellij.lang.javascript.library.typings.TypeScriptPackageName;
import com.intellij.lang.typescript.compiler.TypeScriptService;
import com.intellij.lang.typescript.lsp.LspDownloadService;
import com.intellij.lang.typescript.lsp.LspServerDownloadingKt;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.components.ComponentManager;
import com.intellij.openapi.components.ServicesKt;
import com.intellij.openapi.progress.PerformInBackgroundOption;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.progress.util.ProgressWrapper;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.concurrency.AppExecutorUtil;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Arrays;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=2, xi=48, d1={"\u0000.\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0002\u001a(\u0010\u0000\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00020\u00012\u0006\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0002\u001a\u0018\u0010\t\u001a\u0004\u0018\u00010\n2\u0006\u0010\u000b\u001a\u00020\b2\u0006\u0010\f\u001a\u00020\n\u001a\u0016\u0010\r\u001a\u00020\u000e2\u0006\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0007\u001a\u00020\b\u001a\u0018\u0010\u000f\u001a\u00020\u000e2\u0006\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0007\u001a\u00020\bH\u0002\u00a8\u0006\u0010"}, d2={"downloadLspServer", "Ljava/util/concurrent/CompletableFuture;", "Lcom/intellij/openapi/vfs/VirtualFile;", "project", "Lcom/intellij/openapi/project/Project;", "indicator", "Lcom/intellij/openapi/progress/ProgressIndicator;", "npmPackage", "Lcom/intellij/lang/javascript/library/typings/TypeScriptPackageName;", "getLspServerExecutablePath", "", "packageName", "relativeScriptPath", "scheduleLspServerDownloading", "", "scheduleLspServerDownloadingTask", "intellij.javascript.impl"})
@SourceDebugExtension(value={"SMAP\nlspServerDownloading.kt\nKotlin\n*S Kotlin\n*F\n+ 1 lspServerDownloading.kt\ncom/intellij/lang/typescript/lsp/LspServerDownloadingKt\n+ 2 services.kt\ncom/intellij/openapi/components/ServicesKt\n*L\n1#1,115:1\n31#2,2:116\n*S KotlinDebug\n*F\n+ 1 lspServerDownloading.kt\ncom/intellij/lang/typescript/lsp/LspServerDownloadingKt\n*L\n69#1:116,2\n*E\n"})
public final class LspServerDownloadingKt {
    @Nullable
    public static final String getLspServerExecutablePath(@NotNull TypeScriptPackageName packageName, @NotNull String relativeScriptPath) {
        Intrinsics.checkNotNullParameter((Object)packageName, (String)"packageName");
        Intrinsics.checkNotNullParameter((Object)relativeScriptPath, (String)"relativeScriptPath");
        String string = TypeScriptExternalDefinitionsRegistry.Companion.getExactModuleTypingsPath(packageName);
        if (string == null) {
            return null;
        }
        String path2 = string;
        Path path3 = Paths.get(path2, new String[0]);
        Intrinsics.checkNotNullExpressionValue((Object)path3, (String)"get(...)");
        Path path4 = path3;
        LinkOption[] linkOptionArray = new LinkOption[]{};
        return !Files.isDirectory(path4, Arrays.copyOf(linkOptionArray, linkOptionArray.length)) ? null : path2 + FileUtil.toSystemDependentName((String)relativeScriptPath);
    }

    public static final void scheduleLspServerDownloading(@NotNull Project project, @NotNull TypeScriptPackageName npmPackage) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)npmPackage, (String)"npmPackage");
        ComponentManager $this$service$iv = (ComponentManager)project;
        boolean $i$f$service = false;
        Class<LspDownloadService> serviceClass$iv = LspDownloadService.class;
        Object object = $this$service$iv.getService(serviceClass$iv);
        if (object == null) {
            throw ServicesKt.serviceNotFoundError((ComponentManager)$this$service$iv, serviceClass$iv);
        }
        LspDownloadService downloadService = (LspDownloadService)object;
        downloadService.scheduleDownload(npmPackage);
    }

    private static final void scheduleLspServerDownloadingTask(Project project, TypeScriptPackageName npmPackage) {
        Object[] objectArray = new Object[]{npmPackage.getName()};
        String string = JavaScriptBundle.message("npm.downloading_package", objectArray);
        objectArray = Task.Backgroundable.ALWAYS_BACKGROUND;
        new Task.Backgroundable(project, npmPackage, string, (PerformInBackgroundOption)objectArray){
            final /* synthetic */ Project $project;
            final /* synthetic */ TypeScriptPackageName $npmPackage;
            {
                this.$project = $project;
                this.$npmPackage = $npmPackage;
                super($project, $super_call_param$1, true, $super_call_param$2);
            }

            public void run(@NotNull ProgressIndicator indicator) {
                Intrinsics.checkNotNullParameter((Object)indicator, (String)"indicator");
                indicator.setIndeterminate(true);
                CompletableFuture future = LspServerDownloadingKt.access$downloadLspServer(this.$project, indicator, this.$npmPackage);
                future.handleAsync((arg_0, arg_1) -> scheduleLspServerDownloadingTask.1.run$lambda$0((Function2)new Function2<VirtualFile, Throwable, Unit>(this.$project){
                    final /* synthetic */ Project $project;
                    {
                        this.$project = $project;
                        super(2);
                    }

                    public final void invoke(@Nullable VirtualFile packagePath, Throwable throwable) {
                        if (packagePath != null) {
                            ApplicationManager.getApplication().invokeLater(() -> scheduleLspServerDownloadingTask.run.1.invoke$lambda$0(this.$project));
                        }
                    }

                    private static final void invoke$lambda$0(Project $project) {
                        Intrinsics.checkNotNullParameter((Object)$project, (String)"$project");
                        TypeScriptService.Companion.restartServices($project);
                    }
                }, arg_0, arg_1));
            }

            private static final Unit run$lambda$0(Function2 $tmp0, Object p0, Throwable p1) {
                Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
                return (Unit)$tmp0.invoke(p0, (Object)p1);
            }
        }.queue();
    }

    private static final CompletableFuture<VirtualFile> downloadLspServer(Project project, ProgressIndicator indicator, TypeScriptPackageName npmPackage) {
        CompletableFuture<VirtualFile> completableFuture = CompletableFuture.supplyAsync(() -> LspServerDownloadingKt.downloadLspServer$lambda$0(indicator, npmPackage, project), AppExecutorUtil.getAppExecutorService());
        Intrinsics.checkNotNullExpressionValue(completableFuture, (String)"supplyAsync(...)");
        return completableFuture;
    }

    private static final VirtualFile downloadLspServer$lambda$0(ProgressIndicator $indicator, TypeScriptPackageName $npmPackage, Project $project) {
        VirtualFile virtualFile;
        Intrinsics.checkNotNullParameter((Object)$indicator, (String)"$indicator");
        Intrinsics.checkNotNullParameter((Object)$npmPackage, (String)"$npmPackage");
        Intrinsics.checkNotNullParameter((Object)$project, (String)"$project");
        TypeScriptExternalDefinitionsRegistry definitionsRegistry = TypeScriptExternalDefinitionsRegistry.Companion.getInstance();
        ProgressWrapper installProgress = (ProgressWrapper)new SensitiveProgressWrapper($indicator);
        Future<VirtualFile> future = definitionsRegistry.installPackage($npmPackage, $project, (ProgressIndicator)installProgress);
        try {
            virtualFile = future.get(2L, TimeUnit.MINUTES);
        }
        catch (InterruptedException e) {
            Object[] objectArray = new Object[]{$npmPackage.getName()};
            throw new RuntimeException(JavaScriptBundle.message("npm.failed_to_install_package.title.message", objectArray), e);
        }
        catch (ExecutionException e) {
            Object[] objectArray = new Object[]{$npmPackage.getName()};
            throw new RuntimeException(JavaScriptBundle.message("npm.failed_to_install_package.title.message", objectArray), e);
        }
        catch (TimeoutException e) {
            installProgress.cancel();
            Object[] objectArray = new Object[]{$npmPackage.getName()};
            throw new RuntimeException(JavaScriptBundle.message("npm.failed_to_install_package.title.message", objectArray), e);
        }
        return virtualFile;
    }

    public static final /* synthetic */ void access$scheduleLspServerDownloadingTask(Project project, TypeScriptPackageName npmPackage) {
        LspServerDownloadingKt.scheduleLspServerDownloadingTask(project, npmPackage);
    }

    public static final /* synthetic */ CompletableFuture access$downloadLspServer(Project project, ProgressIndicator indicator, TypeScriptPackageName npmPackage) {
        return LspServerDownloadingKt.downloadLspServer(project, indicator, npmPackage);
    }
}

