/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.typescript.lsp;

import com.intellij.execution.ExecutionException;
import com.intellij.execution.configurations.GeneralCommandLine;
import com.intellij.execution.process.OSProcessHandler;
import com.intellij.execution.target.TargetedCommandLineBuilder;
import com.intellij.javascript.nodejs.execution.NodeTargetRun;
import com.intellij.javascript.nodejs.execution.NodeTargetRunOptions;
import com.intellij.javascript.nodejs.execution.ProcessWithCmdLine;
import com.intellij.javascript.nodejs.interpreter.NodeJsInterpreter;
import com.intellij.javascript.nodejs.interpreter.NodeJsInterpreterManager;
import com.intellij.javascript.nodejs.interpreter.local.NodeJsLocalInterpreter;
import com.intellij.javascript.nodejs.interpreter.wsl.WslNodeInterpreter;
import com.intellij.javascript.nodejs.util.NodePackage;
import com.intellij.javascript.nodejs.util.NodePackageRef;
import com.intellij.lang.javascript.JavaScriptBundle;
import com.intellij.lang.javascript.service.JSLanguageServiceUtil;
import com.intellij.lang.javascript.service.JSNodeServicesProfilerActionKt;
import com.intellij.lang.typescript.lsp.JSFrameworkLsp4jServer;
import com.intellij.lang.typescript.lsp.JSFrameworkLspServerDescriptor;
import com.intellij.lang.typescript.lsp.JSFrameworkLspServerDescriptorKt;
import com.intellij.lang.typescript.lsp.LspServerDownloader;
import com.intellij.openapi.application.ActionsKt;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.platform.lsp.api.LspServerDescriptor;
import com.intellij.platform.lsp.api.LspServerListener;
import com.intellij.platform.lsp.api.ProjectWideLspServerDescriptor;
import com.intellij.util.text.SemVer;
import kotlin.Metadata;
import kotlin.jvm.JvmField;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.Charsets;
import org.eclipse.lsp4j.InitializeResult;
import org.eclipse.lsp4j.ServerInfo;
import org.eclipse.lsp4j.services.LanguageServer;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000l\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0001\n\u0002\b\u0007\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\b'\u0018\u00002\u00020\u0001B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\u0006\u0010'\u001a\u00020(J\b\u0010)\u001a\u00020*H\u0016J\u0012\u0010+\u001a\u0004\u0018\u00010,2\u0006\u0010-\u001a\u00020\u0007H\u0014J\b\u0010.\u001a\u00020\u0007H\u0004J\u0010\u0010/\u001a\u00020\u00072\u0006\u00100\u001a\u00020,H\u0016J\b\u00101\u001a\u0004\u0018\u00010&J\b\u00102\u001a\u000203H\u0016R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR \u0010\u000b\u001a\u000e\u0012\n\b\u0001\u0012\u00060\rj\u0002`\u000e0\fX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u0016\u0010\u0011\u001a\u0004\u0018\u00010\u0012X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0014R\u0016\u0010\u0015\u001a\u0004\u0018\u00010\u0012X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0016\u0010\u0014R\u0016\u0010\u0017\u001a\u0004\u0018\u00010\u0012X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0018\u0010\u0014R\u0014\u0010\u0019\u001a\u00020\u001aX\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001b\u0010\u001cR\u0014\u0010\u001d\u001a\u00020\u001aX\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001e\u0010\u001cR\u0014\u0010\u001f\u001a\u00020 X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b!\u0010\"R\u0010\u0010#\u001a\u0004\u0018\u00010$X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010%\u001a\u0004\u0018\u00010&X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u00064"}, d2={"Lcom/intellij/lang/typescript/lsp/JSFrameworkLspServerDescriptor;", "Lcom/intellij/platform/lsp/api/ProjectWideLspServerDescriptor;", "project", "Lcom/intellij/openapi/project/Project;", "downloader", "Lcom/intellij/lang/typescript/lsp/LspServerDownloader;", "presentableName", "", "(Lcom/intellij/openapi/project/Project;Lcom/intellij/lang/typescript/lsp/LspServerDownloader;Ljava/lang/String;)V", "getDownloader", "()Lcom/intellij/lang/typescript/lsp/LspServerDownloader;", "lsp4jServerClass", "Ljava/lang/Class;", "Lorg/eclipse/lsp4j/services/LanguageServer;", "Lcom/intellij/platform/lsp/api/Lsp4jServer;", "getLsp4jServerClass", "()Ljava/lang/Class;", "lspCompletionSupport", "", "getLspCompletionSupport", "()Ljava/lang/Void;", "lspDiagnosticsSupport", "getLspDiagnosticsSupport", "lspFormattingSupport", "getLspFormattingSupport", "lspGoToDefinitionSupport", "", "getLspGoToDefinitionSupport", "()Z", "lspHoverSupport", "getLspHoverSupport", "lspServerListener", "Lcom/intellij/platform/lsp/api/LspServerListener;", "getLspServerListener", "()Lcom/intellij/platform/lsp/api/LspServerListener;", "nodeTarget", "Lcom/intellij/javascript/nodejs/execution/NodeTargetRun;", "serverVersion", "Lcom/intellij/util/text/SemVer;", "createCommandLine", "Lcom/intellij/execution/configurations/GeneralCommandLine;", "createInitializationOptions", "", "findLocalFileByPath", "Lcom/intellij/openapi/vfs/VirtualFile;", "path", "getCommandLineArgsFromRegistry", "getFilePath", "file", "getVersion", "startServerProcess", "Lcom/intellij/execution/process/OSProcessHandler;", "intellij.javascript.impl"})
@ApiStatus.Experimental
@SourceDebugExtension(value={"SMAP\nJSFrameworkLspServerDescriptor.kt\nKotlin\n*S Kotlin\n*F\n+ 1 JSFrameworkLspServerDescriptor.kt\ncom/intellij/lang/typescript/lsp/JSFrameworkLspServerDescriptor\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,143:1\n1#2:144\n*E\n"})
public abstract class JSFrameworkLspServerDescriptor
extends ProjectWideLspServerDescriptor {
    @NotNull
    private final LspServerDownloader downloader;
    @NotNull
    private final Class<? extends LanguageServer> lsp4jServerClass;
    private final boolean lspGoToDefinitionSupport;
    private final boolean lspHoverSupport;
    @Nullable
    private final Void lspCompletionSupport;
    @Nullable
    private final Void lspDiagnosticsSupport;
    @Nullable
    private final Void lspFormattingSupport;
    @Nullable
    private NodeTargetRun nodeTarget;
    @Nullable
    private SemVer serverVersion;
    @NotNull
    private final LspServerListener lspServerListener;

    public JSFrameworkLspServerDescriptor(@NotNull Project project, @NotNull LspServerDownloader downloader, @NotNull String presentableName) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)downloader, (String)"downloader");
        Intrinsics.checkNotNullParameter((Object)presentableName, (String)"presentableName");
        super(project, presentableName);
        this.downloader = downloader;
        this.lsp4jServerClass = JSFrameworkLsp4jServer.class;
        this.lspServerListener = new LspServerListener(this){
            final /* synthetic */ JSFrameworkLspServerDescriptor this$0;
            {
                this.this$0 = $receiver;
            }

            public void serverInitialized(@NotNull InitializeResult params) {
                block0: {
                    Intrinsics.checkNotNullParameter((Object)params, (String)"params");
                    ServerInfo serverInfo = params.getServerInfo();
                    SemVer semVer = SemVer.parseFromText((String)(serverInfo != null ? serverInfo.getVersion() : null));
                    if (semVer == null) break block0;
                    SemVer semVer2 = semVer;
                    JSFrameworkLspServerDescriptor jSFrameworkLspServerDescriptor = this.this$0;
                    SemVer it = semVer2;
                    boolean bl = false;
                    JSFrameworkLspServerDescriptor.access$setServerVersion$p(jSFrameworkLspServerDescriptor, it);
                }
            }
        };
    }

    @NotNull
    public final LspServerDownloader getDownloader() {
        return this.downloader;
    }

    @NotNull
    public Class<? extends LanguageServer> getLsp4jServerClass() {
        return this.lsp4jServerClass;
    }

    public boolean getLspGoToDefinitionSupport() {
        return this.lspGoToDefinitionSupport;
    }

    public boolean getLspHoverSupport() {
        return this.lspHoverSupport;
    }

    @Nullable
    public Void getLspCompletionSupport() {
        return this.lspCompletionSupport;
    }

    @Nullable
    public Void getLspDiagnosticsSupport() {
        return this.lspDiagnosticsSupport;
    }

    @Nullable
    public Void getLspFormattingSupport() {
        return this.lspFormattingSupport;
    }

    @NotNull
    public final GeneralCommandLine createCommandLine() {
        throw new RuntimeException();
    }

    @Nullable
    public final SemVer getVersion() {
        return this.serverVersion;
    }

    @NotNull
    public OSProcessHandler startServerProcess() {
        NodeJsInterpreter interpreter = NodeJsInterpreterManager.getInstance(this.getProject()).getInterpreter();
        if (!(interpreter instanceof NodeJsLocalInterpreter) && !(interpreter instanceof WslNodeInterpreter)) {
            throw new ExecutionException(JavaScriptBundle.message("lsp.interpreter.error", new Object[0]));
        }
        NodePackageRef selectedPackageRef = this.downloader.getSelectedPackageRef(this.getProject());
        NodePackage nodePackage = selectedPackageRef.getConstantPackage();
        if (nodePackage == null) {
            Object[] objectArray = new Object[]{this.getPresentableName()};
            throw new ExecutionException(JavaScriptBundle.message("lsp.executable.error", objectArray));
        }
        NodePackage nodePackage2 = nodePackage;
        String executable = this.downloader.getExecutable(this.getProject());
        if (executable == null) {
            Object[] objectArray = new Object[]{nodePackage2.getName()};
            throw new ExecutionException(JavaScriptBundle.message("lsp.executable.error", objectArray));
        }
        NodeTargetRun target = new NodeTargetRun(interpreter, this.getProject(), null, NodeTargetRunOptions.Companion.of$default(NodeTargetRunOptions.Companion, false, null, null, 6, null), null, 16, null);
        TargetedCommandLineBuilder builder2 = target.getCommandLineBuilder();
        JSLanguageServiceUtil.addNodeProcessArgumentsFromRegistry(builder2, this.getPresentableName(), this::getCommandLineArgsFromRegistry);
        String string = this.getProject().getBasePath();
        if (string != null) {
            String it = string;
            boolean bl = false;
            builder2.setWorkingDirectory(target.path(it));
        }
        if (JSNodeServicesProfilerActionKt.isNodeServicesProfilerEnabled(this.getProject())) {
            builder2.addParameter("--prof");
        }
        builder2.addParameter(target.path(executable));
        builder2.addParameter("--stdio");
        builder2.setCharset(Charsets.UTF_8);
        LspServerDescriptor.LOG.info("Starting " + ((Object)((Object)this)).getClass().getName() + " LSP server. Node.js version " + interpreter.getCachedVersion() + ", path: " + interpreter.getPresentableName());
        ProcessWithCmdLine process2 = target.startProcessEx();
        this.nodeTarget = target;
        this.serverVersion = nodePackage2.getVersion();
        return (OSProcessHandler)process2.getProcessHandler();
    }

    @NotNull
    protected final String getCommandLineArgsFromRegistry() {
        String string = Registry.stringValue((String)"typescript.service.lsp.node.arguments");
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"stringValue(...)");
        return string;
    }

    @NotNull
    public String getFilePath(@NotNull VirtualFile file) {
        Object object;
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        try {
            Object object2;
            block5: {
                block4: {
                    object2 = this.nodeTarget;
                    if (object2 == null) break block4;
                    String string = file.getPath();
                    Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getPath(...)");
                    if ((object2 = ((NodeTargetRun)object2).convertLocalPathToTargetPath(string)) != null) break block5;
                }
                object2 = super.getFilePath(file);
            }
            object = object2;
        }
        catch (IllegalArgumentException e) {
            LspServerDescriptor.LOG.error((Throwable)e);
            object = super.getFilePath(file);
        }
        return object;
    }

    @Nullable
    protected VirtualFile findLocalFileByPath(@NotNull String path2) {
        VirtualFile virtualFile;
        Intrinsics.checkNotNullParameter((Object)path2, (String)"path");
        try {
            NodeTargetRun nodeTargetRun = this.nodeTarget;
            Intrinsics.checkNotNull((Object)nodeTargetRun);
            virtualFile = super.findLocalFileByPath(nodeTargetRun.convertTargetPathToLocalPath(path2));
        }
        catch (IllegalArgumentException e) {
            LspServerDescriptor.LOG.error((Throwable)e);
            virtualFile = super.findLocalFileByPath(path2);
        }
        return virtualFile;
    }

    @NotNull
    public Object createInitializationOptions() {
        String tsPath2 = (String)ActionsKt.runReadAction((Function0)((Function0)new Function0<String>(this){
            final /* synthetic */ JSFrameworkLspServerDescriptor this$0;
            {
                this.this$0 = $receiver;
                super(0);
            }

            @NotNull
            public final String invoke() {
                return JSFrameworkLspServerDescriptorKt.getTypeScriptServiceDirectory(this.this$0.getProject());
            }
        }));
        NodeTargetRun nodeTargetRun = this.nodeTarget;
        Intrinsics.checkNotNull((Object)nodeTargetRun);
        @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\b\u0003*\u0002\u0000\u0006\b\n\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004R\u0012\u0010\u0005\u001a\u00020\u00068\u0006X\u0087\u0004\u00a2\u0006\u0004\n\u0002\u0010\u0007\u00a8\u0006\b"}, d2={"com/intellij/lang/typescript/lsp/JSFrameworkLspServerDescriptor$createInitializationOptions$State", "", "path", "", "(Ljava/lang/String;)V", "typescript", "com/intellij/lang/typescript/lsp/JSFrameworkLspServerDescriptor$createInitializationOptions$TypescriptSdkState", "Lcom/intellij/lang/typescript/lsp/JSFrameworkLspServerDescriptor$createInitializationOptions$TypescriptSdkState;", "intellij.javascript.impl"})
        public final class State {
            @JvmField
            @NotNull
            public final createInitializationOptions.TypescriptSdkState typescript;

            public State(@NotNull String path2) {
                Intrinsics.checkNotNullParameter((Object)path2, (String)"path");
                @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0013\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003*\u0001\u0000\b\n\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004R\u0010\u0010\u0005\u001a\u00020\u00038\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"com/intellij/lang/typescript/lsp/JSFrameworkLspServerDescriptor$createInitializationOptions$TypescriptSdkState", "", "path", "", "(Ljava/lang/String;)V", "tsdk", "intellij.javascript.impl"})
                public final class TypescriptSdkState {
                    @JvmField
                    @NotNull
                    public final String tsdk;

                    public TypescriptSdkState(@NotNull String path2) {
                        Intrinsics.checkNotNullParameter((Object)path2, (String)"path");
                        this.tsdk = path2;
                    }
                }
                this.typescript = new TypescriptSdkState(path2);
            }
        }
        return new State(nodeTargetRun.convertLocalPathToTargetPath(tsPath2));
    }

    @NotNull
    public LspServerListener getLspServerListener() {
        return this.lspServerListener;
    }

    public static final /* synthetic */ void access$setServerVersion$p(JSFrameworkLspServerDescriptor $this, SemVer semVer) {
        $this.serverVersion = semVer;
    }
}

