/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.typescript.inspection;

import com.intellij.codeInsight.completion.CompletionUtil;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.lang.javascript.JavaScriptBundle;
import com.intellij.lang.javascript.inspections.JSVariablesWithInitializerPredicate;
import com.intellij.lang.javascript.psi.JSElement;
import com.intellij.lang.javascript.psi.JSFunction;
import com.intellij.lang.javascript.psi.JSOptionalOwner;
import com.intellij.lang.javascript.psi.JSType;
import com.intellij.lang.javascript.psi.JSTypeDeclarationOwner;
import com.intellij.lang.javascript.psi.JSVarStatement;
import com.intellij.lang.javascript.psi.JSVariable;
import com.intellij.lang.javascript.psi.JSVariableDeclaringScope;
import com.intellij.lang.javascript.psi.types.JSCompositeTypeFactory;
import com.intellij.lang.javascript.psi.types.JSLiteralType;
import com.intellij.lang.javascript.psi.types.JSResolvableType;
import com.intellij.lang.javascript.psi.types.JSResolvedTypeInfo;
import com.intellij.lang.javascript.psi.types.JSTypeWithWidening;
import com.intellij.lang.javascript.psi.types.JSUnionType;
import com.intellij.lang.javascript.psi.types.JSUniqueSymbolTypeImpl;
import com.intellij.lang.javascript.psi.types.primitives.JSUndefinedType;
import com.intellij.lang.javascript.refactoring.util.JSRefactoringUtil;
import com.intellij.lang.typescript.inspection.TypeScriptExplicitMemberTypeInspection;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.Function;
import com.intellij.util.containers.ContainerUtil;
import java.util.List;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class TypeScriptSpecifyTypeExplicitlyQuickFix
implements LocalQuickFix {
    @Nls
    @NotNull
    public String getFamilyName() {
        String string = JavaScriptBundle.message("typescript.specify.type.explicitly", new Object[0]);
        if (string == null) {
            TypeScriptSpecifyTypeExplicitlyQuickFix.$$$reportNull$$$0(0);
        }
        return string;
    }

    public void applyFix(@NotNull Project project, @NotNull ProblemDescriptor descriptor) {
        if (project == null) {
            TypeScriptSpecifyTypeExplicitlyQuickFix.$$$reportNull$$$0(1);
        }
        if (descriptor == null) {
            TypeScriptSpecifyTypeExplicitlyQuickFix.$$$reportNull$$$0(2);
        }
        JSElement element = (JSElement)PsiTreeUtil.getParentOfType((PsiElement)descriptor.getPsiElement(), (Class[])new Class[]{JSTypeDeclarationOwner.class, JSFunction.class});
        TypeScriptSpecifyTypeExplicitlyQuickFix.doSpecifyExplicitType(element);
    }

    public static void doSpecifyExplicitType(JSElement element) {
        if (element == null || TypeScriptExplicitMemberTypeInspection.getTypeDeclarationElement(element) != null) {
            return;
        }
        JSElement elementToInferType = (JSElement)CompletionUtil.getOriginalOrSelf((PsiElement)element);
        JSType inferredType = TypeScriptExplicitMemberTypeInspection.getInferredType((PsiElement)elementToInferType);
        if (inferredType == null) {
            return;
        }
        String newTypeStr = TypeScriptSpecifyTypeExplicitlyQuickFix.getNewTypeString(elementToInferType, inferredType);
        JSRefactoringUtil.setType(element, newTypeStr);
    }

    @Nullable
    public static String getNewTypeString(JSElement element, @NotNull JSType inferredType) {
        List<JSType> types2;
        List filteredTypes;
        if (inferredType == null) {
            TypeScriptSpecifyTypeExplicitlyQuickFix.$$$reportNull$$$0(3);
        }
        inferredType = inferredType.transformTypeHierarchy((Function<? super JSType, ? extends JSType>)((Function)TypeScriptSpecifyTypeExplicitlyQuickFix::getTypeWithEnforcedLiteralStrictness));
        JSType expandedType = inferredType.substitute();
        if (element instanceof JSOptionalOwner && ((JSOptionalOwner)((Object)element)).isOptional() && inferredType instanceof JSUnionType && (filteredTypes = ContainerUtil.filter(types2 = ((JSUnionType)inferredType).getTypes(), t -> !(t instanceof JSUndefinedType))).size() != types2.size()) {
            inferredType = JSCompositeTypeFactory.createUnionType(inferredType.getSource(), filteredTypes);
        }
        return expandedType instanceof JSUniqueSymbolTypeImpl && ((JSUniqueSymbolTypeImpl)expandedType).getElement() == element ? "unique symbol" : JSVariablesWithInitializerPredicate.formatType(inferredType, (PsiElement)element);
    }

    public static boolean isAvailable(@NotNull PsiElement context2) {
        PsiElement parent;
        JSVarStatement statement;
        if (context2 == null) {
            TypeScriptSpecifyTypeExplicitlyQuickFix.$$$reportNull$$$0(4);
        }
        if (context2 instanceof JSVariable && (statement = ((JSVariable)context2).getStatement()) != null && (parent = statement.getParent()) instanceof JSVariableDeclaringScope) {
            return statement != ((JSVariableDeclaringScope)parent).getVarDeclaration();
        }
        return true;
    }

    @Nullable
    @Contract(value="null -> null")
    private static JSType getTypeWithEnforcedLiteralStrictness(@Nullable JSType t) {
        JSResolvedTypeInfo resolvedType;
        if (t instanceof JSLiteralType && ((JSLiteralType)t).allowWidening()) {
            return ((JSLiteralType)t).copyWithAllowWidening(false);
        }
        if (t instanceof JSResolvableType && t instanceof JSTypeWithWidening && ((JSTypeWithWidening)t).allowWidening() && (resolvedType = ((JSResolvableType)t).resolveType()).isEnumLiteral()) {
            return ((JSTypeWithWidening)t).copyWithAllowWidening(false);
        }
        return t;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 2;
            case 1, 2, 3, 4 -> 3;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/typescript/inspection/TypeScriptSpecifyTypeExplicitlyQuickFix";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "descriptor";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "inferredType";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getFamilyName";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/typescript/inspection/TypeScriptSpecifyTypeExplicitlyQuickFix";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "applyFix";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "getNewTypeString";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "isAvailable";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalStateException(string);
            case 1, 2, 3, 4 -> new IllegalArgumentException(string);
        };
    }
}

