/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.typescript.inspection;

import com.intellij.codeHighlighting.HighlightDisplayLevel;
import com.intellij.codeInspection.LocalInspectionToolSession;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.json.psi.JsonArray;
import com.intellij.json.psi.JsonObject;
import com.intellij.json.psi.JsonProperty;
import com.intellij.json.psi.JsonStringLiteral;
import com.intellij.json.psi.JsonValue;
import com.intellij.lang.javascript.JavaScriptBundle;
import com.intellij.lang.javascript.ecmascript6.TypeScriptAnnotatorCheckerProvider;
import com.intellij.lang.javascript.inspections.JSInspection;
import com.intellij.lang.javascript.psi.JSElementVisitor;
import com.intellij.lang.javascript.psi.JSReferenceExpression;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptCompileTimeType;
import com.intellij.lang.javascript.psi.ecmal4.JSQualifiedNamedElement;
import com.intellij.lang.javascript.psi.resolve.JSResolveUtil;
import com.intellij.lang.typescript.inspection.TypeScriptConfigJsonFixBase;
import com.intellij.lang.typescript.library.TypeScriptLibraries;
import com.intellij.lang.typescript.library.TypeScriptLibraryProvider;
import com.intellij.lang.typescript.resolve.TypeScriptClassResolver;
import com.intellij.lang.typescript.tsconfig.TypeScriptConfig;
import com.intellij.lang.typescript.tsconfig.TypeScriptConfigService;
import com.intellij.lang.typescript.tsconfig.TypeScriptConfigUtil;
import com.intellij.lang.typescript.tsconfig.TypeScriptExtendedConfig;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.ResolveResult;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.util.PsiUtilCore;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.ContainerUtil;
import com.jetbrains.jsonSchema.impl.JsonSchemaType;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class TypeScriptLibraryInspection
extends JSInspection {
    @NotNull
    public HighlightDisplayLevel getDefaultLevel() {
        HighlightDisplayLevel highlightDisplayLevel = HighlightDisplayLevel.ERROR;
        if (highlightDisplayLevel == null) {
            TypeScriptLibraryInspection.$$$reportNull$$$0(0);
        }
        return highlightDisplayLevel;
    }

    @Override
    @NotNull
    protected PsiElementVisitor createVisitor(final @NotNull ProblemsHolder holder, @NotNull LocalInspectionToolSession session) {
        if (holder == null) {
            TypeScriptLibraryInspection.$$$reportNull$$$0(1);
        }
        if (session == null) {
            TypeScriptLibraryInspection.$$$reportNull$$$0(2);
        }
        return new JSElementVisitor(){

            @Override
            public void visitJSReferenceExpression(@NotNull JSReferenceExpression node) {
                if (node == null) {
                    1.$$$reportNull$$$0(0);
                }
                if (node.getQualifier() != null) {
                    return;
                }
                TypeScriptLibraryInspection.this.processReference(holder, node);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "node", "com/intellij/lang/typescript/inspection/TypeScriptLibraryInspection$1", "visitJSReferenceExpression"));
            }
        };
    }

    private void processReference(@NotNull ProblemsHolder holder, @NotNull JSReferenceExpression node) {
        ResolveResult[] results;
        if (holder == null) {
            TypeScriptLibraryInspection.$$$reportNull$$$0(3);
        }
        if (node == null) {
            TypeScriptLibraryInspection.$$$reportNull$$$0(4);
        }
        if ((results = node.multiResolve(false)).length > 0) {
            return;
        }
        String name = node.getReferenceName();
        if (StringUtil.isEmpty((String)name) || name.length() < 2) {
            return;
        }
        Project project = node.getProject();
        TypeScriptConfigService configService = TypeScriptConfigService.Provider.get(project);
        VirtualFile file = PsiUtilCore.getVirtualFile((PsiElement)node);
        if (file == null) {
            return;
        }
        TypeScriptConfig config = configService.getPreferableConfig(file);
        if (config == null) {
            return;
        }
        if (config instanceof TypeScriptExtendedConfig) {
            return;
        }
        TypeScriptLibraryProvider service2 = TypeScriptLibraryProvider.getService(project);
        Collection<VirtualFile> customLibs = service2.getCurrentLibraries();
        ArrayList<VirtualFile> libsWithSymbol = new ArrayList<VirtualFile>();
        boolean isTypeContext = JSResolveUtil.isExprInStrictTypeContext(node);
        for (VirtualFile lib : customLibs) {
            String libName;
            String fileName = lib.getName();
            if (fileName.equals("lib.d.ts") || (libName = TypeScriptLibraries.getLibraryName(fileName)).endsWith(".full") || libName.startsWith("es") && !libName.contains(".")) continue;
            Set<VirtualFile> files = Collections.singleton(lib);
            GlobalSearchScope filter = GlobalSearchScope.filesScope((Project)project, files);
            Collection<JSQualifiedNamedElement> elements = TypeScriptClassResolver.getInstance().findGlobalElementsByQName(node.getProject(), name, filter);
            if (elements.isEmpty() || !isTypeContext && TypeScriptLibraryInspection.isCompileTypeOnly(elements)) continue;
            libsWithSymbol.add(lib);
        }
        if (libsWithSymbol.isEmpty()) {
            return;
        }
        ContainerUtil.sort(libsWithSymbol, Comparator.comparing(el -> el.getName()));
        List<InsertLibraryFix> fixes = TypeScriptLibraryInspection.getConfigFixes(libsWithSymbol);
        TypeScriptAnnotatorCheckerProvider provider = TypeScriptAnnotatorCheckerProvider.getCheckerProvider((PsiElement)holder.getFile());
        if (!holder.isOnTheFly() && provider.skipErrors((PsiElement)node)) {
            return;
        }
        ProblemHighlightType type2 = provider.skipErrors((PsiElement)node) ? ProblemHighlightType.INFORMATION : ProblemHighlightType.GENERIC_ERROR_OR_WARNING;
        holder.registerProblem((PsiElement)node, this.getDisplayName(), type2, fixes.toArray(LocalQuickFix.EMPTY_ARRAY));
    }

    private static boolean isCompileTypeOnly(@NotNull Collection<JSQualifiedNamedElement> elements) {
        if (elements == null) {
            TypeScriptLibraryInspection.$$$reportNull$$$0(5);
        }
        return ContainerUtil.all(elements, el -> el instanceof TypeScriptCompileTimeType);
    }

    private static List<InsertLibraryFix> getConfigFixes(@NotNull List<VirtualFile> libsWithSymbol) {
        if (libsWithSymbol == null) {
            TypeScriptLibraryInspection.$$$reportNull$$$0(6);
        }
        return ContainerUtil.map(libsWithSymbol, el -> new InsertLibraryFix(TypeScriptLibraries.getLibraryName(el.getName())));
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 2;
            case 1, 2, 3, 4, 5, 6 -> 3;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/typescript/inspection/TypeScriptLibraryInspection";
                break;
            }
            case 1: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "holder";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "session";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "node";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "elements";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "libsWithSymbol";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getDefaultLevel";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/typescript/inspection/TypeScriptLibraryInspection";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "createVisitor";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "processReference";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "isCompileTypeOnly";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "getConfigFixes";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalStateException(string);
            case 1, 2, 3, 4, 5, 6 -> new IllegalArgumentException(string);
        };
    }

    private static final class InsertLibraryFix
    extends TypeScriptConfigJsonFixBase {
        @NotNull
        private final String myLibName;

        private InsertLibraryFix(@NotNull String libName) {
            if (libName == null) {
                InsertLibraryFix.$$$reportNull$$$0(0);
            }
            this.myLibName = libName;
        }

        @Nls(capitalization=Nls.Capitalization.Sentence)
        @NotNull
        public String getFamilyName() {
            String string = JavaScriptBundle.message("typescript.config.inspection.libs.fix", this.myLibName);
            if (string == null) {
                InsertLibraryFix.$$$reportNull$$$0(1);
            }
            return string;
        }

        @Override
        protected void applyFix(@NotNull Project project, @NotNull PsiElement element, TypeScriptConfig preferableConfig) {
            JsonObject compilerOptionsValue;
            if (project == null) {
                InsertLibraryFix.$$$reportNull$$$0(2);
            }
            if (element == null) {
                InsertLibraryFix.$$$reportNull$$$0(3);
            }
            if ((compilerOptionsValue = this.getOrCreateCompilerOptionsObject(element, preferableConfig)) == null) {
                return;
            }
            JsonProperty libs = compilerOptionsValue.findProperty("lib");
            if (libs == null && (libs = InsertLibraryFix.createLib(project, (PsiElement)compilerOptionsValue)) == null) {
                return;
            }
            JsonArray value = (JsonArray)ObjectUtils.tryCast((Object)libs.getValue(), JsonArray.class);
            if (value == null) {
                return;
            }
            this.addOptionToLib(project, preferableConfig, value);
        }

        private static JsonProperty createLib(@NotNull Project project, @NotNull PsiElement object) {
            if (project == null) {
                InsertLibraryFix.$$$reportNull$$$0(4);
            }
            if (object == null) {
                InsertLibraryFix.$$$reportNull$$$0(5);
            }
            return InsertLibraryFix.createProperty(project, "lib", JsonSchemaType._array, object);
        }

        private void addOptionToLib(@NotNull Project project, @NotNull TypeScriptConfig config, @NotNull JsonArray array) {
            List list2;
            if (project == null) {
                InsertLibraryFix.$$$reportNull$$$0(6);
            }
            if (config == null) {
                InsertLibraryFix.$$$reportNull$$$0(7);
            }
            if (array == null) {
                InsertLibraryFix.$$$reportNull$$$0(8);
            }
            if ((list2 = array.getValueList()).isEmpty() && null == config.getRawCompilerOption("lib") && (array = InsertLibraryFix.addLibsForCurrentTarget(project, config, array)) == null) {
                return;
            }
            for (JsonValue value : list2) {
                if (!(value instanceof JsonStringLiteral) || !this.myLibName.equals(((JsonStringLiteral)value).getValue())) continue;
                return;
            }
            TypeScriptConfigUtil.addValueToJsonArray(project, array, this.myLibName);
        }

        @Nullable
        private static JsonArray addLibsForCurrentTarget(@NotNull Project project, @NotNull TypeScriptConfig config, @NotNull JsonArray array) {
            if (project == null) {
                InsertLibraryFix.$$$reportNull$$$0(9);
            }
            if (config == null) {
                InsertLibraryFix.$$$reportNull$$$0(10);
            }
            if (array == null) {
                InsertLibraryFix.$$$reportNull$$$0(11);
            }
            TypeScriptLibraryProvider service2 = TypeScriptLibraryProvider.getService(project);
            TypeScriptConfig.LanguageTarget target = config.getLanguageTarget();
            if (!target.libName.equals("lib.d.ts")) {
                return (JsonArray)TypeScriptConfigUtil.addValueToJsonArray(project, array, target.libName);
            }
            ArrayList libs = new ArrayList(ContainerUtil.filter(service2.getLibsForTarget(project, target), el -> !"lib.d.ts".equals(el.getName())));
            ContainerUtil.sort(libs, Comparator.comparing(VirtualFile::getName));
            for (VirtualFile lib : libs) {
                String name = TypeScriptLibraries.getLibraryName(lib.getName());
                if (!name.startsWith("es") && name.contains(".") || (array = (JsonArray)TypeScriptConfigUtil.addValueToJsonArray(project, array, name)) != null) continue;
                return null;
            }
            return array;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 1 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "libName";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/lang/typescript/inspection/TypeScriptLibraryInspection$InsertLibraryFix";
                    break;
                }
                case 2: 
                case 4: 
                case 6: 
                case 9: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "element";
                    break;
                }
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "object";
                    break;
                }
                case 7: 
                case 10: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "config";
                    break;
                }
                case 8: 
                case 11: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "array";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/lang/typescript/inspection/TypeScriptLibraryInspection$InsertLibraryFix";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getFamilyName";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 1: {
                    break;
                }
                case 2: 
                case 3: {
                    objectArray = objectArray;
                    objectArray[2] = "applyFix";
                    break;
                }
                case 4: 
                case 5: {
                    objectArray = objectArray;
                    objectArray[2] = "createLib";
                    break;
                }
                case 6: 
                case 7: 
                case 8: {
                    objectArray = objectArray;
                    objectArray[2] = "addOptionToLib";
                    break;
                }
                case 9: 
                case 10: 
                case 11: {
                    objectArray = objectArray;
                    objectArray[2] = "addLibsForCurrentTarget";
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 1 -> new IllegalStateException(string);
            };
        }
    }
}

