/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.typescript.imports;

import com.intellij.codeInsight.daemon.ImplicitUsageProvider;
import com.intellij.lang.ecmascript6.psi.ES6ImportDeclaration;
import com.intellij.lang.ecmascript6.psi.ES6ImportSpecifier;
import com.intellij.lang.ecmascript6.psi.ES6ImportSpecifierAlias;
import com.intellij.lang.ecmascript6.psi.ES6ImportedBinding;
import com.intellij.lang.ecmascript6.resolve.ES6PsiUtil;
import com.intellij.lang.javascript.DialectDetector;
import com.intellij.lang.javascript.config.JSXNamespaceInfo;
import com.intellij.lang.javascript.inspections.ES6UnusedImportsInspection;
import com.intellij.lang.javascript.inspections.JSInspectionSuppressor;
import com.intellij.lang.javascript.psi.JSElement;
import com.intellij.lang.javascript.psi.JSLiteralExpression;
import com.intellij.lang.javascript.psi.JSRecursiveWalkingElementVisitor;
import com.intellij.lang.javascript.psi.JSTypeUtils;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptImportStatement;
import com.intellij.lang.javascript.psi.resolve.JSResolveResult;
import com.intellij.lang.javascript.psi.resolve.ResolveResultSink;
import com.intellij.lang.javascript.psi.resolve.SinkResolveProcessor;
import com.intellij.lang.typescript.imports.JSXNamespaceProvider;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiReference;
import com.intellij.psi.ResolveResult;
import com.intellij.psi.ResolveState;
import com.intellij.psi.search.LocalSearchScope;
import com.intellij.psi.search.SearchScope;
import com.intellij.psi.search.searches.ReferencesSearch;
import com.intellij.psi.util.CachedValueProvider;
import com.intellij.psi.util.CachedValuesManager;
import com.intellij.psi.util.ParameterizedCachedValue;
import com.intellij.psi.util.ParameterizedCachedValueProvider;
import com.intellij.psi.xml.XmlTag;
import com.intellij.util.Query;
import com.intellij.util.containers.ContainerUtil;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class ES6UnusedImportsHelper {
    private static final ParameterizedCachedValueProvider<Pair<JSXNamespaceInfo, Collection<String>>, JSElement> JSX_INFO_PROVIDER = param -> {
        JSXNamespaceInfo namespace = JSXNamespaceProvider.getDefaultNamespace((PsiElement)param);
        Collection<String> tags = ES6UnusedImportsHelper.calcUsedJSXTags(param);
        return CachedValueProvider.Result.create((Object)Pair.create((Object)namespace, tags), (Object[])new Object[]{param, JSTypeUtils.getTypeInvalidationDependency()});
    };
    public static final Key<ParameterizedCachedValue<Pair<JSXNamespaceInfo, Collection<String>>, JSElement>> JSX_INFO_KEY = Key.create((String)"jsx.namespace.info");

    public static boolean isES6SuppressedUnused(@NotNull ES6ImportDeclaration importDeclaration) {
        if (importDeclaration == null) {
            ES6UnusedImportsHelper.$$$reportNull$$$0(0);
        }
        return new JSInspectionSuppressor().isSuppressedFor((PsiElement)importDeclaration, ES6UnusedImportsInspection.SHORT_NAME);
    }

    public static boolean isTypeScriptSuppressedUnused(@NotNull TypeScriptImportStatement importDeclaration) {
        if (importDeclaration == null) {
            ES6UnusedImportsHelper.$$$reportNull$$$0(1);
        }
        return new JSInspectionSuppressor().isSuppressedFor((PsiElement)importDeclaration, ES6UnusedImportsInspection.SHORT_NAME);
    }

    @NotNull
    public static UnusedInfo getInfo(@NotNull ES6ImportDeclaration declaration) {
        if (declaration == null) {
            ES6UnusedImportsHelper.$$$reportNull$$$0(2);
        }
        UnusedInfo info2 = new UnusedInfo(declaration);
        info2.fillUsages();
        UnusedInfo unusedInfo = info2;
        if (unusedInfo == null) {
            ES6UnusedImportsHelper.$$$reportNull$$$0(3);
        }
        return unusedInfo;
    }

    @NotNull
    public static UnusedInfo getInfo(@NotNull ES6ImportDeclaration declaration, int position, UnusedInfo prevAnchor) {
        if (declaration == null) {
            ES6UnusedImportsHelper.$$$reportNull$$$0(4);
        }
        UnusedInfo info2 = new UnusedInfo(declaration, position, prevAnchor);
        info2.fillUsages();
        UnusedInfo unusedInfo = info2;
        if (unusedInfo == null) {
            ES6UnusedImportsHelper.$$$reportNull$$$0(5);
        }
        return unusedInfo;
    }

    public static boolean isUnusedTypeScriptImport(@NotNull TypeScriptImportStatement statement) {
        if (statement == null) {
            ES6UnusedImportsHelper.$$$reportNull$$$0(6);
        }
        if (statement.isExported()) {
            return false;
        }
        String name = statement.getName();
        if (StringUtil.isEmpty((String)name)) {
            return false;
        }
        if (statement.getExternalModuleReference() == null && statement.getInternalModuleReference() == null) {
            return false;
        }
        return ES6UnusedImportsHelper.isUnusedInContainer(name, (PsiElement)statement);
    }

    private static boolean isImplicitlyUsed(@NotNull PsiElement element) {
        if (element == null) {
            ES6UnusedImportsHelper.$$$reportNull$$$0(7);
        }
        return ContainerUtil.exists((Iterable)ImplicitUsageProvider.EP_NAME.getExtensionList(), it -> it.isImplicitUsage(element));
    }

    private static boolean isUnusedAlias(@NotNull ES6ImportSpecifierAlias alias) {
        if (alias == null) {
            ES6UnusedImportsHelper.$$$reportNull$$$0(8);
        }
        return ES6UnusedImportsHelper.isUnusedInContainer(alias.getName(), (PsiElement)alias);
    }

    private static boolean isUnusedSpecifier(@NotNull ES6ImportSpecifier specifier) {
        if (specifier == null) {
            ES6UnusedImportsHelper.$$$reportNull$$$0(9);
        }
        if (ES6UnusedImportsHelper.isImplicitlyUsed((PsiElement)specifier)) {
            return false;
        }
        JSElement container = ES6PsiUtil.getExportScope((PsiElement)specifier);
        if (container == null) {
            return false;
        }
        if (ES6UnusedImportsHelper.hasJSXReference(specifier.getReferenceName(), container)) {
            return false;
        }
        Object[] elements = specifier.multiResolve(false);
        List validElements = ContainerUtil.filter((Object[])elements, ES6UnusedImportsHelper::isValid);
        if (elements.length == 0) {
            return !ES6UnusedImportsHelper.hasLocalReferences((PsiElement)specifier, (PsiElement)container);
        }
        if (validElements.isEmpty()) {
            return false;
        }
        for (ResolveResult resolveResult : validElements) {
            PsiElement element = resolveResult.getElement();
            assert (element != null);
            Query<PsiReference> query2 = ES6UnusedImportsHelper.getLocalReferencesQuery(element, (PsiElement)container);
            boolean result2 = query2.forEach(reference -> {
                JSElement containerForReference;
                ApplicationManager.getApplication().assertReadAccessAllowed();
                ProgressManager.checkCanceled();
                PsiElement referenceElement = reference.getElement();
                if (referenceElement instanceof ES6ImportSpecifier && container == (containerForReference = ES6PsiUtil.getExportScope(referenceElement))) {
                    return true;
                }
                return !ES6UnusedImportsHelper.isReferenceCanBeResolvedToSpecifier(referenceElement, (PsiElement)specifier, reference.getCanonicalText());
            });
            if (result2) continue;
            return false;
        }
        return true;
    }

    private static boolean isValid(@NotNull ResolveResult result2) {
        JSResolveResult jsResolveResult;
        JSResolveResult.ProblemKind kind;
        PsiElement element;
        if (result2 == null) {
            ES6UnusedImportsHelper.$$$reportNull$$$0(10);
        }
        if ((element = result2.getElement()) == null) {
            return false;
        }
        if (result2.isValidResult()) {
            return true;
        }
        return result2 instanceof JSResolveResult && (kind = (jsResolveResult = (JSResolveResult)result2).getResolveProblemKind()) == JSResolveResult.ProblemKind.TS_NEED_TO_BE_INCLUDED_TO_CONFIG;
    }

    private static boolean isUnusedImportedBinding(@NotNull ES6ImportedBinding binding) {
        if (binding == null) {
            ES6UnusedImportsHelper.$$$reportNull$$$0(11);
        }
        String name = binding.getName();
        return ES6UnusedImportsHelper.isUnusedInContainer(name, (PsiElement)binding);
    }

    private static boolean isReferenceCanBeResolvedToSpecifier(@NotNull PsiElement refElement, @NotNull PsiElement importSpecifier, @NotNull String name) {
        if (refElement == null) {
            ES6UnusedImportsHelper.$$$reportNull$$$0(12);
        }
        if (importSpecifier == null) {
            ES6UnusedImportsHelper.$$$reportNull$$$0(13);
        }
        if (name == null) {
            ES6UnusedImportsHelper.$$$reportNull$$$0(14);
        }
        ResolveResultSink sink = new ResolveResultSink(refElement, name);
        SinkResolveProcessor<ResolveResultSink> processor = new SinkResolveProcessor<ResolveResultSink>(sink);
        processor.setTypeContext(true);
        processor.setLocalResolve(true);
        return !processor.execute(importSpecifier, ResolveState.initial());
    }

    public static boolean isUnusedInContainer(@Nullable String name, @NotNull PsiElement refElement) {
        if (refElement == null) {
            ES6UnusedImportsHelper.$$$reportNull$$$0(15);
        }
        if (ES6UnusedImportsHelper.isImplicitlyUsed(refElement)) {
            return false;
        }
        JSElement container = ES6PsiUtil.getExportScope(refElement);
        if (container == null || name == null || ES6UnusedImportsHelper.hasJSXReference(name, container)) {
            return false;
        }
        return !ES6UnusedImportsHelper.hasLocalReferences(refElement, (PsiElement)container);
    }

    private static boolean hasJSXReference(@Nullable String name, @NotNull JSElement container) {
        if (container == null) {
            ES6UnusedImportsHelper.$$$reportNull$$$0(16);
        }
        if (name == null || !DialectDetector.isJSX((PsiElement)container)) {
            return false;
        }
        Pair<JSXNamespaceInfo, Collection<String>> pair = ES6UnusedImportsHelper.getUsedJSXInfo(container);
        JSXNamespaceInfo info2 = (JSXNamespaceInfo)pair.first;
        Collection tags = (Collection)pair.second;
        if (tags.isEmpty()) {
            return false;
        }
        if (Objects.equals(name, info2.getFragmentFactoryOrDefault()) && tags.contains("")) {
            return true;
        }
        return tags.contains(name) || Objects.equals(info2.jsxFactory, name);
    }

    private static boolean hasLocalReferences(@NotNull PsiElement refElement, @NotNull PsiElement container) {
        Query<PsiReference> search;
        if (refElement == null) {
            ES6UnusedImportsHelper.$$$reportNull$$$0(17);
        }
        if (container == null) {
            ES6UnusedImportsHelper.$$$reportNull$$$0(18);
        }
        return (search = ES6UnusedImportsHelper.getLocalReferencesQuery(refElement, container)).findFirst() != null;
    }

    @NotNull
    private static Query<PsiReference> getLocalReferencesQuery(@NotNull PsiElement refElement, @NotNull PsiElement container) {
        if (refElement == null) {
            ES6UnusedImportsHelper.$$$reportNull$$$0(19);
        }
        if (container == null) {
            ES6UnusedImportsHelper.$$$reportNull$$$0(20);
        }
        LocalSearchScope scope2 = new LocalSearchScope(container);
        Query query2 = ReferencesSearch.search((PsiElement)refElement, (SearchScope)scope2, (boolean)true);
        if (query2 == null) {
            ES6UnusedImportsHelper.$$$reportNull$$$0(21);
        }
        return query2;
    }

    @NotNull
    public static Pair<JSXNamespaceInfo, Collection<String>> getUsedJSXInfo(@NotNull JSElement element) {
        if (element == null) {
            ES6UnusedImportsHelper.$$$reportNull$$$0(22);
        }
        Pair pair = (Pair)CachedValuesManager.getManager((Project)element.getProject()).getParameterizedCachedValue((UserDataHolder)element, JSX_INFO_KEY, JSX_INFO_PROVIDER, false, (Object)element);
        if (pair == null) {
            ES6UnusedImportsHelper.$$$reportNull$$$0(23);
        }
        return pair;
    }

    @NotNull
    private static Collection<String> calcUsedJSXTags(@NotNull JSElement container) {
        if (container == null) {
            ES6UnusedImportsHelper.$$$reportNull$$$0(24);
        }
        final HashSet<String> results = new HashSet<String>();
        container.accept(new JSRecursiveWalkingElementVisitor(){

            @Override
            public void visitJSLiteralExpression(@NotNull JSLiteralExpression node) {
                if (node == null) {
                    1.$$$reportNull$$$0(0);
                }
                if (node instanceof XmlTag) {
                    String name = node.getName();
                    if (!StringUtil.isEmpty((String)name)) {
                        List strings = StringUtil.split((String)name, (String)".");
                        if (!strings.isEmpty()) {
                            results.add((String)ContainerUtil.getFirstItem((List)strings));
                        }
                    } else {
                        results.add("");
                    }
                }
                super.visitJSLiteralExpression(node);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "node", "com/intellij/lang/typescript/imports/ES6UnusedImportsHelper$1", "visitJSLiteralExpression"));
            }
        });
        HashSet<String> hashSet = results;
        if (hashSet == null) {
            ES6UnusedImportsHelper.$$$reportNull$$$0(25);
        }
        return hashSet;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 3, 5, 21, 23, 25 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "importDeclaration";
                break;
            }
            case 2: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "declaration";
                break;
            }
            case 3: 
            case 5: 
            case 21: 
            case 23: 
            case 25: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/typescript/imports/ES6UnusedImportsHelper";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "statement";
                break;
            }
            case 7: 
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "alias";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "specifier";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "result";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "binding";
                break;
            }
            case 12: 
            case 15: 
            case 17: 
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "refElement";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "importSpecifier";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 16: 
            case 18: 
            case 20: 
            case 24: {
                objectArray2 = objectArray3;
                objectArray3[0] = "container";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/typescript/imports/ES6UnusedImportsHelper";
                break;
            }
            case 3: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getInfo";
                break;
            }
            case 21: {
                objectArray = objectArray2;
                objectArray2[1] = "getLocalReferencesQuery";
                break;
            }
            case 23: {
                objectArray = objectArray2;
                objectArray2[1] = "getUsedJSXInfo";
                break;
            }
            case 25: {
                objectArray = objectArray2;
                objectArray2[1] = "calcUsedJSXTags";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "isES6SuppressedUnused";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "isTypeScriptSuppressedUnused";
                break;
            }
            case 2: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "getInfo";
                break;
            }
            case 3: 
            case 5: 
            case 21: 
            case 23: 
            case 25: {
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "isUnusedTypeScriptImport";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "isImplicitlyUsed";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "isUnusedAlias";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "isUnusedSpecifier";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "isValid";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "isUnusedImportedBinding";
                break;
            }
            case 12: 
            case 13: 
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "isReferenceCanBeResolvedToSpecifier";
                break;
            }
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "isUnusedInContainer";
                break;
            }
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "hasJSXReference";
                break;
            }
            case 17: 
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "hasLocalReferences";
                break;
            }
            case 19: 
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "getLocalReferencesQuery";
                break;
            }
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "getUsedJSXInfo";
                break;
            }
            case 24: {
                objectArray = objectArray;
                objectArray[2] = "calcUsedJSXTags";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 3, 5, 21, 23, 25 -> new IllegalStateException(string);
        };
    }

    public static class UnusedInfo {
        @NotNull
        private final ES6ImportDeclaration myDeclaration;
        private final Collection<ES6ImportedBinding> myUnusedBindings;
        private final Collection<ES6ImportSpecifier> myUnusedSpecifiers;
        private boolean myIsUnused;
        private boolean mySideEffectImport;
        private final int myPosition;
        @Nullable
        private final UnusedInfo myPrevAnchor;

        @NotNull
        public ES6ImportDeclaration getDeclaration() {
            ES6ImportDeclaration eS6ImportDeclaration = this.myDeclaration;
            if (eS6ImportDeclaration == null) {
                UnusedInfo.$$$reportNull$$$0(0);
            }
            return eS6ImportDeclaration;
        }

        @NotNull
        public Collection<ES6ImportedBinding> getUnusedBindings() {
            Collection<ES6ImportedBinding> collection = this.myUnusedBindings;
            if (collection == null) {
                UnusedInfo.$$$reportNull$$$0(1);
            }
            return collection;
        }

        @NotNull
        public Collection<ES6ImportSpecifier> getUnusedSpecifiers() {
            Collection<ES6ImportSpecifier> collection = this.myUnusedSpecifiers;
            if (collection == null) {
                UnusedInfo.$$$reportNull$$$0(2);
            }
            return collection;
        }

        public boolean isAllUnused() {
            return this.myIsUnused;
        }

        public UnusedInfo(@NotNull ES6ImportDeclaration declaration) {
            if (declaration == null) {
                UnusedInfo.$$$reportNull$$$0(3);
            }
            this.myUnusedBindings = new HashSet<ES6ImportedBinding>();
            this.myUnusedSpecifiers = new HashSet<ES6ImportSpecifier>();
            this.myDeclaration = declaration;
            this.myPosition = -1;
            this.myPrevAnchor = null;
        }

        public UnusedInfo(@NotNull ES6ImportDeclaration declaration, int pos, UnusedInfo prevAnchor) {
            if (declaration == null) {
                UnusedInfo.$$$reportNull$$$0(4);
            }
            this.myUnusedBindings = new HashSet<ES6ImportedBinding>();
            this.myUnusedSpecifiers = new HashSet<ES6ImportSpecifier>();
            this.myDeclaration = declaration;
            this.myPosition = pos;
            this.myPrevAnchor = prevAnchor;
        }

        public boolean isEmpty() {
            return this.myDeclaration.getImportSpecifiers().length == 0 && this.myDeclaration.getImportedBindings().length == 0;
        }

        public boolean isSideEffectImport() {
            return this.mySideEffectImport;
        }

        private void fillUsages() {
            ES6ImportedBinding[] bindings;
            ES6ImportSpecifier[] specifiers;
            boolean hasUsages = false;
            for (ES6ImportSpecifier specifier : specifiers = this.myDeclaration.getImportSpecifiers()) {
                ES6ImportSpecifierAlias alias = specifier.getAlias();
                if (alias != null && ES6UnusedImportsHelper.isUnusedAlias(alias) || alias == null && ES6UnusedImportsHelper.isUnusedSpecifier(specifier)) {
                    this.myUnusedSpecifiers.add(specifier);
                    continue;
                }
                hasUsages = true;
            }
            for (ES6ImportedBinding binding : bindings = this.myDeclaration.getImportedBindings()) {
                if (ES6UnusedImportsHelper.isUnusedImportedBinding(binding)) {
                    this.myUnusedBindings.add(binding);
                    continue;
                }
                hasUsages = true;
            }
            this.mySideEffectImport = !StringUtil.isEmpty((String)this.myDeclaration.getImportModuleText());
            this.myIsUnused = !this.mySideEffectImport && !hasUsages;
        }

        public int getPosition() {
            return this.myPosition;
        }

        @Nullable
        public UnusedInfo getPrevAnchor() {
            return this.myPrevAnchor;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 2;
                case 3, 4 -> 3;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/lang/typescript/imports/ES6UnusedImportsHelper$UnusedInfo";
                    break;
                }
                case 3: 
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "declaration";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getDeclaration";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getUnusedBindings";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getUnusedSpecifiers";
                    break;
                }
                case 3: 
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/lang/typescript/imports/ES6UnusedImportsHelper$UnusedInfo";
                    break;
                }
            }
            switch (n) {
                default: {
                    break;
                }
                case 3: 
                case 4: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalStateException(string);
                case 3, 4 -> new IllegalArgumentException(string);
            };
        }
    }
}

