/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.typescript.hint;

import com.intellij.injected.editor.VirtualFileWindow;
import com.intellij.javascript.JSParameterInfoHandler;
import com.intellij.lang.javascript.psi.JSArgumentsHolder;
import com.intellij.lang.javascript.psi.JSFunctionType;
import com.intellij.lang.javascript.service.JSLanguageServiceUtil;
import com.intellij.lang.parameterInfo.CreateParameterInfoContext;
import com.intellij.lang.typescript.compiler.TypeScriptService;
import com.intellij.lang.typescript.compiler.languageService.TypeScriptLanguageServiceUtil;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiFile;
import java.util.concurrent.Future;
import java.util.stream.Stream;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class TypeScriptParameterInfoHandler
extends JSParameterInfoHandler {
    @Override
    @Nullable
    protected Stream<JSFunctionType> fillSignaturesForArgumentList(CreateParameterInfoContext context2, @NotNull JSArgumentsHolder argList) {
        Stream<JSFunctionType> result2;
        if (argList == null) {
            TypeScriptParameterInfoHandler.$$$reportNull$$$0(0);
        }
        if ((result2 = super.fillSignaturesForArgumentList(context2, argList)) != null) {
            return result2;
        }
        PsiFile file = context2.getFile();
        Project project = context2.getProject();
        VirtualFile virtualFile = file.getVirtualFile();
        if (virtualFile instanceof VirtualFileWindow || !TypeScriptLanguageServiceUtil.useServiceParameterInfo(project, virtualFile)) {
            return null;
        }
        TypeScriptService service2 = TypeScriptService.getForFile(project, virtualFile);
        if (service2 == null) {
            return null;
        }
        Future<Stream<JSFunctionType>> future = service2.getSignatureHelp(file, context2);
        return JSLanguageServiceUtil.awaitFuture(future, JSLanguageServiceUtil.getShortTimeout(), 5L, null);
    }

    @Override
    protected boolean skipTypeScript() {
        return false;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "argList", "com/intellij/lang/typescript/hint/TypeScriptParameterInfoHandler", "fillSignaturesForArgumentList"));
    }
}

