/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.typescript.editing;

import com.intellij.injected.editor.VirtualFileWindow;
import com.intellij.lang.Language;
import com.intellij.lang.javascript.DialectOptionHolder;
import com.intellij.lang.javascript.JSLanguageDialect;
import com.intellij.lang.javascript.editing.JSDeclarativeTypeHintsInlayProvider;
import com.intellij.lang.javascript.psi.JSElement;
import com.intellij.lang.javascript.psi.JSFunctionType;
import com.intellij.lang.javascript.psi.JSType;
import com.intellij.lang.javascript.psi.types.JSTypeParser;
import com.intellij.lang.javascript.psi.types.JSTypeSource;
import com.intellij.lang.javascript.service.JSLanguageServiceUtil;
import com.intellij.lang.typescript.compiler.TypeScriptCompilerSettings;
import com.intellij.lang.typescript.compiler.TypeScriptService;
import com.intellij.lang.typescript.compiler.languageService.protocol.commands.response.TypeScriptQuickInfoResponse;
import com.intellij.lang.typescript.documentation.TypeScriptServiceQuickInfoParser;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 \u00142\u00020\u0001:\u0001\u0014B\u0005\u00a2\u0006\u0002\u0010\u0002J\b\u0010\u0003\u001a\u00020\u0004H\u0016J\"\u0010\u0005\u001a\u0004\u0018\u00010\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0016J\u0010\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010H\u0016J\u0012\u0010\u0011\u001a\u00020\u000e2\b\u0010\u0012\u001a\u0004\u0018\u00010\u0013H\u0014\u00a8\u0006\u0015"}, d2={"Lcom/intellij/lang/typescript/editing/TypeScriptDeclarativeTypeTypeHintsInlayProvider;", "Lcom/intellij/lang/javascript/editing/JSDeclarativeTypeHintsInlayProvider;", "()V", "getLanguageServiceUsage", "Lcom/intellij/lang/javascript/editing/JSDeclarativeTypeHintsInlayProvider$LanguageServiceUsage;", "getTypeFromService", "", "element", "Lcom/intellij/lang/javascript/psi/JSElement;", "kind", "Lcom/intellij/lang/javascript/editing/JSDeclarativeTypeHintsInlayProvider$HintFromServiceKind;", "serviceTimeoutMs", "", "isLanguageSupported", "", "language", "Lcom/intellij/lang/Language;", "isSupportedDialect", "dialectOfElement", "Lcom/intellij/lang/javascript/DialectOptionHolder;", "Companion", "intellij.javascript.impl"})
public final class TypeScriptDeclarativeTypeTypeHintsInlayProvider
extends JSDeclarativeTypeHintsInlayProvider {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    public static final String LANGUAGE_SERVICE_USAGE_KEY = "typescript.inlayTypeHints.languageServiceUsage";
    @NotNull
    public static final String ONLY_SERVICE_OPTION = "Only service";
    @NotNull
    public static final String ONLY_INTERNAL_OPTION = "Only internal";

    @Override
    public boolean isLanguageSupported(@NotNull Language language) {
        Intrinsics.checkNotNullParameter((Object)language, (String)"language");
        return language instanceof JSLanguageDialect && ((JSLanguageDialect)language).getOptionHolder().isTypeScript;
    }

    @Override
    protected boolean isSupportedDialect(@Nullable DialectOptionHolder dialectOfElement) {
        return dialectOfElement != null && dialectOfElement.isTypeScript;
    }

    /*
     * Unable to fully structure code
     */
    @Override
    @NotNull
    public JSDeclarativeTypeHintsInlayProvider.LanguageServiceUsage getLanguageServiceUsage() {
        block5: {
            block4: {
                var1_1 = Registry.get((String)"typescript.inlayTypeHints.languageServiceUsage").getSelectedOption();
                if (var1_1 == null) break block4;
                switch (var1_1.hashCode()) {
                    case -628909935: {
                        if (var1_1.equals("Only internal")) break;
                        ** break;
                    }
                    case -271291807: {
                        if (!var1_1.equals("Only service")) ** break;
                        v0 = JSDeclarativeTypeHintsInlayProvider.LanguageServiceUsage.ONLY_SERVICE;
                        break block5;
                    }
                }
                v0 = JSDeclarativeTypeHintsInlayProvider.LanguageServiceUsage.ONLY_INTERNAL;
                break block5;
            }
            v0 = JSDeclarativeTypeHintsInlayProvider.LanguageServiceUsage.SERVICE_THEN_INTERNAL;
        }
        return v0;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    @Nullable
    public String getTypeFromService(@NotNull JSElement element, @NotNull JSDeclarativeTypeHintsInlayProvider.HintFromServiceKind kind, long serviceTimeoutMs) {
        JSType resultType;
        JSType jSType;
        Object object;
        TypeScriptQuickInfoResponse serviceResponse;
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        Intrinsics.checkNotNullParameter((Object)((Object)kind), (String)"kind");
        TypeScriptCompilerSettings typeScriptCompilerSettings = TypeScriptCompilerSettings.getSettings(element.getProject());
        if (typeScriptCompilerSettings == null) {
            return null;
        }
        TypeScriptCompilerSettings settings2 = typeScriptCompilerSettings;
        if (!settings2.useService()) {
            return null;
        }
        PsiFile psiFile = element.getContainingFile();
        if (psiFile == null) return null;
        VirtualFile virtualFile = psiFile.getVirtualFile();
        if (virtualFile == null) {
            return null;
        }
        VirtualFile virtualFile2 = virtualFile;
        if (virtualFile2 instanceof VirtualFileWindow) {
            return null;
        }
        Project project = element.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
        TypeScriptService typeScriptService = TypeScriptService.Companion.getForFile(project, virtualFile2);
        if (typeScriptService == null) {
            return null;
        }
        TypeScriptService service2 = typeScriptService;
        PsiElement psiElement = element.getOriginalElement();
        Intrinsics.checkNotNullExpressionValue((Object)psiElement, (String)"getOriginalElement(...)");
        VirtualFile virtualFile3 = element.getOriginalElement().getContainingFile().getVirtualFile();
        Intrinsics.checkNotNullExpressionValue((Object)virtualFile3, (String)"getVirtualFile(...)");
        TypeScriptQuickInfoResponse typeScriptQuickInfoResponse = serviceResponse = JSLanguageServiceUtil.awaitFuture(service2.getQuickInfoAt(psiElement, virtualFile3), serviceTimeoutMs);
        if (typeScriptQuickInfoResponse == null) return null;
        String string = typeScriptQuickInfoResponse.displayString;
        if (string == null) {
            return null;
        }
        String quickInfoStr = string;
        TypeScriptServiceQuickInfoParser.ParsedInfo parsedInfo = TypeScriptServiceQuickInfoParser.parseServiceTextAsInfo(quickInfoStr);
        if (parsedInfo == null) {
            return null;
        }
        TypeScriptServiceQuickInfoParser.ParsedInfo parsedQuickInfo = parsedInfo;
        String string2 = parsedQuickInfo.myRestPart;
        if (string2 == null) {
            return null;
        }
        String restPart = string2;
        if (kind == JSDeclarativeTypeHintsInlayProvider.HintFromServiceKind.FIELD_OR_VAR_TYPE && StringsKt.startsWith$default((String)restPart, (String)": ", (boolean)false, (int)2, null)) {
            String string3 = restPart.substring(2);
            object = string3;
            Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"substring(...)");
        } else {
            if (kind != JSDeclarativeTypeHintsInlayProvider.HintFromServiceKind.FUNCTION_RETURN_TYPE) return null;
            String string4 = parsedQuickInfo.myKeywords;
            Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"myKeywords");
            if (!StringsKt.contains$default((CharSequence)string4, (CharSequence)"function", (boolean)false, (int)2, null)) {
                String string5 = parsedQuickInfo.myKindPrefix;
                Intrinsics.checkNotNullExpressionValue((Object)string5, (String)"myKindPrefix");
                if (!StringsKt.contains$default((CharSequence)string5, (CharSequence)"function", (boolean)false, (int)2, null)) {
                    String string6 = parsedQuickInfo.myKindPrefix;
                    Intrinsics.checkNotNullExpressionValue((Object)string6, (String)"myKindPrefix");
                    if (!StringsKt.contains$default((CharSequence)string6, (CharSequence)"method", (boolean)false, (int)2, null)) return null;
                }
            }
            object = "function " + restPart;
        }
        String typeStr = object;
        JSType jSType2 = JSTypeParser.createTypeFromJSDoc(element.getProject(), typeStr, JSTypeSource.EMPTY);
        if (jSType2 == null) {
            return null;
        }
        JSType elementType = jSType2;
        if (kind == JSDeclarativeTypeHintsInlayProvider.HintFromServiceKind.FUNCTION_RETURN_TYPE) {
            if (!(elementType instanceof JSFunctionType)) return null;
            JSFunctionType jSFunctionType = (JSFunctionType)elementType;
            jSType = jSFunctionType;
            if (jSFunctionType == null) return null;
            if ((jSType = jSType.getReturnType()) == null) {
                return null;
            }
        } else {
            jSType = elementType;
        }
        if (this.isSuitableType(resultType = jSType)) return resultType.getTypeText(JSType.TypeTextFormat.PRESENTABLE);
        return "";
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0007"}, d2={"Lcom/intellij/lang/typescript/editing/TypeScriptDeclarativeTypeTypeHintsInlayProvider$Companion;", "", "()V", "LANGUAGE_SERVICE_USAGE_KEY", "", "ONLY_INTERNAL_OPTION", "ONLY_SERVICE_OPTION", "intellij.javascript.impl"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

