/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.typescript.documentation;

import com.intellij.lang.javascript.documentation.JSHtmlHighlightingUtil;
import com.intellij.lang.javascript.documentation.JSQuickNavigateBuilder;
import com.intellij.openapi.diagnostic.ControlFlowException;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class TypeScriptServiceQuickInfoParser {
    private static final Set<String> KEYWORDS = Set.of("var", "let", "const", "class", "enum", "function", "module", "namespace", "export", "private", "public", "protected", "type", "interface", "static", "readonly", "async");

    public static String parseServiceText(@NotNull PsiElement resolvedElement, @NotNull String originalText) {
        ParsedInfo info2;
        if (resolvedElement == null) {
            TypeScriptServiceQuickInfoParser.$$$reportNull$$$0(0);
        }
        if (originalText == null) {
            TypeScriptServiceQuickInfoParser.$$$reportNull$$$0(1);
        }
        if ((info2 = TypeScriptServiceQuickInfoParser.parseServiceTextAsInfo(originalText)) == null) {
            return StringUtil.escapeXmlEntities((String)originalText);
        }
        return TypeScriptServiceQuickInfoParser.getQuickNavigate(resolvedElement, info2);
    }

    @Nullable
    public static ParsedInfo parseServiceTextAsInfo(@NotNull String originalText) {
        if (originalText == null) {
            TypeScriptServiceQuickInfoParser.$$$reportNull$$$0(2);
        }
        try {
            int close;
            String processText = originalText;
            String kind = "";
            if (processText.startsWith("(") && (close = processText.indexOf(") ")) > 0) {
                kind = processText.substring(0, close + 2);
                processText = processText.substring(close + 2);
            }
            int space = processText.indexOf(" ");
            int lastKeywordStartOffset = 0;
            while (space >= 0 && KEYWORDS.contains(processText.substring(lastKeywordStartOffset, space))) {
                lastKeywordStartOffset = space;
                space = processText.indexOf(" ", lastKeywordStartOffset);
            }
            String keywords = "";
            if (lastKeywordStartOffset > 0) {
                keywords = processText.substring(0, lastKeywordStartOffset + 1);
                processText = processText.substring(lastKeywordStartOffset + 1);
            }
            if (processText.isEmpty()) {
                return null;
            }
            int qNameIndex = TypeScriptServiceQuickInfoParser.readQNameWithGenerics(processText);
            if (qNameIndex == 0) {
                return null;
            }
            String restPart = processText.substring(qNameIndex);
            String postfix = "";
            int indexOfOverloads = restPart.indexOf("(+");
            if (indexOfOverloads > 0) {
                postfix = restPart.substring(indexOfOverloads);
                restPart = restPart.substring(0, indexOfOverloads);
            }
            String qName = processText.substring(0, qNameIndex);
            return new ParsedInfo(keywords, restPart, qName, kind, postfix);
        }
        catch (RuntimeException e) {
            if (e instanceof ControlFlowException) {
                throw e;
            }
            Logger.getInstance(TypeScriptServiceQuickInfoParser.class).warn("Cannot parse service text: " + originalText, (Throwable)e);
            return null;
        }
    }

    private static int readQNameWithGenerics(@NotNull String processText) {
        if (processText == null) {
            TypeScriptServiceQuickInfoParser.$$$reportNull$$$0(3);
        }
        if (processText.isEmpty()) {
            return 0;
        }
        int qNameIndex = 0;
        char ch = processText.charAt(0);
        if (Character.isJavaIdentifierStart(ch)) {
            while (processText.length() > qNameIndex && (Character.isJavaIdentifierStart(processText.charAt(qNameIndex)) || processText.charAt(qNameIndex) == '<')) {
                int before = qNameIndex;
                if (processText.charAt(qNameIndex) == '<') {
                    int end = TypeScriptServiceQuickInfoParser.findGenericsEnd(processText.substring(qNameIndex));
                    if (end <= 0 || processText.length() <= qNameIndex + end) break;
                    if (processText.charAt(qNameIndex += end) == '.') {
                        ++qNameIndex;
                    }
                } else {
                    qNameIndex = TypeScriptServiceQuickInfoParser.readQualifiedName(processText, qNameIndex);
                }
                if (before != qNameIndex) continue;
                break;
            }
        }
        return qNameIndex;
    }

    private static int findGenericsEnd(@NotNull String rest) {
        if (rest == null) {
            TypeScriptServiceQuickInfoParser.$$$reportNull$$$0(4);
        }
        int count = 1;
        char[] array = rest.toCharArray();
        for (int i = 0; i < array.length; ++i) {
            if (i == 0) continue;
            char c2 = array[i];
            if (c2 == '<') {
                ++count;
            }
            if (c2 == '>') {
                --count;
            }
            if (count != 0) continue;
            return i + 1;
        }
        return -1;
    }

    private static int readQualifiedName(String processText, int qNameIndex) {
        ++qNameIndex;
        while (processText.length() > qNameIndex && (Character.isJavaIdentifierPart(processText.charAt(qNameIndex)) || '.' == processText.charAt(qNameIndex))) {
            ++qNameIndex;
        }
        return qNameIndex;
    }

    private static String getQuickNavigate(@NotNull PsiElement element, @NotNull ParsedInfo info2) {
        if (element == null) {
            TypeScriptServiceQuickInfoParser.$$$reportNull$$$0(5);
        }
        if (info2 == null) {
            TypeScriptServiceQuickInfoParser.$$$reportNull$$$0(6);
        }
        String name = StringUtil.escapeXmlEntities((String)info2.myQName);
        if (!info2.myKeywords.isEmpty()) {
            return info2.myKindPrefix + TypeScriptServiceQuickInfoParser.getQuickNavigateByKeyword(element, info2.myRestPart, info2.myKeywords, name) + info2.myOverloadInfo;
        }
        String htmlText = switch (info2.getObjectKind()) {
            case JSQuickNavigateBuilder.ObjectKind.FUNCTION, JSQuickNavigateBuilder.ObjectKind.METHOD -> JSQuickNavigateBuilder.buildHtmlForFunction(element, "", name, false, info2.myRestPart);
            default -> JSQuickNavigateBuilder.buildHtmlForVariableOrField(element, "", name, false, info2.myRestPart);
        };
        return info2.myKindPrefix + htmlText + info2.myOverloadInfo;
    }

    private static JSQuickNavigateBuilder.ObjectKind toObjectKind(@NotNull String kindPrefix) {
        if (kindPrefix == null) {
            TypeScriptServiceQuickInfoParser.$$$reportNull$$$0(7);
        }
        for (JSQuickNavigateBuilder.ObjectKind value : JSQuickNavigateBuilder.ObjectKind.values()) {
            if (!value.toPrefix().equals(kindPrefix)) continue;
            return value;
        }
        return JSQuickNavigateBuilder.ObjectKind.SIMPLE_DECLARATION;
    }

    @NotNull
    private static String getQuickNavigateByKeyword(@NotNull PsiElement element, @NotNull String restPart, @NotNull String keywords, @NotNull String qName) {
        if (element == null) {
            TypeScriptServiceQuickInfoParser.$$$reportNull$$$0(8);
        }
        if (restPart == null) {
            TypeScriptServiceQuickInfoParser.$$$reportNull$$$0(9);
        }
        if (keywords == null) {
            TypeScriptServiceQuickInfoParser.$$$reportNull$$$0(10);
        }
        if (qName == null) {
            TypeScriptServiceQuickInfoParser.$$$reportNull$$$0(11);
        }
        String finalText = keywords + "$$Name$$" + restPart;
        TextRange nameRange = new TextRange(keywords.length(), keywords.length() + "$$Name$$".length());
        String string = JSQuickNavigateBuilder.getQuickNavigateHtmlHighlighting(element, qName, "", finalText, nameRange);
        if (string == null) {
            TypeScriptServiceQuickInfoParser.$$$reportNull$$$0(12);
        }
        return string;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 12 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "resolvedElement";
                break;
            }
            case 1: 
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "originalText";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "processText";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "rest";
                break;
            }
            case 5: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "info";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "kindPrefix";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "restPart";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "keywords";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "qName";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/typescript/documentation/TypeScriptServiceQuickInfoParser";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/typescript/documentation/TypeScriptServiceQuickInfoParser";
                break;
            }
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "getQuickNavigateByKeyword";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "parseServiceText";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "parseServiceTextAsInfo";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "readQNameWithGenerics";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "findGenericsEnd";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "getQuickNavigate";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "toObjectKind";
                break;
            }
            case 8: 
            case 9: 
            case 10: 
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "getQuickNavigateByKeyword";
                break;
            }
            case 12: {
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 12 -> new IllegalStateException(string);
        };
    }

    public static class ParsedInfo {
        public static final String PREFIX = "...";
        public final String myKeywords;
        public final String myRestPart;
        public final String myRestPartWithPlaceHolders;
        public final List<JSHtmlHighlightingUtil.TextPlaceholder> myPlaceholders;
        public final String myQName;
        public final String myKindPrefix;
        public final String myOverloadInfo;

        ParsedInfo(@NotNull String keywords, @NotNull String restPart, @NotNull String qName, @NotNull String kindPrefix, @NotNull String overloadInfo) {
            if (keywords == null) {
                ParsedInfo.$$$reportNull$$$0(0);
            }
            if (restPart == null) {
                ParsedInfo.$$$reportNull$$$0(1);
            }
            if (qName == null) {
                ParsedInfo.$$$reportNull$$$0(2);
            }
            if (kindPrefix == null) {
                ParsedInfo.$$$reportNull$$$0(3);
            }
            if (overloadInfo == null) {
                ParsedInfo.$$$reportNull$$$0(4);
            }
            this.myPlaceholders = new ArrayList<JSHtmlHighlightingUtil.TextPlaceholder>();
            this.myKeywords = keywords;
            this.myRestPart = restPart;
            this.myQName = qName;
            this.myKindPrefix = kindPrefix;
            this.myOverloadInfo = overloadInfo;
            this.myRestPartWithPlaceHolders = this.cropImportPart(this.parseRestPart());
        }

        @NotNull
        private JSQuickNavigateBuilder.ObjectKind getObjectKind() {
            JSQuickNavigateBuilder.ObjectKind objectKind = TypeScriptServiceQuickInfoParser.toObjectKind(this.myKindPrefix);
            if (objectKind == null) {
                ParsedInfo.$$$reportNull$$$0(5);
            }
            return objectKind;
        }

        @NotNull
        private String cropImportPart(@NotNull String restPart) {
            if (restPart == null) {
                ParsedInfo.$$$reportNull$$$0(6);
            }
            if (!this.myKindPrefix.contains("alias")) {
                String string = restPart;
                if (string == null) {
                    ParsedInfo.$$$reportNull$$$0(7);
                }
                return string;
            }
            String import_prefix = "\nimport ";
            int import_ = restPart.lastIndexOf(import_prefix);
            if (import_ > 0) {
                String string = restPart.substring(0, import_);
                if (string == null) {
                    ParsedInfo.$$$reportNull$$$0(8);
                }
                return string;
            }
            String string = restPart;
            if (string == null) {
                ParsedInfo.$$$reportNull$$$0(9);
            }
            return string;
        }

        @NotNull
        private String parseRestPart() {
            String currentString = this.myRestPart;
            int threeDots = currentString.indexOf(PREFIX);
            StringBuilder newRest = new StringBuilder();
            int counter2 = 0;
            while (threeDots > 0 && threeDots + PREFIX.length() < currentString.length()) {
                ProgressManager.checkCanceled();
                int afterPrefixIndex = threeDots + PREFIX.length();
                char afterPrefix = currentString.charAt(afterPrefixIndex);
                if (Character.isWhitespace(afterPrefix) && afterPrefixIndex + 1 < currentString.length()) {
                    char nextChar = currentString.charAt(afterPrefixIndex + 1);
                    if (nextChar == '|' || nextChar == '&') {
                        this.addHolderForPrefix(currentString, newRest, threeDots, ++counter2);
                        currentString = currentString.substring(threeDots + PREFIX.length());
                        threeDots = currentString.indexOf(PREFIX);
                        continue;
                    }
                    if (!Character.isDigit(nextChar)) {
                        threeDots = currentString.indexOf(PREFIX, threeDots + PREFIX.length());
                        continue;
                    }
                    newRest.append(currentString, 0, threeDots);
                    int skipped = ParsedInfo.skipMessageAndDigits(currentString, afterPrefixIndex + 1);
                    if (skipped <= 0) {
                        this.myPlaceholders.clear();
                        String string = this.myRestPart;
                        if (string == null) {
                            ParsedInfo.$$$reportNull$$$0(10);
                        }
                        return string;
                    }
                    String toReplace = currentString.substring(threeDots, skipped);
                    String holderText = "$$Type$$Srv" + ++counter2 + "_" + this.hashCode();
                    JSHtmlHighlightingUtil.TextPlaceholder holder = JSHtmlHighlightingUtil.createSimpleHolder(toReplace, holderText);
                    newRest.append(holderText);
                    this.myPlaceholders.add(holder);
                    currentString = currentString.substring(skipped);
                    threeDots = currentString.indexOf(PREFIX);
                    continue;
                }
                int before = threeDots - 1;
                int after = threeDots + PREFIX.length();
                if (before > 0 && after < currentString.length() && currentString.charAt(before) == '<' && currentString.charAt(after) == '>') {
                    this.addHolderForPrefix(currentString, newRest, threeDots, ++counter2);
                    currentString = currentString.substring(after);
                    threeDots = currentString.indexOf(PREFIX);
                    continue;
                }
                threeDots = currentString.indexOf(PREFIX, threeDots + PREFIX.length());
            }
            newRest.append(currentString);
            String string = newRest.toString();
            if (string == null) {
                ParsedInfo.$$$reportNull$$$0(11);
            }
            return string;
        }

        private void addHolderForPrefix(@NotNull String currentString, @NotNull StringBuilder newRest, int offset, int counter2) {
            if (currentString == null) {
                ParsedInfo.$$$reportNull$$$0(12);
            }
            if (newRest == null) {
                ParsedInfo.$$$reportNull$$$0(13);
            }
            String holderText = "$$Type$$Srv" + counter2 + "_" + this.hashCode();
            String toReplace = currentString.substring(offset, offset + PREFIX.length());
            JSHtmlHighlightingUtil.TextPlaceholder holder = JSHtmlHighlightingUtil.createSimpleHolder(toReplace, holderText);
            newRest.append(currentString, 0, offset);
            newRest.append(holder.getHolderText());
            this.myPlaceholders.add(holder);
        }

        private static int skipMessageAndDigits(@NotNull String restPart, int index) {
            if (restPart == null) {
                ParsedInfo.$$$reportNull$$$0(14);
            }
            while (restPart.length() > index && Character.isDigit(restPart.charAt(index))) {
                ++index;
            }
            if (restPart.length() <= index) {
                return -1;
            }
            char space = restPart.charAt(index);
            if (!Character.isWhitespace(space)) {
                return -1;
            }
            ++index;
            while (restPart.length() > index && Character.isLetter(restPart.charAt(index))) {
                ++index;
            }
            if (restPart.length() <= index) {
                return -1;
            }
            String next = restPart.substring(index);
            if (next.startsWith(" ...")) {
                return " ...".length() + index;
            }
            return -1;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 5, 7, 8, 9, 10, 11 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "keywords";
                    break;
                }
                case 1: 
                case 6: 
                case 14: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "restPart";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "qName";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "kindPrefix";
                    break;
                }
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "overloadInfo";
                    break;
                }
                case 5: 
                case 7: 
                case 8: 
                case 9: 
                case 10: 
                case 11: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/lang/typescript/documentation/TypeScriptServiceQuickInfoParser$ParsedInfo";
                    break;
                }
                case 12: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "currentString";
                    break;
                }
                case 13: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "newRest";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/lang/typescript/documentation/TypeScriptServiceQuickInfoParser$ParsedInfo";
                    break;
                }
                case 5: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getObjectKind";
                    break;
                }
                case 7: 
                case 8: 
                case 9: {
                    objectArray = objectArray2;
                    objectArray2[1] = "cropImportPart";
                    break;
                }
                case 10: 
                case 11: {
                    objectArray = objectArray2;
                    objectArray2[1] = "parseRestPart";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 5: 
                case 7: 
                case 8: 
                case 9: 
                case 10: 
                case 11: {
                    break;
                }
                case 6: {
                    objectArray = objectArray;
                    objectArray[2] = "cropImportPart";
                    break;
                }
                case 12: 
                case 13: {
                    objectArray = objectArray;
                    objectArray[2] = "addHolderForPrefix";
                    break;
                }
                case 14: {
                    objectArray = objectArray;
                    objectArray[2] = "skipMessageAndDigits";
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 5, 7, 8, 9, 10, 11 -> new IllegalStateException(string);
            };
        }
    }
}

