/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.typescript.documentation;

import com.intellij.lang.javascript.service.JSLanguageServiceUtil;
import com.intellij.lang.typescript.compiler.TypeScriptCompilerService;
import com.intellij.lang.typescript.compiler.TypeScriptService;
import com.intellij.lang.typescript.compiler.languageService.protocol.commands.response.TypeScriptQuickInfoResponse;
import com.intellij.lang.typescript.documentation.TypeScriptServiceQuickInfoParser;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import java.util.concurrent.Future;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0005\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\b\u001a\u0004\u0018\u00010\t2\u0006\u0010\n\u001a\u00020\u0007J\u0010\u0010\u000b\u001a\u0004\u0018\u00010\f2\u0006\u0010\n\u001a\u00020\u0007J\u0010\u0010\r\u001a\u0004\u0018\u00010\f2\u0006\u0010\n\u001a\u00020\u0007J\u0010\u0010\u000e\u001a\u00020\u00072\u0006\u0010\n\u001a\u00020\u0007H\u0002J\u0012\u0010\u000f\u001a\u0004\u0018\u00010\u00052\u0006\u0010\u0010\u001a\u00020\u0007H\u0002R\u0018\u0010\u0003\u001a\f\u0012\u0006\u0012\u0004\u0018\u00010\u0005\u0018\u00010\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0006\u001a\u0004\u0018\u00010\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0011"}, d2={"Lcom/intellij/lang/typescript/documentation/TypeScriptServiceQuickInfoFetcher;", "", "()V", "future", "Ljava/util/concurrent/Future;", "Lcom/intellij/lang/typescript/compiler/languageService/protocol/commands/response/TypeScriptQuickInfoResponse;", "requestElement", "Lcom/intellij/psi/PsiElement;", "getParsedServiceInfo", "Lcom/intellij/lang/typescript/documentation/TypeScriptServiceQuickInfoParser$ParsedInfo;", "element", "getServiceDocumentation", "", "getServiceResult", "normalizeElement", "requestServiceQuickInfo", "_element", "intellij.javascript.impl"})
public final class TypeScriptServiceQuickInfoFetcher {
    @Nullable
    private PsiElement requestElement;
    @Nullable
    private Future<TypeScriptQuickInfoResponse> future;

    @Nullable
    public final String getServiceResult(@NotNull PsiElement element) {
        TypeScriptQuickInfoResponse response;
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        TypeScriptQuickInfoResponse typeScriptQuickInfoResponse = response = this.requestServiceQuickInfo(element);
        return typeScriptQuickInfoResponse != null ? typeScriptQuickInfoResponse.displayString : null;
    }

    @Nullable
    public final TypeScriptServiceQuickInfoParser.ParsedInfo getParsedServiceInfo(@NotNull PsiElement element) {
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        String string = this.getServiceResult(element);
        if (string == null) {
            return null;
        }
        String serviceResult = string;
        return TypeScriptServiceQuickInfoParser.parseServiceTextAsInfo(serviceResult);
    }

    @Nullable
    public final String getServiceDocumentation(@NotNull PsiElement element) {
        TypeScriptQuickInfoResponse response;
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        TypeScriptQuickInfoResponse typeScriptQuickInfoResponse = response = this.requestServiceQuickInfo(element);
        return typeScriptQuickInfoResponse != null ? typeScriptQuickInfoResponse.documentation : null;
    }

    private final TypeScriptQuickInfoResponse requestServiceQuickInfo(PsiElement _element) {
        if (ApplicationManager.getApplication().isDispatchThread()) {
            return null;
        }
        PsiElement element = this.normalizeElement(_element);
        if (this.future != null) {
            if (!Intrinsics.areEqual((Object)element, (Object)this.requestElement)) {
                this.requestElement = null;
                this.future = null;
                return this.requestServiceQuickInfo(_element);
            }
            return JSLanguageServiceUtil.awaitFuture(this.future, 500L);
        }
        VirtualFile file = TypeScriptService.Companion.getServiceAwareVirtualFile(element);
        if (file == null) {
            return null;
        }
        Project project = element.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
        TypeScriptService typeScriptService = TypeScriptService.Companion.getForFile(project, file);
        if (typeScriptService == null) {
            return null;
        }
        Future<TypeScriptQuickInfoResponse> responseFuture = typeScriptService.getQuickInfoAt(element, file);
        if (responseFuture == null) {
            return null;
        }
        this.requestElement = element;
        this.future = responseFuture;
        return JSLanguageServiceUtil.awaitFuture(responseFuture, 500L);
    }

    private final PsiElement normalizeElement(PsiElement element) {
        return TypeScriptCompilerService.Companion.adjustIntoIdentifier(element);
    }
}

