/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.typescript.compiler.ui;

import com.intellij.ui.JBColor;
import com.intellij.ui.scale.JBUIScale;
import com.intellij.util.ui.JBFont;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import javax.swing.JPanel;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0000\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0018\u0010\u0007\u001a\u00020\u00062\u0006\u0010\b\u001a\u00020\u00062\u0006\u0010\t\u001a\u00020\u0006H\u0016J\b\u0010\n\u001a\u00020\u000bH\u0016J\u0010\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0014R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0010"}, d2={"Lcom/intellij/lang/typescript/compiler/ui/TextBadgeComponent;", "Ljavax/swing/JPanel;", "text", "", "(Ljava/lang/String;)V", "scaledWidth", "", "getBaseline", "width", "height", "getFont", "Ljava/awt/Font;", "paintComponent", "", "g", "Ljava/awt/Graphics;", "intellij.javascript.impl"})
public final class TextBadgeComponent
extends JPanel {
    @NotNull
    private final String text;
    private final int scaledWidth;

    public TextBadgeComponent(@NotNull String text2) {
        Intrinsics.checkNotNullParameter((Object)text2, (String)"text");
        this.text = text2;
        this.scaledWidth = this.getFontMetrics(this.getFont()).stringWidth(this.text) + JBUIScale.scale((int)14);
        this.setPreferredSize(new Dimension(this.scaledWidth, JBUIScale.scale((int)15)));
    }

    @Override
    @NotNull
    public Font getFont() {
        JBFont jBFont = JBFont.small();
        Intrinsics.checkNotNullExpressionValue((Object)jBFont, (String)"small(...)");
        return (Font)jBFont;
    }

    @Override
    public int getBaseline(int width, int height) {
        return JBUIScale.scale((int)11);
    }

    @Override
    protected void paintComponent(@NotNull Graphics g) {
        Intrinsics.checkNotNullParameter((Object)g, (String)"g");
        super.paintComponent(g);
        if (g instanceof Graphics2D) {
            ((Graphics2D)g).setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        }
        int scaledHeight = JBUIScale.scale((int)15);
        int scaledTextX = JBUIScale.scale((int)7);
        g.setColor((Color)new JBColor(new Color(197, 230, 204), new Color(39, 56, 40)));
        g.fillRoundRect(0, 0, this.scaledWidth, scaledHeight, scaledHeight, scaledHeight);
        g.setColor((Color)new JBColor(new Color(32, 138, 60), new Color(95, 173, 101)));
        g.drawString(this.text, scaledTextX, JBUIScale.scale((int)11));
    }
}

