/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.typescript.compiler.languageService.frameworks;

import com.intellij.lang.javascript.service.protocol.JSLanguageServiceAnswer;
import com.intellij.lang.javascript.service.protocol.LocalFilePath;
import com.intellij.lang.typescript.compiler.TypeScriptCompilerSettings;
import com.intellij.lang.typescript.compiler.languageService.frameworks.DownloadableTypeScriptServicePlugin;
import com.intellij.lang.typescript.compiler.languageService.protocol.TypeScriptServiceStandardOutputProtocol;
import com.intellij.lang.typescript.compiler.languageService.protocol.commands.TypeScriptServiceInitialStateObject;
import com.intellij.lang.typescript.lsp.LspServerDownloader;
import com.intellij.openapi.project.Project;
import java.util.Collection;
import java.util.List;
import java.util.function.Consumer;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000H\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0000\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0007\u0018\u00002\u00020\u0001BA\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\n\u0010\u0006\u001a\u0006\u0012\u0002\b\u00030\u0007\u0012\u000e\u0010\b\u001a\n\u0012\u0006\b\u0000\u0012\u00020\t0\u0007\u0012\u0006\u0010\n\u001a\u00020\u000b\u0012\u0006\u0010\f\u001a\u00020\r\u00a2\u0006\u0002\u0010\u000eJ\b\u0010\u000f\u001a\u00020\u0010H\u0016J\u000e\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u000b0\u0012H\u0014J\u0013\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00150\u0014H\u0014\u00a2\u0006\u0002\u0010\u0016R\u000e\u0010\f\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0017"}, d2={"Lcom/intellij/lang/typescript/compiler/languageService/frameworks/PluggableTypeScriptServiceProtocol;", "Lcom/intellij/lang/typescript/compiler/languageService/protocol/TypeScriptServiceStandardOutputProtocol;", "project", "Lcom/intellij/openapi/project/Project;", "settings", "Lcom/intellij/lang/typescript/compiler/TypeScriptCompilerSettings;", "readyConsumer", "Ljava/util/function/Consumer;", "eventConsumer", "Lcom/intellij/lang/javascript/service/protocol/JSLanguageServiceAnswer;", "tsServicePath", "", "servicePlugin", "Lcom/intellij/lang/typescript/compiler/languageService/frameworks/DownloadableTypeScriptServicePlugin;", "(Lcom/intellij/openapi/project/Project;Lcom/intellij/lang/typescript/compiler/TypeScriptCompilerSettings;Ljava/util/function/Consumer;Ljava/util/function/Consumer;Ljava/lang/String;Lcom/intellij/lang/typescript/compiler/languageService/frameworks/DownloadableTypeScriptServicePlugin;)V", "createState", "Lcom/intellij/lang/typescript/compiler/languageService/protocol/commands/TypeScriptServiceInitialStateObject;", "getGlobalPlugins", "", "getProbeLocations", "", "Lcom/intellij/lang/javascript/service/protocol/LocalFilePath;", "()[Lcom/intellij/lang/javascript/service/protocol/LocalFilePath;", "intellij.javascript.impl"})
@ApiStatus.Experimental
public final class PluggableTypeScriptServiceProtocol
extends TypeScriptServiceStandardOutputProtocol {
    @NotNull
    private final DownloadableTypeScriptServicePlugin servicePlugin;

    public PluggableTypeScriptServiceProtocol(@NotNull Project project, @NotNull TypeScriptCompilerSettings settings2, @NotNull Consumer<?> readyConsumer, @NotNull Consumer<? super JSLanguageServiceAnswer> eventConsumer, @NotNull String tsServicePath, @NotNull DownloadableTypeScriptServicePlugin servicePlugin) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)settings2, (String)"settings");
        Intrinsics.checkNotNullParameter(readyConsumer, (String)"readyConsumer");
        Intrinsics.checkNotNullParameter(eventConsumer, (String)"eventConsumer");
        Intrinsics.checkNotNullParameter((Object)tsServicePath, (String)"tsServicePath");
        Intrinsics.checkNotNullParameter((Object)servicePlugin, (String)"servicePlugin");
        super(project, settings2, readyConsumer, eventConsumer, servicePlugin.getPackageName() + "-service", tsServicePath);
        this.servicePlugin = servicePlugin;
    }

    @Override
    @NotNull
    public TypeScriptServiceInitialStateObject createState() {
        TypeScriptServiceInitialStateObject state = super.createState();
        state.pluginName = this.servicePlugin.getPackageName();
        Intrinsics.checkNotNull((Object)state);
        return state;
    }

    @Override
    @NotNull
    protected List<String> getGlobalPlugins() {
        List<String> list2 = super.getGlobalPlugins();
        Intrinsics.checkNotNullExpressionValue(list2, (String)"getGlobalPlugins(...)");
        List<String> globalPlugins = list2;
        return CollectionsKt.plus((Collection)globalPlugins, (Object)this.servicePlugin.getPackageName());
    }

    @Override
    @NotNull
    protected LocalFilePath[] getProbeLocations() {
        Object[] objectArray = super.getProbeLocations();
        Intrinsics.checkNotNullExpressionValue((Object)objectArray, (String)"getProbeLocations(...)");
        Object[] probeLocations = objectArray;
        LspServerDownloader lspServerDownloader = this.servicePlugin.getDownloader();
        Project project = this.myProject;
        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"myProject");
        String pluginProbe = lspServerDownloader.getExecutable(project);
        LocalFilePath localFilePath = LocalFilePath.create(pluginProbe);
        if (localFilePath == null) {
            return probeLocations;
        }
        LocalFilePath element = localFilePath;
        return (LocalFilePath[])ArraysKt.plus((Object[])probeLocations, (Object)element);
    }
}

