/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.typescript.compiler.languageService;

import com.intellij.lang.typescript.compiler.languageService.TypeScriptLanguageServiceResponseParser;
import com.intellij.lang.typescript.compiler.languageService.protocol.commands.response.TypeScriptSymbolDisplayPart;
import com.intellij.openapi.util.Couple;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayDeque;
import java.util.Deque;
import java.util.HashSet;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=2, xi=48, d1={"\u0000D\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\"\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0011\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\u001a\u001e\u0010\u0005\u001a\u00020\u00062\f\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\b2\u0006\u0010\n\u001a\u00020\u000bH\u0002\u001a\u0010\u0010\f\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0002\u001a\u0010\u0010\r\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0002\u001a/\u0010\u000e\u001a\u00020\u000f2\f\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u000b0\u00112\u0006\u0010\u0012\u001a\u00020\u000f2\n\u0010\u0013\u001a\u00060\u0014j\u0002`\u0015H\u0002\u00a2\u0006\u0002\u0010\u0016\u001a\u001b\u0010\u0017\u001a\u00020\u000f2\f\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u000b0\u0011H\u0002\u00a2\u0006\u0002\u0010\u0018\u001a#\u0010\u0019\u001a\u00020\u000f2\f\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u000b0\u00112\u0006\u0010\u0012\u001a\u00020\u000fH\u0002\u00a2\u0006\u0002\u0010\u001a\"\u0016\u0010\u0000\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000\"\u0016\u0010\u0003\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001b"}, d2={"DEFAULT_SIGNATURE", "Lcom/intellij/openapi/util/Couple;", "", "FUNCTION_TYPES", "", "fillBraces", "", "braces", "Ljava/util/Deque;", "", "part", "Lcom/intellij/lang/typescript/compiler/languageService/protocol/commands/response/TypeScriptSymbolDisplayPart;", "isCloseBrace", "isOpenBrace", "readFunctionSignature", "", "parts", "", "startIndex", "signature", "Ljava/lang/StringBuilder;", "Lkotlin/text/StringBuilder;", "([Lcom/intellij/lang/typescript/compiler/languageService/protocol/commands/response/TypeScriptSymbolDisplayPart;ILjava/lang/StringBuilder;)I", "skipDescriptionBraces", "([Lcom/intellij/lang/typescript/compiler/languageService/protocol/commands/response/TypeScriptSymbolDisplayPart;)I", "skipWhitespaces", "([Lcom/intellij/lang/typescript/compiler/languageService/protocol/commands/response/TypeScriptSymbolDisplayPart;I)I", "intellij.javascript.impl"})
@SourceDebugExtension(value={"SMAP\nTypeScriptServerServiceCompletionEntry.kt\nKotlin\n*S Kotlin\n*F\n+ 1 TypeScriptServerServiceCompletionEntry.kt\ncom/intellij/lang/typescript/compiler/languageService/TypeScriptServerServiceCompletionEntryKt\n+ 2 _Sequences.kt\nkotlin/sequences/SequencesKt___SequencesKt\n*L\n1#1,191:1\n205#2,8:192\n*S KotlinDebug\n*F\n+ 1 TypeScriptServerServiceCompletionEntry.kt\ncom/intellij/lang/typescript/compiler/languageService/TypeScriptServerServiceCompletionEntryKt\n*L\n100#1:192,8\n*E\n"})
public final class TypeScriptServerServiceCompletionEntryKt {
    @NotNull
    private static final Set<String> FUNCTION_TYPES;
    @NotNull
    private static final Couple<String> DEFAULT_SIGNATURE;

    private static final int readFunctionSignature(TypeScriptSymbolDisplayPart[] parts, int startIndex, StringBuilder signature) {
        Deque openedBraces = new ArrayDeque();
        openedBraces.add(true);
        signature.append("(");
        int n = parts.length;
        for (int i = startIndex; i < n; ++i) {
            TypeScriptSymbolDisplayPart part = parts[i];
            if (TypeScriptServerServiceCompletionEntryKt.isOpenBrace(part)) {
                openedBraces.add(true);
            } else if (TypeScriptServerServiceCompletionEntryKt.isCloseBrace(part)) {
                openedBraces.pop();
                if (openedBraces.isEmpty()) {
                    signature.append(")");
                    return i + 1;
                }
            }
            TypeScriptLanguageServiceResponseParser.appendText(signature, part);
        }
        signature.append(")");
        return -1;
    }

    private static final int skipWhitespaces(TypeScriptSymbolDisplayPart[] parts, int startIndex) {
        int n;
        block3: {
            Sequence $this$indexOfFirst$iv = SequencesKt.drop((Sequence)ArraysKt.asSequence((Object[])parts), (int)startIndex);
            boolean $i$f$indexOfFirst = false;
            int index$iv = 0;
            for (Object item$iv : $this$indexOfFirst$iv) {
                if (index$iv < 0) {
                    CollectionsKt.throwIndexOverflow();
                }
                TypeScriptSymbolDisplayPart it = (TypeScriptSymbolDisplayPart)item$iv;
                boolean bl = false;
                if (!Intrinsics.areEqual((Object)it.kind, (Object)"space")) {
                    n = index$iv;
                    break block3;
                }
                ++index$iv;
            }
            n = -1;
        }
        return n + startIndex;
    }

    private static final int skipDescriptionBraces(TypeScriptSymbolDisplayPart[] parts) {
        Deque braces = new ArrayDeque();
        boolean firstBraceAdded = false;
        int n = parts.length;
        for (int i = 0; i < n; ++i) {
            TypeScriptSymbolDisplayPart part = parts[i];
            if (firstBraceAdded) {
                TypeScriptServerServiceCompletionEntryKt.fillBraces(braces, part);
                if (!braces.isEmpty()) continue;
                return i + 1;
            }
            if (!TypeScriptServerServiceCompletionEntryKt.isOpenBrace(part)) continue;
            int nextToken = i + 1;
            if (nextToken < parts.length && Intrinsics.areEqual((Object)"parameterName", (Object)parts[nextToken].kind)) {
                return i;
            }
            braces.add(true);
            firstBraceAdded = true;
        }
        return -1;
    }

    private static final void fillBraces(Deque<Boolean> braces, TypeScriptSymbolDisplayPart part) {
        if (Intrinsics.areEqual((Object)part.kind, (Object)"punctuation")) {
            String string = part.text;
            if (Intrinsics.areEqual((Object)string, (Object)")")) {
                braces.pop();
            } else if (Intrinsics.areEqual((Object)string, (Object)"(")) {
                braces.add(true);
            }
        }
    }

    private static final boolean isOpenBrace(TypeScriptSymbolDisplayPart part) {
        return Intrinsics.areEqual((Object)"punctuation", (Object)part.kind) && Intrinsics.areEqual((Object)part.text, (Object)"(");
    }

    private static final boolean isCloseBrace(TypeScriptSymbolDisplayPart part) {
        return Intrinsics.areEqual((Object)"punctuation", (Object)part.kind) && Intrinsics.areEqual((Object)part.text, (Object)")");
    }

    public static final /* synthetic */ Set access$getFUNCTION_TYPES$p() {
        return FUNCTION_TYPES;
    }

    public static final /* synthetic */ Couple access$getDEFAULT_SIGNATURE$p() {
        return DEFAULT_SIGNATURE;
    }

    public static final /* synthetic */ int access$skipDescriptionBraces(TypeScriptSymbolDisplayPart[] parts) {
        return TypeScriptServerServiceCompletionEntryKt.skipDescriptionBraces(parts);
    }

    public static final /* synthetic */ int access$skipWhitespaces(TypeScriptSymbolDisplayPart[] parts, int startIndex) {
        return TypeScriptServerServiceCompletionEntryKt.skipWhitespaces(parts, startIndex);
    }

    public static final /* synthetic */ int access$readFunctionSignature(TypeScriptSymbolDisplayPart[] parts, int startIndex, StringBuilder signature) {
        return TypeScriptServerServiceCompletionEntryKt.readFunctionSignature(parts, startIndex, signature);
    }

    static {
        Object[] objectArray = new String[]{"call", "method", "function", "local function"};
        HashSet hashSet = ContainerUtil.newHashSet((Object[])objectArray);
        Intrinsics.checkNotNullExpressionValue((Object)hashSet, (String)"newHashSet(...)");
        FUNCTION_TYPES = hashSet;
        Couple couple = Couple.of((Object)"(...)", null);
        Intrinsics.checkNotNullExpressionValue((Object)couple, (String)"of(...)");
        DEFAULT_SIGNATURE = couple;
    }
}

