/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.typescript.compiler;

import com.intellij.injected.editor.VirtualFileWindow;
import com.intellij.lang.javascript.psi.JSPsiReferenceElement;
import com.intellij.lang.typescript.compiler.TypeScriptCompilerService;
import com.intellij.lang.typescript.compiler.TypeScriptService;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.util.ObjectUtils;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=2, xi=48, d1={"\u0000\u0014\n\u0000\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u001a\u001b\u0010\u0000\u001a\n\u0012\u0004\u0012\u00020\u0002\u0018\u00010\u00012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\u0005\u00a8\u0006\u0006"}, d2={"getServiceNavigationTargets", "", "Lcom/intellij/psi/PsiElement;", "expression", "Lcom/intellij/lang/javascript/psi/JSPsiReferenceElement;", "(Lcom/intellij/lang/javascript/psi/JSPsiReferenceElement;)[Lcom/intellij/psi/PsiElement;", "intellij.javascript.impl"})
public final class TypeScriptServiceResolveFacadeImplKt {
    @Nullable
    public static final PsiElement[] getServiceNavigationTargets(@NotNull JSPsiReferenceElement expression) {
        Intrinsics.checkNotNullParameter((Object)expression, (String)"expression");
        PsiFile psiFile = expression.getContainingFile();
        Object object = psiFile != null ? psiFile.getVirtualFile() : null;
        if (object == null) {
            return null;
        }
        VirtualFile virtualFile = object;
        if (virtualFile instanceof VirtualFileWindow) {
            return null;
        }
        Project project = expression.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
        TypeScriptService service2 = TypeScriptService.Companion.getForFile(project, virtualFile);
        Document document2 = PsiDocumentManager.getInstance((Project)expression.getProject()).getDocument(expression.getContainingFile());
        if (document2 == null || service2 == null) {
            return null;
        }
        PsiElement identifier = TypeScriptCompilerService.Companion.adjustIntoIdentifier((PsiElement)expression);
        if (identifier instanceof JSPsiReferenceElement) {
            Object object2 = ObjectUtils.coalesce((Object)((JSPsiReferenceElement)identifier).getReferenceNameElement(), (Object)identifier);
            Intrinsics.checkNotNullExpressionValue((Object)object2, (String)"coalesce(...)");
            identifier = (PsiElement)object2;
        }
        return service2.getElementDefinitions(document2, identifier);
    }
}

