/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.typescript.compiler;

import com.intellij.lang.javascript.ecmascript6.TypeScriptAnnotatorCheckerProvider;
import com.intellij.lang.javascript.psi.JSAssignmentExpression;
import com.intellij.lang.javascript.psi.JSExpression;
import com.intellij.lang.javascript.psi.JSNamedElement;
import com.intellij.lang.javascript.psi.JSReturnStatement;
import com.intellij.lang.javascript.psi.JSVariable;
import com.intellij.lang.javascript.service.JSLanguageServiceBase;
import com.intellij.lang.typescript.compiler.TypeScriptCompilerSettings;
import com.intellij.lang.typescript.compiler.TypeScriptCompilerSettingsTracker;
import com.intellij.lang.typescript.compiler.TypeScriptService;
import com.intellij.lang.typescript.compiler.languageService.TypeScriptLanguageServiceUtil;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.util.CachedValue;
import com.intellij.psi.util.CachedValueProvider;
import com.intellij.psi.util.CachedValuesManager;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class TypeScriptLanguageServiceAnnotatorCheckerProvider
extends TypeScriptAnnotatorCheckerProvider {
    public static final Key<CachedValue<Boolean>> USE_SERVICE_INFO = Key.create((String)"use.service.info");
    private final Project myProject;
    @Nullable
    private final TypeScriptCompilerSettings mySettings;
    private final TypeScriptCompilerSettingsTracker myTracker;

    public TypeScriptLanguageServiceAnnotatorCheckerProvider(@NotNull Project project) {
        if (project == null) {
            TypeScriptLanguageServiceAnnotatorCheckerProvider.$$$reportNull$$$0(0);
        }
        this.myProject = project;
        this.mySettings = TypeScriptCompilerSettings.getSettings(project);
        this.myTracker = TypeScriptCompilerSettingsTracker.getInstance(project);
    }

    @Override
    protected boolean isAvailable(@NotNull PsiElement context2) {
        PsiFile file;
        if (context2 == null) {
            TypeScriptLanguageServiceAnnotatorCheckerProvider.$$$reportNull$$$0(1);
        }
        return Boolean.TRUE == CachedValuesManager.getCachedValue((PsiElement)(file = context2.getContainingFile().getOriginalFile()), USE_SERVICE_INFO, () -> CachedValueProvider.Result.create((Object)this.isAvailableImpl((PsiElement)file), (Object[])new Object[]{this.myTracker, VirtualFileManager.getInstance()}));
    }

    private boolean isAvailableImpl(@NotNull PsiElement context2) {
        if (context2 == null) {
            TypeScriptLanguageServiceAnnotatorCheckerProvider.$$$reportNull$$$0(2);
        }
        if (this.mySettings == null || ApplicationManager.getApplication().isUnitTestMode() && TypeScriptLanguageServiceUtil.ourUseService != TypeScriptLanguageServiceUtil.TypeScriptUseServiceState.USE_FOR_EVERYTHING) {
            return false;
        }
        VirtualFile virtualFile = TypeScriptService.getServiceAwareVirtualFile(context2);
        TypeScriptService service2 = this.getService(virtualFile);
        if (service2 == null) {
            return false;
        }
        return TypeScriptLanguageServiceAnnotatorCheckerProvider.checkServiceIsAvailable(this.myProject, service2, this.mySettings);
    }

    public static boolean checkServiceIsAvailable(@NotNull Project project, @Nullable TypeScriptService service2, @NotNull TypeScriptCompilerSettings settings2) {
        if (project == null) {
            TypeScriptLanguageServiceAnnotatorCheckerProvider.$$$reportNull$$$0(3);
        }
        if (settings2 == null) {
            TypeScriptLanguageServiceAnnotatorCheckerProvider.$$$reportNull$$$0(4);
        }
        if (service2 == null || !TypeScriptLanguageServiceUtil.isServiceEnabled(project)) {
            return false;
        }
        if (service2 instanceof JSLanguageServiceBase) {
            JSLanguageServiceBase jsLanguageService = (JSLanguageServiceBase)((Object)service2);
            if (!jsLanguageService.checkCanUseService()) {
                return false;
            }
            jsLanguageService.initialize();
        }
        if (ApplicationManager.getApplication().isUnitTestMode()) {
            return TypeScriptLanguageServiceUtil.ourUseService == TypeScriptLanguageServiceUtil.TypeScriptUseServiceState.USE_FOR_EVERYTHING;
        }
        return true;
    }

    @Nullable
    private TypeScriptService getService(@Nullable VirtualFile virtualFile) {
        return virtualFile != null ? TypeScriptService.getForFile(this.myProject, virtualFile) : null;
    }

    @Override
    public boolean useEmptyTypeChecker() {
        return true;
    }

    @Override
    @Nullable
    protected PsiElement getAdjustedTypeCheckProblemPlace(PsiElement psiElement) {
        if (psiElement instanceof JSExpression) {
            PsiElement parent = psiElement.getParent();
            if (parent instanceof JSReturnStatement) {
                return parent;
            }
            if (parent instanceof JSVariable) {
                return ((JSNamedElement)parent).getNameIdentifier();
            }
            if (parent instanceof JSAssignmentExpression) {
                return ((JSAssignmentExpression)parent).getDefinitionExpression();
            }
        }
        return null;
    }

    @Override
    public boolean skipErrors(@Nullable PsiElement context2) {
        if (context2 == null) {
            return false;
        }
        TypeScriptService service2 = this.getService(TypeScriptService.getServiceAwareVirtualFile(context2));
        if (service2 == null) {
            return false;
        }
        return service2.skipInternalErrors(context2);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: 
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "settings";
                break;
            }
        }
        objectArray2[1] = "com/intellij/lang/typescript/compiler/TypeScriptLanguageServiceAnnotatorCheckerProvider";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "isAvailable";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "isAvailableImpl";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "checkServiceIsAvailable";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

