/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.validation;

import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.lang.Language;
import com.intellij.lang.javascript.DialectDetector;
import com.intellij.lang.javascript.JSTokenTypes;
import com.intellij.lang.javascript.JavaScriptBundle;
import com.intellij.lang.javascript.JavaScriptSupportLoader;
import com.intellij.lang.javascript.dialects.JSDialectSpecificHandlersFactory;
import com.intellij.lang.javascript.highlighting.JSFixFactory;
import com.intellij.lang.javascript.psi.JSArgumentList;
import com.intellij.lang.javascript.psi.JSAssignmentExpression;
import com.intellij.lang.javascript.psi.JSBinaryExpression;
import com.intellij.lang.javascript.psi.JSCallExpression;
import com.intellij.lang.javascript.psi.JSCommonTypeNames;
import com.intellij.lang.javascript.psi.JSConditionalExpression;
import com.intellij.lang.javascript.psi.JSDefinitionExpression;
import com.intellij.lang.javascript.psi.JSDestructuringObject;
import com.intellij.lang.javascript.psi.JSExpression;
import com.intellij.lang.javascript.psi.JSFile;
import com.intellij.lang.javascript.psi.JSFunction;
import com.intellij.lang.javascript.psi.JSLiteralExpression;
import com.intellij.lang.javascript.psi.JSNamedElement;
import com.intellij.lang.javascript.psi.JSOptionalOwner;
import com.intellij.lang.javascript.psi.JSParameter;
import com.intellij.lang.javascript.psi.JSParameterItem;
import com.intellij.lang.javascript.psi.JSParameterList;
import com.intellij.lang.javascript.psi.JSParameterListElement;
import com.intellij.lang.javascript.psi.JSParenthesizedExpression;
import com.intellij.lang.javascript.psi.JSReferenceExpression;
import com.intellij.lang.javascript.psi.JSType;
import com.intellij.lang.javascript.psi.JSTypeDeclarationOwner;
import com.intellij.lang.javascript.psi.JSTypeOwner;
import com.intellij.lang.javascript.psi.JSTypeUtils;
import com.intellij.lang.javascript.psi.ecmal4.JSAttributeList;
import com.intellij.lang.javascript.psi.ecmal4.JSClass;
import com.intellij.lang.javascript.psi.resolve.ActionScriptResolveUtil;
import com.intellij.lang.javascript.psi.resolve.JSResolveUtil;
import com.intellij.lang.javascript.psi.types.JSAnyType;
import com.intellij.lang.javascript.psi.types.JSCodeBasedType;
import com.intellij.lang.javascript.psi.types.JSContext;
import com.intellij.lang.javascript.psi.types.JSGenericParameterImpl;
import com.intellij.lang.javascript.psi.types.JSNamedType;
import com.intellij.lang.javascript.psi.types.JSNamedTypeFactory;
import com.intellij.lang.javascript.psi.types.JSTypeComparingContextService;
import com.intellij.lang.javascript.psi.types.JSTypeSource;
import com.intellij.lang.javascript.psi.types.JSTypeSourceFactory;
import com.intellij.lang.javascript.psi.types.JSUnionType;
import com.intellij.lang.javascript.psi.types.guard.JSTypeGuardChecker;
import com.intellij.lang.javascript.psi.types.guard.JSTypeGuardUtil;
import com.intellij.lang.javascript.psi.types.primitives.JSBooleanType;
import com.intellij.lang.javascript.psi.types.primitives.JSNullType;
import com.intellij.lang.javascript.psi.types.primitives.JSNumberType;
import com.intellij.lang.javascript.psi.types.primitives.JSObjectType;
import com.intellij.lang.javascript.psi.types.primitives.JSPrimitiveType;
import com.intellij.lang.javascript.psi.types.primitives.JSStringType;
import com.intellij.lang.javascript.psi.types.primitives.JSUndefinedType;
import com.intellij.lang.javascript.psi.types.primitives.JSVoidType;
import com.intellij.lang.javascript.psi.util.JSProjectUtil;
import com.intellij.lang.javascript.validation.JSTypeChecker;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.Trinity;
import com.intellij.psi.PsiComment;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.SyntaxTraverser;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.ArrayUtil;
import com.intellij.util.ProcessingContext;
import com.intellij.util.Processor;
import com.intellij.util.containers.ContainerUtil;
import java.util.HashSet;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.PropertyKey;

public final class ValidateTypesUtil {
    @NonNls
    public static final String FLASH_UTILS_DICTIONARY = "flash.utils.Dictionary";

    static void checkNumericTypesInUnaryOperation(IElementType operationSign, JSExpression expression, JSTypeChecker typeChecker) {
        PsiFile containingFile2;
        if (expression != null && (JSTokenTypes.PLUSPLUS == operationSign || JSTokenTypes.MINUSMINUS == operationSign || JSTokenTypes.PLUS == operationSign || JSTokenTypes.MINUS == operationSign) && (containingFile2 = expression.getContainingFile()).getLanguage().isKindOf((Language)JavaScriptSupportLoader.ECMA_SCRIPT_L4)) {
            JSType numberType = JSNamedType.createType("Number", JSTypeSourceFactory.createTypeSource((PsiElement)expression, true), JSContext.INSTANCE);
            typeChecker.checkExpressionIsAssignableToTypeAndReportError(expression, numberType, "javascript.expression.type.implicitly.coerced.to.unrelated.type", null, false);
        }
    }

    static void checkTypesInConditionalExpr(JSConditionalExpression node, JSTypeChecker typeChecker) {
        JSType expectedType;
        PsiFile containingFile2;
        JSExpression thenBranch = (JSExpression)node.getThenBranch();
        JSExpression elseBranch = (JSExpression)node.getElseBranch();
        if (thenBranch != null && elseBranch != null && (containingFile2 = node.getContainingFile()).getLanguage().isKindOf((Language)JavaScriptSupportLoader.ECMA_SCRIPT_L4) && (expectedType = JSDialectSpecificHandlersFactory.findExpectedType(node)) != null) {
            if (JSNamedType.isNamedTypeWithName(expectedType, "String") && ValidateTypesUtil.isInStringConcatenation(node)) {
                return;
            }
            typeChecker.checkExpressionIsAssignableToTypeAndReportError(elseBranch, expectedType, "javascript.expression.type.implicitly.coerced.to.unrelated.type", null, false);
            typeChecker.checkExpressionIsAssignableToTypeAndReportError(thenBranch, expectedType, "javascript.expression.type.implicitly.coerced.to.unrelated.type", null, false);
        }
    }

    private static boolean isInStringConcatenation(JSConditionalExpression node) {
        String type2;
        IElementType sign;
        PsiElement parent = node.getParent();
        while (parent instanceof JSParenthesizedExpression) {
            parent = parent.getParent();
        }
        if (parent instanceof JSConditionalExpression) {
            return ValidateTypesUtil.isInStringConcatenation((JSConditionalExpression)parent);
        }
        return parent instanceof JSBinaryExpression && (sign = ((JSBinaryExpression)parent).getOperationSign()) == JSTokenTypes.PLUS && "String".equals(type2 = ActionScriptResolveUtil.getQualifiedExpressionType(((JSBinaryExpression)parent).getLOperand(), node.getContainingFile()));
    }

    public static void checkTypesInAssignment(JSAssignmentExpression node, JSTypeChecker typeChecker) {
        JSType expressionJSType;
        JSReferenceExpression requiresTypeChecking;
        JSDefinitionExpression definitionExpression;
        JSExpression innerExpression;
        JSExpression lOperand = node.getLOperand();
        if (lOperand == null) {
            return;
        }
        JSExpression rOperand = node.getROperand();
        if (rOperand == null) {
            return;
        }
        if (lOperand instanceof JSDefinitionExpression && ((innerExpression = (definitionExpression = (JSDefinitionExpression)lOperand).getExpression()) instanceof JSReferenceExpression ? ValidateTypesUtil.canChangeType(definitionExpression, (JSReferenceExpression)innerExpression) : (requiresTypeChecking = (JSReferenceExpression)SyntaxTraverser.psiTraverser((PsiElement)innerExpression).filter(JSReferenceExpression.class).find(ref -> !ValidateTypesUtil.canChangeType(definitionExpression, ref))) == null)) {
            return;
        }
        JSType jsType = JSResolveUtil.getExpressionJSType(lOperand);
        JSType jSType = expressionJSType = DialectDetector.isTypeScript((PsiElement)lOperand) ? JSTypeUtils.getValuableType(jsType) : jsType;
        if (expressionJSType == null) {
            return;
        }
        if ((expressionJSType instanceof JSStringType || JSNamedType.isNamedTypeWithName(expressionJSType, "XMLList")) && node.getOperationSign() == JSTokenTypes.PLUSEQ) {
            return;
        }
        JSTypeSource source = expressionJSType.getSource();
        if (source.isStrict()) {
            PsiElement resolve;
            JSExpression innerExpression2;
            JSTypeDeclarationOwner variableToFixTypeOf;
            PsiElement sourceElement = source.getSourceElement();
            JSTypeDeclarationOwner jSTypeDeclarationOwner = sourceElement instanceof JSTypeDeclarationOwner ? (JSTypeDeclarationOwner)sourceElement : (variableToFixTypeOf = sourceElement != null && sourceElement.getContext() instanceof JSTypeDeclarationOwner ? (JSTypeDeclarationOwner)sourceElement.getContext() : null);
            if (variableToFixTypeOf == null && lOperand instanceof JSDefinitionExpression && (innerExpression2 = ((JSDefinitionExpression)lOperand).getExpression()) instanceof JSReferenceExpression && (resolve = ((JSReferenceExpression)innerExpression2).resolve()) instanceof JSTypeDeclarationOwner) {
                variableToFixTypeOf = (JSTypeDeclarationOwner)resolve;
            }
            if (variableToFixTypeOf instanceof JSOptionalOwner && ((JSOptionalOwner)((Object)variableToFixTypeOf)).isOptional()) {
                expressionJSType = JSTypeGuardUtil.wrapWithUndefined(expressionJSType, null);
            }
            typeChecker.checkExpressionIsAssignableToTypeAndReportError(rOperand, expressionJSType, "javascript.assigned.expression.type.mismatch", (PsiElement)variableToFixTypeOf, false);
        }
    }

    private static boolean canChangeType(@NotNull JSDefinitionExpression definitionExpression, @NotNull JSReferenceExpression innerExpression) {
        JSType type2;
        PsiElement resolve;
        if (definitionExpression == null) {
            ValidateTypesUtil.$$$reportNull$$$0(0);
        }
        if (innerExpression == null) {
            ValidateTypesUtil.$$$reportNull$$$0(1);
        }
        return (resolve = innerExpression.resolve()) == definitionExpression ? (type2 = definitionExpression.getJSType()) == null || !(type2.getSource().getSourceElement() instanceof PsiComment) : resolve instanceof JSTypeOwner && !((JSTypeOwner)resolve).requiresTypeChecking();
    }

    @NotNull
    public static PsiElement getPlaceForSignatureProblem(JSCallExpression node, @Nullable JSArgumentList argumentList) {
        if (argumentList != null && !argumentList.textContains('\n')) {
            JSArgumentList jSArgumentList = argumentList;
            if (jSArgumentList == null) {
                ValidateTypesUtil.$$$reportNull$$$0(2);
            }
            return jSArgumentList;
        }
        JSExpression expression = node.getMethodExpression();
        if (expression != null) {
            PsiElement psiElement = PsiTreeUtil.lastChild((PsiElement)expression);
            if (psiElement == null) {
                ValidateTypesUtil.$$$reportNull$$$0(3);
            }
            return psiElement;
        }
        PsiElement psiElement = PsiTreeUtil.firstChild((PsiElement)node);
        if (psiElement == null) {
            ValidateTypesUtil.$$$reportNull$$$0(4);
        }
        return psiElement;
    }

    public static Trinity<Integer, Integer, Boolean> getMinMaxParameters(JSParameterItem[] parameters) {
        boolean hasRest = false;
        boolean hasOptional = false;
        int minParameterLength = 0;
        int maxParameterLength = parameters.length;
        HashSet<JSDestructuringObject> destructingObjectParams = new HashSet<JSDestructuringObject>();
        int paramInsideObjectCount = 0;
        int voidCount = 0;
        for (JSParameterItem parameter : parameters) {
            PsiElement parent;
            if (parameter instanceof JSParameter && (parent = PsiTreeUtil.getParentOfType((PsiElement)((JSParameter)parameter), (Class[])new Class[]{JSDestructuringObject.class, JSParameterList.class})) instanceof JSDestructuringObject) {
                destructingObjectParams.add((JSDestructuringObject)parent);
                ++paramInsideObjectCount;
            }
            hasOptional |= parameter.isOptional();
            if (parameter.getTypeDecorator().isRest()) {
                hasRest = true;
                maxParameterLength = Integer.MAX_VALUE;
            } else if (!hasOptional) {
                ++minParameterLength;
            }
            if (parameter.getInferredType() instanceof JSVoidType) {
                ++voidCount;
                continue;
            }
            voidCount = 0;
        }
        minParameterLength -= paramInsideObjectCount - destructingObjectParams.size();
        return Trinity.create((Object)(minParameterLength -= voidCount), (Object)maxParameterLength, (Object)hasRest);
    }

    public static LocalQuickFix jsInsertCastFix(String type2, @NotNull JSExpression expression) {
        if (expression == null) {
            ValidateTypesUtil.$$$reportNull$$$0(5);
        }
        return JSFixFactory.getInstance().jsInsertCastFix(type2, expression);
    }

    static LocalQuickFix changeTypeFix(JSNamedElement var, String expressionType, @PropertyKey(resourceBundle="messages.JavaScriptBundle") @PropertyKey(resourceBundle="messages.JavaScriptBundle") String nameKey) {
        return JSFixFactory.getInstance().changeTypeFix(var, expressionType, nameKey);
    }

    @Nullable
    public static LocalQuickFix tryCreateInheritanceFix(String expectedType, String actualType, PsiElement context2) {
        if (ArrayUtil.contains((String)expectedType, (String[])JSCommonTypeNames.ALL)) {
            return null;
        }
        PsiElement expectedClass = JSResolveUtil.findType(expectedType, context2, true);
        if (!(expectedClass instanceof JSClass)) {
            return null;
        }
        PsiElement actualClass = JSResolveUtil.findType(actualType, context2, true);
        if (!(actualClass instanceof JSClass)) {
            return null;
        }
        if (JSProjectUtil.isInLibrary(actualClass)) {
            return null;
        }
        JSAttributeList attributeList = ((JSClass)expectedClass).getAttributeList();
        if (attributeList != null && attributeList.hasModifier(JSAttributeList.ModifierType.FINAL)) {
            return null;
        }
        if (!((JSClass)expectedClass).isInterface() && ((JSClass)actualClass).getSuperClasses().length > 0 && !JSResolveUtil.isObjectClass(((JSClass)actualClass).getSuperClasses()[0])) {
            return null;
        }
        if (!((JSClass)expectedClass).isInterface() && ((JSClass)actualClass).isInterface()) {
            return null;
        }
        return ValidateTypesUtil.createInheritanceFix((JSClass)expectedClass, actualClass);
    }

    private static LocalQuickFix createInheritanceFix(JSClass expectedClass, PsiElement actualClass) {
        return JSFixFactory.getInstance().createInheritanceFix(expectedClass, actualClass);
    }

    public static boolean checkIfNullIsAssignedToNumeric(JSExpression expr, JSType type2, JSType expressionType) {
        return expressionType instanceof JSAnyType && expr instanceof JSLiteralExpression && expr.getFirstChild().getNode().getElementType() == JSTokenTypes.NULL_KEYWORD && type2 instanceof JSNamedType && (JSNamedType.isNamedTypeWithName(type2, "Number") || JSNamedType.isNamedTypeWithName(type2, "int") || JSNamedType.isNamedTypeWithName(type2, "uint"));
    }

    private static boolean isParameterTypeValidityCheck(@NotNull JSType lOpType, @NotNull JSType rOpType) {
        if (lOpType == null) {
            ValidateTypesUtil.$$$reportNull$$$0(6);
        }
        if (rOpType == null) {
            ValidateTypesUtil.$$$reportNull$$$0(7);
        }
        JSTypeSource lOpTypeSource = lOpType.getSource();
        JSTypeSource rOpTypeSource = rOpType.getSource();
        return lOpTypeSource.getLanguage() == JSTypeSource.SourceLanguage.JS && lOpTypeSource.getSourceElement() instanceof JSParameter && (rOpType instanceof JSNullType || rOpType instanceof JSUndefinedType) || rOpTypeSource.getLanguage() == JSTypeSource.SourceLanguage.JS && rOpTypeSource.getSourceElement() instanceof JSParameter && (lOpType instanceof JSNullType || lOpType instanceof JSUndefinedType);
    }

    @Nullable
    public static ProblemHighlightType getHighlightTypeForTypeOrSignatureProblem(@NotNull PsiElement node) {
        Language language;
        if (node == null) {
            ValidateTypesUtil.$$$reportNull$$$0(8);
        }
        if ((language = node.getContainingFile().getLanguage()) == JavaScriptSupportLoader.ECMA_SCRIPT_L4) {
            return ProblemHighlightType.GENERIC_ERROR;
        }
        if (DialectDetector.isTypeScript(node)) {
            if (!(node.getContainingFile() instanceof JSFile)) {
                return null;
            }
            return ProblemHighlightType.GENERIC_ERROR;
        }
        return null;
    }

    public static LocalQuickFix removeASTNodeFix(PsiElement expression, String propKey) {
        return JSFixFactory.getInstance().removeASTNodeFix(propKey, expression);
    }

    public static void checkTypesInComparison(@NotNull JSBinaryExpression node, @NotNull JSTypeChecker checker) {
        IElementType sign;
        if (node == null) {
            ValidateTypesUtil.$$$reportNull$$$0(9);
        }
        if (checker == null) {
            ValidateTypesUtil.$$$reportNull$$$0(10);
        }
        if ((sign = node.getOperationSign()) != JSTokenTypes.EQEQ && sign != JSTokenTypes.NE && sign != JSTokenTypes.EQEQEQ && sign != JSTokenTypes.NEQEQ) {
            return;
        }
        JSExpression lOperand = node.getLOperand();
        JSExpression rOperand = node.getROperand();
        if (lOperand == null || rOperand == null) {
            return;
        }
        boolean ecma = DialectDetector.isActionScript((PsiElement)node);
        ProcessingContext context2 = JSTypeComparingContextService.createProcessingContextWithCache((PsiElement)node);
        JSType lOpType = JSTypeUtils.getValuableType(JSResolveUtil.getExpressionJSType(lOperand), false);
        if (lOpType == null || lOpType instanceof JSAnyType) {
            return;
        }
        JSType rOpType = JSTypeUtils.getValuableType(JSResolveUtil.getExpressionJSType(rOperand), false);
        if (rOpType == null) {
            return;
        }
        if (ValidateTypesUtil.skipCheckingNull(lOpType, rOpType) || ValidateTypesUtil.skipCheckingNull(rOpType, lOpType)) {
            return;
        }
        JSTypeSource lOpTypeSource = lOpType.getSource();
        JSTypeSource rOpTypeSource = rOpType.getSource();
        if (lOpTypeSource.isStrict() && rOpTypeSource.isStrict() && !JSResolveUtil.isAssignableJSType(lOpType, rOpType, context2)) {
            LocalQuickFix[] localQuickFixArray;
            boolean strictComparison;
            if (rOpType instanceof JSBooleanType) {
                return;
            }
            if (ValidateTypesUtil.isParameterTypeValidityCheck(lOpType, rOpType)) {
                return;
            }
            boolean bl = strictComparison = sign == JSTokenTypes.EQEQEQ || sign == JSTokenTypes.NEQEQ;
            if (!strictComparison && ValidateTypesUtil.isSkippableForNonStrictBinaryComparison(lOpType) && ValidateTypesUtil.isSkippableForNonStrictBinaryComparison(rOpType)) {
                return;
            }
            if (DialectDetector.isActionScript((PsiElement)node)) {
                JSClass rOpTypeClass = rOpType.resolveClass();
                if (rOpTypeClass != null && rOpTypeClass.isInterface()) {
                    return;
                }
                JSClass lOpTypeClass = lOpType.resolveClass();
                if (lOpTypeClass != null && lOpTypeClass.isInterface()) {
                    return;
                }
            }
            if (lOpType instanceof JSUnionType && rOpType instanceof JSUnionType || rOpType instanceof JSGenericParameterImpl || lOpType instanceof JSGenericParameterImpl) {
                return;
            }
            if (JSResolveUtil.isAssignableJSType(rOpType, lOpType, context2)) {
                return;
            }
            if (rOpType instanceof JSPrimitiveType ? ValidateTypesUtil.checkPrimitiveTypeCompatibility((JSPrimitiveType)rOpType, lOpType, context2) : lOpType instanceof JSPrimitiveType && ValidateTypesUtil.checkPrimitiveTypeCompatibility((JSPrimitiveType)lOpType, rOpType, context2)) {
                return;
            }
            if (ecma) {
                LocalQuickFix[] localQuickFixArray2 = new LocalQuickFix[1];
                localQuickFixArray = localQuickFixArray2;
                localQuickFixArray2[0] = ValidateTypesUtil.jsInsertCastFix(JSTypeChecker.formatTypeForFix(lOpType, (PsiElement)node), rOperand);
            } else {
                localQuickFixArray = LocalQuickFix.EMPTY_ARRAY;
            }
            LocalQuickFix[] fixes = localQuickFixArray;
            String message = JavaScriptBundle.message("js.incompatible.types.comparison.message", JSTypeGuardChecker.isNegativeSign(sign) ? 1 : 0, lOpType.getTypeText(JSType.TypeTextFormat.PRESENTABLE), rOpType.getTypeText(JSType.TypeTextFormat.PRESENTABLE));
            checker.registerProblem(node.getNode().findChildByType(sign).getPsi(), message, ValidateTypesUtil.getHighlightTypeForTypeOrSignatureProblem((PsiElement)node), fixes);
        } else if (ecma && ValidateTypesUtil.checkIfNullIsAssignedToNumeric(rOperand, lOpType, rOpType)) {
            String message = JavaScriptBundle.message("javascript.expression.type.implicitly.coerced.to.unrelated.type", lOpType.getTypeText(JSType.TypeTextFormat.PRESENTABLE), rOpType.getTypeText(JSType.TypeTextFormat.PRESENTABLE));
            checker.registerProblem((PsiElement)rOperand, message, ValidateTypesUtil.getHighlightTypeForTypeOrSignatureProblem((PsiElement)lOperand), new LocalQuickFix[0]);
        }
    }

    private static boolean skipCheckingNull(@NotNull JSType expressionType, @NotNull JSType nullType) {
        if (expressionType == null) {
            ValidateTypesUtil.$$$reportNull$$$0(11);
        }
        if (nullType == null) {
            ValidateTypesUtil.$$$reportNull$$$0(12);
        }
        return JSTypeUtils.isNullOrUndefinedType(nullType) && expressionType.isJavaScript();
    }

    @Contract(value="null -> false")
    private static boolean isSkippableForNonStrictBinaryComparison(@Nullable JSType lOpType) {
        return lOpType instanceof JSObjectType || lOpType instanceof JSStringType || lOpType instanceof JSNumberType || lOpType instanceof JSNullType || lOpType instanceof JSUndefinedType || lOpType instanceof JSUnionType && ContainerUtil.and(((JSUnionType)lOpType).getTypes(), ValidateTypesUtil::isSkippableForNonStrictBinaryComparison);
    }

    private static boolean checkPrimitiveTypeCompatibility(@NotNull JSPrimitiveType primitiveType, @NotNull JSType toCompare, @NotNull ProcessingContext context2) {
        if (primitiveType == null) {
            ValidateTypesUtil.$$$reportNull$$$0(13);
        }
        if (toCompare == null) {
            ValidateTypesUtil.$$$reportNull$$$0(14);
        }
        if (context2 == null) {
            ValidateTypesUtil.$$$reportNull$$$0(15);
        }
        Ref result2 = Ref.create((Object)false);
        JSTypeUtils.processExpandedType((Processor<? super JSType>)((Processor)type2 -> {
            if (((Boolean)result2.get()).booleanValue()) {
                return false;
            }
            if (type2 instanceof JSPrimitiveType) {
                result2.set((Object)(JSResolveUtil.isAssignableJSType(type2, primitiveType, context2) || JSResolveUtil.isAssignableJSType(primitiveType, type2, context2) ? 1 : 0));
            }
            return true;
        }), toCompare, false, true, true);
        return (Boolean)result2.get();
    }

    public static boolean hasRequiredParameters(JSFunction method) {
        for (JSParameterListElement p : method.getParameters()) {
            if (p.isRest() || p.hasInitializer()) continue;
            return true;
        }
        return false;
    }

    public static boolean emptyReturnIsAcceptable(@NotNull JSFunction function2, @NotNull JSType type2) {
        JSUnionType compositeType;
        JSType componentType;
        if (function2 == null) {
            ValidateTypesUtil.$$$reportNull$$$0(16);
        }
        if (type2 == null) {
            ValidateTypesUtil.$$$reportNull$$$0(17);
        }
        if (DialectDetector.isTypeScript(function2)) {
            return true;
        }
        type2 = JSTypeUtils.getValuableType(type2);
        if (function2.isAsync() && JSTypeUtils.isExactlyPromiseLikeType(type2) && (componentType = JSTypeUtils.getPromiseComponentTypeOrNull(type2)) != null) {
            type2 = componentType;
        }
        if (function2.isGenerator() && (componentType = JSTypeUtils.getIterableComponentType(type2)) != null) {
            type2 = componentType;
        }
        JSUndefinedType undefinedType = JSNamedTypeFactory.createUndefinedType(JSTypeSourceFactory.createTypeSource(function2, false));
        JSUnionType jSUnionType = compositeType = type2 instanceof JSUnionType ? (JSUnionType)type2 : null;
        if (compositeType != null) {
            for (JSType component : compositeType.getTypes()) {
                if (!ValidateTypesUtil.canAssignUdefined(component, undefinedType)) continue;
                return true;
            }
        }
        return ValidateTypesUtil.canAssignUdefined(type2, undefinedType);
    }

    private static boolean canAssignUdefined(@NotNull JSType type2, @NotNull JSType undefinedType) {
        JSType substitute;
        if (type2 == null) {
            ValidateTypesUtil.$$$reportNull$$$0(18);
        }
        if (undefinedType == null) {
            ValidateTypesUtil.$$$reportNull$$$0(19);
        }
        if (type2 instanceof JSAnyType || type2 instanceof JSVoidType) {
            return true;
        }
        return !(type2 instanceof JSObjectType) && type2.isDirectlyAssignableType(undefinedType, new ProcessingContext()) && (JSTypeUtils.typeCanBeAssignedWithoutCoercion(substitute = type2.substitute(), undefinedType) || substitute instanceof JSCodeBasedType);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 2, 3, 4 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "definitionExpression";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "innerExpression";
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/javascript/validation/ValidateTypesUtil";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "expression";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "lOpType";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "rOpType";
                break;
            }
            case 8: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "node";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "checker";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "expressionType";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "nullType";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "primitiveType";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "toCompare";
                break;
            }
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "function";
                break;
            }
            case 17: 
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "type";
                break;
            }
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "undefinedType";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/javascript/validation/ValidateTypesUtil";
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getPlaceForSignatureProblem";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "canChangeType";
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "jsInsertCastFix";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "isParameterTypeValidityCheck";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "getHighlightTypeForTypeOrSignatureProblem";
                break;
            }
            case 9: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "checkTypesInComparison";
                break;
            }
            case 11: 
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "skipCheckingNull";
                break;
            }
            case 13: 
            case 14: 
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "checkPrimitiveTypeCompatibility";
                break;
            }
            case 16: 
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "emptyReturnIsAcceptable";
                break;
            }
            case 18: 
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "canAssignUdefined";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 2, 3, 4 -> new IllegalStateException(string);
        };
    }
}

