/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.validation;

import com.intellij.codeInsight.highlighting.ReadWriteAccessDetector;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.codeInspection.util.InspectionMessage;
import com.intellij.lang.ecmascript6.psi.ES6ImportExportDeclarationPart;
import com.intellij.lang.ecmascript6.psi.ES6ImportExportSpecifier;
import com.intellij.lang.ecmascript6.resolve.ES6PsiUtil;
import com.intellij.lang.javascript.DialectDetector;
import com.intellij.lang.javascript.DialectOptionHolder;
import com.intellij.lang.javascript.JSStubElementTypes;
import com.intellij.lang.javascript.JSTokenTypes;
import com.intellij.lang.javascript.JavaScriptBundle;
import com.intellij.lang.javascript.JavaScriptSupportLoader;
import com.intellij.lang.javascript.dialects.JSDialectSpecificHandlersFactory;
import com.intellij.lang.javascript.dialects.JSLanguageFeature;
import com.intellij.lang.javascript.ecmascript6.JSInsertThisFix;
import com.intellij.lang.javascript.findUsages.JSReadWriteAccessDetector;
import com.intellij.lang.javascript.highlighting.JSFixFactory;
import com.intellij.lang.javascript.index.JSLocalNamespaceEvaluator;
import com.intellij.lang.javascript.index.JSSymbolUtil;
import com.intellij.lang.javascript.inspections.JSAccessibilityCheckInspection;
import com.intellij.lang.javascript.inspections.JSCheckFunctionSignaturesInspection;
import com.intellij.lang.javascript.library.JSLibraryUtil;
import com.intellij.lang.javascript.psi.JSArgumentList;
import com.intellij.lang.javascript.psi.JSArrayLiteralExpression;
import com.intellij.lang.javascript.psi.JSBinaryExpression;
import com.intellij.lang.javascript.psi.JSCallExpression;
import com.intellij.lang.javascript.psi.JSCallLikeExpression;
import com.intellij.lang.javascript.psi.JSDefinitionExpression;
import com.intellij.lang.javascript.psi.JSElement;
import com.intellij.lang.javascript.psi.JSExpectedTypeKind;
import com.intellij.lang.javascript.psi.JSExpression;
import com.intellij.lang.javascript.psi.JSFunction;
import com.intellij.lang.javascript.psi.JSNewExpression;
import com.intellij.lang.javascript.psi.JSObjectLiteralExpression;
import com.intellij.lang.javascript.psi.JSParenthesizedExpression;
import com.intellij.lang.javascript.psi.JSPrefixExpression;
import com.intellij.lang.javascript.psi.JSProperty;
import com.intellij.lang.javascript.psi.JSRecordType;
import com.intellij.lang.javascript.psi.JSReferenceExpression;
import com.intellij.lang.javascript.psi.JSThisExpression;
import com.intellij.lang.javascript.psi.JSType;
import com.intellij.lang.javascript.psi.JSTypeUtils;
import com.intellij.lang.javascript.psi.JSVariable;
import com.intellij.lang.javascript.psi.ecma6.ES6Decorator;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptEnum;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptModule;
import com.intellij.lang.javascript.psi.ecmal4.JSAttributeList;
import com.intellij.lang.javascript.psi.ecmal4.JSAttributeListOwner;
import com.intellij.lang.javascript.psi.ecmal4.JSClass;
import com.intellij.lang.javascript.psi.ecmal4.JSQualifiedNamedElement;
import com.intellij.lang.javascript.psi.ecmal4.JSReferenceListMember;
import com.intellij.lang.javascript.psi.ecmal4.JSSuperExpression;
import com.intellij.lang.javascript.psi.impl.JSPsiImplUtils;
import com.intellij.lang.javascript.psi.resolve.JSResolveResult;
import com.intellij.lang.javascript.psi.resolve.JSResolveUtil;
import com.intellij.lang.javascript.psi.types.JSGenericTypeImpl;
import com.intellij.lang.javascript.psi.types.JSTypeCastUtil;
import com.intellij.lang.javascript.psi.util.JSClassUtils;
import com.intellij.lang.javascript.psi.util.JSProjectUtil;
import com.intellij.lang.javascript.psi.util.JSUtils;
import com.intellij.lang.javascript.refactoring.JSVisibilityUtil;
import com.intellij.lang.javascript.validation.JSBundleMessageHighlighter;
import com.intellij.lang.javascript.validation.JSProblemReporter;
import com.intellij.lang.javascript.validation.JSUnresolvedReferenceErrorUpdater;
import com.intellij.lang.javascript.validation.JSValidateExpressionUtil;
import com.intellij.lang.javascript.validation.fixes.FixAndIntentionAction;
import com.intellij.lang.javascript.validation.fixes.FixPropertyNameTypoQuickFix;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.ResolveResult;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.xml.XmlAttributeValue;
import com.intellij.util.ArrayUtil;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.text.EditDistance;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JSReferenceChecker {
    @NotNull
    protected final JSProblemReporter<?> myReporter;

    public JSReferenceChecker(@NotNull JSProblemReporter<?> reporter) {
        if (reporter == null) {
            JSReferenceChecker.$$$reportNull$$$0(0);
        }
        this.myReporter = reporter;
    }

    public void checkRefExpression(@NotNull JSReferenceExpression node) {
        if (node == null) {
            JSReferenceChecker.$$$reportNull$$$0(1);
        }
        if (JSSymbolUtil.isAccurateReferenceExpressionName(node, "arguments") && PsiTreeUtil.getParentOfType((PsiElement)node, XmlAttributeValue.class) != null) {
            return;
        }
        if (!node.shouldCheckReferences() || JSReferenceChecker.getCallIfMethodExpression(node) != null) {
            return;
        }
        ResolveResult[] resolveResults = node.multiResolve(false);
        boolean hasValidResult = false;
        for (ResolveResult r : resolveResults) {
            if (!r.isValidResult()) continue;
            hasValidResult = true;
            if (this.processExpressionResolveResult(node, r.getElement())) break;
        }
        if (!hasValidResult && !JSUtils.isPrivateBrandCheckReference(node)) {
            this.registerQuickFixesForUnresolvedRef(node, resolveResults);
        } else if (!JSResolveUtil.isSelfReference((PsiElement)node) && JSReadWriteAccessDetector.ourInstance.getExpressionAccess((PsiElement)node) == ReadWriteAccessDetector.Access.ReadWrite) {
            PsiElement element;
            boolean seenRead = false;
            boolean seenWrite = false;
            for (ResolveResult r : resolveResults) {
                PsiElement element2 = r.getElement();
                if (element2 instanceof JSFunction && ((JSFunction)element2).isGetProperty() || element2 instanceof JSProperty && ((JSProperty)element2).isGetProperty()) {
                    seenRead = true;
                    continue;
                }
                if (element2 instanceof JSFunction && ((JSFunction)element2).isSetProperty() || element2 instanceof JSProperty && ((JSProperty)element2).isSetProperty()) {
                    seenWrite = true;
                    continue;
                }
                if (!(element2 instanceof JSProperty) && !(element2 instanceof JSVariable) && !(element2 instanceof JSDefinitionExpression)) continue;
                seenWrite = true;
                seenRead = true;
                break;
            }
            if ((seenRead || seenWrite) && (element = node.getReferenceNameElement()) != null) {
                if (!seenRead) {
                    this.myReporter.registerProblem(element, null, JavaScriptBundle.message("javascript.missing.read.property", new Object[0]), null, new LocalQuickFix[0]);
                }
                if (!seenWrite) {
                    this.myReporter.registerProblem(element, null, JavaScriptBundle.message("javascript.missing.write.property", new Object[0]), null, new LocalQuickFix[0]);
                }
            }
        }
    }

    protected boolean processExpressionResolveResult(@Nullable JSExpression expression, @Nullable PsiElement resolved) {
        return true;
    }

    protected void registerQuickFixesForUnresolvedRef(JSReferenceExpression node, ResolveResult[] resolveResults) {
        boolean canHaveCreateFromUsage;
        PsiElement nameIdentifier = node.getReferenceNameElement();
        if (nameIdentifier == null) {
            return;
        }
        ArrayList<LocalQuickFix> fixes = new ArrayList<LocalQuickFix>();
        JSReferenceExpression topReferenceExpression = (JSReferenceExpression)JSResolveUtil.getTopReferenceExpression((PsiElement)node);
        boolean inTypeContext = JSResolveUtil.isExprInTypeContext(topReferenceExpression);
        JSExpression qualifier = node.getQualifier();
        boolean bl = canHaveCreateFromUsage = JSReferenceChecker.findInsufficientVisibilityResult(resolveResults) == null && JSReferenceChecker.canHaveCreateFromUsage(qualifier);
        if (canHaveCreateFromUsage) {
            ContainerUtil.addIfNotNull(fixes, (Object)this.getPreferredQuickFixForUnresolvedRef(nameIdentifier));
            if (fixes.isEmpty()) {
                boolean reportProblem;
                PsiFile containingFile2 = node.getContainingFile();
                boolean ecma = containingFile2.getLanguage() == JavaScriptSupportLoader.ECMA_SCRIPT_L4;
                ProblemHighlightType highlightType = this.getUnresolvedReferenceHighlightType(node);
                boolean bl2 = reportProblem = (!ecma || highlightType != ProblemHighlightType.LIKE_UNKNOWN_SYMBOL) && highlightType != null;
                if (!reportProblem) {
                    return;
                }
                inTypeContext = this.addCreateFromUsageFixes(node, resolveResults, fixes, inTypeContext, ecma);
            }
        }
        JSReferenceChecker.addEscalateVisibilityFix(resolveResults, node, fixes);
        fixes.add(JSReferenceChecker.renameReferenceFix());
        String message = JavaScriptBundle.message(node.getQualifier() == null ? (inTypeContext && node == topReferenceExpression ? "javascript.unresolved.type.name.message" : "javascript.unresolved.variable.or.type.name.message") : "javascript.unresolved.variable.name.message", node.getReferenceName());
        this.reportUnresolvedReference(resolveResults, node, fixes, message, false, inTypeContext);
    }

    protected boolean suggestCreateVarFromUsage(JSReferenceExpression node) {
        return true;
    }

    @Nullable
    protected LocalQuickFix getPreferredQuickFixForUnresolvedRef(PsiElement nameIdentifier) {
        return null;
    }

    @Nullable
    public ProblemHighlightType getUnresolvedReferenceHighlightType(@NotNull JSReferenceExpression node) {
        JSType type2;
        JSExpression qualifier;
        if (node == null) {
            JSReferenceChecker.$$$reportNull$$$0(2);
        }
        if ((qualifier = node.getQualifier()) == null && node.getParent() instanceof JSDefinitionExpression && JSResolveUtil.isEcmaScript5((PsiElement)node)) {
            return ProblemHighlightType.ERROR;
        }
        if (qualifier != null && (type2 = JSResolveUtil.getExpressionJSType(qualifier)) != null && JSTypeUtils.isMapType(type2)) {
            return null;
        }
        return ProblemHighlightType.LIKE_UNKNOWN_SYMBOL;
    }

    protected boolean addCreateFromUsageFixes(JSReferenceExpression node, ResolveResult[] resolveResults, @NotNull @NotNull List<? super @NotNull LocalQuickFix> fixes, boolean inTypeContext, boolean ecma) {
        boolean isField;
        JSClass contextClass;
        if (fixes == null) {
            JSReferenceChecker.$$$reportNull$$$0(3);
        }
        if (!inTypeContext && !ecma && JSInsertThisFix.isThisFixAvailable(node)) {
            String name = node.getReferenceName();
            fixes.add((LocalQuickFix)new JSInsertThisFix(node));
            fixes.add((LocalQuickFix)this.createJSVariableIntentionAction(name, false, false, false));
            JSReferenceChecker.addCreateParameterFix(node, fixes, name);
            return false;
        }
        JSExpression qualifier = node.getQualifier();
        String referencedName = node.getReferenceName();
        PsiElement parent = node.getParent();
        PsiFile containingFile2 = node.getContainingFile();
        DialectOptionHolder dialect = DialectDetector.dialectOfElement((PsiElement)containingFile2);
        boolean supportsClasses = JSClassUtils.canHaveClasses(parent);
        JSReferenceChecker.addTypoQuickFixes(node, fixes, qualifier);
        JSClass jSClass = contextClass = supportsClasses ? JSResolveUtil.getClassOfContext((PsiElement)node) : null;
        if (ES6PsiUtil.isInsideDecorator((PsiElement)node)) {
            contextClass = JSResolveUtil.getClassOfContext(contextClass);
        }
        if (parent instanceof JSReferenceListMember) {
            if (supportsClasses && contextClass != null && qualifier == null) {
                boolean isInterface = contextClass.isInterface() || parent.getParent().getNode().getElementType() == JSStubElementTypes.IMPLEMENTS_LIST;
                fixes.add((LocalQuickFix)this.createClassOrInterfaceFix(node, isInterface));
            }
            return inTypeContext;
        }
        if (inTypeContext && !(node.getParent() instanceof JSReferenceExpression) && supportsClasses && resolveResults.length == 0) {
            PsiElement element;
            fixes.add((LocalQuickFix)this.createClassOrInterfaceFix(node, true));
            fixes.add((LocalQuickFix)this.createClassOrInterfaceFix(node, false));
            if (qualifier instanceof JSReferenceExpression && (element = ((JSReferenceExpression)qualifier).resolve()) instanceof TypeScriptEnum) {
                fixes.add((LocalQuickFix)this.createJSVariableIntentionAction(referencedName, true, false, false));
            }
            return true;
        }
        boolean bl = isField = qualifier != null || (ecma || supportsClasses) && contextClass != null;
        if (!inTypeContext) {
            if (parent instanceof JSArgumentList && (dialect == null || !dialect.isTypeScript) || JSReferenceChecker.isFunctionExpectedType(node) || parent instanceof ES6Decorator) {
                if (parent instanceof JSArgumentList && ecma) {
                    fixes.add((LocalQuickFix)JSFixFactory.getInstance().createJSFunctionFromArgumentIntentionAction(referencedName, qualifier, true));
                } else {
                    this.addFunctionFixes(node, fixes, referencedName, dialect, qualifier);
                }
            }
            if (!(parent instanceof ES6Decorator) && this.suggestCreateVarFromUsage(node)) {
                boolean isTypeScriptModule = JSReferenceChecker.isTypeScriptModule(qualifier);
                fixes.add((LocalQuickFix)this.createJSVariableIntentionAction(referencedName, isField, false, isTypeScriptModule));
                if (qualifier != null && referencedName != null) {
                    this.addSurroundWithTypeGuardFix(qualifier, fixes, referencedName);
                }
                if (isField && qualifier == null) {
                    fixes.add((LocalQuickFix)this.createJSVariableIntentionAction(referencedName, false, false, false));
                }
                if (qualifier == null) {
                    JSReferenceChecker.addCreateParameterFix(node, fixes, referencedName);
                }
                if (ecma && JSReadWriteAccessDetector.ourInstance.getExpressionAccess((PsiElement)node) == ReadWriteAccessDetector.Access.Read) {
                    fixes.add((LocalQuickFix)this.createJSVariableIntentionAction(referencedName, isField, true, isTypeScriptModule));
                }
            }
        }
        return inTypeContext;
    }

    @NotNull
    private static Set<String> getPotentialTypos(JSExpression qualifier, String referencedName) {
        if (qualifier == null || referencedName == null) {
            Set<String> set = Collections.emptySet();
            if (set == null) {
                JSReferenceChecker.$$$reportNull$$$0(4);
            }
            return set;
        }
        JSType type2 = JSResolveUtil.getExpressionJSType(qualifier);
        if (type2 == null) {
            Set<String> set = Collections.emptySet();
            if (set == null) {
                JSReferenceChecker.$$$reportNull$$$0(5);
            }
            return set;
        }
        LinkedHashSet<String> allProperties = new LinkedHashSet<String>();
        for (JSRecordType.TypeMember member : type2.asRecordType().getTypeMembers()) {
            String name1;
            if (!(member instanceof JSRecordType.PropertySignature) || (name1 = ((JSRecordType.PropertySignature)member).getMemberName()).length() == 1 || referencedName.length() == 1 || !name1.equalsIgnoreCase(referencedName) && EditDistance.optimalAlignment((CharSequence)name1, (CharSequence)referencedName, (boolean)false, (int)1) > 1) continue;
            allProperties.add(name1);
        }
        LinkedHashSet<String> linkedHashSet = allProperties;
        if (linkedHashSet == null) {
            JSReferenceChecker.$$$reportNull$$$0(6);
        }
        return linkedHashSet;
    }

    private static boolean isTypeScriptModule(JSExpression qualifier) {
        return qualifier instanceof JSReferenceExpression && DialectDetector.isTypeScript((PsiElement)qualifier) && ((JSReferenceExpression)qualifier).resolve() instanceof TypeScriptModule;
    }

    protected void addSurroundWithTypeGuardFix(@NotNull JSExpression qualifier, @NotNull @NotNull List<? super @NotNull LocalQuickFix> fixes, @NotNull String name) {
        if (qualifier == null) {
            JSReferenceChecker.$$$reportNull$$$0(7);
        }
        if (fixes == null) {
            JSReferenceChecker.$$$reportNull$$$0(8);
        }
        if (name == null) {
            JSReferenceChecker.$$$reportNull$$$0(9);
        }
    }

    protected void addCreateFromUsageFixesForCall(@NotNull JSReferenceExpression methodExpression, boolean isNewExpression, ResolveResult @NotNull [] resolveResults, @NotNull @NotNull List<? super @NotNull LocalQuickFix> quickFixes) {
        if (methodExpression == null) {
            JSReferenceChecker.$$$reportNull$$$0(10);
        }
        if (quickFixes == null) {
            JSReferenceChecker.$$$reportNull$$$0(11);
        }
        if (resolveResults == null) {
            JSReferenceChecker.$$$reportNull$$$0(12);
        }
        String refName = methodExpression.getReferenceName();
        DialectOptionHolder dialect = DialectDetector.dialectOfElement((PsiElement)methodExpression);
        JSExpression qualifier = methodExpression.getQualifier();
        boolean isAsync = JSReferenceChecker.isAsyncContext(methodExpression);
        JSReferenceChecker.addTypoQuickFixes(methodExpression, quickFixes, qualifier);
        if (!isNewExpression && JSInsertThisFix.isThisFixAvailable(methodExpression)) {
            quickFixes.add((LocalQuickFix)new JSInsertThisFix(methodExpression));
        }
        if (isNewExpression) {
            if (qualifier != null && !(qualifier instanceof JSReferenceExpression)) {
                return;
            }
            if (dialect != null && !dialect.hasFeature(JSLanguageFeature.CLASSES)) {
                boolean isModuleScope = JSReferenceChecker.isTypeScriptModule(qualifier);
                quickFixes.add((LocalQuickFix)JSFixFactory.getInstance().createJSFunctionIntentionAction(refName, true, isModuleScope, isAsync));
                quickFixes.add((LocalQuickFix)JSFixFactory.getInstance().createJSFunctionIntentionAction(refName, false, isModuleScope, isAsync));
            } else {
                JSNewExpression newExpression = (JSNewExpression)ObjectUtils.tryCast((Object)methodExpression.getParent(), JSNewExpression.class);
                if (newExpression != null) {
                    quickFixes.add((LocalQuickFix)this.createClassFromNewFix(methodExpression, newExpression.getArgumentList(), JSDialectSpecificHandlersFactory.findExpectedType(newExpression)));
                }
            }
        } else {
            this.addFunctionFixes(methodExpression, quickFixes, refName, dialect, qualifier);
        }
        quickFixes.add((LocalQuickFix)JSReferenceChecker.renameReferenceFix());
    }

    private static void addTypoQuickFixes(@NotNull JSReferenceExpression expression, @NotNull @NotNull List<? super @NotNull LocalQuickFix> quickFixes, JSExpression qualifier) {
        if (expression == null) {
            JSReferenceChecker.$$$reportNull$$$0(13);
        }
        if (quickFixes == null) {
            JSReferenceChecker.$$$reportNull$$$0(14);
        }
        Set<String> myPotentialTypo = JSReferenceChecker.getPotentialTypos(qualifier, expression.getReferenceName());
        for (String typo : myPotentialTypo) {
            quickFixes.add((LocalQuickFix)new FixPropertyNameTypoQuickFix(expression, typo));
        }
    }

    protected void addFunctionFixes(@NotNull JSReferenceExpression node, @NotNull @NotNull List<? super @NotNull LocalQuickFix> quickFixes, @Nullable String refName, DialectOptionHolder dialect, JSExpression qualifier) {
        if (node == null) {
            JSReferenceChecker.$$$reportNull$$$0(15);
        }
        if (quickFixes == null) {
            JSReferenceChecker.$$$reportNull$$$0(16);
        }
        boolean isAsync = JSReferenceChecker.isAsyncContext(node);
        if (qualifier != null) {
            quickFixes.add((LocalQuickFix)JSFixFactory.getInstance().createJSFunctionIntentionAction(refName, true, JSReferenceChecker.isTypeScriptModule(qualifier), isAsync));
            if (JSReferenceChecker.hasArrowFunctions(dialect, node)) {
                quickFixes.add((LocalQuickFix)JSFixFactory.getInstance().createJSArrowFunctionIntentionAction(refName, true, JSReferenceChecker.isTypeScriptModule(qualifier), isAsync));
            }
            if (refName != null) {
                this.addSurroundWithTypeGuardFix(qualifier, quickFixes, refName);
            }
        } else {
            if (JSResolveUtil.getClassOfContext((PsiElement)node) != null && PsiTreeUtil.getParentOfType((PsiElement)node, ES6Decorator.class, (boolean)true, (Class[])new Class[]{JSClass.class}) == null && !JSInsertThisFix.isThisFixAvailable(node)) {
                quickFixes.add((LocalQuickFix)JSFixFactory.getInstance().createJSFunctionIntentionAction(refName, true, false, isAsync));
                if (JSReferenceChecker.hasArrowFunctions(dialect, node)) {
                    quickFixes.add((LocalQuickFix)JSFixFactory.getInstance().createJSArrowFunctionIntentionAction(refName, true, false, isAsync));
                }
            }
            if (dialect == null || dialect.isJavaScript() && !dialect.isECMA6) {
                quickFixes.add((LocalQuickFix)JSFixFactory.getInstance().createJSFunctionIntentionAction(refName, true, false, isAsync));
                if (JSReferenceChecker.hasArrowFunctions(dialect, node)) {
                    quickFixes.add((LocalQuickFix)JSFixFactory.getInstance().createJSArrowFunctionIntentionAction(refName, true, false, isAsync));
                }
            }
            if (dialect == null || !dialect.isECMA4) {
                quickFixes.add((LocalQuickFix)JSFixFactory.getInstance().createJSFunctionIntentionAction(refName, false, false, isAsync));
                if (JSReferenceChecker.hasArrowFunctions(dialect, node)) {
                    quickFixes.add((LocalQuickFix)JSFixFactory.getInstance().createJSArrowFunctionIntentionAction(refName, false, false, isAsync));
                }
            }
        }
    }

    private static boolean isAsyncContext(JSReferenceExpression node) {
        JSCallExpression callExpression = (JSCallExpression)ObjectUtils.tryCast((Object)node.getParent(), JSCallExpression.class);
        if (callExpression == null) {
            return false;
        }
        JSPrefixExpression expression = (JSPrefixExpression)ObjectUtils.tryCast((Object)callExpression.getParent(), JSPrefixExpression.class);
        return expression != null && expression.getOperationSign() == JSTokenTypes.AWAIT_KEYWORD;
    }

    private static boolean hasArrowFunctions(@Nullable DialectOptionHolder dialect, @NotNull JSReferenceExpression context2) {
        if (context2 == null) {
            JSReferenceChecker.$$$reportNull$$$0(17);
        }
        if (dialect != null) {
            return dialect.hasFeature(JSLanguageFeature.ARROW_FUNCTIONS);
        }
        return DialectDetector.hasFeature((PsiElement)context2, JSLanguageFeature.ARROW_FUNCTIONS);
    }

    @NotNull
    protected LocalQuickFix createJSVariableIntentionAction(String referencedName, boolean isField, boolean isConstant, boolean isModuleScope) {
        LocalQuickFix localQuickFix = JSFixFactory.getInstance().createJSVariableIntentionAction(referencedName, isField, isConstant, isModuleScope);
        if (localQuickFix == null) {
            JSReferenceChecker.$$$reportNull$$$0(18);
        }
        return localQuickFix;
    }

    protected void reportUnresolvedReference(ResolveResult @NotNull [] resolveResults, @NotNull JSReferenceExpression referenceExpression, @NotNull List<LocalQuickFix> quickFixes, @NotNull @InspectionMessage String message, boolean isFunction, boolean inTypeContext) {
        PsiElement place;
        if (referenceExpression == null) {
            JSReferenceChecker.$$$reportNull$$$0(19);
        }
        if (quickFixes == null) {
            JSReferenceChecker.$$$reportNull$$$0(20);
        }
        if (message == null) {
            JSReferenceChecker.$$$reportNull$$$0(21);
        }
        if (resolveResults == null) {
            JSReferenceChecker.$$$reportNull$$$0(22);
        }
        if ((place = referenceExpression.getReferenceNameElement()) == null) {
            return;
        }
        boolean jsSymbolNotAccessible = JSAccessibilityCheckInspection.isSymbolNotAccessible(resolveResults);
        if (resolveResults.length > 0 && resolveResults[0] instanceof JSResolveResult) {
            JSResolveResult.ProblemKind problemKind;
            if (isFunction) {
                JSReferenceChecker.addEscalateVisibilityFix(resolveResults, referenceExpression, quickFixes);
            }
            if ((problemKind = ((JSResolveResult)resolveResults[0]).getResolveProblemKind()) != null) {
                message = JavaScriptBundle.message(problemKind.getMessageKey(), new Object[0]);
            }
            PsiElement element = resolveResults[0].getElement();
            if (jsSymbolNotAccessible && element instanceof JSQualifiedNamedElement) {
                JSAttributeList.AccessType newVisibility = JSVisibilityUtil.getEscalatedJSDocVisibility((JSQualifiedNamedElement)element, (PsiElement)referenceExpression);
                quickFixes.add((LocalQuickFix)new JSAccessibilityCheckInspection.SetJSDocElementVisibilityFix(element, newVisibility));
            }
        }
        if (resolveResults.length == 0) {
            JSType qualifierType;
            JSFunction parentFunction;
            String referenceName = referenceExpression.getReferenceName();
            JSExpression qualifier = referenceExpression.getQualifier();
            if (qualifier != null && referenceName != null && (parentFunction = (JSFunction)PsiTreeUtil.getParentOfType((PsiElement)qualifier, JSFunction.class)) != null && JSPsiImplUtils.hasModifier(parentFunction, JSAttributeList.ModifierType.ASYNC) && (qualifierType = JSResolveUtil.getExpressionJSType(qualifier)) instanceof JSGenericTypeImpl && JSTypeUtils.isExactlyPromiseLikeType(qualifierType)) {
                JSRecordType.PropertySignature signature;
                JSType innerType = JSTypeUtils.getSingleGenericArgTypeFromGenericType((JSGenericTypeImpl)qualifierType, t -> true, false);
                JSRecordType.PropertySignature propertySignature = signature = innerType == null ? null : innerType.asRecordType().findPropertySignature(referenceName);
                if (signature != null) {
                    quickFixes.add(JSFixFactory.getInstance().createInsertAwaitFix(qualifier, false));
                }
            }
        }
        JSUnresolvedReferenceErrorUpdater.ErrorInfoImpl info2 = new JSUnresolvedReferenceErrorUpdater.ErrorInfoImpl(quickFixes);
        for (JSUnresolvedReferenceErrorUpdater provider : JSUnresolvedReferenceErrorUpdater.EP_NAME.getExtensionList()) {
            provider.updateError(info2, referenceExpression, resolveResults, inTypeContext);
            String newMessage = info2.getMessage();
            if (newMessage == null) continue;
            message = newMessage;
        }
        if (jsSymbolNotAccessible) {
            this.myReporter.registerProblem(place, null, message, null, quickFixes.toArray(LocalQuickFix.EMPTY_ARRAY));
        } else {
            ProblemHighlightType type2 = this.getUnresolvedReferenceHighlightType(referenceExpression);
            if (isFunction) {
                if (JSCheckFunctionSignaturesInspection.reportIncompleteAsArgumentTypesMismatch(resolveResults) == null) {
                    this.myReporter.registerProblem(place, null, message, type2, quickFixes.toArray(LocalQuickFix.EMPTY_ARRAY));
                }
            } else {
                this.myReporter.registerProblem(place, null, message, type2, quickFixes.toArray(LocalQuickFix.EMPTY_ARRAY));
            }
        }
    }

    public void checkCallReferences(JSReferenceExpression methodExpression, boolean isNewExpression) {
        PsiElement element;
        JSElement expression;
        ResolveResult[] resolveResults = methodExpression.multiResolve(false);
        boolean noCompleteResolve = true;
        boolean mismatchArguments = resolveResults.length > 0;
        for (ResolveResult r : resolveResults) {
            if (r.isValidResult()) {
                noCompleteResolve = false;
                if (this.processExpressionResolveResult(methodExpression, r.getElement())) break;
            }
            mismatchArguments &= r instanceof JSResolveResult && ((JSResolveResult)r).getResolveProblemKind() == JSResolveResult.ProblemKind.ARGUMENT_TYPES_MISMATCH;
        }
        if (resolveResults.length == 0 || noCompleteResolve) {
            boolean canCreateFromUsage;
            JSExpression qualifier = methodExpression.getQualifier();
            LinkedList<LocalQuickFix> quickFixes = new LinkedList<LocalQuickFix>();
            DialectOptionHolder dialect = DialectDetector.dialectOfElement((PsiElement)methodExpression);
            boolean simpleJs = dialect != null && dialect.isJavaScript();
            ProblemHighlightType unresolvedRefHighlightType = this.getUnresolvedReferenceHighlightType(methodExpression);
            boolean reportProblem = unresolvedRefHighlightType != null && (dialect == null || !dialect.isECMA4 || unresolvedRefHighlightType != ProblemHighlightType.LIKE_UNKNOWN_SYMBOL);
            boolean bl = canCreateFromUsage = JSReferenceChecker.canHaveCreateFromUsage(qualifier) && (simpleJs || JSReferenceChecker.findInsufficientVisibilityResult(resolveResults) == null);
            if (reportProblem && canCreateFromUsage && !mismatchArguments) {
                this.addCreateFromUsageFixesForCall(methodExpression, isNewExpression, resolveResults, quickFixes);
            }
            if (reportProblem) {
                String message = this.createUnresolvedCallReferenceMessage(methodExpression, isNewExpression);
                this.reportUnresolvedReference(resolveResults, methodExpression, quickFixes, message, true, false);
            }
        } else if (resolveResults.length == 1 && resolveResults[0].getElement() instanceof JSVariable && methodExpression.getQualifier() == null && ((expression = JSLocalNamespaceEvaluator.calcRefExprValue(methodExpression)) instanceof JSObjectLiteralExpression || expression instanceof JSArrayLiteralExpression) && (element = methodExpression.getReferenceNameElement()) != null) {
            this.myReporter.registerProblem(element, null, JavaScriptBundle.message("javascript.invalid.invoker.target", new Object[0]), ProblemHighlightType.ERROR, new LocalQuickFix[0]);
        }
    }

    @NotNull
    @InspectionMessage
    protected String createUnresolvedCallReferenceMessage(@NotNull JSReferenceExpression methodExpression, boolean isNewExpression) {
        String refName;
        if (methodExpression == null) {
            JSReferenceChecker.$$$reportNull$$$0(23);
        }
        if ((refName = methodExpression.getReferenceName()) == null) {
            refName = "";
        }
        String string = ((JSBundleMessageHighlighter)methodExpression.getProject().getService(JSBundleMessageHighlighter.class)).message(isNewExpression ? "javascript.unresolved.type.name.message" : "javascript.unresolved.function.name.message", refName);
        if (string == null) {
            JSReferenceChecker.$$$reportNull$$$0(24);
        }
        return string;
    }

    public void checkNewExpressionInsideCallReferences(JSNewExpression methodExpression) {
        PsiElement elt;
        ResolveResult[] results;
        JSExpression methodExpr = methodExpression.getMethodExpression();
        if (methodExpr instanceof JSReferenceExpression && (results = ((JSReferenceExpression)methodExpr).multiResolve(false)).length > 0 && ((elt = results[0].getElement()) instanceof JSFunction && ((JSFunction)elt).isConstructor() || elt instanceof JSClass)) {
            this.myReporter.registerProblem((PsiElement)methodExpression, null, JavaScriptBundle.message("javascript.term.does.not.evaluate.to.function", new Object[0]), this.getUnresolvedReferenceHighlightType((JSReferenceExpression)methodExpr), new LocalQuickFix[0]);
        }
    }

    private static JSResolveResult findInsufficientVisibilityResult(ResolveResult[] results) {
        for (ResolveResult r : results) {
            JSResolveResult.ProblemKind problemKey;
            if (r.isValidResult() || !(r instanceof JSResolveResult) || !ArrayUtil.contains((Object)((Object)(problemKey = ((JSResolveResult)r).getResolveProblemKind())), (Object[])JSResolveResult.INSUFFICIENT_VISIBILITY_PROBLEM_KEYS)) continue;
            return (JSResolveResult)r;
        }
        return null;
    }

    private static void addEscalateVisibilityFix(ResolveResult[] resolveResults, JSReferenceExpression refExpr, @NotNull @NotNull List<? super @NotNull LocalQuickFix> fixes) {
        PsiElement psiElement;
        JSResolveResult result2;
        if (fixes == null) {
            JSReferenceChecker.$$$reportNull$$$0(25);
        }
        if ((result2 = JSReferenceChecker.findInsufficientVisibilityResult(resolveResults)) == null || !((psiElement = result2.getElement()) instanceof JSAttributeListOwner)) {
            return;
        }
        JSAttributeListOwner element = (JSAttributeListOwner)psiElement;
        JSAttributeList attributeList = element.getAttributeList();
        if (attributeList == null) {
            return;
        }
        if (JSProjectUtil.isInLibrary((PsiElement)element)) {
            return;
        }
        JSVisibilityUtil.Options options = new JSVisibilityUtil.Options();
        JSResolveResult.ProblemKind problemKind = result2.getResolveProblemKind();
        if (attributeList.getAccessType() == JSAttributeList.AccessType.PUBLIC) {
            return;
        }
        options.ignoreClassInheritance = problemKind == JSResolveResult.ProblemKind.PROTECTED_MEMBER_IS_NOT_ACCESSIBLE;
        JSAttributeList.AccessType visibility = JSVisibilityUtil.getEscalatedVisibility(element, (PsiElement)refExpr, attributeList.getAccessType(), options);
        fixes.add((LocalQuickFix)JSFixFactory.getInstance().createChangeVisibilityFix(element, visibility, null));
        if (DialectDetector.isJavaScriptFamily((PsiElement)element) && visibility == JSAttributeList.AccessType.PROTECTED) {
            fixes.add((LocalQuickFix)JSFixFactory.getInstance().createChangeVisibilityFix(element, JSAttributeList.AccessType.PUBLIC, null));
        }
    }

    protected static void addCreateParameterFix(JSReferenceExpression referenceExpression, @NotNull @NotNull List<? super @NotNull LocalQuickFix> fixes, String referencedName) {
        if (fixes == null) {
            JSReferenceChecker.$$$reportNull$$$0(26);
        }
        PsiElement parentElement = referenceExpression.getParent();
        if (PsiTreeUtil.getParentOfType((PsiElement)referenceExpression, JSFunction.class) != null && !ES6PsiUtil.isInsideDecorator(parentElement)) {
            fixes.add((LocalQuickFix)JSFixFactory.getInstance().createJSParameterIntentionAction(referenceExpression, referencedName));
        }
    }

    private static boolean isFunctionExpectedType(@NotNull JSReferenceExpression node) {
        JSType type2;
        JSType valuableType;
        if (node == null) {
            JSReferenceChecker.$$$reportNull$$$0(27);
        }
        return (valuableType = JSTypeUtils.getValuableType(type2 = JSDialectSpecificHandlersFactory.findExpectedType(node, JSExpectedTypeKind.EXPECTED))) != null && !JSTypeCastUtil.isAlwaysAssignableType(valuableType, (PsiElement)node) && JSTypeUtils.hasFunctionType(valuableType, false, (PsiElement)node);
    }

    @NotNull
    protected LocalQuickFix createClassOrInterfaceFix(@NotNull JSReferenceExpression referenceExpression, boolean isInterface) {
        if (referenceExpression == null) {
            JSReferenceChecker.$$$reportNull$$$0(28);
        }
        LocalQuickFix localQuickFix = JSFixFactory.getInstance().createClassOrInterfaceFix((PsiElement)referenceExpression, isInterface, null, null);
        if (localQuickFix == null) {
            JSReferenceChecker.$$$reportNull$$$0(29);
        }
        return localQuickFix;
    }

    @NotNull
    protected LocalQuickFix createClassFromNewFix(@NotNull JSReferenceExpression referenceExpression, @Nullable JSArgumentList argumentList, @Nullable JSType expectedType) {
        if (referenceExpression == null) {
            JSReferenceChecker.$$$reportNull$$$0(30);
        }
        LocalQuickFix localQuickFix = JSFixFactory.getInstance().createClassOrInterfaceFix((PsiElement)referenceExpression, false, argumentList, expectedType);
        if (localQuickFix == null) {
            JSReferenceChecker.$$$reportNull$$$0(31);
        }
        return localQuickFix;
    }

    @NotNull
    private static LocalQuickFix renameReferenceFix() {
        LocalQuickFix localQuickFix = JSFixFactory.getInstance().renameReferenceFix();
        if (localQuickFix == null) {
            JSReferenceChecker.$$$reportNull$$$0(32);
        }
        return localQuickFix;
    }

    private static boolean canHaveCreateFromUsage(JSExpression qualifier) {
        JSExpression innerExpression;
        if (qualifier instanceof JSParenthesizedExpression && (innerExpression = ((JSParenthesizedExpression)qualifier).getInnerExpression()) instanceof JSBinaryExpression && JSTokenTypes.AS_KEYWORD == ((JSBinaryExpression)innerExpression).getOperationSign()) {
            return true;
        }
        return qualifier == null || qualifier instanceof JSThisExpression || qualifier instanceof JSSuperExpression || qualifier instanceof JSNewExpression || qualifier instanceof JSCallExpression && (DialectDetector.isActionScript((PsiElement)qualifier) || DialectDetector.isTypeScript((PsiElement)qualifier)) || JSValidateExpressionUtil.isLHSExpression(qualifier);
    }

    public static LocalQuickFix[] getCreateFixesForUnresolvedRef(ES6ImportExportDeclarationPart importExportPart) {
        PsiElement file = ES6PsiUtil.computeFromFileForImportExport((PsiElement)importExportPart);
        if (JSReferenceChecker.isInapplicableFile(file)) {
            return LocalQuickFix.EMPTY_ARRAY;
        }
        LocalQuickFix createClassFix = JSFixFactory.getInstance().createClassOrInterfaceFix((PsiElement)importExportPart, false, null, null);
        LocalQuickFix createInterfaceFix = JSFixFactory.getInstance().createClassOrInterfaceFix((PsiElement)importExportPart, true, null, null);
        FixAndIntentionAction createVariableFix = (FixAndIntentionAction)JSFixFactory.getInstance().createJSVariableIntentionAction(JSReferenceChecker.getNameToCreate(importExportPart), true, false, true);
        createVariableFix.registerElementRefForFix((PsiElement)importExportPart, null);
        FixAndIntentionAction createFunctionFix = (FixAndIntentionAction)JSFixFactory.getInstance().createJSFunctionIntentionAction(JSReferenceChecker.getNameToCreate(importExportPart), true, true, false);
        createFunctionFix.registerElementRefForFix((PsiElement)importExportPart, null);
        return new LocalQuickFix[]{createClassFix, createInterfaceFix, createVariableFix, createFunctionFix};
    }

    private static boolean isInapplicableFile(@Nullable PsiElement file) {
        if (file == null) {
            return true;
        }
        PsiFile file1 = file.getContainingFile();
        if (file1 == null) {
            return true;
        }
        VirtualFile virtualFile = file1.getVirtualFile();
        return virtualFile == null || JSLibraryUtil.isProbableLibraryFile(virtualFile);
    }

    public static String getNameToCreate(ES6ImportExportDeclarationPart importExportPart) {
        if (importExportPart instanceof ES6ImportExportSpecifier) {
            return ((ES6ImportExportSpecifier)importExportPart).getReferenceName();
        }
        return importExportPart.getName();
    }

    @Nullable
    public static JSCallLikeExpression getCallIfMethodExpression(@NotNull JSReferenceExpression expression) {
        JSExpression methodExpression;
        PsiElement parent;
        if (expression == null) {
            JSReferenceChecker.$$$reportNull$$$0(33);
        }
        return (parent = (methodExpression = JSUtils.getTopmostParenthesizedOrSelf(expression)).getParent()) instanceof JSCallLikeExpression && ((JSCallLikeExpression)parent).getMethodExpression() == methodExpression ? (JSCallLikeExpression)parent : null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 4, 5, 6, 18, 24, 29, 31, 32 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "reporter";
                break;
            }
            case 1: 
            case 2: 
            case 15: 
            case 27: {
                objectArray2 = objectArray3;
                objectArray3[0] = "node";
                break;
            }
            case 3: 
            case 8: 
            case 25: 
            case 26: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fixes";
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 18: 
            case 24: 
            case 29: 
            case 31: 
            case 32: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/javascript/validation/JSReferenceChecker";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "qualifier";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 10: 
            case 23: {
                objectArray2 = objectArray3;
                objectArray3[0] = "methodExpression";
                break;
            }
            case 11: 
            case 14: 
            case 16: 
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "quickFixes";
                break;
            }
            case 12: 
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "resolveResults";
                break;
            }
            case 13: 
            case 33: {
                objectArray2 = objectArray3;
                objectArray3[0] = "expression";
                break;
            }
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 19: 
            case 28: 
            case 30: {
                objectArray2 = objectArray3;
                objectArray3[0] = "referenceExpression";
                break;
            }
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "message";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/javascript/validation/JSReferenceChecker";
                break;
            }
            case 4: 
            case 5: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getPotentialTypos";
                break;
            }
            case 18: {
                objectArray = objectArray2;
                objectArray2[1] = "createJSVariableIntentionAction";
                break;
            }
            case 24: {
                objectArray = objectArray2;
                objectArray2[1] = "createUnresolvedCallReferenceMessage";
                break;
            }
            case 29: {
                objectArray = objectArray2;
                objectArray2[1] = "createClassOrInterfaceFix";
                break;
            }
            case 31: {
                objectArray = objectArray2;
                objectArray2[1] = "createClassFromNewFix";
                break;
            }
            case 32: {
                objectArray = objectArray2;
                objectArray2[1] = "renameReferenceFix";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "checkRefExpression";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "getUnresolvedReferenceHighlightType";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "addCreateFromUsageFixes";
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 18: 
            case 24: 
            case 29: 
            case 31: 
            case 32: {
                break;
            }
            case 7: 
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "addSurroundWithTypeGuardFix";
                break;
            }
            case 10: 
            case 11: 
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "addCreateFromUsageFixesForCall";
                break;
            }
            case 13: 
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "addTypoQuickFixes";
                break;
            }
            case 15: 
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "addFunctionFixes";
                break;
            }
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "hasArrowFunctions";
                break;
            }
            case 19: 
            case 20: 
            case 21: 
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "reportUnresolvedReference";
                break;
            }
            case 23: {
                objectArray = objectArray;
                objectArray[2] = "createUnresolvedCallReferenceMessage";
                break;
            }
            case 25: {
                objectArray = objectArray;
                objectArray[2] = "addEscalateVisibilityFix";
                break;
            }
            case 26: {
                objectArray = objectArray;
                objectArray[2] = "addCreateParameterFix";
                break;
            }
            case 27: {
                objectArray = objectArray;
                objectArray[2] = "isFunctionExpectedType";
                break;
            }
            case 28: {
                objectArray = objectArray;
                objectArray[2] = "createClassOrInterfaceFix";
                break;
            }
            case 30: {
                objectArray = objectArray;
                objectArray[2] = "createClassFromNewFix";
                break;
            }
            case 33: {
                objectArray = objectArray;
                objectArray[2] = "getCallIfMethodExpression";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 4, 5, 6, 18, 24, 29, 31, 32 -> new IllegalStateException(string);
        };
    }
}

