/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.validation;

import com.intellij.codeInsight.daemon.impl.analysis.HighlightInfoHolder;
import com.intellij.lang.ASTNode;
import com.intellij.lang.ecmascript6.psi.ES6ExportDeclaration;
import com.intellij.lang.ecmascript6.psi.ES6ImportDeclaration;
import com.intellij.lang.javascript.DialectOptionHolder;
import com.intellij.lang.javascript.JSTokenTypes;
import com.intellij.lang.javascript.dialects.ECMA6SyntaxHighlighterFactory;
import com.intellij.lang.javascript.documentation.JSDocumentationUtils;
import com.intellij.lang.javascript.highlighting.JSHighlighter;
import com.intellij.lang.javascript.psi.JSCallExpression;
import com.intellij.lang.javascript.psi.JSElement;
import com.intellij.lang.javascript.psi.JSExpression;
import com.intellij.lang.javascript.psi.JSForInStatement;
import com.intellij.lang.javascript.psi.JSPrefixExpression;
import com.intellij.lang.javascript.psi.JSReferenceExpression;
import com.intellij.lang.javascript.psi.JSVarStatement;
import com.intellij.lang.javascript.psi.ecma6.ES6Decorator;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptSingleType;
import com.intellij.lang.javascript.psi.ecmal4.JSAttributeList;
import com.intellij.lang.javascript.validation.JSKeywordHighlighterVisitor;
import com.intellij.openapi.editor.colors.TextAttributesKey;
import com.intellij.psi.PsiElement;
import org.jetbrains.annotations.NotNull;

public class ES6KeywordHighlighterVisitor
extends JSKeywordHighlighterVisitor {
    public ES6KeywordHighlighterVisitor(@NotNull HighlightInfoHolder holder) {
        if (holder == null) {
            ES6KeywordHighlighterVisitor.$$$reportNull$$$0(0);
        }
        super(holder, new ECMA6SyntaxHighlighterFactory.ECMA6SyntaxHighlighter(DialectOptionHolder.JS_WITH_JSX, true));
    }

    public ES6KeywordHighlighterVisitor(HighlightInfoHolder holder, JSHighlighter highlighter) {
        super(holder, highlighter);
    }

    @Override
    public void visitJSForInStatement(@NotNull JSForInStatement element) {
        if (element == null) {
            ES6KeywordHighlighterVisitor.$$$reportNull$$$0(1);
        }
        this.highlightChildKeywordOfType((PsiElement)element, JSTokenTypes.OF_KEYWORD);
        this.highlightChildKeywordOfType((PsiElement)element, JSTokenTypes.AWAIT_KEYWORD);
        super.visitJSForInStatement(element);
    }

    @Override
    public void visitES6ExportDeclaration(@NotNull ES6ExportDeclaration exportDeclaration) {
        if (exportDeclaration == null) {
            ES6KeywordHighlighterVisitor.$$$reportNull$$$0(2);
        }
        this.highlightChildKeywordOfType((PsiElement)exportDeclaration, JSTokenTypes.TYPE_KEYWORD);
        super.visitES6ExportDeclaration(exportDeclaration);
    }

    @Override
    public void visitES6ImportDeclaration(@NotNull ES6ImportDeclaration importDeclaration) {
        if (importDeclaration == null) {
            ES6KeywordHighlighterVisitor.$$$reportNull$$$0(3);
        }
        this.highlightChildKeywordOfType((PsiElement)importDeclaration, JSTokenTypes.TYPE_KEYWORD);
        super.visitES6ImportDeclaration(importDeclaration);
    }

    @Override
    public void visitJSPrefixExpression(@NotNull JSPrefixExpression element) {
        if (element == null) {
            ES6KeywordHighlighterVisitor.$$$reportNull$$$0(4);
        }
        this.highlightChildKeywordOfType((PsiElement)element, JSTokenTypes.AWAIT_KEYWORD);
        super.visitJSPrefixExpression(element);
    }

    @Override
    public void visitJSAttributeList(@NotNull JSAttributeList element) {
        if (element == null) {
            ES6KeywordHighlighterVisitor.$$$reportNull$$$0(5);
        }
        this.highlightChildKeywordOfType((PsiElement)element, JSTokenTypes.ASYNC_KEYWORD);
        super.visitJSAttributeList(element);
    }

    @Override
    public void visitES6Decorator(@NotNull ES6Decorator decorator) {
        PsiElement element;
        JSExpression expression;
        ASTNode at;
        if (decorator == null) {
            ES6KeywordHighlighterVisitor.$$$reportNull$$$0(6);
        }
        if ((at = decorator.getNode().findChildByType(JSTokenTypes.AT)) != null) {
            ES6KeywordHighlighterVisitor.lineMarker(at.getPsi(), this.myHighlighter.getMappedKey(JSHighlighter.ES6_DECORATOR), "decorator", this.myHolder);
        }
        if ((expression = decorator.getExpression()) instanceof JSCallExpression) {
            expression = ((JSCallExpression)expression).getMethodExpression();
        }
        if (expression instanceof JSReferenceExpression && (element = ((JSReferenceExpression)expression).getReferenceNameElement()) != null) {
            ES6KeywordHighlighterVisitor.lineMarker(element, this.myHighlighter.getMappedKey(JSHighlighter.ES6_DECORATOR), "decorator", this.myHolder);
        }
        super.visitES6Decorator(decorator);
    }

    @Override
    public void visitTypeScriptSingleType(@NotNull TypeScriptSingleType singleType) {
        JSReferenceExpression referenceExpression;
        JSElement parent;
        ASTNode node;
        ASTNode keyword;
        if (singleType == null) {
            ES6KeywordHighlighterVisitor.$$$reportNull$$$0(7);
        }
        if ((keyword = (node = (parent = (referenceExpression = singleType.getReferenceExpression()) != null ? referenceExpression : singleType).getNode()).findChildByType(JSDocumentationUtils.ourPrimitiveTypeFilter)) != null) {
            TextAttributesKey key2 = this.annotatePrimitiveType(keyword);
            this.myHolder.add(JSKeywordHighlighterVisitor.highlightKeyword(keyword, key2));
        }
        super.visitTypeScriptSingleType(singleType);
    }

    @NotNull
    protected TextAttributesKey annotatePrimitiveType(ASTNode keyword) {
        TextAttributesKey textAttributesKey = JSHighlighter.JS_PRIMITIVE_TYPE;
        if (textAttributesKey == null) {
            ES6KeywordHighlighterVisitor.$$$reportNull$$$0(8);
        }
        return textAttributesKey;
    }

    @Override
    public void visitJSVarStatement(@NotNull JSVarStatement varStatement) {
        if (varStatement == null) {
            ES6KeywordHighlighterVisitor.$$$reportNull$$$0(9);
        }
        this.highlightChildKeywordOfType((PsiElement)varStatement, JSTokenTypes.USING_KEYWORD);
        super.visitJSVarStatement(varStatement);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 8 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "holder";
                break;
            }
            case 1: 
            case 4: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "exportDeclaration";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "importDeclaration";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "decorator";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "singleType";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/javascript/validation/ES6KeywordHighlighterVisitor";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "varStatement";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/javascript/validation/ES6KeywordHighlighterVisitor";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "annotatePrimitiveType";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "visitJSForInStatement";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "visitES6ExportDeclaration";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "visitES6ImportDeclaration";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "visitJSPrefixExpression";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "visitJSAttributeList";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "visitES6Decorator";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "visitTypeScriptSingleType";
                break;
            }
            case 8: {
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "visitJSVarStatement";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 8 -> new IllegalStateException(string);
        };
    }
}

