/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.ui;

import com.intellij.ide.IdeBundle;
import com.intellij.ide.projectView.impl.AbstractProjectTreeStructure;
import com.intellij.ide.projectView.impl.ProjectAbstractTreeStructureBase;
import com.intellij.ide.projectView.impl.nodes.PsiFileNode;
import com.intellij.ide.util.gotoByName.ChooseByNameModel;
import com.intellij.ide.util.gotoByName.ChooseByNamePanel;
import com.intellij.ide.util.gotoByName.ChooseByNamePopupComponent;
import com.intellij.ide.util.gotoByName.GotoClassModel2;
import com.intellij.ide.util.treeView.AbstractTreeStructure;
import com.intellij.ide.util.treeView.AlphaComparator;
import com.intellij.ide.util.treeView.NodeRenderer;
import com.intellij.lang.javascript.psi.JSFile;
import com.intellij.lang.javascript.psi.ecmal4.JSClass;
import com.intellij.lang.javascript.psi.ecmal4.JSQualifiedNamedElement;
import com.intellij.lang.javascript.psi.ecmal4.XmlBackedJSClassFactory;
import com.intellij.lang.javascript.psi.impl.JSPsiImplUtils;
import com.intellij.lang.javascript.psi.resolve.ActionScriptResolveUtil;
import com.intellij.lang.javascript.psi.resolve.JSResolveUtil;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.NlsContexts;
import com.intellij.openapi.wm.IdeFocusManager;
import com.intellij.openapi.wm.ex.IdeFocusTraversalPolicy;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.search.PsiSearchScopeUtil;
import com.intellij.psi.xml.XmlFile;
import com.intellij.ui.DoubleClickListener;
import com.intellij.ui.ScrollPaneFactory;
import com.intellij.ui.TabbedPaneWrapper;
import com.intellij.ui.TreeUIHelper;
import com.intellij.ui.tree.AsyncTreeModel;
import com.intellij.ui.tree.StructureTreeModel;
import com.intellij.ui.treeStructure.Tree;
import com.intellij.util.concurrency.AppExecutorUtil;
import com.intellij.util.indexing.FindSymbolParameters;
import com.intellij.util.ui.JBUI;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.concurrent.Executor;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTree;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.TreeCellRenderer;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreePath;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class JSClassChooserDialog
extends DialogWrapper {
    @NotNull
    private final Project myProject;
    @NotNull
    private final GlobalSearchScope mySearchScope;
    private Tree myTree;
    @Nullable
    private JSClass myInitialClass;
    private StructureTreeModel<? extends ProjectAbstractTreeStructureBase> myModel;
    private ChooseByNamePanel myGotoByNamePanel;
    private TabbedPaneWrapper myTabbedPane;
    private JSClass mySelectedClass;
    private boolean myResult;
    @Nullable
    private final Condition<? super JSClass> myClassFilter;

    public JSClassChooserDialog(@NotNull Project project, @NotNull @NlsContexts.DialogTitle String title, @NotNull GlobalSearchScope scope2, @Nullable JSClass initialClass, @Nullable Condition<? super JSClass> classFilter) {
        if (project == null) {
            JSClassChooserDialog.$$$reportNull$$$0(0);
        }
        if (title == null) {
            JSClassChooserDialog.$$$reportNull$$$0(1);
        }
        if (scope2 == null) {
            JSClassChooserDialog.$$$reportNull$$$0(2);
        }
        super(project, true);
        this.myProject = project;
        this.mySearchScope = scope2;
        this.myInitialClass = initialClass;
        this.myClassFilter = classFilter;
        this.setTitle(title);
        this.init();
        if (this.myInitialClass != null) {
            this.selectElementInTree(this.myInitialClass);
        }
        this.handleSelectionChanged();
    }

    public JComponent getPreferredFocusedComponent() {
        return this.myGotoByNamePanel.getPreferredFocusedComponent();
    }

    public JSClass getSelectedClass() {
        return this.mySelectedClass;
    }

    public boolean showDialog() {
        this.myResult = false;
        this.show();
        return this.myResult;
    }

    @Nullable
    private JSClass calcSelectedClass() {
        if (this.myTabbedPane.getSelectedIndex() == 0) {
            return (JSClass)this.myGotoByNamePanel.getChosenElement();
        }
        TreePath path2 = this.myTree.getSelectionPath();
        if (path2 == null) {
            return null;
        }
        DefaultMutableTreeNode node = (DefaultMutableTreeNode)path2.getLastPathComponent();
        Object userObject = node.getUserObject();
        if (userObject instanceof PsiFileNode) {
            PsiFile file = (PsiFile)((PsiFileNode)userObject).getValue();
            if (file instanceof JSFile) {
                return JSPsiImplUtils.findClass((JSFile)file);
            }
            if (file instanceof XmlFile) {
                return XmlBackedJSClassFactory.getXmlBackedClass((XmlFile)file);
            }
        }
        return null;
    }

    private JSClass getContext() {
        return this.myInitialClass;
    }

    private ModalityState getModalityState() {
        return ModalityState.stateForComponent((Component)this.getRootPane());
    }

    private void handleSelectionChanged() {
        JSClass selection = this.calcSelectedClass();
        this.setOKActionEnabled(selection != null && this.isAccepted(selection));
    }

    private boolean isAccepted(@NotNull JSClass clazz) {
        if (clazz == null) {
            JSClassChooserDialog.$$$reportNull$$$0(3);
        }
        return !ActionScriptResolveUtil.hasExcludeClassMetadata(clazz) && PsiSearchScopeUtil.isInScope((GlobalSearchScope)this.mySearchScope, (PsiElement)clazz) && (this.myClassFilter == null || this.myClassFilter.value((Object)clazz));
    }

    private void selectElementInTree(@NotNull PsiElement element) {
        if (element == null) {
            JSClassChooserDialog.$$$reportNull$$$0(4);
        }
        ReadAction.nonBlocking(() -> element.getContainingFile()).coalesceBy(new Object[]{element, this.mySearchScope, this}).expireWith(this.getDisposable()).finishOnUiThread(this.getModalityState(), psiFile -> {
            if (this.myModel != null) {
                this.myModel.select(psiFile, (JTree)this.myTree, path2 -> {});
            }
        }).submit((Executor)AppExecutorUtil.getAppExecutorService());
    }

    @Nullable
    protected JComponent createCenterPanel() {
        AbstractProjectTreeStructure treeStructure = new AbstractProjectTreeStructure(this.myProject){

            public boolean isHideEmptyMiddlePackages() {
                return true;
            }

            public boolean isShowModules() {
                return false;
            }
        };
        this.myModel = new StructureTreeModel((AbstractTreeStructure)treeStructure, this.getDisposable());
        this.myModel.setComparator((Comparator)AlphaComparator.INSTANCE);
        this.myTree = new Tree((TreeModel)new AsyncTreeModel(this.myModel, this.getDisposable()));
        this.myTree.setRootVisible(false);
        this.myTree.setShowsRootHandles(true);
        this.myTree.expandRow(0);
        this.myTree.getSelectionModel().setSelectionMode(1);
        this.myTree.setCellRenderer((TreeCellRenderer)new NodeRenderer());
        JScrollPane scrollPane = ScrollPaneFactory.createScrollPane((Component)this.myTree);
        scrollPane.setPreferredSize((Dimension)JBUI.size((int)500, (int)300));
        this.myTree.addKeyListener((KeyListener)new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent e) {
                if (10 == e.getKeyCode()) {
                    JSClassChooserDialog.this.doOKAction();
                }
            }
        });
        new DoubleClickListener(){

            protected boolean onDoubleClick(@NotNull MouseEvent e) {
                JSClass jsClass;
                TreePath path2;
                if (e == null) {
                    3.$$$reportNull$$$0(0);
                }
                if ((path2 = JSClassChooserDialog.this.myTree.getPathForLocation(e.getX(), e.getY())) != null && JSClassChooserDialog.this.myTree.isPathSelected(path2) && (jsClass = JSClassChooserDialog.this.calcSelectedClass()) != null && JSClassChooserDialog.this.isAccepted(jsClass)) {
                    JSClassChooserDialog.this.doOKAction();
                    return true;
                }
                return false;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/lang/javascript/ui/JSClassChooserDialog$3", "onDoubleClick"));
            }
        }.installOn((Component)this.myTree);
        this.myTree.addTreeSelectionListener(new TreeSelectionListener(){

            @Override
            public void valueChanged(TreeSelectionEvent e) {
                JSClassChooserDialog.this.handleSelectionChanged();
            }
        });
        TreeUIHelper.getInstance().installTreeSpeedSearch((JTree)this.myTree);
        JPanel dummyPanel = new JPanel(new BorderLayout());
        String name = null;
        this.myGotoByNamePanel = new MyChooseByNamePanel(name, dummyPanel);
        this.myTabbedPane = new TabbedPaneWrapper(this.getDisposable());
        this.myTabbedPane.addTab(IdeBundle.message((String)"tab.chooser.search.by.name", (Object[])new Object[0]), (JComponent)dummyPanel);
        this.myTabbedPane.addTab(IdeBundle.message((String)"tab.chooser.project", (Object[])new Object[0]), (JComponent)scrollPane);
        this.myGotoByNamePanel.invoke((ChooseByNamePopupComponent.Callback)new MyCallback(), this.getModalityState(), false);
        this.myTabbedPane.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                JSClassChooserDialog.this.handleSelectionChanged();
            }
        });
        return this.myTabbedPane.getComponent();
    }

    private ChooseByNameModel createChooseByNameModel() {
        return new MyGotoClassModel(this.myProject);
    }

    protected void doOKAction() {
        this.myResult = true;
        this.mySelectedClass = this.calcSelectedClass();
        if (this.mySelectedClass == null) {
            return;
        }
        super.doOKAction();
    }

    protected String getDimensionServiceKey() {
        return "#com.intellij.ide.util.TreeClassChooserDialog";
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "title";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "scope";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "clazz";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
        }
        objectArray2[1] = "com/intellij/lang/javascript/ui/JSClassChooserDialog";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "isAccepted";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "selectElementInTree";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    private class MyChooseByNamePanel
    extends ChooseByNamePanel {
        private final JPanel dummyPanel;

        MyChooseByNamePanel(String name, JPanel dummyPanel) {
            super(JSClassChooserDialog.this.myProject, JSClassChooserDialog.this.createChooseByNameModel(), name, JSClassChooserDialog.this.mySearchScope.isSearchInLibraries(), (PsiElement)JSClassChooserDialog.this.getContext());
            this.dummyPanel = dummyPanel;
        }

        protected void showTextFieldPanel() {
        }

        protected void close(boolean isOk) {
            super.close(isOk);
            if (isOk) {
                JSClassChooserDialog.this.doOKAction();
            } else {
                JSClassChooserDialog.this.doCancelAction();
            }
        }

        protected void initUI(ChooseByNamePopupComponent.Callback callback, ModalityState modalityState, boolean allowMultipleSelection) {
            super.initUI(callback, modalityState, allowMultipleSelection);
            this.dummyPanel.add((Component)JSClassChooserDialog.this.myGotoByNamePanel.getPanel(), "Center");
            IdeFocusManager.getGlobalInstance().doWhenFocusSettlesDown(() -> IdeFocusManager.getGlobalInstance().requestFocus((Component)IdeFocusTraversalPolicy.getPreferredFocusedComponent((JComponent)JSClassChooserDialog.this.myGotoByNamePanel.getPanel()), true));
        }

        protected void showList() {
            super.showList();
            if (JSClassChooserDialog.this.myInitialClass != null && this.myList.getModel().getSize() > 0) {
                this.myList.setSelectedValue(JSClassChooserDialog.this.myInitialClass, true);
                JSClassChooserDialog.this.myInitialClass = null;
            }
        }

        protected void chosenElementMightChange() {
            JSClassChooserDialog.this.handleSelectionChanged();
        }
    }

    private class MyCallback
    extends ChooseByNamePopupComponent.Callback {
        private MyCallback() {
        }

        public void elementChosen(Object element) {
            JSClassChooserDialog.this.mySelectedClass = (JSClass)element;
            JSClassChooserDialog.this.close(0);
        }
    }

    private class MyGotoClassModel
    extends GotoClassModel2 {
        MyGotoClassModel(Project project) {
            if (project == null) {
                MyGotoClassModel.$$$reportNull$$$0(0);
            }
            super(project);
        }

        public Object @NotNull [] getElementsByName(@NotNull String name, @NotNull FindSymbolParameters parameters, @NotNull ProgressIndicator canceled) {
            if (name == null) {
                MyGotoClassModel.$$$reportNull$$$0(1);
            }
            if (parameters == null) {
                MyGotoClassModel.$$$reportNull$$$0(2);
            }
            if (canceled == null) {
                MyGotoClassModel.$$$reportNull$$$0(3);
            }
            Collection<JSQualifiedNamedElement> elements = JSResolveUtil.findElementsByName(name, this.myProject, parameters.getSearchScope(), false);
            ArrayList<JSClass> list2 = new ArrayList<JSClass>();
            for (JSQualifiedNamedElement element : elements) {
                if (!(element instanceof JSClass) || !JSClassChooserDialog.this.isAccepted((JSClass)element)) continue;
                list2.add((JSClass)element);
            }
            Object[] objectArray = list2.toArray(JSClass.EMPTY_ARRAY);
            if (objectArray == null) {
                MyGotoClassModel.$$$reportNull$$$0(4);
            }
            return objectArray;
        }

        @Nullable
        public String getPromptText() {
            return null;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 4 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "name";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "parameters";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "canceled";
                    break;
                }
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/lang/javascript/ui/JSClassChooserDialog$MyGotoClassModel";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/lang/javascript/ui/JSClassChooserDialog$MyGotoClassModel";
                    break;
                }
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getElementsByName";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 1: 
                case 2: 
                case 3: {
                    objectArray = objectArray;
                    objectArray[2] = "getElementsByName";
                    break;
                }
                case 4: {
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 4 -> new IllegalStateException(string);
            };
        }
    }
}

