/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.types;

import com.intellij.lang.javascript.DialectDetector;
import com.intellij.lang.javascript.dialects.JSDialectSpecificHandlersFactory;
import com.intellij.lang.javascript.psi.JSBlockStatement;
import com.intellij.lang.javascript.psi.JSExpectedTypeKind;
import com.intellij.lang.javascript.psi.JSExpression;
import com.intellij.lang.javascript.psi.JSFunction;
import com.intellij.lang.javascript.psi.JSFunctionExpression;
import com.intellij.lang.javascript.psi.JSInitializerOwner;
import com.intellij.lang.javascript.psi.JSRecordType;
import com.intellij.lang.javascript.psi.JSRecursiveElementVisitor;
import com.intellij.lang.javascript.psi.JSReturnStatement;
import com.intellij.lang.javascript.psi.JSType;
import com.intellij.lang.javascript.psi.JSTypeUtils;
import com.intellij.lang.javascript.psi.JSYieldExpression;
import com.intellij.lang.javascript.psi.ecmal4.JSClass;
import com.intellij.lang.javascript.psi.impl.JSPsiImplUtils;
import com.intellij.lang.javascript.psi.resolve.JSResolveUtil;
import com.intellij.lang.javascript.psi.types.JSAnyType;
import com.intellij.lang.javascript.psi.types.JSArrayType;
import com.intellij.lang.javascript.psi.types.JSAsyncReturnType;
import com.intellij.lang.javascript.psi.types.JSCompositeTypeFactory;
import com.intellij.lang.javascript.psi.types.JSGeneratorReturnType;
import com.intellij.lang.javascript.psi.types.JSGenericTypeImpl;
import com.intellij.lang.javascript.psi.types.JSLiteralType;
import com.intellij.lang.javascript.psi.types.JSNamedTypeFactory;
import com.intellij.lang.javascript.psi.types.JSTupleType;
import com.intellij.lang.javascript.psi.types.JSTypeContext;
import com.intellij.lang.javascript.psi.types.JSTypeSource;
import com.intellij.lang.javascript.psi.types.JSTypeSourceFactory;
import com.intellij.lang.javascript.psi.types.JSTypeofTypeImpl;
import com.intellij.lang.javascript.psi.types.JSWidenType;
import com.intellij.lang.javascript.psi.types.primitives.JSStringType;
import com.intellij.openapi.util.Conditions;
import com.intellij.openapi.util.Ref;
import com.intellij.psi.PsiElement;
import com.intellij.psi.SyntaxTraverser;
import com.intellij.util.Processor;
import it.unimi.dsi.fastutil.Hash;
import it.unimi.dsi.fastutil.objects.ObjectOpenCustomHashSet;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class TypeFromUsageDetector {
    private TypeFromUsageDetector() {
    }

    @Nullable
    public static JSType detectTypeFromUsage(@NotNull PsiElement parent) {
        JSExpression expression;
        if (parent == null) {
            TypeFromUsageDetector.$$$reportNull$$$0(0);
        }
        if (parent instanceof JSInitializerOwner && (expression = ((JSInitializerOwner)parent).getInitializer()) != null) {
            if (DialectDetector.isActionScript(parent)) {
                return JSResolveUtil.getExpressionJSType(expression);
            }
            JSTypeSource source = JSTypeSourceFactory.createTypeSource(parent, true);
            return JSWidenType.createWidening(new JSTypeofTypeImpl(expression, source), parent);
        }
        if (!(parent instanceof JSFunction)) {
            return null;
        }
        JSFunction function2 = (JSFunction)parent;
        JSType functionType2 = TypeFromUsageDetector.getFunctionType(function2, false);
        JSType generatorReturn = TypeFromUsageDetector.getFunctionType(function2, true);
        JSType typeForYield = JSCompositeTypeFactory.createIntersectionType(((SyntaxTraverser)SyntaxTraverser.psiTraverser((PsiElement)function2).forceIgnore(Conditions.instanceOf(JSFunction.class))).filter(JSYieldExpression.class).map(e -> JSDialectSpecificHandlersFactory.findExpectedType(e, JSExpectedTypeKind.EXPECTED)).filter(Conditions.notNull()).filter(t -> !(t instanceof JSAnyType)).toList(), JSTypeSourceFactory.createTypeSource(function2, true));
        return TypeFromUsageDetector.getReturnTypeInContext(functionType2, generatorReturn, typeForYield, function2);
    }

    @Contract(value="!null, _, _, _ -> !null")
    @Nullable
    public static JSType getReturnTypeInContext(@Nullable JSType functionType2, @Nullable JSType generatorReturn, @Nullable JSType typeForYield, @NotNull JSFunction function2) {
        if (function2 == null) {
            TypeFromUsageDetector.$$$reportNull$$$0(1);
        }
        boolean isGenerator = function2.isGenerator();
        boolean isAsync = function2.isAsync();
        if (isAsync && !isGenerator) {
            if (functionType2 == null) {
                return null;
            }
            return new JSAsyncReturnType(JSTypeSourceFactory.createTypeSource(function2, true), functionType2);
        }
        if (isAsync) {
            return new JSGeneratorReturnType(JSTypeSourceFactory.createTypeSource(function2, true), functionType2, generatorReturn, typeForYield, true);
        }
        if (isGenerator && (functionType2 == null || !TypeFromUsageDetector.isValidGeneratorReturn(functionType2.substitute()))) {
            return new JSGeneratorReturnType(JSTypeSourceFactory.createTypeSource(function2, true), functionType2, generatorReturn, typeForYield, false);
        }
        return functionType2;
    }

    private static boolean isValidGeneratorReturn(@NotNull JSType functionType2) {
        if (functionType2 == null) {
            TypeFromUsageDetector.$$$reportNull$$$0(2);
        }
        if (JSTypeUtils.getIterableComponentType(functionType2) == null) {
            return false;
        }
        return !(functionType2 instanceof JSStringType) && !(functionType2 instanceof JSArrayType) && !(functionType2 instanceof JSTupleType) && !(functionType2 instanceof JSRecordType) && (!(functionType2 instanceof JSGenericTypeImpl) || !JSArrayType.isGenericArray((JSGenericTypeImpl)functionType2));
    }

    @Nullable
    private static JSType getFunctionType(@NotNull JSFunction parent, final boolean forGeneratorReturnOnly) {
        JSExpression arrowFunctionReturnExpression;
        if (parent == null) {
            TypeFromUsageDetector.$$$reportNull$$$0(3);
        }
        if ((arrowFunctionReturnExpression = JSPsiImplUtils.tryGetArrowFunctionReturnExpression(parent)) != null) {
            return JSResolveUtil.getExpressionJSType(arrowFunctionReturnExpression);
        }
        JSBlockStatement body2 = parent.getBlock();
        if (body2 == null) {
            return null;
        }
        ObjectOpenCustomHashSet usedTypes = new ObjectOpenCustomHashSet(4, (Hash.Strategy)new Hash.Strategy<JSType>(){

            public int hashCode(@Nullable JSType object) {
                return object == null ? 0 : object.getTypeText(JSType.TypeTextFormat.SIMPLE).hashCode();
            }

            public boolean equals(JSType o1, JSType o2) {
                if (o1 == o2) {
                    return true;
                }
                if (o1 == null || o2 == null) {
                    return false;
                }
                return o1.getTypeText(JSType.TypeTextFormat.SIMPLE).equals(o2.getTypeText(JSType.TypeTextFormat.SIMPLE));
            }
        });
        ArrayList<JSClass> classesList = new ArrayList<JSClass>();
        Ref hasUnresolvedTypes = new Ref();
        Ref hasValuelessReturns = new Ref();
        final boolean isGenerator = parent.isGenerator();
        body2.acceptChildren(new JSRecursiveElementVisitor((Set)usedTypes, parent, classesList, hasUnresolvedTypes, hasValuelessReturns){
            final /* synthetic */ Set val$usedTypes;
            final /* synthetic */ JSFunction val$parent;
            final /* synthetic */ List val$classesList;
            final /* synthetic */ Ref val$hasUnresolvedTypes;
            final /* synthetic */ Ref val$hasValuelessReturns;
            {
                this.val$usedTypes = set;
                this.val$parent = jSFunction;
                this.val$classesList = list2;
                this.val$hasUnresolvedTypes = ref;
                this.val$hasValuelessReturns = ref2;
            }

            @Override
            public void visitJSReturnStatement(@NotNull JSReturnStatement node) {
                if (node == null) {
                    2.$$$reportNull$$$0(0);
                }
                super.visitJSReturnStatement(node);
                if (isGenerator && !forGeneratorReturnOnly) {
                    return;
                }
                this.tryAddTypeFromExpression(node.getExpression());
            }

            private void tryAddTypeFromExpression(@Nullable JSExpression expression) {
                if (expression != null) {
                    JSType jsType = JSResolveUtil.getExpressionJSType(expression);
                    if (jsType instanceof JSLiteralType) {
                        jsType = JSTypeUtils.widenLiteralTypes(jsType);
                    }
                    if (jsType == null) {
                        jsType = JSAnyType.get((PsiElement)expression);
                    }
                    if (!this.val$usedTypes.add(jsType)) {
                        return;
                    }
                    String type2 = jsType.getTypeText();
                    PsiElement psiElement = JSResolveUtil.findType(type2, this.val$parent, true);
                    if (psiElement instanceof JSClass) {
                        this.val$classesList.add((JSClass)psiElement);
                    } else {
                        this.val$hasUnresolvedTypes.set((Object)true);
                    }
                } else {
                    this.val$hasValuelessReturns.set((Object)true);
                }
            }

            @Override
            public void visitJSYieldExpression(@NotNull JSYieldExpression statement) {
                if (statement == null) {
                    2.$$$reportNull$$$0(1);
                }
                super.visitJSYieldExpression(statement);
                if (!isGenerator || forGeneratorReturnOnly) {
                    return;
                }
                this.tryAddTypeFromExpression(statement.getExpression());
            }

            @Override
            public void visitJSFunctionExpression(@NotNull JSFunctionExpression node) {
                if (node == null) {
                    2.$$$reportNull$$$0(2);
                }
            }

            @Override
            public void visitJSFunctionDeclaration(@NotNull JSFunction node) {
                if (node == null) {
                    2.$$$reportNull$$$0(3);
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2;
                Object[] objectArray3 = new Object[3];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "node";
                        break;
                    }
                    case 1: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "statement";
                        break;
                    }
                }
                objectArray2[1] = "com/intellij/lang/javascript/types/TypeFromUsageDetector$2";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[2] = "visitJSReturnStatement";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[2] = "visitJSYieldExpression";
                        break;
                    }
                    case 2: {
                        objectArray = objectArray2;
                        objectArray2[2] = "visitJSFunctionExpression";
                        break;
                    }
                    case 3: {
                        objectArray = objectArray2;
                        objectArray2[2] = "visitJSFunctionDeclaration";
                        break;
                    }
                }
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        });
        if (classesList.isEmpty() && hasUnresolvedTypes.get() == null) {
            if (parent.isGenerator()) {
                return null;
            }
            JSTypeSource source = JSTypeSourceFactory.createTypeSource(parent, false);
            return JSNamedTypeFactory.createVoidType(source);
        }
        if (!classesList.isEmpty() && hasUnresolvedTypes.get() == null && hasValuelessReturns.get() == null) {
            return TypeFromUsageDetector.calcCommonType(classesList);
        }
        if (hasUnresolvedTypes.get() != null && !usedTypes.isEmpty()) {
            JSTypeSource source = JSTypeSourceFactory.createTypeSource(parent, false);
            return JSCompositeTypeFactory.createUnionType(source, new ArrayList(usedTypes));
        }
        return DialectDetector.isActionScript(parent) ? JSAnyType.get(parent) : null;
    }

    @NotNull
    private static JSType calcCommonType(@NotNull List<JSClass> aClasses) {
        JSClass aClass;
        if (aClasses == null) {
            TypeFromUsageDetector.$$$reportNull$$$0(4);
        }
        if (aClasses.size() == 0) {
            JSAnyType jSAnyType = JSAnyType.getSimple();
            if (jSAnyType == null) {
                TypeFromUsageDetector.$$$reportNull$$$0(5);
            }
            return jSAnyType;
        }
        Ref classRef = new Ref((Object)aClasses.get(0));
        HashSet descendantClasses = new HashSet();
        TypeFromUsageDetector.processNontrivialAncestors(aClasses.get(0), (Processor<? super JSClass>)((Processor)jsClass -> {
            descendantClasses.add(jsClass.getQualifiedName());
            return true;
        }), new HashSet());
        for (JSClass clazz : aClasses.subList(1, aClasses.size())) {
            HashSet visitedClasses;
            boolean res;
            if (((JSClass)classRef.get()).equals(clazz) || !(res = TypeFromUsageDetector.processNontrivialAncestors(clazz, (Processor<? super JSClass>)((Processor)jsClass -> {
                String qName = jsClass.getQualifiedName();
                if (descendantClasses.contains(qName)) {
                    classRef.set(jsClass);
                    return false;
                }
                return true;
            }), visitedClasses = new HashSet()))) continue;
            classRef.set(null);
            break;
        }
        String qualifiedName = (aClass = (JSClass)classRef.get()) != null ? aClass.getQualifiedName() : null;
        JSType jSType = qualifiedName == null ? JSAnyType.get(aClasses.get(0)) : JSNamedTypeFactory.createType(qualifiedName, JSTypeSourceFactory.createTypeSource(aClasses.get(0), true), JSTypeContext.INSTANCE);
        if (jSType == null) {
            TypeFromUsageDetector.$$$reportNull$$$0(6);
        }
        return jSType;
    }

    private static boolean processNontrivialAncestors(JSClass aClass, Processor<? super JSClass> processor, Set<? super JSClass> visited) {
        if (!visited.add(aClass)) {
            return false;
        }
        if (!processor.process((Object)aClass)) {
            return false;
        }
        for (JSClass superClazz : aClass.getSupers()) {
            if ("Object".equals(superClazz.getQualifiedName())) break;
            if (!processor.process((Object)superClazz)) {
                return false;
            }
            if (TypeFromUsageDetector.processNontrivialAncestors(superClazz, processor, visited)) continue;
            return false;
        }
        for (JSClass superClazz : aClass.getImplementedInterfaces()) {
            if ("Object".equals(superClazz.getQualifiedName())) break;
            visited.add(superClazz);
            if (!processor.process((Object)superClazz)) {
                return false;
            }
            if (TypeFromUsageDetector.processNontrivialAncestors(superClazz, processor, visited)) continue;
            return false;
        }
        return true;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 5, 6 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parent";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "function";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "functionType";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "aClasses";
                break;
            }
            case 5: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/javascript/types/TypeFromUsageDetector";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/javascript/types/TypeFromUsageDetector";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "calcCommonType";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "detectTypeFromUsage";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "getReturnTypeInContext";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "isValidGeneratorReturn";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "getFunctionType";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "calcCommonType";
                break;
            }
            case 5: 
            case 6: {
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 5, 6 -> new IllegalStateException(string);
        };
    }
}

