/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.service.protocol;

import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.google.gson.JsonPrimitive;
import com.intellij.execution.ExecutionException;
import com.intellij.execution.process.KillableProcessHandler;
import com.intellij.execution.process.ProcessAdapter;
import com.intellij.execution.process.ProcessEvent;
import com.intellij.execution.process.ProcessHandler;
import com.intellij.execution.process.ProcessListener;
import com.intellij.execution.process.ProcessOutputTypes;
import com.intellij.execution.target.TargetedCommandLineBuilder;
import com.intellij.javascript.nodejs.execution.NodeTargetRun;
import com.intellij.javascript.nodejs.execution.NodeTargetRunOptions;
import com.intellij.javascript.nodejs.execution.ProcessWithCmdLine;
import com.intellij.javascript.nodejs.interpreter.NodeCommandLineConfigurator;
import com.intellij.javascript.nodejs.interpreter.NodeInterpreterNotificationService;
import com.intellij.javascript.nodejs.interpreter.NodeJsInterpreter;
import com.intellij.javascript.nodejs.interpreter.NodeJsInterpreterManager;
import com.intellij.lang.javascript.JavaScriptBundle;
import com.intellij.lang.javascript.service.JSLanguageServiceQueue;
import com.intellij.lang.javascript.service.JSLanguageServiceUtil;
import com.intellij.lang.javascript.service.JSNodeServicesProfilerActionKt;
import com.intellij.lang.javascript.service.protocol.JSLanguageServiceAnswer;
import com.intellij.lang.javascript.service.protocol.JSLanguageServiceAnswerConsumer;
import com.intellij.lang.javascript.service.protocol.JSLanguageServiceCommand;
import com.intellij.lang.javascript.service.protocol.JSLanguageServiceInitialState;
import com.intellij.lang.javascript.service.protocol.JSLanguageServiceObject;
import com.intellij.lang.javascript.service.protocol.JSLanguageServiceProtocol;
import com.intellij.lang.javascript.service.protocol.JSLanguageServiceRemoteHelper;
import com.intellij.lang.javascript.service.protocol.JSLanguageServiceRequest;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.Consumer;
import com.intellij.util.ThrowableRunnable;
import com.intellij.util.io.BaseDataReader;
import com.intellij.util.io.BaseOutputReader;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.CharBuffer;
import java.nio.charset.StandardCharsets;
import java.util.Collection;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class JSLanguageServiceNodeStdProtocolBase
implements JSLanguageServiceProtocol {
    protected static final String ANSWER_READY = "ready";
    protected static final String ANSWER_ERROR = "error";
    private static final byte[] NEW_LINE = "\n".getBytes(StandardCharsets.UTF_8);
    public static final BaseOutputReader.Options PROCESS_READER_OPTIONS = new BaseOutputReader.Options(){

        public BaseDataReader.SleepingPolicy policy() {
            return BaseOutputReader.Options.BLOCKING.policy();
        }

        public boolean splitToLines() {
            return BaseOutputReader.Options.BLOCKING.splitToLines();
        }

        public boolean sendIncompleteLines() {
            return false;
        }
    };
    @Nullable
    public final String myServiceName;
    @NotNull
    protected final Project myProject;
    @Nullable
    @Nls
    private volatile String myInitializeError;
    protected final long mySessionId;
    @NotNull
    private final java.util.function.Consumer<JsonObject> myInitialStateConsumer;
    private final AtomicInteger mySeq;
    @Nullable
    private OutputStream myProcessInput;
    protected final ConcurrentMap<Integer, JSLanguageServiceAnswerConsumer> myCallbacks;
    @NotNull
    private Gson myGson;
    @Nullable
    protected volatile JSLanguageServiceRemoteHelper myRemoteHelper;

    public JSLanguageServiceNodeStdProtocolBase(@NotNull Project project, @NotNull Consumer<?> readyConsumer) {
        if (project == null) {
            JSLanguageServiceNodeStdProtocolBase.$$$reportNull$$$0(0);
        }
        if (readyConsumer == null) {
            JSLanguageServiceNodeStdProtocolBase.$$$reportNull$$$0(1);
        }
        this(null, project, arg_0 -> readyConsumer.consume(arg_0));
    }

    public JSLanguageServiceNodeStdProtocolBase(@Nullable String serviceName, @NotNull Project project, @NotNull java.util.function.Consumer<?> readyConsumer) {
        if (project == null) {
            JSLanguageServiceNodeStdProtocolBase.$$$reportNull$$$0(2);
        }
        if (readyConsumer == null) {
            JSLanguageServiceNodeStdProtocolBase.$$$reportNull$$$0(3);
        }
        this.mySessionId = System.currentTimeMillis();
        this.mySeq = new AtomicInteger();
        this.myCallbacks = new ConcurrentHashMap<Integer, JSLanguageServiceAnswerConsumer>();
        this.myGson = JSLanguageServiceQueue.SharedGson.GSON;
        this.myServiceName = serviceName;
        this.myProject = project;
        this.myInitialStateConsumer = readyConsumer;
    }

    @Override
    @Nullable
    public final String getInitializeError() {
        return this.myInitializeError;
    }

    protected boolean waitingReadyNotification(@NotNull ProcessHandler processHandler, @NotNull ThrowableRunnable<Exception> action, final @NotNull ReadyChecker checker) throws Exception {
        if (processHandler == null) {
            JSLanguageServiceNodeStdProtocolBase.$$$reportNull$$$0(4);
        }
        if (action == null) {
            JSLanguageServiceNodeStdProtocolBase.$$$reportNull$$$0(5);
        }
        if (checker == null) {
            JSLanguageServiceNodeStdProtocolBase.$$$reportNull$$$0(6);
        }
        final CountDownLatch countDownLatch = new CountDownLatch(1);
        final Ref result2 = new Ref((Object)false);
        ProcessAdapter listener2 = new ProcessAdapter(){

            public void onTextAvailable(@NotNull ProcessEvent event, @NotNull Key outputType) {
                if (event == null) {
                    2.$$$reportNull$$$0(0);
                }
                if (outputType == null) {
                    2.$$$reportNull$$$0(1);
                }
                checker.check(event, outputType, (Ref<Boolean>)result2, countDownLatch);
            }

            public void processTerminated(@NotNull ProcessEvent event) {
                if (event == null) {
                    2.$$$reportNull$$$0(2);
                }
                countDownLatch.countDown();
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2;
                Object[] objectArray3 = new Object[3];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "event";
                        break;
                    }
                    case 1: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "outputType";
                        break;
                    }
                }
                objectArray2[1] = "com/intellij/lang/javascript/service/protocol/JSLanguageServiceNodeStdProtocolBase$2";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[2] = "onTextAvailable";
                        break;
                    }
                    case 2: {
                        objectArray = objectArray2;
                        objectArray2[2] = "processTerminated";
                        break;
                    }
                }
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        };
        processHandler.addProcessListener((ProcessListener)listener2);
        action.run();
        JSLanguageServiceQueue.Holder.LOGGER.debug("Start waiting for ready start");
        if (JSLanguageServiceUtil.TIMEOUT_DISABLED) {
            countDownLatch.await();
        } else {
            countDownLatch.await(100L, TimeUnit.SECONDS);
        }
        JSLanguageServiceQueue.Holder.LOGGER.debug("End waiting for process starting. Result " + result2.get());
        processHandler.removeProcessListener((ProcessListener)listener2);
        return (Boolean)result2.get();
    }

    @NotNull
    private NodeTargetRun createTargetRun() throws ExecutionException {
        NodeJsInterpreter interpreter = this.getInterpreterOrFail();
        NodeTargetRun targetRun = new NodeTargetRun(interpreter, this.myProject, null, NodeTargetRunOptions.of(false, null, builder2 -> builder2.setProcessReaderOptions(PROCESS_READER_OPTIONS)));
        this.myGson = JSLanguageServiceUtil.createGson(targetRun);
        this.prepareTargetRun(targetRun);
        NodeTargetRun nodeTargetRun = targetRun;
        if (nodeTargetRun == null) {
            JSLanguageServiceNodeStdProtocolBase.$$$reportNull$$$0(7);
        }
        return nodeTargetRun;
    }

    protected void prepareTargetRun(@NotNull NodeTargetRun targetRun) {
        if (targetRun == null) {
            JSLanguageServiceNodeStdProtocolBase.$$$reportNull$$$0(8);
        }
        TargetedCommandLineBuilder commandLineBuilder = targetRun.getCommandLineBuilder();
        this.addNodeProcessAdditionalArguments(targetRun);
        File file = new File(this.getEntryPointFolder(), JSLanguageServiceNodeStdProtocolBase.getEntryPointFile());
        if (!file.exists()) {
            throw new RuntimeException("Cannot find resource start point: " + file.getAbsolutePath());
        }
        commandLineBuilder.setWorkingDirectory(targetRun.path(this.getWorkingDirectory()));
        if (JSNodeServicesProfilerActionKt.isNodeServicesProfilerEnabled(this.myProject)) {
            commandLineBuilder.addParameter("--prof");
        }
        commandLineBuilder.addParameter(targetRun.path(file.getAbsolutePath()));
        commandLineBuilder.addParameter(this.getSessionIdParam());
        if (this.myServiceName != null) {
            commandLineBuilder.addParameter("-debug-name=" + this.myServiceName);
        }
    }

    @NotNull
    protected NodeCommandLineConfigurator.Options getNodeCommandLineConfiguratorOptions(@NotNull Project project) {
        if (project == null) {
            JSLanguageServiceNodeStdProtocolBase.$$$reportNull$$$0(9);
        }
        NodeCommandLineConfigurator.Options options = NodeCommandLineConfigurator.emptyOptions(this.myProject);
        if (options == null) {
            JSLanguageServiceNodeStdProtocolBase.$$$reportNull$$$0(10);
        }
        return options;
    }

    protected String getWorkingDirectory() {
        return this.myProject.getBasePath();
    }

    @Nullable
    protected NodeJsInterpreter getInterpreter() {
        return NodeJsInterpreterManager.getInstance(this.myProject).getInterpreter();
    }

    @NotNull
    protected final NodeJsInterpreter getInterpreterOrFail() {
        NodeJsInterpreter interpreter = this.getInterpreter();
        if (interpreter == null) {
            NodeInterpreterNotificationService.getInstance(this.myProject).showNotificationForUnresolvedProjectInterpreter();
            this.myInitializeError = JavaScriptBundle.message("javascript.service.node.error", new Object[0]);
            throw new RuntimeException(this.myInitializeError);
        }
        NodeJsInterpreter nodeJsInterpreter = interpreter;
        if (nodeJsInterpreter == null) {
            JSLanguageServiceNodeStdProtocolBase.$$$reportNull$$$0(11);
        }
        return nodeJsInterpreter;
    }

    protected void addNodeProcessAdditionalArguments(@NotNull NodeTargetRun targetRun) {
        if (targetRun == null) {
            JSLanguageServiceNodeStdProtocolBase.$$$reportNull$$$0(12);
        }
        if (this.myServiceName != null) {
            String systemProp = System.getProperty("idea.javascript.language.service.debug.options." + this.myServiceName);
            JSLanguageServiceUtil.addNodeProcessArguments(targetRun.getCommandLineBuilder(), this.myServiceName, systemProp);
        }
    }

    @NotNull
    public static String getEntryPointFile() {
        return "js-language-service.js";
    }

    protected final String getSessionIdParam() {
        return "-id=" + this.mySessionId;
    }

    protected File getEntryPointFolder() {
        return JSLanguageServiceUtil.getPluginStarterDirectory();
    }

    @Override
    public void cancelCommand(@Nullable Object cancellationToken) {
        if (cancellationToken == null) {
            return;
        }
        if (cancellationToken instanceof Collection) {
            ((Collection)cancellationToken).forEach(el -> this.myCallbacks.remove(el));
        } else {
            this.myCallbacks.remove(cancellationToken);
        }
    }

    @NotNull
    protected final String toSystemCommand(String command) {
        String string = this.mySessionId + " " + command;
        if (string == null) {
            JSLanguageServiceNodeStdProtocolBase.$$$reportNull$$$0(13);
        }
        return string;
    }

    @Override
    @NotNull
    public ProcessHandler connect() throws Exception {
        NodeTargetRun targetRun = this.createTargetRun();
        ProcessWithCmdLine processWithCmdLine = targetRun.startProcessEx();
        KillableProcessHandler processHandler = processWithCmdLine.getProcessHandler();
        if (JSLanguageServiceQueue.Holder.LOGGER.isDebugEnabled()) {
            JSLanguageServiceQueue.Holder.LOGGER.debug("Command line: " + processWithCmdLine.getCommandLinePresentation());
        }
        JSLanguageServiceQueue.Holder.LOGGER.debug("Language service was started. Start initialization of the plugin");
        KillableProcessHandler killableProcessHandler = processHandler;
        if (killableProcessHandler == null) {
            JSLanguageServiceNodeStdProtocolBase.$$$reportNull$$$0(14);
        }
        return killableProcessHandler;
    }

    @Override
    public boolean awaitReadyNotification(@NotNull ProcessHandler processHandler) throws Exception {
        if (processHandler == null) {
            JSLanguageServiceNodeStdProtocolBase.$$$reportNull$$$0(15);
        }
        this.myProcessInput = processHandler.getProcessInput();
        try {
            if (!this.waitingReadyNotification(processHandler, (ThrowableRunnable<Exception>)((ThrowableRunnable)() -> ((ProcessHandler)processHandler).startNotify()), this::checkReadyCommand)) {
                processHandler.destroyProcess();
                return false;
            }
            if (!this.waitingReadyNotification(processHandler, (ThrowableRunnable<Exception>)((ThrowableRunnable)this::sendInitialState), (event, outputType, result2, countDownLatch) -> {
                block6: {
                    if (outputType == ProcessOutputTypes.STDOUT && !StringUtil.isEmpty((String)event.getText())) {
                        String text2 = StringUtil.trim((String)event.getText());
                        if (text2.startsWith("{") && text2.endsWith("}")) {
                            JsonElement answer = JsonParser.parseString((String)text2);
                            JsonObject answerAsJsonObject = answer.getAsJsonObject();
                            try {
                                JsonPrimitive success = answerAsJsonObject.getAsJsonPrimitive("success");
                                JsonPrimitive error = answerAsJsonObject.getAsJsonPrimitive(ANSWER_ERROR);
                                if (success.getAsBoolean()) {
                                    result2.set((Object)true);
                                    countDownLatch.countDown();
                                    this.myInitialStateConsumer.accept(answerAsJsonObject);
                                    break block6;
                                }
                                String errorText = StringUtil.notNullize((String)error.getAsString());
                                JsonPrimitive stack = answerAsJsonObject.getAsJsonPrimitive("stack");
                                @NlsSafe String errorWithStack = errorText + "\n" + (stack == null ? "" : stack.getAsString());
                                JSLanguageServiceQueue.Holder.LOGGER.debug(this.getClass().getName() + " Error initializing " + errorWithStack);
                                this.myInitializeError = errorWithStack;
                                countDownLatch.countDown();
                            }
                            catch (Exception e) {
                                JSLanguageServiceQueue.Holder.LOGGER.debug(this.getClass().getName() + " Error initializing " + e.getMessage() + "\nCannot parse " + text2);
                                this.myInitializeError = JavaScriptBundle.message("cannot.parse.service.initialization.answer.0", text2);
                            }
                        } else {
                            JSLanguageServiceQueue.Holder.LOGGER.warn(this.getClass().getName() + " Expected json answer: " + event.getText());
                        }
                    }
                }
            })) {
                processHandler.destroyProcess();
                return false;
            }
        }
        catch (Exception e) {
            processHandler.destroyProcess();
            throw e;
        }
        processHandler.addProcessListener((ProcessListener)new ProcessAdapter(){

            public void onTextAvailable(@NotNull ProcessEvent event, @NotNull Key outputType) {
                String text2;
                if (event == null) {
                    3.$$$reportNull$$$0(0);
                }
                if (outputType == null) {
                    3.$$$reportNull$$$0(1);
                }
                if (outputType == ProcessOutputTypes.STDOUT && !StringUtil.isEmpty((String)(text2 = event.getText()))) {
                    JSLanguageServiceNodeStdProtocolBase.this.processText(JSLanguageServiceNodeStdProtocolBase.trimToCharSequence(text2));
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[3];
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[0] = "event";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[0] = "outputType";
                        break;
                    }
                }
                objectArray[1] = "com/intellij/lang/javascript/service/protocol/JSLanguageServiceNodeStdProtocolBase$3";
                objectArray[2] = "onTextAvailable";
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        });
        return true;
    }

    private static CharSequence trimToCharSequence(@NotNull String text2) {
        int bound;
        int pos;
        if (text2 == null) {
            JSLanguageServiceNodeStdProtocolBase.$$$reportNull$$$0(16);
        }
        for (pos = 0; pos < text2.length() && text2.charAt(pos) <= ' '; ++pos) {
        }
        for (bound = text2.length(); bound > pos && text2.charAt(bound - 1) <= ' '; --bound) {
        }
        return CharBuffer.wrap(text2, pos, bound);
    }

    private void processText(CharSequence text2) {
        if (text2.length() >= 2 && text2.charAt(0) == '{' && text2.charAt(text2.length() - 1) == '}') {
            JSLanguageServiceAnswer answer = null;
            try {
                answer = new JSLanguageServiceAnswer(text2);
            }
            catch (Exception e) {
                JSLanguageServiceQueue.Holder.LOGGER.error("Cannot parse answer for protocol: " + this.getClass().getName() + ", text:\n " + JSLanguageServiceNodeStdProtocolBase.truncateText(text2), (Throwable)e);
            }
            if (answer == null) {
                return;
            }
            this.processAnswer(answer, text2);
        }
    }

    protected void processAnswer(@NotNull JSLanguageServiceAnswer answer, @NotNull CharSequence text2) {
        Integer seq;
        if (answer == null) {
            JSLanguageServiceNodeStdProtocolBase.$$$reportNull$$$0(17);
        }
        if (text2 == null) {
            JSLanguageServiceNodeStdProtocolBase.$$$reportNull$$$0(18);
        }
        if ((seq = answer.getSeq()) != null) {
            JSLanguageServiceAnswerConsumer consumer = (JSLanguageServiceAnswerConsumer)this.myCallbacks.remove(seq);
            if (consumer != null) {
                if (JSLanguageServiceQueue.Holder.LOGGER.isDebugEnabled()) {
                    JSLanguageServiceQueue.Holder.LOGGER.debug(this.getClass().getSimpleName() + " Pass request " + seq + " to consumer");
                }
                consumer.consume(answer);
            } else if (JSLanguageServiceQueue.Holder.LOGGER.isDebugEnabled()) {
                JSLanguageServiceQueue.Holder.LOGGER.debug(this.getClass().getSimpleName() + " No callback for seq: " + text2);
            }
        } else if (JSLanguageServiceQueue.Holder.LOGGER.isDebugEnabled()) {
            JSLanguageServiceQueue.Holder.LOGGER.debug(this.getClass().getSimpleName() + " No sequence number, skip request: " + text2);
        }
    }

    private void sendInitialState() throws Exception {
        JSLanguageServiceInitialState initialState = this.needReadActionToCreateState() ? (JSLanguageServiceInitialState)ReadAction.compute(() -> this.createState()) : this.createState();
        String state = this.myGson.toJson((Object)initialState);
        JSLanguageServiceQueue.Holder.LOGGER.debug(this.getClass().getName() + " Send state to service: " + state);
        this.writeln(state);
    }

    protected boolean needReadActionToCreateState() {
        return true;
    }

    protected abstract JSLanguageServiceInitialState createState();

    @Override
    @NotNull
    public Object sendCommand(@NotNull JSLanguageServiceCommand command, @NotNull JSLanguageServiceObject data, @Nullable JSLanguageServiceAnswerConsumer resultConsumer) throws Exception {
        if (command == null) {
            JSLanguageServiceNodeStdProtocolBase.$$$reportNull$$$0(19);
        }
        if (data == null) {
            JSLanguageServiceNodeStdProtocolBase.$$$reportNull$$$0(20);
        }
        int value = this.getUniqueCommandId();
        if (resultConsumer != null) {
            this.myCallbacks.put(value, resultConsumer);
        }
        String request2 = this.getWritableString(command, data, value);
        this.writeln(request2);
        Integer n = value;
        if (n == null) {
            JSLanguageServiceNodeStdProtocolBase.$$$reportNull$$$0(21);
        }
        return n;
    }

    @NotNull
    protected String getWritableString(@NotNull JSLanguageServiceCommand command, @NotNull JSLanguageServiceObject data, int value) {
        if (command == null) {
            JSLanguageServiceNodeStdProtocolBase.$$$reportNull$$$0(22);
        }
        if (data == null) {
            JSLanguageServiceNodeStdProtocolBase.$$$reportNull$$$0(23);
        }
        JSLanguageServiceRequest toSend = new JSLanguageServiceRequest(command, data, this.mySessionId, value);
        String request2 = this.myGson.toJson((Object)toSend);
        if (JSLanguageServiceQueue.Holder.LOGGER.isTraceEnabled()) {
            CharSequence toPrint = JSLanguageServiceNodeStdProtocolBase.truncateText(request2);
            JSLanguageServiceQueue.Holder.LOGGER.trace(this.getClass().getSimpleName() + " Request: " + toPrint);
        }
        if (JSLanguageServiceQueue.Holder.LOGGER.isDebugEnabled()) {
            JSLanguageServiceQueue.Holder.LOGGER.debug(this.getClass().getSimpleName() + " Request command: " + command.getCommand());
        }
        String string = request2;
        if (string == null) {
            JSLanguageServiceNodeStdProtocolBase.$$$reportNull$$$0(24);
        }
        return string;
    }

    @NotNull
    private static CharSequence truncateText(CharSequence request2) {
        Object toPrint = request2;
        if (Registry.is((String)"JavaScript.Language.Service.truncate.traced.messages", (boolean)true) && request2.length() > 1000) {
            toPrint = CharBuffer.wrap(request2, 0, 200) + "\n ................................(truncated)";
        }
        CharSequence charSequence = toPrint;
        if (charSequence == null) {
            JSLanguageServiceNodeStdProtocolBase.$$$reportNull$$$0(25);
        }
        return charSequence;
    }

    protected int getUniqueCommandId() {
        return this.mySeq.getAndIncrement();
    }

    protected final void checkReadyCommand(ProcessEvent event, Key outputType, Ref<? super Boolean> result2, CountDownLatch countDownLatch) {
        if (outputType == ProcessOutputTypes.STDOUT && !StringUtil.isEmpty((String)event.getText())) {
            String prefix;
            JSLanguageServiceQueue.Holder.LOGGER.debug("Starting language service output: " + event.getText());
            String text2 = event.getText().trim();
            if (this.toSystemCommand(ANSWER_READY).equals(text2)) {
                result2.set((Object)true);
                countDownLatch.countDown();
            }
            if (text2.startsWith(prefix = this.toSystemCommand(ANSWER_ERROR))) {
                JSLanguageServiceQueue.Holder.LOGGER.debug("Error initialization " + text2.substring(prefix.length()));
                this.myInitializeError = text2.substring(prefix.length());
                countDownLatch.countDown();
            }
        } else if (outputType == ProcessOutputTypes.STDERR) {
            JSLanguageServiceQueue.Holder.LOGGER.debug("Starting language service output error: " + event.getText());
        }
    }

    protected void writeln(@NotNull String data) throws IOException {
        if (data == null) {
            JSLanguageServiceNodeStdProtocolBase.$$$reportNull$$$0(26);
        }
        if (this.myProcessInput != null) {
            this.myProcessInput.write(data.getBytes(StandardCharsets.UTF_8));
            this.myProcessInput.write(NEW_LINE);
            this.myProcessInput.flush();
        }
    }

    @NotNull
    public Gson getGson() {
        Gson gson = this.myGson;
        if (gson == null) {
            JSLanguageServiceNodeStdProtocolBase.$$$reportNull$$$0(27);
        }
        return gson;
    }

    @Nullable
    protected String getFilePath(@NotNull VirtualFile file) {
        if (file == null) {
            JSLanguageServiceNodeStdProtocolBase.$$$reportNull$$$0(28);
        }
        if (this.myRemoteHelper != null) {
            return this.myRemoteHelper.getFilePath(file);
        }
        String canonicalPath = file.getCanonicalPath();
        return canonicalPath != null ? FileUtil.toSystemDependentName((String)canonicalPath) : null;
    }

    @NotNull
    protected String getFilePath(@NotNull String path2) {
        if (path2 == null) {
            JSLanguageServiceNodeStdProtocolBase.$$$reportNull$$$0(29);
        }
        String string = this.myRemoteHelper != null ? this.myRemoteHelper.getFilePath(path2) : path2;
        if (string == null) {
            JSLanguageServiceNodeStdProtocolBase.$$$reportNull$$$0(30);
        }
        return string;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 7, 10, 11, 13, 14, 21, 24, 25, 27, 30 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "readyConsumer";
                break;
            }
            case 4: 
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "processHandler";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "action";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "checker";
                break;
            }
            case 7: 
            case 10: 
            case 11: 
            case 13: 
            case 14: 
            case 21: 
            case 24: 
            case 25: 
            case 27: 
            case 30: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/javascript/service/protocol/JSLanguageServiceNodeStdProtocolBase";
                break;
            }
            case 8: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "targetRun";
                break;
            }
            case 16: 
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "text";
                break;
            }
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "answer";
                break;
            }
            case 19: 
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "command";
                break;
            }
            case 20: 
            case 23: 
            case 26: {
                objectArray2 = objectArray3;
                objectArray3[0] = "data";
                break;
            }
            case 28: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 29: {
                objectArray2 = objectArray3;
                objectArray3[0] = "path";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/javascript/service/protocol/JSLanguageServiceNodeStdProtocolBase";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "createTargetRun";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "getNodeCommandLineConfiguratorOptions";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "getInterpreterOrFail";
                break;
            }
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "toSystemCommand";
                break;
            }
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "connect";
                break;
            }
            case 21: {
                objectArray = objectArray2;
                objectArray2[1] = "sendCommand";
                break;
            }
            case 24: {
                objectArray = objectArray2;
                objectArray2[1] = "getWritableString";
                break;
            }
            case 25: {
                objectArray = objectArray2;
                objectArray2[1] = "truncateText";
                break;
            }
            case 27: {
                objectArray = objectArray2;
                objectArray2[1] = "getGson";
                break;
            }
            case 30: {
                objectArray = objectArray2;
                objectArray2[1] = "getFilePath";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 4: 
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "waitingReadyNotification";
                break;
            }
            case 7: 
            case 10: 
            case 11: 
            case 13: 
            case 14: 
            case 21: 
            case 24: 
            case 25: 
            case 27: 
            case 30: {
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "prepareTargetRun";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "getNodeCommandLineConfiguratorOptions";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "addNodeProcessAdditionalArguments";
                break;
            }
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "awaitReadyNotification";
                break;
            }
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "trimToCharSequence";
                break;
            }
            case 17: 
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "processAnswer";
                break;
            }
            case 19: 
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "sendCommand";
                break;
            }
            case 22: 
            case 23: {
                objectArray = objectArray;
                objectArray[2] = "getWritableString";
                break;
            }
            case 26: {
                objectArray = objectArray;
                objectArray[2] = "writeln";
                break;
            }
            case 28: 
            case 29: {
                objectArray = objectArray;
                objectArray[2] = "getFilePath";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 7, 10, 11, 13, 14, 21, 24, 25, 27, 30 -> new IllegalStateException(string);
        };
    }

    protected static interface ReadyChecker {
        public void check(@NotNull ProcessEvent var1, @NotNull Key var2, @NotNull Ref<Boolean> var3, @NotNull CountDownLatch var4);
    }
}

