/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.service.highlighting;

import com.intellij.codeHighlighting.TextEditorHighlightingPass;
import com.intellij.codeHighlighting.TextEditorHighlightingPassFactory;
import com.intellij.codeHighlighting.TextEditorHighlightingPassRegistrar;
import com.intellij.lang.javascript.psi.JSFile;
import com.intellij.lang.javascript.service.JSLanguageService;
import com.intellij.lang.javascript.service.highlighting.JSLanguageServiceHighlightingPass;
import com.intellij.lang.javascript.service.highlighting.JSLanguageServiceHighlightingStateHolder;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.psi.PsiFile;
import com.intellij.psi.xml.XmlFile;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class JSLanguageServiceHighlightingPassFactory
implements Disposable,
TextEditorHighlightingPassFactory {
    private final JSLanguageServiceHighlightingStateHolder mySharedCalcHolder = new JSLanguageServiceHighlightingStateHolder();

    protected JSLanguageServiceHighlightingPassFactory() {
    }

    public static void registerHighlightingPassFactory(@NotNull TextEditorHighlightingPassRegistrar registrar, @NotNull JSLanguageServiceHighlightingPassFactory factory) {
        if (registrar == null) {
            JSLanguageServiceHighlightingPassFactory.$$$reportNull$$$0(0);
        }
        if (factory == null) {
            JSLanguageServiceHighlightingPassFactory.$$$reportNull$$$0(1);
        }
        registrar.registerTextEditorHighlightingPass((TextEditorHighlightingPassFactory)factory, new int[]{4}, null, true, -1);
    }

    @Nullable
    public TextEditorHighlightingPass createHighlightingPass(@NotNull PsiFile file, @NotNull Editor editor) {
        if (file == null) {
            JSLanguageServiceHighlightingPassFactory.$$$reportNull$$$0(2);
        }
        if (editor == null) {
            JSLanguageServiceHighlightingPassFactory.$$$reportNull$$$0(3);
        }
        return this.createHighlightingPass(file, editor.getDocument());
    }

    @Nullable
    public TextEditorHighlightingPass createHighlightingPass(@NotNull PsiFile file, @NotNull Document document2) {
        if (file == null) {
            JSLanguageServiceHighlightingPassFactory.$$$reportNull$$$0(4);
        }
        if (document2 == null) {
            JSLanguageServiceHighlightingPassFactory.$$$reportNull$$$0(5);
        }
        if (!this.isAcceptablePsiFile(file)) {
            return null;
        }
        JSLanguageService service2 = this.getService(file);
        return new JSLanguageServiceHighlightingPass(file.getProject(), service2, file, this.mySharedCalcHolder, document2, this.getServiceName());
    }

    @Nullable
    protected abstract JSLanguageService getService(@NotNull PsiFile var1);

    protected boolean isAcceptablePsiFile(@NotNull PsiFile file) {
        if (file == null) {
            JSLanguageServiceHighlightingPassFactory.$$$reportNull$$$0(6);
        }
        return file instanceof JSFile || file instanceof XmlFile;
    }

    @NotNull
    protected abstract String getServiceName();

    public void dispose() {
        this.mySharedCalcHolder.reset();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "registrar";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "factory";
                break;
            }
            case 2: 
            case 4: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "editor";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "document";
                break;
            }
        }
        objectArray2[1] = "com/intellij/lang/javascript/service/highlighting/JSLanguageServiceHighlightingPassFactory";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "registerHighlightingPassFactory";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[2] = "createHighlightingPass";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[2] = "isAcceptablePsiFile";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

