/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.service;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonParseException;
import com.google.gson.JsonSerializationContext;
import com.google.gson.JsonSerializer;
import com.intellij.codeInspection.util.InspectionMessage;
import com.intellij.execution.ExecutionException;
import com.intellij.execution.target.TargetedCommandLineBuilder;
import com.intellij.ide.nls.NlsMessages;
import com.intellij.javascript.nodejs.execution.NodeTargetRun;
import com.intellij.javascript.nodejs.interpreter.NodeJsInterpreter;
import com.intellij.lang.javascript.JavaScriptBundle;
import com.intellij.lang.javascript.ecmascript6.TypeScriptUtil;
import com.intellij.lang.javascript.integration.JSAnnotationError;
import com.intellij.lang.javascript.integration.JSAnnotationRangeError;
import com.intellij.lang.javascript.linter.LinterLanguageServiceClient;
import com.intellij.lang.javascript.service.JSLanguageServiceBase;
import com.intellij.lang.javascript.service.JSLanguageServiceQueue;
import com.intellij.lang.javascript.service.JSLanguageServiceQueueImpl;
import com.intellij.lang.javascript.service.protocol.JSLanguageServiceNodeStdProtocolBase;
import com.intellij.lang.javascript.service.protocol.LocalFilePath;
import com.intellij.lang.typescript.psi.TypeScriptPsiUtil;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.PluginPathManager;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Computable;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.NlsContexts;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.util.text.StringUtilRt;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileSystem;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.util.ExceptionUtil;
import com.intellij.util.Function;
import com.intellij.util.ObjectUtils;
import java.io.File;
import java.lang.reflect.Type;
import java.nio.file.Path;
import java.util.MissingResourceException;
import java.util.concurrent.CancellationException;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.locks.Lock;
import java.util.function.Supplier;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.TestOnly;
import org.jetbrains.concurrency.Promise;

public final class JSLanguageServiceUtil {
    private static final long DEFAULT_TIMEOUT = TimeUnit.SECONDS.toMillis(20L);
    private static final long DEFAULT_SHORT_TIMEOUT = 200L;
    private static final long DEFAULT_MODERATE_TIMEOUT = 4000L;
    public static final long QUOTA_MILLS = 5L;
    public static final boolean TIMEOUT_DISABLED = StringUtil.isNotEmpty((String)System.getProperty("idea.javascript.language.service.disable.timeout"));
    private static long EXPLICIT_TIMEOUT = -1L;

    private JSLanguageServiceUtil() {
    }

    /*
     * WARNING - void declaration
     */
    @TestOnly
    public static void setTimeout(long explicitTimeout, @NotNull Disposable disposable) {
        void disposable2;
        if (disposable == null) {
            JSLanguageServiceUtil.$$$reportNull$$$0(0);
        }
        long previousTimeout = EXPLICIT_TIMEOUT;
        EXPLICIT_TIMEOUT = explicitTimeout;
        Disposer.register((Disposable)disposable2, () -> {
            EXPLICIT_TIMEOUT = previousTimeout;
        });
    }

    public static long getTimeout() {
        return JSLanguageServiceUtil.getTimeout(DEFAULT_TIMEOUT);
    }

    public static long getShortTimeout() {
        return JSLanguageServiceUtil.getTimeout(200L);
    }

    public static long getModerateTimeout() {
        return JSLanguageServiceUtil.getTimeout(4000L);
    }

    public static long getModerateTimeoutNanos() {
        return TimeUnit.MILLISECONDS.toNanos(JSLanguageServiceUtil.getTimeout(4000L));
    }

    public static long getTimeout(long defaultValue) {
        if (TIMEOUT_DISABLED) {
            return -1L;
        }
        if (EXPLICIT_TIMEOUT >= 0L) {
            return EXPLICIT_TIMEOUT;
        }
        return defaultValue;
    }

    @NlsContexts.DialogMessage
    public static String getTimeoutMessage(@NlsSafe @NotNull String fileName) {
        if (fileName == null) {
            JSLanguageServiceUtil.$$$reportNull$$$0(1);
        }
        long timeout = JSLanguageServiceUtil.getTimeout();
        String formattedTimeout = NlsMessages.formatDurationApproximateNarrow((long)timeout);
        return JavaScriptBundle.message("dialog.message.no.results.for.after", fileName, formattedTimeout);
    }

    @Nullable
    public static <T> T awaitFuture(@Nullable Future<T> future) {
        return JSLanguageServiceUtil.awaitFuture(future, JSLanguageServiceUtil.getTimeout());
    }

    @Nullable
    public static <T> T awaitFuture(@Nullable Future<T> future, long timeoutMillis) {
        return JSLanguageServiceUtil.awaitFuture(future, timeoutMillis, 5L, null);
    }

    @Nullable
    public static <T> T awaitFuture(@Nullable Future<T> future, long timeoutMills, long quotaMills, @Nullable ProgressIndicator indicator) {
        return JSLanguageServiceUtil.awaitFuture(future, timeoutMills, quotaMills, indicator, true, null);
    }

    @Nullable
    public static <T> T awaitFuture(@Nullable Future<T> future, long timeoutMills, long quotaMills, @Nullable ProgressIndicator indicator, boolean cancelFutureIfTimeout, @Nullable Computable<Boolean> cancelCheck) {
        return JSLanguageServiceUtil.awaitFuture(future, timeoutMills, quotaMills, indicator, cancelFutureIfTimeout, cancelCheck, false);
    }

    @Nullable
    public static <T> T awaitFuture(@Nullable Future<T> future, long timeoutMills, long quotaMills, @Nullable ProgressIndicator indicator, boolean cancelFutureIfTimeout, @Nullable Computable<Boolean> cancelCheck, boolean allowEDT) {
        if (future == null) {
            return null;
        }
        if (ApplicationManager.getApplication().isDispatchThread() && !ApplicationManager.getApplication().isHeadlessEnvironment() && !allowEDT) {
            JSLanguageServiceQueue.Holder.LOGGER.error("Await future on EDT may cause a deadlock");
            return null;
        }
        JSLanguageServiceUtil.checkCanceled(indicator);
        try {
            if (future.isDone()) {
                return future.get();
            }
            for (long totalWait = timeoutMills; !(timeoutMills >= 0L && totalWait <= 0L || cancelCheck != null && Boolean.TRUE.equals(cancelCheck.compute())); totalWait -= quotaMills) {
                try {
                    return future.get(quotaMills, TimeUnit.MILLISECONDS);
                }
                catch (TimeoutException timeoutException) {
                }
                catch (InterruptedException | CancellationException e) {
                    return null;
                }
                JSLanguageServiceUtil.checkCanceled(indicator);
            }
            if (future.isDone()) {
                return future.get();
            }
            if (cancelFutureIfTimeout && timeoutMills >= 0L) {
                future.cancel(false);
            }
        }
        catch (ProcessCanceledException e) {
            throw e;
        }
        catch (Exception exception) {
            // empty catch block
        }
        return null;
    }

    public static void checkCanceled(@Nullable ProgressIndicator indicator) {
        if (indicator == null) {
            ProgressManager.checkCanceled();
        } else {
            indicator.checkCanceled();
        }
    }

    @Nullable
    public static <Result> Result awaitLanguageService(@Nullable Future<? extends Result> future, @NotNull LinterLanguageServiceClient languageService, @NotNull VirtualFile file) throws ExecutionException {
        if (languageService == null) {
            JSLanguageServiceUtil.$$$reportNull$$$0(2);
        }
        if (file == null) {
            JSLanguageServiceUtil.$$$reportNull$$$0(3);
        }
        if (future == null) {
            if (JSLanguageServiceUtil.languageServiceHasError(languageService)) {
                throw new ExecutionException(JSLanguageServiceUtil.getLanguageServiceCreationError(languageService));
            }
            return null;
        }
        Result result2 = JSLanguageServiceUtil.awaitFuture(future, JSLanguageServiceUtil.getTimeout(), 5L, null, true, (Computable<Boolean>)((Computable)() -> languageService.getServiceCreationError() != null));
        if (future.isCancelled()) {
            if (JSLanguageServiceUtil.languageServiceHasError(languageService)) {
                throw new ExecutionException(JSLanguageServiceUtil.getLanguageServiceCreationError(languageService));
            }
            throw new ExecutionException(JSLanguageServiceUtil.getTimeoutMessage(StringUtil.notNullize((String)file.getName())));
        }
        if (result2 == null) {
            if (JSLanguageServiceUtil.languageServiceHasError(languageService)) {
                throw new ExecutionException(JSLanguageServiceUtil.getLanguageServiceCreationError(languageService));
            }
            return null;
        }
        return result2;
    }

    private static boolean languageServiceHasError(@NotNull LinterLanguageServiceClient languageService) {
        if (languageService == null) {
            JSLanguageServiceUtil.$$$reportNull$$$0(4);
        }
        return !languageService.isServiceCreated() || languageService.getServiceCreationError() != null;
    }

    @NotNull
    @InspectionMessage
    public static String getLanguageServiceCreationError(@NotNull LinterLanguageServiceClient languageService) {
        if (languageService == null) {
            JSLanguageServiceUtil.$$$reportNull$$$0(5);
        }
        String string = (String)ObjectUtils.coalesce((Object)languageService.getServiceCreationError(), (Object)JavaScriptBundle.message("javascript.language.service.cannot.start", new Object[0]));
        if (string == null) {
            JSLanguageServiceUtil.$$$reportNull$$$0(6);
        }
        return string;
    }

    @Nullable
    public static PsiElementInfo getElementInfo(@Nullable PsiFile file, @NotNull Document document2, @NotNull JSAnnotationError result2) {
        if (document2 == null) {
            JSLanguageServiceUtil.$$$reportNull$$$0(7);
        }
        if (result2 == null) {
            JSLanguageServiceUtil.$$$reportNull$$$0(8);
        }
        int endLine = result2 instanceof JSAnnotationRangeError ? ((JSAnnotationRangeError)result2).getEndLine() : -1;
        int endColumn = result2 instanceof JSAnnotationRangeError ? ((JSAnnotationRangeError)result2).getEndColumn() : -1;
        return JSLanguageServiceUtil.getElementInfo(file, document2, result2.getLine(), result2.getColumn(), endLine, endColumn);
    }

    @Nullable
    public static PsiElementInfo getElementInfo(@Nullable PsiFile file, @NotNull Document document2, int line, int column, int endLine, int endColumn) {
        if (document2 == null) {
            JSLanguageServiceUtil.$$$reportNull$$$0(9);
        }
        try {
            PsiElement element;
            if (line < 0 || line >= document2.getLineCount()) {
                return null;
            }
            int lineStartOffset = document2.getLineStartOffset(line);
            int errorStartOffset = Math.min(lineStartOffset + column, document2.getLineEndOffset(line));
            TextRange range = null;
            if (endLine < 0 && file != null) {
                element = file.findElementAt(errorStartOffset);
                if (element == null && lineStartOffset < errorStartOffset) {
                    element = file.findElementAt(errorStartOffset - 1);
                }
            } else {
                if (endLine < 0 || endLine >= document2.getLineCount()) {
                    return null;
                }
                int errorEndOffset = Math.min(document2.getLineStartOffset(endLine) + endColumn, document2.getLineEndOffset(endLine));
                range = TextRange.create((int)errorStartOffset, (int)errorEndOffset);
                element = file != null ? TypeScriptPsiUtil.getPsiElementByRange(file, range) : null;
            }
            return new PsiElementInfo(element, range);
        }
        catch (ProcessCanceledException e) {
            throw e;
        }
        catch (Exception e) {
            JSLanguageServiceQueue.Holder.LOGGER.error(e.getMessage(), (Throwable)e);
            return null;
        }
    }

    @Nullable
    public static NodeJsInterpreter getInterpreterIfValid(@Nullable NodeJsInterpreter interpreter) {
        return interpreter != null && interpreter.validate(null) == null ? interpreter : null;
    }

    @Nullable
    public static String normalizePathDoNotFollowSymlinks(@Nullable VirtualFile virtualFile) {
        if (virtualFile == null || !virtualFile.isInLocalFileSystem()) {
            return null;
        }
        VirtualFileSystem fileSystem = virtualFile.getFileSystem();
        Path nioPath = fileSystem.getNioPath(virtualFile);
        if (nioPath == null) {
            return null;
        }
        return FileUtil.toSystemDependentName((String)LocalFilePath.asLocalFilePath(nioPath));
    }

    @Nullable
    public static String normalizeNameAndPath(@NotNull VirtualFile file) {
        if (file == null) {
            JSLanguageServiceUtil.$$$reportNull$$$0(10);
        }
        return JSLanguageServiceUtil.normalizePathDoNotFollowSymlinks(file);
    }

    @Contract(value="!null -> !null")
    public static String normalizeNameAndPath(@Nullable String path2) {
        if (null == path2) {
            return null;
        }
        return FileUtil.toSystemDependentName((String)path2);
    }

    @NotNull
    public static CharSequence convertLineSeparatorsToFileOriginal(@NotNull Project project, @NotNull CharSequence fileContent, @NotNull VirtualFile file) {
        String lineSeparator;
        if (project == null) {
            JSLanguageServiceUtil.$$$reportNull$$$0(11);
        }
        if (fileContent == null) {
            JSLanguageServiceUtil.$$$reportNull$$$0(12);
        }
        if (file == null) {
            JSLanguageServiceUtil.$$$reportNull$$$0(13);
        }
        if ((lineSeparator = FileDocumentManager.getInstance().getLineSeparator(file, project)).equals("\n")) {
            CharSequence charSequence = fileContent;
            if (charSequence == null) {
                JSLanguageServiceUtil.$$$reportNull$$$0(14);
            }
            return charSequence;
        }
        CharSequence charSequence = StringUtilRt.convertLineSeparators((CharSequence)fileContent, (String)lineSeparator);
        if (charSequence == null) {
            JSLanguageServiceUtil.$$$reportNull$$$0(15);
        }
        return charSequence;
    }

    @NotNull
    public static File getPluginStarterDirectory() {
        File file = TypeScriptUtil.getTypeScriptCompilerFolderFile();
        if (file == null) {
            JSLanguageServiceUtil.$$$reportNull$$$0(16);
        }
        return file;
    }

    @NotNull
    public static Gson createGson(@NotNull NodeTargetRun targetRun) {
        if (targetRun == null) {
            JSLanguageServiceUtil.$$$reportNull$$$0(17);
        }
        return JSLanguageServiceUtil.createGson((Function<? super String, String>)((Function)localPath -> {
            try {
                Promise<String> targetPathPromise = targetRun.convertLocalPathToTarget((String)localPath);
                return (String)targetPathPromise.blockingGet(1000, TimeUnit.MILLISECONDS);
            }
            catch (Exception e) {
                ExceptionUtil.rethrowUnchecked((Throwable)e);
                throw new RuntimeException(e);
            }
        }), (Function<? super String, String>)((Function)targetPath -> {
            try {
                Promise<String> localPathPromise = targetRun.convertTargetPathToLocal((String)targetPath);
                return (String)localPathPromise.blockingGet(1000, TimeUnit.MILLISECONDS);
            }
            catch (Exception e) {
                ExceptionUtil.rethrowUnchecked((Throwable)e);
                throw new RuntimeException(e);
            }
        }));
    }

    @NotNull
    static Gson createGson(final @NotNull Function<? super String, String> localPathToRemotePathConverter, final @NotNull Function<? super String, String> remotePathToLocalPathConverter) {
        if (localPathToRemotePathConverter == null) {
            JSLanguageServiceUtil.$$$reportNull$$$0(18);
        }
        if (remotePathToLocalPathConverter == null) {
            JSLanguageServiceUtil.$$$reportNull$$$0(19);
        }
        Gson gson = new GsonBuilder().registerTypeAdapter(LocalFilePath.class, (Object)new JsonSerializer<LocalFilePath>(){

            public JsonElement serialize(LocalFilePath src, Type typeOfSrc, JsonSerializationContext context2) {
                if (src == null) {
                    return context2.serialize(null);
                }
                try {
                    String targetPath = (String)localPathToRemotePathConverter.fun((Object)src.getPath());
                    return context2.serialize((Object)targetPath);
                }
                catch (Exception e) {
                    throw new IllegalStateException("Cannot convert local path (" + src.getPath() + ") to remote", e);
                }
            }
        }).registerTypeAdapter(LocalFilePath.class, (Object)new JsonDeserializer<LocalFilePath>(){

            public LocalFilePath deserialize(JsonElement json, Type typeOfT, JsonDeserializationContext context2) throws JsonParseException {
                String targetPath = (String)context2.deserialize(json, String.class);
                if (targetPath == null) {
                    return null;
                }
                try {
                    String localPath = (String)remotePathToLocalPathConverter.fun((Object)targetPath);
                    return LocalFilePath.create(localPath);
                }
                catch (Exception e) {
                    throw new IllegalStateException("Cannot convert remote path (" + targetPath + ") to local", e);
                }
            }
        }).create();
        if (gson == null) {
            JSLanguageServiceUtil.$$$reportNull$$$0(20);
        }
        return gson;
    }

    @NotNull
    public static Gson getGson(@NotNull JSLanguageServiceBase serviceBase) {
        JSLanguageServiceNodeStdProtocolBase protocolBase;
        JSLanguageServiceQueue queue;
        if (serviceBase == null) {
            JSLanguageServiceUtil.$$$reportNull$$$0(21);
        }
        if ((queue = serviceBase.getProcess()) != null && queue instanceof JSLanguageServiceQueueImpl && (protocolBase = (JSLanguageServiceNodeStdProtocolBase)ObjectUtils.tryCast((Object)((JSLanguageServiceQueueImpl)queue).getProtocol(), JSLanguageServiceNodeStdProtocolBase.class)) != null) {
            Gson gson = protocolBase.getGson();
            if (gson == null) {
                JSLanguageServiceUtil.$$$reportNull$$$0(22);
            }
            return gson;
        }
        Gson gson = JSLanguageServiceQueue.SharedGson.GSON;
        if (gson == null) {
            JSLanguageServiceUtil.$$$reportNull$$$0(23);
        }
        return gson;
    }

    public static void addNodePathFromRegistry(@NotNull TargetedCommandLineBuilder commandLineBuilder, @NotNull Supplier<String> getRegistryValue) {
        if (commandLineBuilder == null) {
            JSLanguageServiceUtil.$$$reportNull$$$0(24);
        }
        if (getRegistryValue == null) {
            JSLanguageServiceUtil.$$$reportNull$$$0(25);
        }
        String nodePath = null;
        try {
            nodePath = getRegistryValue.get();
        }
        catch (MissingResourceException e) {
            JSLanguageServiceQueue.Holder.LOGGER.debug(e.getMessage(), (Throwable)e);
        }
        if (!StringUtil.isEmptyOrSpaces((String)nodePath)) {
            commandLineBuilder.addEnvironmentVariable("NODE_PATH", nodePath);
        }
    }

    public static void addNodeProcessArgumentsFromRegistry(@NotNull TargetedCommandLineBuilder commandLineBuilder, @NotNull String serviceName, @NotNull Supplier<String> getRegistryValue) {
        if (commandLineBuilder == null) {
            JSLanguageServiceUtil.$$$reportNull$$$0(26);
        }
        if (serviceName == null) {
            JSLanguageServiceUtil.$$$reportNull$$$0(27);
        }
        if (getRegistryValue == null) {
            JSLanguageServiceUtil.$$$reportNull$$$0(28);
        }
        String value = null;
        try {
            value = getRegistryValue.get();
        }
        catch (MissingResourceException e) {
            JSLanguageServiceQueue.Holder.LOGGER.info(e.getMessage(), (Throwable)e);
        }
        JSLanguageServiceUtil.addNodeProcessArguments(commandLineBuilder, serviceName, value);
    }

    public static File getPluginDirectory(@NotNull Class<?> pluginClass, @NotNull String resourceName) {
        if (pluginClass == null) {
            JSLanguageServiceUtil.$$$reportNull$$$0(29);
        }
        if (resourceName == null) {
            JSLanguageServiceUtil.$$$reportNull$$$0(30);
        }
        return PluginPathManager.getPluginResource(pluginClass, (String)resourceName);
    }

    public static void addNodeProcessArguments(@NotNull TargetedCommandLineBuilder commandLineBuilder, @NotNull String serviceName, @Nullable String value) {
        if (commandLineBuilder == null) {
            JSLanguageServiceUtil.$$$reportNull$$$0(31);
        }
        if (serviceName == null) {
            JSLanguageServiceUtil.$$$reportNull$$$0(32);
        }
        if (!StringUtil.isEmptyOrSpaces((String)value)) {
            commandLineBuilder.addParameters(value.split("\n"));
            JSLanguageServiceQueue.Holder.LOGGER.info(String.format("Language service %s started with arguments '%s'", serviceName, StringUtil.join((String[])new String[]{value, " "})));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static <T> T cancellableSynchronized(Lock lock, Supplier<T> computation) {
        boolean locked = false;
        long startNs = System.nanoTime();
        long timeoutNs = JSLanguageServiceUtil.getModerateTimeoutNanos();
        while (!locked && System.nanoTime() - startNs < timeoutNs) {
            ProgressManager.checkCanceled();
            try {
                locked = lock.tryLock(5L, TimeUnit.MILLISECONDS);
            }
            catch (InterruptedException e) {
                throw new CannotRunSynchronizedComputationException(e);
            }
        }
        if (!locked) {
            throw new CannotRunSynchronizedComputationException();
        }
        try {
            T t = computation.get();
            return t;
        }
        finally {
            lock.unlock();
        }
    }

    public static <T> T nonBlockingReadActionWithTimeout(Supplier<T> computation) {
        if (ApplicationManager.getApplication().isDispatchThread()) {
            return computation.get();
        }
        long startNs = System.nanoTime();
        long timeoutNs = JSLanguageServiceUtil.getModerateTimeoutNanos();
        return (T)ReadAction.nonBlocking(computation::get).expireWhen(() -> System.nanoTime() - startNs > timeoutNs).executeSynchronously();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 6, 14, 15, 16, 20, 22, 23 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "disposable";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fileName";
                break;
            }
            case 2: 
            case 4: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "languageService";
                break;
            }
            case 3: 
            case 10: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 6: 
            case 14: 
            case 15: 
            case 16: 
            case 20: 
            case 22: 
            case 23: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/javascript/service/JSLanguageServiceUtil";
                break;
            }
            case 7: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "document";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "result";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fileContent";
                break;
            }
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "targetRun";
                break;
            }
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "localPathToRemotePathConverter";
                break;
            }
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "remotePathToLocalPathConverter";
                break;
            }
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "serviceBase";
                break;
            }
            case 24: 
            case 26: 
            case 31: {
                objectArray2 = objectArray3;
                objectArray3[0] = "commandLineBuilder";
                break;
            }
            case 25: 
            case 28: {
                objectArray2 = objectArray3;
                objectArray3[0] = "getRegistryValue";
                break;
            }
            case 27: 
            case 32: {
                objectArray2 = objectArray3;
                objectArray3[0] = "serviceName";
                break;
            }
            case 29: {
                objectArray2 = objectArray3;
                objectArray3[0] = "pluginClass";
                break;
            }
            case 30: {
                objectArray2 = objectArray3;
                objectArray3[0] = "resourceName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/javascript/service/JSLanguageServiceUtil";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getLanguageServiceCreationError";
                break;
            }
            case 14: 
            case 15: {
                objectArray = objectArray2;
                objectArray2[1] = "convertLineSeparatorsToFileOriginal";
                break;
            }
            case 16: {
                objectArray = objectArray2;
                objectArray2[1] = "getPluginStarterDirectory";
                break;
            }
            case 20: {
                objectArray = objectArray2;
                objectArray2[1] = "createGson";
                break;
            }
            case 22: 
            case 23: {
                objectArray = objectArray2;
                objectArray2[1] = "getGson";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "setTimeout";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "getTimeoutMessage";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "awaitLanguageService";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "languageServiceHasError";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "getLanguageServiceCreationError";
                break;
            }
            case 6: 
            case 14: 
            case 15: 
            case 16: 
            case 20: 
            case 22: 
            case 23: {
                break;
            }
            case 7: 
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "getElementInfo";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "normalizeNameAndPath";
                break;
            }
            case 11: 
            case 12: 
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "convertLineSeparatorsToFileOriginal";
                break;
            }
            case 17: 
            case 18: 
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "createGson";
                break;
            }
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "getGson";
                break;
            }
            case 24: 
            case 25: {
                objectArray = objectArray;
                objectArray[2] = "addNodePathFromRegistry";
                break;
            }
            case 26: 
            case 27: 
            case 28: {
                objectArray = objectArray;
                objectArray[2] = "addNodeProcessArgumentsFromRegistry";
                break;
            }
            case 29: 
            case 30: {
                objectArray = objectArray;
                objectArray[2] = "getPluginDirectory";
                break;
            }
            case 31: 
            case 32: {
                objectArray = objectArray;
                objectArray[2] = "addNodeProcessArguments";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 6, 14, 15, 16, 20, 22, 23 -> new IllegalStateException(string);
        };
    }

    public static class PsiElementInfo {
        @Nullable
        private final PsiElement myElement;
        @Nullable
        private final TextRange myRange;

        public PsiElementInfo(@Nullable PsiElement element, @Nullable TextRange range) {
            this.myElement = element;
            this.myRange = range;
        }

        @Nullable
        public PsiElement getElement() {
            return this.myElement;
        }

        @Nullable
        public TextRange getRange() {
            return this.myRange;
        }
    }

    public static class CannotRunSynchronizedComputationException
    extends ProcessCanceledException {
        public CannotRunSynchronizedComputationException() {
        }

        public CannotRunSynchronizedComputationException(Throwable cause) {
            super(cause);
        }
    }
}

