/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.service;

import com.intellij.analysis.problemsView.FileProblem;
import com.intellij.analysis.problemsView.Problem;
import com.intellij.analysis.problemsView.ProblemsCollector;
import com.intellij.analysis.problemsView.ProblemsProvider;
import com.intellij.lang.javascript.integration.JSAnnotationError;
import com.intellij.lang.javascript.service.JSAnnotationErrorsFilter;
import com.intellij.lang.javascript.service.JSLanguageServiceFileProblem;
import com.intellij.lang.typescript.compiler.languageService.LanguageServiceInfo;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.CheckedDisposable;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.ConcurrencyUtil;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.ThreadPoolExecutor;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class JSLanguageServiceProjectErrors<AnswerT>
implements Disposable,
ProblemsProvider {
    @NotNull
    private final ThreadPoolExecutor myExecutorService;
    @NotNull
    private final Project myProject;
    @NotNull
    protected final Map<Pair<String, ServiceError>, List<JSAnnotationError>> myErrors;
    protected final Map<Pair<String, ServiceError>, Set<FileProblem>> myNewErrors;
    @NotNull
    protected final List<JSAnnotationError> myGlobalErrors;
    @NotNull
    protected final CheckedDisposable myDisposable;
    @Nullable
    protected String myProjectContext;
    protected volatile boolean myDisposed;
    @NotNull
    private final JSAnnotationErrorsFilter myErrorFilter;

    public JSLanguageServiceProjectErrors(@NotNull Project project, @NotNull JSAnnotationErrorsFilter filter) {
        if (project == null) {
            JSLanguageServiceProjectErrors.$$$reportNull$$$0(0);
        }
        if (filter == null) {
            JSLanguageServiceProjectErrors.$$$reportNull$$$0(1);
        }
        this.myErrors = new HashMap<Pair<String, ServiceError>, List<JSAnnotationError>>();
        this.myNewErrors = new HashMap<Pair<String, ServiceError>, Set<FileProblem>>();
        this.myGlobalErrors = new CopyOnWriteArrayList<JSAnnotationError>();
        this.myDisposed = false;
        this.myProject = project;
        this.myDisposable = Disposer.newCheckedDisposable();
        this.myErrorFilter = filter;
        this.myExecutorService = ConcurrencyUtil.newSingleThreadExecutor((String)"Project errors processing");
    }

    public synchronized void setProjectContext(@Nullable String projectContext, @NotNull List<JSAnnotationError> globalErrors) {
        if (globalErrors == null) {
            JSLanguageServiceProjectErrors.$$$reportNull$$$0(2);
        }
        if (this.myDisposed) {
            return;
        }
        if (!Objects.equals(projectContext, this.myProjectContext)) {
            this.myProjectContext = projectContext;
            this.clear();
            this.cancelAllUpdates();
        }
        if (projectContext != null && !Objects.equals(globalErrors, this.myGlobalErrors)) {
            ArrayList<JSAnnotationError> old = new ArrayList<JSAnnotationError>(this.myGlobalErrors);
            this.myGlobalErrors.clear();
            this.myGlobalErrors.addAll(globalErrors);
            this.reportGlobalErrorsNew(globalErrors, old);
            this.queueUpdate();
        }
    }

    private synchronized void reportGlobalErrorsNew(@NotNull List<JSAnnotationError> newErrors, @NotNull List<JSAnnotationError> old) {
        if (newErrors == null) {
            JSLanguageServiceProjectErrors.$$$reportNull$$$0(3);
        }
        if (old == null) {
            JSLanguageServiceProjectErrors.$$$reportNull$$$0(4);
        }
        ProblemsCollector collector = ProblemsCollector.getInstance((Project)this.myProject);
        Collection<FileProblem> oldProblems = this.convertToFileProblem(old);
        Collection<FileProblem> newProblems = this.convertToFileProblem(newErrors);
        for (FileProblem problem : oldProblems) {
            collector.problemDisappeared((Problem)problem);
        }
        for (FileProblem problem : newProblems) {
            collector.problemAppeared((Problem)problem);
        }
    }

    @NotNull
    public Project getProject() {
        Project project = this.myProject;
        if (project == null) {
            JSLanguageServiceProjectErrors.$$$reportNull$$$0(5);
        }
        return project;
    }

    public void pushSyntaxErrors(@NotNull AnswerT answer, @Nullable LanguageServiceInfo languageServiceInfo) {
        if (answer == null) {
            JSLanguageServiceProjectErrors.$$$reportNull$$$0(6);
        }
        this.handleAnswer(answer, ServiceError.SYNTAX, languageServiceInfo);
    }

    public void pushSemanticErrors(@NotNull AnswerT answer, @Nullable LanguageServiceInfo languageServiceInfo) {
        if (answer == null) {
            JSLanguageServiceProjectErrors.$$$reportNull$$$0(7);
        }
        this.handleAnswer(answer, ServiceError.SEMANTICS, languageServiceInfo);
    }

    private void handleAnswer(@NotNull AnswerT answer, @NotNull ServiceError serviceError, @Nullable LanguageServiceInfo languageServiceInfo) {
        if (answer == null) {
            JSLanguageServiceProjectErrors.$$$reportNull$$$0(8);
        }
        if (serviceError == null) {
            JSLanguageServiceProjectErrors.$$$reportNull$$$0(9);
        }
        this.myExecutorService.execute(() -> {
            if (this.myDisposed) {
                return;
            }
            if (this.convertEventsToAnnotations(answer, serviceError, languageServiceInfo)) {
                this.queueUpdate();
            }
        });
    }

    protected void cancelAllUpdates() {
    }

    protected void queueUpdate() {
    }

    private boolean convertEventsToAnnotations(@NotNull AnswerT answer, @NotNull ServiceError serviceError, @Nullable LanguageServiceInfo languageServiceInfo) {
        if (answer == null) {
            JSLanguageServiceProjectErrors.$$$reportNull$$$0(10);
        }
        if (serviceError == null) {
            JSLanguageServiceProjectErrors.$$$reportNull$$$0(11);
        }
        if (this.myProject.isDisposed() || this.myDisposable.isDisposed()) {
            return false;
        }
        Pair<String, List<JSAnnotationError>> pair = this.getPathAndErrors(answer, languageServiceInfo);
        if (pair == null) {
            return false;
        }
        String path2 = (String)pair.first;
        List newElements = (List)ReadAction.nonBlocking(() -> this.myErrorFilter.process(path2, (List)pair.second)).expireWhen(() -> this.myProject.isDisposed() || this.myDisposable.isDisposed()).executeSynchronously();
        return this.processEventAnnotations(serviceError, path2, newElements);
    }

    private synchronized boolean processEventAnnotations(@NotNull ServiceError serviceError, @NotNull String path2, @NotNull List<JSAnnotationError> newElements) {
        if (serviceError == null) {
            JSLanguageServiceProjectErrors.$$$reportNull$$$0(12);
        }
        if (path2 == null) {
            JSLanguageServiceProjectErrors.$$$reportNull$$$0(13);
        }
        if (newElements == null) {
            JSLanguageServiceProjectErrors.$$$reportNull$$$0(14);
        }
        if (this.myProjectContext == null) {
            return false;
        }
        Pair key2 = new Pair((Object)path2, (Object)serviceError);
        List<JSAnnotationError> oldElements = this.myErrors.get(key2);
        this.handleNewProjectErrors((Pair<String, ServiceError>)key2, newElements);
        if (newElements.isEmpty()) {
            this.myErrors.remove(key2);
            return oldElements != null;
        }
        this.myErrors.put((Pair<String, ServiceError>)key2, newElements);
        return !Objects.equals(newElements, oldElements);
    }

    @Nullable
    protected abstract Pair<String, List<JSAnnotationError>> getPathAndErrors(@NotNull AnswerT var1, @Nullable LanguageServiceInfo var2);

    protected synchronized void handleNewProjectErrors(@NotNull Pair<String, ServiceError> key2, @NotNull List<JSAnnotationError> newElements) {
        if (key2 == null) {
            JSLanguageServiceProjectErrors.$$$reportNull$$$0(15);
        }
        if (newElements == null) {
            JSLanguageServiceProjectErrors.$$$reportNull$$$0(16);
        }
        Set<FileProblem> oldEls = !this.myNewErrors.containsKey(key2) ? Collections.emptySet() : this.myNewErrors.get(key2);
        ProblemsCollector collector = ProblemsCollector.getInstance((Project)this.myProject);
        if (newElements.isEmpty()) {
            if (!oldEls.isEmpty()) {
                oldEls.forEach(el -> collector.problemDisappeared((Problem)el));
                this.myNewErrors.remove(key2);
            }
            return;
        }
        Collection<FileProblem> newEls = this.convertToFileProblem(newElements);
        HashSet<FileProblem> newProblems = new HashSet<FileProblem>(newEls);
        if (!newProblems.equals(oldEls)) {
            this.myNewErrors.put(key2, newProblems);
            for (FileProblem el2 : oldEls) {
                collector.problemDisappeared((Problem)el2);
            }
            for (FileProblem el2 : newEls) {
                collector.problemAppeared((Problem)el2);
            }
        }
    }

    @NotNull
    private Collection<? extends FileProblem> convertToFileProblem(@NotNull List<? extends JSAnnotationError> newElements) {
        if (newElements == null) {
            JSLanguageServiceProjectErrors.$$$reportNull$$$0(17);
        }
        Set set = ContainerUtil.map2SetNotNull(newElements, el -> {
            String pathCandidate = el.getAbsoluteFilePath();
            if (pathCandidate == null) {
                return null;
            }
            VirtualFile path2 = LocalFileSystem.getInstance().findFileByPath(pathCandidate);
            return path2 != null ? new JSLanguageServiceFileProblem(this, (JSAnnotationError)el, path2) : null;
        });
        if (set == null) {
            JSLanguageServiceProjectErrors.$$$reportNull$$$0(18);
        }
        return set;
    }

    private synchronized void clear() {
        this.clearNew();
        this.myGlobalErrors.clear();
        this.myErrors.clear();
    }

    private synchronized void clearNew() {
        if (!this.myProject.isDisposed()) {
            ProblemsCollector collector = ProblemsCollector.getInstance((Project)this.myProject);
            this.myNewErrors.forEach((key2, value) -> value.forEach(el -> collector.problemDisappeared((Problem)el)));
            this.convertToFileProblem(this.myGlobalErrors).forEach(el -> collector.problemDisappeared((Problem)el));
        }
        this.myNewErrors.clear();
    }

    public void dispose() {
        Disposer.dispose((Disposable)this.myDisposable);
        this.clear();
        this.myDisposed = true;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 5, 18 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "filter";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "globalErrors";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "newErrors";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "old";
                break;
            }
            case 5: 
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/javascript/service/JSLanguageServiceProjectErrors";
                break;
            }
            case 6: 
            case 7: 
            case 8: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "answer";
                break;
            }
            case 9: 
            case 11: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "serviceError";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "path";
                break;
            }
            case 14: 
            case 16: 
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "newElements";
                break;
            }
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "key";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/javascript/service/JSLanguageServiceProjectErrors";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getProject";
                break;
            }
            case 18: {
                objectArray = objectArray2;
                objectArray2[1] = "convertToFileProblem";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "setProjectContext";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "reportGlobalErrorsNew";
                break;
            }
            case 5: 
            case 18: {
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "pushSyntaxErrors";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "pushSemanticErrors";
                break;
            }
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "handleAnswer";
                break;
            }
            case 10: 
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "convertEventsToAnnotations";
                break;
            }
            case 12: 
            case 13: 
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "processEventAnnotations";
                break;
            }
            case 15: 
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "handleNewProjectErrors";
                break;
            }
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "convertToFileProblem";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 5, 18 -> new IllegalStateException(string);
        };
    }

    protected static enum ServiceError {
        SYNTAX,
        SEMANTICS,
        GLOBAL;

    }
}

