/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.service;

import com.intellij.codeInspection.util.InspectionMessage;
import com.intellij.execution.process.ProcessAdapter;
import com.intellij.execution.process.ProcessEvent;
import com.intellij.execution.process.ProcessHandler;
import com.intellij.execution.process.ProcessListener;
import com.intellij.execution.process.ProcessOutputTypes;
import com.intellij.execution.process.ScriptRunnerUtil;
import com.intellij.lang.javascript.JavaScriptBundle;
import com.intellij.lang.javascript.service.JSLanguageServiceExecutor;
import com.intellij.lang.javascript.service.JSLanguageServiceQueue;
import com.intellij.lang.javascript.service.JSLanguageServiceStatisticsCollector;
import com.intellij.lang.javascript.service.protocol.JSLanguageServiceCommand;
import com.intellij.lang.javascript.service.protocol.JSLanguageServiceConnector;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.progress.impl.BackgroundableProcessIndicator;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.NlsContexts;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.ConcurrencyUtil;
import com.intellij.util.ObjectUtils;
import com.intellij.util.ui.UIUtil;
import java.io.IOException;
import java.util.concurrent.Callable;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JSLanguageServiceExecutorImpl
implements JSLanguageServiceExecutor {
    @NotNull
    private final CompletableFuture<Void> myInitialized;
    @NotNull
    protected final ExecutorService myExecutorService;
    @NotNull
    protected final JSLanguageServiceQueue.ServiceInfoReporter myReporter;
    @NotNull
    protected final JSLanguageServiceConnector myServiceConnector;
    @NotNull
    private final Project myProject;
    @Nullable
    private final JSLanguageServiceQueue.ProcessConnector myProcessConnector;
    private final AtomicBoolean myDisposed;
    private volatile @InspectionMessage String myStartErrorMessage;
    @NotNull
    protected volatile JSLanguageServiceExecutor.State myState;
    @Nullable
    private ProcessHandler myProcessHandler;

    public JSLanguageServiceExecutorImpl(@NotNull Project project, @NotNull JSLanguageServiceConnector serviceConnector, @Nullable JSLanguageServiceQueue.ProcessConnector connector, @NotNull JSLanguageServiceQueue.ServiceInfoReporter reporter) {
        if (project == null) {
            JSLanguageServiceExecutorImpl.$$$reportNull$$$0(0);
        }
        if (serviceConnector == null) {
            JSLanguageServiceExecutorImpl.$$$reportNull$$$0(1);
        }
        if (reporter == null) {
            JSLanguageServiceExecutorImpl.$$$reportNull$$$0(2);
        }
        this.myInitialized = new CompletableFuture();
        this.myDisposed = new AtomicBoolean(false);
        this.myState = JSLanguageServiceExecutor.State.STARTING;
        this.myReporter = reporter;
        this.myProject = project;
        this.myProcessConnector = connector;
        this.myServiceConnector = serviceConnector;
        this.myExecutorService = ConcurrencyUtil.newSingleThreadExecutor((String)("JS external service " + reporter.getPresentableServiceName()));
        this.myExecutorService.execute(this::startServiceWithProgress);
    }

    @Override
    @NotNull
    public final JSLanguageServiceExecutor.State getState() {
        JSLanguageServiceExecutor.State state = this.myState;
        if (state == null) {
            JSLanguageServiceExecutorImpl.$$$reportNull$$$0(3);
        }
        return state;
    }

    private void startServiceWithProgress() {
        BackgroundableProcessIndicator indicator = this.createIndicator();
        try {
            if (indicator != null) {
                try {
                    ProgressManager.getInstance().runProcess(() -> this.startService(), (ProgressIndicator)indicator);
                }
                catch (ProcessCanceledException e) {
                    this.infoLog("starting has been cancelled");
                }
            } else {
                this.startService();
            }
        }
        catch (Throwable e) {
            JSLanguageServiceQueue.Holder.LOGGER.error(e);
            throw e;
        }
        finally {
            if (indicator != null) {
                this.disposeIndicator(indicator);
            }
        }
    }

    private void startService() {
        try {
            if (this.myState == JSLanguageServiceExecutor.State.DISPOSED) {
                this.debugLog("StartService: already disposed");
                return;
            }
            this.debugLog("Creating OS Handler");
            this.createProcessHandler();
            if (this.myProcessHandler == null) {
                return;
            }
            this.debugLog("OS Handler created successfully");
            this.connectProcessHandler(this.myProcessHandler);
        }
        finally {
            this.myInitialized.complete(null);
        }
        Exception exception = null;
        boolean readyNotificationReceived = false;
        try {
            readyNotificationReceived = this.myServiceConnector.awaitReadyNotification(this.myProcessHandler);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            return;
        }
        catch (Exception e) {
            exception = e;
        }
        if (this.myState == JSLanguageServiceExecutor.State.DISPOSED) {
            this.debugLog("StartService after awaitReadyNotification. Already disposed.");
            return;
        }
        if (exception != null) {
            this.myState = JSLanguageServiceExecutor.State.ERROR_OR_TIMEOUT;
            this.reportUserError(JSLanguageServiceExecutorImpl.getPresentableExceptionMessage(exception));
            this.infoLog("Exception while waiting for ready notification", exception);
            return;
        }
        if (readyNotificationReceived) {
            this.myState = JSLanguageServiceExecutor.State.STARTED;
        } else {
            this.myState = JSLanguageServiceExecutor.State.ERROR_OR_TIMEOUT;
            this.reportUserError((String)ObjectUtils.coalesce((Object)this.myServiceConnector.getInitializeError(), (Object)JavaScriptBundle.message("javascript.language.service.start.timeout", new Object[0])));
            this.infoLog("Timed out waiting for ready notification");
        }
    }

    @Nullable
    private BackgroundableProcessIndicator createIndicator() {
        if (this.myProcessConnector == null) {
            return null;
        }
        String title = JavaScriptBundle.message("javascript.starting.service", this.myReporter.getPresentableServiceName());
        return new BackgroundableProcessIndicator(this.myProject, title, null, "", false);
    }

    private void connectProcessHandler(@NotNull ProcessHandler processHandler) {
        if (processHandler == null) {
            JSLanguageServiceExecutorImpl.$$$reportNull$$$0(4);
        }
        if (this.myProcessConnector != null) {
            this.myProcessConnector.connectToProcessHandler(processHandler);
        }
    }

    private void createProcessHandler() {
        try {
            this.myProcessHandler = this.myServiceConnector.connect();
            if (this.myProcessHandler == null) {
                this.myState = JSLanguageServiceExecutor.State.ERROR_OR_TIMEOUT;
                this.reportUserError((String)ObjectUtils.coalesce((Object)this.myServiceConnector.getInitializeError(), (Object)JavaScriptBundle.message("javascript.language.service.start.timeout", new Object[0])));
                this.infoLog("Error creating process handler");
                return;
            }
            this.myProcessHandler.addProcessListener((ProcessListener)new ProcessAdapter(){

                public void onTextAvailable(@NotNull ProcessEvent event, @NotNull Key outputType) {
                    if (event == null) {
                        1.$$$reportNull$$$0(0);
                    }
                    if (outputType == null) {
                        1.$$$reportNull$$$0(1);
                    }
                    if (outputType == ProcessOutputTypes.STDERR) {
                        if (JSLanguageServiceQueue.Holder.LOGGER.isDebugEnabled()) {
                            JSLanguageServiceQueue.Holder.LOGGER.debug("Stderr output: " + StringUtil.escapeLineBreak((String)event.getText()));
                        }
                        return;
                    }
                    if (outputType == ProcessOutputTypes.STDOUT) {
                        if (JSLanguageServiceQueue.Holder.LOGGER.isTraceEnabled()) {
                            JSLanguageServiceQueue.Holder.LOGGER.trace("Stdout output: " + StringUtil.escapeLineBreak((String)event.getText()));
                        }
                        if (ApplicationManager.getApplication().isUnitTestMode()) {
                            ((JSLanguageServiceStatisticsCollector)ApplicationManager.getApplication().getService(JSLanguageServiceStatisticsCollector.class)).responseReceived(event.getText().length());
                        }
                    }
                }

                public void processTerminated(@NotNull ProcessEvent event) {
                    if (event == null) {
                        1.$$$reportNull$$$0(2);
                    }
                    JSLanguageServiceExecutorImpl.this.processTerminated();
                    if (JSLanguageServiceQueue.Holder.LOGGER.isTraceEnabled()) {
                        JSLanguageServiceQueue.Holder.LOGGER.trace("Process [" + event.getProcessHandler() + "] was killed " + event.getText());
                    }
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    Object[] objectArray;
                    Object[] objectArray2;
                    Object[] objectArray3 = new Object[3];
                    switch (n) {
                        default: {
                            objectArray2 = objectArray3;
                            objectArray3[0] = "event";
                            break;
                        }
                        case 1: {
                            objectArray2 = objectArray3;
                            objectArray3[0] = "outputType";
                            break;
                        }
                    }
                    objectArray2[1] = "com/intellij/lang/javascript/service/JSLanguageServiceExecutorImpl$1";
                    switch (n) {
                        default: {
                            objectArray = objectArray2;
                            objectArray2[2] = "onTextAvailable";
                            break;
                        }
                        case 2: {
                            objectArray = objectArray2;
                            objectArray2[2] = "processTerminated";
                            break;
                        }
                    }
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
                }
            });
        }
        catch (Exception e) {
            this.myState = JSLanguageServiceExecutor.State.ERROR_OR_TIMEOUT;
            this.reportUserError(JSLanguageServiceExecutorImpl.getPresentableExceptionMessage(e));
            JSLanguageServiceQueue.Holder.LOGGER.info("Error while creating OS Handler: " + e.getMessage(), (Throwable)e);
        }
    }

    protected void processTerminated() {
        if (this.myState == JSLanguageServiceExecutor.State.STARTED || this.myState == JSLanguageServiceExecutor.State.STARTING) {
            this.myState = JSLanguageServiceExecutor.State.ERROR_OR_TIMEOUT;
        }
    }

    @InspectionMessage
    private static String getPresentableExceptionMessage(@NotNull Throwable e) {
        if (e == null) {
            JSLanguageServiceExecutorImpl.$$$reportNull$$$0(5);
        }
        return e.getLocalizedMessage() != null ? e.getLocalizedMessage() : e.getMessage();
    }

    private void reportUserError(@InspectionMessage String message) {
        this.myStartErrorMessage = message;
        this.myReporter.startingError(message);
    }

    public final void dispose() {
        if (this.myDisposed.compareAndSet(false, true)) {
            this.doDispose();
        } else {
            this.debugLog("Dispose. already disposed");
        }
    }

    protected void doDispose() {
        if (JSLanguageServiceQueue.Holder.LOGGER.isDebugEnabled()) {
            JSLanguageServiceQueue.Holder.LOGGER.debug(String.format("Disposing service %s with hashCode %s", this.myReporter.getPresentableServiceName(), this.hashCode()), new Throwable());
        }
        this.myInitialized.thenRun(() -> {
            long timeoutMillis = ApplicationManager.getApplication().isDispatchThread() ? 50L : 1000L;
            this.myState = JSLanguageServiceExecutor.State.DISPOSED;
            this.shutdownPool(this.myExecutorService, timeoutMillis);
            if (this.myProcessHandler != null) {
                if (!this.myProcessHandler.isProcessTerminated()) {
                    ScriptRunnerUtil.terminateProcessHandler((ProcessHandler)this.myProcessHandler, (long)10000L, null);
                }
                this.myProcessHandler = null;
                if (this.myProcessConnector != null) {
                    this.myProcessConnector.disconnectFromProcessHandler(false);
                }
            }
        });
    }

    private void shutdownPool(@NotNull ExecutorService pool, long timeout) {
        if (pool == null) {
            JSLanguageServiceExecutorImpl.$$$reportNull$$$0(6);
        }
        pool.shutdownNow();
        try {
            if (!pool.awaitTermination(timeout, TimeUnit.MILLISECONDS)) {
                JSLanguageServiceQueue.Holder.LOGGER.warn(String.format("%s: Pool did not terminate in %s milliseconds", this.myReporter.getPresentableServiceName(), timeout));
            } else {
                this.debugLog("Pool terminated");
            }
        }
        catch (InterruptedException ie) {
            pool.shutdownNow();
            Thread.currentThread().interrupt();
        }
    }

    protected void startAction(@NotNull JSLanguageServiceCommand command) {
        if (command == null) {
            JSLanguageServiceExecutorImpl.$$$reportNull$$$0(7);
        }
        this.startAction(command.getPresentableText(this.myProject));
    }

    protected void startAction(@NlsContexts.ProgressText String text2) {
        if (StringUtil.isEmpty((String)text2)) {
            return;
        }
        this.myReporter.setProcess(text2);
    }

    protected void endAction() {
        if (this.getState() == JSLanguageServiceExecutor.State.STARTED) {
            this.myReporter.setProcess(null);
        }
    }

    private void disposeIndicator(@Nullable BackgroundableProcessIndicator indicator) {
        try {
            if (indicator != null) {
                if (!indicator.isCanceled()) {
                    indicator.cancel();
                }
                UIUtil.invokeLaterIfNeeded(() -> {
                    if (this.myProject.isDisposed()) {
                        return;
                    }
                    Disposer.dispose((Disposable)indicator);
                });
            }
        }
        catch (Exception e) {
            JSLanguageServiceQueue.Holder.LOGGER.debug(e.getMessage(), (Throwable)e);
        }
    }

    protected boolean isStarted() {
        return this.myState == JSLanguageServiceExecutor.State.STARTED;
    }

    @Override
    public boolean isValid() {
        JSLanguageServiceExecutor.State state = this.myState;
        return state != JSLanguageServiceExecutor.State.DISPOSED && state != JSLanguageServiceExecutor.State.ERROR_OR_TIMEOUT;
    }

    @Override
    public String getStartErrorMessage() {
        return (String)ObjectUtils.coalesce((Object)this.myServiceConnector.getInitializeError(), (Object)this.myStartErrorMessage);
    }

    @NotNull
    public JSLanguageServiceConnector getProtocol() {
        JSLanguageServiceConnector jSLanguageServiceConnector = this.myServiceConnector;
        if (jSLanguageServiceConnector == null) {
            JSLanguageServiceExecutorImpl.$$$reportNull$$$0(8);
        }
        return jSLanguageServiceConnector;
    }

    @NotNull
    public <T> Future<T> submit(@Nullable @NlsContexts.ProgressText String presentableName, Callable<? extends T> task) {
        Future<Object> future;
        try {
            future = this.myExecutorService.submit(() -> {
                if (this.myState != JSLanguageServiceExecutor.State.STARTED) {
                    throw new IllegalStateException("Service is not started. State = " + this.myState.name());
                }
                this.startAction(presentableName);
                try {
                    Object v = task.call();
                    return v;
                }
                catch (IOException e) {
                    JSLanguageServiceQueue.Holder.LOGGER.debug(e.getMessage(), (Throwable)e);
                    throw e;
                }
                catch (Throwable throwable) {
                    JSLanguageServiceQueue.Holder.LOGGER.error(throwable.getMessage(), throwable);
                    throw throwable;
                }
                finally {
                    this.endAction();
                }
            });
        }
        catch (RejectedExecutionException exception) {
            JSLanguageServiceQueue.Holder.LOGGER.debug(exception.getMessage(), (Throwable)exception);
            throw exception;
        }
        if (future == null) {
            JSLanguageServiceExecutorImpl.$$$reportNull$$$0(9);
        }
        return future;
    }

    protected final void infoLog(@NotNull String message) {
        if (message == null) {
            JSLanguageServiceExecutorImpl.$$$reportNull$$$0(10);
        }
        this.infoLog(message, null);
    }

    protected final void infoLog(@NotNull String message, @Nullable Throwable exception) {
        if (message == null) {
            JSLanguageServiceExecutorImpl.$$$reportNull$$$0(11);
        }
        JSLanguageServiceQueue.Holder.LOGGER.info(this.myReporter.getPresentableServiceName() + ": " + message, exception);
    }

    protected final void debugLog(@NotNull String message) {
        if (message == null) {
            JSLanguageServiceExecutorImpl.$$$reportNull$$$0(12);
        }
        JSLanguageServiceQueue.Holder.LOGGER.debug(this.myReporter.getPresentableServiceName() + ": " + message);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 3, 8, 9 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "serviceConnector";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "reporter";
                break;
            }
            case 3: 
            case 8: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/javascript/service/JSLanguageServiceExecutorImpl";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "processHandler";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "e";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "pool";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "command";
                break;
            }
            case 10: 
            case 11: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "message";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/javascript/service/JSLanguageServiceExecutorImpl";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getState";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getProtocol";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "submit";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 3: 
            case 8: 
            case 9: {
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "connectProcessHandler";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "getPresentableExceptionMessage";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "shutdownPool";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "startAction";
                break;
            }
            case 10: 
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "infoLog";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "debugLog";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 3, 8, 9 -> new IllegalStateException(string);
        };
    }
}

