/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.refactoring.rename;

import com.intellij.codeInsight.template.TemplateBuilderImpl;
import com.intellij.lang.injection.InjectedLanguageManager;
import com.intellij.lang.javascript.DialectDetector;
import com.intellij.lang.javascript.JSTokenTypes;
import com.intellij.lang.javascript.JavaScriptSupportLoader;
import com.intellij.lang.javascript.psi.JSDestructuringShorthandedProperty;
import com.intellij.lang.javascript.psi.JSEmbeddedContent;
import com.intellij.lang.javascript.psi.JSFunction;
import com.intellij.lang.javascript.psi.JSLabeledStatement;
import com.intellij.lang.javascript.psi.JSNamedElement;
import com.intellij.lang.javascript.psi.JSRecordType;
import com.intellij.lang.javascript.psi.JSThisExpression;
import com.intellij.lang.javascript.psi.JSVariable;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptThisType;
import com.intellij.lang.javascript.psi.ecmal4.JSSuperExpression;
import com.intellij.lang.javascript.psi.impl.JSLiteralTextReference;
import com.intellij.lang.javascript.psi.impl.JSUseScopeProvider;
import com.intellij.lang.javascript.psi.resolve.JSReferenceUtil;
import com.intellij.lang.javascript.refactoring.JSDefaultRenameProcessor;
import com.intellij.lang.javascript.refactoring.JSGetterSetterRenameUtil;
import com.intellij.lang.javascript.refactoring.rename.JSInlineAutomaticRenamerFactory;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.Pass;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiNameIdentifierOwner;
import com.intellij.psi.PsiNamedElement;
import com.intellij.psi.PsiReference;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.search.LocalSearchScope;
import com.intellij.psi.search.PsiSearchHelper;
import com.intellij.psi.search.SearchScope;
import com.intellij.psi.search.searches.ReferencesSearch;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.refactoring.rename.RenamePsiElementProcessor;
import com.intellij.refactoring.rename.inplace.InplaceRefactoring;
import com.intellij.refactoring.rename.inplace.VariableInplaceRenameHandler;
import com.intellij.refactoring.rename.inplace.VariableInplaceRenamer;
import com.intellij.refactoring.rename.naming.AutomaticRenamerFactory;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JSInplaceRenameHandler
extends VariableInplaceRenameHandler {
    protected boolean isAvailable(@Nullable PsiElement element, @NotNull Editor editor, @NotNull PsiFile file) {
        if (editor == null) {
            JSInplaceRenameHandler.$$$reportNull$$$0(0);
        }
        if (file == null) {
            JSInplaceRenameHandler.$$$reportNull$$$0(1);
        }
        return editor.getSettings().isVariableInplaceRenameEnabled() && JSInplaceRenameHandler.isValidContext(editor, file) && JSInplaceRenameHandler.isSuitableForInplaceRename(element, file);
    }

    public static boolean isSuitableForInplaceRename(@Nullable PsiElement element, @NotNull PsiFile file) {
        if (file == null) {
            JSInplaceRenameHandler.$$$reportNull$$$0(2);
        }
        if (element instanceof JSLabeledStatement) {
            return true;
        }
        return !(!(element instanceof JSNamedElement) || !JSInplaceRenameHandler.isOnlyLocallyUsed((JSNamedElement)element) || JavaScriptSupportLoader.isMxmlOrFxgFile(InjectedLanguageManager.getInstance((Project)file.getProject()).getTopLevelFile((PsiElement)file)) || JSGetterSetterRenameUtil.isFieldWithAccessors(element) || element instanceof JSVariable && element.getParent() instanceof JSDestructuringShorthandedProperty || element instanceof JSFunction && ((JSFunction)element).isConstructor() && !DialectDetector.isActionScript(element));
    }

    private static boolean isOnlyLocallyUsed(@NotNull JSNamedElement element) {
        if (element == null) {
            JSInplaceRenameHandler.$$$reportNull$$$0(3);
        }
        return element.getUseScope() instanceof LocalSearchScope || JSInplaceRenameHandler.getEffectiveUseScopeIfGlobal(element) != null;
    }

    @Nullable
    private static PsiElement getEffectiveUseScopeIfGlobal(@NotNull JSNamedElement element) {
        if (element == null) {
            JSInplaceRenameHandler.$$$reportNull$$$0(4);
        }
        if (!JSUseScopeProvider.isLexicalScopeElement((PsiElement)element) || !DialectDetector.isJavaScript((PsiElement)element)) {
            return null;
        }
        String name = element.getName();
        if (name == null) {
            return null;
        }
        PsiFile psiFile = element.getContainingFile();
        if (psiFile == null) {
            return null;
        }
        VirtualFile baseFile = psiFile.getVirtualFile();
        if (baseFile == null) {
            return null;
        }
        return PsiSearchHelper.getInstance((Project)element.getProject()).processCandidateFilesForText((GlobalSearchScope)element.getUseScope(), (short)255, true, name, file -> baseFile.equals(file)) ? psiFile : null;
    }

    private static boolean isValidContext(Editor editor, PsiFile file) {
        int offset = editor.getCaretModel().getOffset();
        PsiReference reference = file.findReferenceAt(offset);
        if (reference instanceof JSLiteralTextReference || reference != null && !JSDefaultRenameProcessor.isStrictEnoughReference(reference)) {
            return false;
        }
        PsiElement element = file.findElementAt(offset);
        return element != null && !JSInplaceRenameHandler.isForbiddenContextForInplace(element.getParent());
    }

    public static boolean isForbiddenContextForInplace(PsiElement parent) {
        return parent instanceof JSThisExpression || parent instanceof TypeScriptThisType || parent instanceof JSSuperExpression;
    }

    @Nullable
    protected VariableInplaceRenamer createRenamer(@NotNull PsiElement elementToRename, @NotNull Editor editor) {
        if (elementToRename == null) {
            JSInplaceRenameHandler.$$$reportNull$$$0(5);
        }
        if (editor == null) {
            JSInplaceRenameHandler.$$$reportNull$$$0(6);
        }
        return new VariableInplaceRenamer((PsiNamedElement)((PsiNameIdentifierOwner)elementToRename), editor){
            private final Collection<Pair<PsiElement, TextRange>> myStringUsages;
            private boolean myDone;
            {
                this.myStringUsages = Collections.synchronizedList(new ArrayList());
                this.myDone = false;
            }

            protected Collection<PsiReference> collectRefs(SearchScope referencesSearchScope) {
                LOG.assertTrue(!this.myDone);
                List<PsiReference> result2 = Collections.synchronizedList(new ArrayList());
                ReferencesSearch.search((PsiElement)this.myElementToRename, (SearchScope)referencesSearchScope).forEach(psiReference -> {
                    if (psiReference instanceof JSSuperExpression || psiReference instanceof JSThisExpression) {
                        return true;
                    }
                    if (JSDefaultRenameProcessor.isStrictEnoughReference(psiReference)) {
                        result2.add((PsiReference)psiReference);
                    } else {
                        this.myStringUsages.add((Pair<PsiElement, TextRange>)Pair.create((Object)psiReference.getElement(), (Object)psiReference.getRangeInElement()));
                    }
                    return true;
                });
                return result2;
            }

            protected void collectAdditionalElementsToRename(@NotNull List<? super Pair<PsiElement, TextRange>> stringUsages) {
                if (stringUsages == null) {
                    1.$$$reportNull$$$0(0);
                }
                LOG.assertTrue(!this.myDone);
                stringUsages.addAll(this.myStringUsages);
                super.collectAdditionalElementsToRename(stringUsages);
            }

            protected void addAdditionalVariables(TemplateBuilderImpl builder2) {
                for (AutomaticRenamerFactory renamerFactory : AutomaticRenamerFactory.EP_NAME.getExtensionList()) {
                    if (!(renamerFactory instanceof JSInlineAutomaticRenamerFactory)) continue;
                    JSInlineAutomaticRenamerFactory jsFactory = (JSInlineAutomaticRenamerFactory)renamerFactory;
                    jsFactory.addTemplateVariables(builder2, this.myElementToRename, this.getInitialName(), "PrimaryVariable");
                }
            }

            protected boolean isRenamerFactoryApplicable(@NotNull AutomaticRenamerFactory renamerFactory, @NotNull PsiNamedElement elementToRename) {
                if (renamerFactory == null) {
                    1.$$$reportNull$$$0(1);
                }
                if (elementToRename == null) {
                    1.$$$reportNull$$$0(2);
                }
                if (renamerFactory instanceof JSInlineAutomaticRenamerFactory) {
                    return false;
                }
                return super.isRenamerFactoryApplicable(renamerFactory, elementToRename);
            }

            public boolean performInplaceRename(@Nullable Collection<String> nameSuggestions) {
                boolean result2 = super.performInplaceRename(nameSuggestions);
                this.myDone = true;
                return result2;
            }

            protected boolean buildTemplateAndStart(@NotNull Collection<PsiReference> refs, @NotNull Collection<Pair<PsiElement, TextRange>> stringUsages, @NotNull PsiElement scope2, @NotNull PsiFile containingFile2) {
                if (refs == null) {
                    1.$$$reportNull$$$0(3);
                }
                if (stringUsages == null) {
                    1.$$$reportNull$$$0(4);
                }
                if (scope2 == null) {
                    1.$$$reportNull$$$0(5);
                }
                if (containingFile2 == null) {
                    1.$$$reportNull$$$0(6);
                }
                if (!JSDefaultRenameProcessor.collectShorthandPropertyUsages(refs).isEmpty()) {
                    return false;
                }
                boolean result2 = super.buildTemplateAndStart(refs, stringUsages, scope2, containingFile2);
                PsiElement container = PsiTreeUtil.getNonStrictParentOfType((PsiElement)scope2, (Class[])new Class[]{PsiFile.class, JSEmbeddedContent.class});
                if (container != null) {
                    this.myLanguage = container.getLanguage();
                }
                return result2;
            }

            @NotNull
            protected TextRange getRangeToRename(@NotNull PsiElement element) {
                if (element == null) {
                    1.$$$reportNull$$$0(7);
                }
                if (element.getNode().getElementType() != JSTokenTypes.STRING_LITERAL) {
                    TextRange textRange = super.getRangeToRename(element);
                    if (textRange == null) {
                        1.$$$reportNull$$$0(8);
                    }
                    return textRange;
                }
                if (!(element.getParent() instanceof JSRecordType.PropertySignature)) {
                    TextRange textRange = super.getRangeToRename(element);
                    if (textRange == null) {
                        1.$$$reportNull$$$0(9);
                    }
                    return textRange;
                }
                TextRange textRange = JSReferenceUtil.getRangeWithoutQuotes(element);
                if (textRange == null) {
                    1.$$$reportNull$$$0(10);
                }
                return textRange;
            }

            @NotNull
            protected TextRange getRangeToRename(@NotNull PsiReference reference) {
                if (reference == null) {
                    1.$$$reportNull$$$0(11);
                }
                if (reference instanceof JSLiteralTextReference && ((JSLiteralTextReference)reference).isLiteralKeyReference()) {
                    TextRange textRange = JSReferenceUtil.getRangeWithoutQuotes(reference.getElement());
                    if (textRange == null) {
                        1.$$$reportNull$$$0(12);
                    }
                    return textRange;
                }
                TextRange textRange = super.getRangeToRename(reference);
                if (textRange == null) {
                    1.$$$reportNull$$$0(13);
                }
                return textRange;
            }

            @Nullable
            protected PsiElement checkLocalScope() {
                PsiElement localScope = super.checkLocalScope();
                if (localScope != null) {
                    return localScope;
                }
                if (this.myElementToRename instanceof JSNamedElement && this.myElementToRename.getUseScope() instanceof GlobalSearchScope) {
                    return JSInplaceRenameHandler.getEffectiveUseScopeIfGlobal((JSNamedElement)this.myElementToRename);
                }
                return null;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2;
                Object[] objectArray3 = new Object[switch (n) {
                    default -> 3;
                    case 8, 9, 10, 12, 13 -> 2;
                }];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "stringUsages";
                        break;
                    }
                    case 1: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "renamerFactory";
                        break;
                    }
                    case 2: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "elementToRename";
                        break;
                    }
                    case 3: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "refs";
                        break;
                    }
                    case 5: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "scope";
                        break;
                    }
                    case 6: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "containingFile";
                        break;
                    }
                    case 7: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "element";
                        break;
                    }
                    case 8: 
                    case 9: 
                    case 10: 
                    case 12: 
                    case 13: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "com/intellij/lang/javascript/refactoring/rename/JSInplaceRenameHandler$1";
                        break;
                    }
                    case 11: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "reference";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[1] = "com/intellij/lang/javascript/refactoring/rename/JSInplaceRenameHandler$1";
                        break;
                    }
                    case 8: 
                    case 9: 
                    case 10: 
                    case 12: 
                    case 13: {
                        objectArray = objectArray2;
                        objectArray2[1] = "getRangeToRename";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray;
                        objectArray[2] = "collectAdditionalElementsToRename";
                        break;
                    }
                    case 1: 
                    case 2: {
                        objectArray = objectArray;
                        objectArray[2] = "isRenamerFactoryApplicable";
                        break;
                    }
                    case 3: 
                    case 4: 
                    case 5: 
                    case 6: {
                        objectArray = objectArray;
                        objectArray[2] = "buildTemplateAndStart";
                        break;
                    }
                    case 7: 
                    case 11: {
                        objectArray = objectArray;
                        objectArray[2] = "getRangeToRename";
                        break;
                    }
                    case 8: 
                    case 9: 
                    case 10: 
                    case 12: 
                    case 13: {
                        break;
                    }
                }
                String string = String.format(v0, objectArray);
                throw switch (n) {
                    default -> new IllegalArgumentException(string);
                    case 8, 9, 10, 12, 13 -> new IllegalStateException(string);
                };
            }
        };
    }

    @Nullable
    public InplaceRefactoring doRename(@NotNull PsiElement elementToRename, final @NotNull Editor editor, final @Nullable DataContext dataContext) {
        if (elementToRename == null) {
            JSInplaceRenameHandler.$$$reportNull$$$0(7);
        }
        if (editor == null) {
            JSInplaceRenameHandler.$$$reportNull$$$0(8);
        }
        final Ref renamer = new Ref();
        RenamePsiElementProcessor processor = RenamePsiElementProcessor.forElement((PsiElement)elementToRename);
        processor.substituteElementToRename(elementToRename, editor, (Pass)new Pass<PsiElement>(){

            public void pass(PsiElement substituted) {
                renamer.set((Object)JSInplaceRenameHandler.super.doRename(substituted, editor, dataContext));
            }
        });
        return (InplaceRefactoring)renamer.get();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "editor";
                break;
            }
            case 1: 
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 3: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 5: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "elementToRename";
                break;
            }
        }
        objectArray2[1] = "com/intellij/lang/javascript/refactoring/rename/JSInplaceRenameHandler";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "isAvailable";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "isSuitableForInplaceRename";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "isOnlyLocallyUsed";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "getEffectiveUseScopeIfGlobal";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[2] = "createRenamer";
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray2;
                objectArray2[2] = "doRename";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

