/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.refactoring.extractMethod;

import com.intellij.lang.javascript.DialectDetector;
import com.intellij.lang.javascript.dialects.JSLanguageFeature;
import com.intellij.lang.javascript.psi.JSNamedElement;
import com.intellij.lang.javascript.psi.JSType;
import com.intellij.lang.javascript.psi.JSTypeDeclarationOwner;
import com.intellij.lang.javascript.psi.JSTypeOwner;
import com.intellij.lang.javascript.psi.JSTypeUtils;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptTypeParameterListOwner;
import com.intellij.lang.javascript.psi.resolve.JSResolveUtil;
import com.intellij.lang.javascript.psi.types.JSCodeBasedType;
import com.intellij.lang.javascript.psi.types.JSContext;
import com.intellij.lang.javascript.psi.types.JSTypeGenericId;
import com.intellij.lang.javascript.psi.types.guard.TypeScriptTypeRelations;
import com.intellij.lang.javascript.refactoring.extractMethod.JSExtractFunctionHandler;
import com.intellij.lang.javascript.refactoring.extractMethod.JSExtractFunctionSettings;
import com.intellij.lang.javascript.refactoring.extractMethod.JSSignatureContext;
import com.intellij.lang.javascript.refactoring.extractMethod.signatureGenerator.JSFunctionSignatureGenerator;
import com.intellij.lang.javascript.refactoring.extractMethod.signatureGenerator.JSFunctionSignatureInfo;
import com.intellij.lang.typescript.tsconfig.TypeScriptConfig;
import com.intellij.lang.typescript.tsconfig.TypeScriptConfigUtil;
import com.intellij.openapi.util.Couple;
import com.intellij.psi.PsiElement;
import com.intellij.util.containers.ContainerUtil;
import java.util.LinkedHashSet;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JSExtractedFunctionSignatureInfoBuilder {
    private static final JSFunctionSignatureGenerator JS_GENERATOR = new JSFunctionSignatureGenerator();

    @NotNull
    public String getSignature(@NotNull JSExtractFunctionSettings settings2, JSSignatureContext context2) {
        if (settings2 == null) {
            JSExtractedFunctionSignatureInfoBuilder.$$$reportNull$$$0(0);
        }
        String string = this.getGenerator().getSignature(this.getSignatureInfo(settings2, context2), context2.getContextElement()).toString();
        if (string == null) {
            JSExtractedFunctionSignatureInfoBuilder.$$$reportNull$$$0(1);
        }
        return string;
    }

    protected JSFunctionSignatureGenerator getGenerator() {
        return JS_GENERATOR;
    }

    protected JSFunctionSignatureInfo getSignatureInfo(@NotNull JSExtractFunctionSettings settings2, JSSignatureContext context2) {
        if (settings2 == null) {
            JSExtractedFunctionSignatureInfoBuilder.$$$reportNull$$$0(2);
        }
        JSExtractFunctionHandler.IntroductionScope introductionScope = settings2.getIntroductionScope();
        JSFunctionSignatureInfo result2 = new JSFunctionSignatureInfo(settings2.getMethodName());
        this.fill(result2, settings2, introductionScope, context2);
        return result2;
    }

    protected void fill(JSFunctionSignatureInfo result2, JSExtractFunctionSettings settings2, JSExtractFunctionHandler.IntroductionScope introductionScope, JSSignatureContext context2) {
        result2.setAsync(context2.isAsync());
        result2.setIsGenerator(context2.isGenerator());
        result2.setScope(this.getScope(settings2));
        result2.setDeclarationType(settings2.getDeclarationType());
        this.setParams(result2, settings2);
        PsiElement anchor = context2.getContextElement();
        if (DialectDetector.hasFeature(anchor, JSLanguageFeature.CLASSES) && introductionScope.isClassContext()) {
            result2.setStatic(context2.getJSContext() == JSContext.STATIC || JSExtractFunctionHandler.possibleToExtractStaticFromInstance(context2, introductionScope) && settings2.makeStatic());
        }
    }

    protected JSFunctionSignatureInfo.Scope getScope(@NotNull JSExtractFunctionSettings settings2) {
        JSExtractFunctionHandler.IntroductionScope introductionScope;
        if (settings2 == null) {
            JSExtractedFunctionSignatureInfoBuilder.$$$reportNull$$$0(3);
        }
        if ((introductionScope = settings2.getIntroductionScope()).isClassContext()) {
            return JSFunctionSignatureInfo.Scope.CLASS;
        }
        if (JSExtractFunctionHandler.isPropertyContext(introductionScope.parent)) {
            return JSFunctionSignatureInfo.Scope.JS_OBJECT;
        }
        return JSFunctionSignatureInfo.Scope.GLOBAL;
    }

    protected void setParams(@NotNull JSFunctionSignatureInfo result2, @NotNull JSExtractFunctionSettings settings2) {
        if (result2 == null) {
            JSExtractedFunctionSignatureInfoBuilder.$$$reportNull$$$0(4);
        }
        if (settings2 == null) {
            JSExtractedFunctionSignatureInfoBuilder.$$$reportNull$$$0(5);
        }
        JSExtractFunctionSettings.ParametersInfo parametersInfo = JSExtractFunctionHandler.getNotNullParametersInfo(settings2);
        List<JSNamedElement> parameters = JSExtractFunctionHandler.getOrderedParameters(parametersInfo);
        boolean referencesArguments = false;
        LinkedHashSet generics = new LinkedHashSet();
        for (JSNamedElement p : parameters) {
            if (JSExtractFunctionHandler.isArgumentsReference(p)) {
                referencesArguments = true;
                continue;
            }
            JSExtractFunctionSettings.ParameterInfo parameterInfo = parametersInfo.variableOptions.get(p);
            if (parameterInfo != null && !parameterInfo.used) continue;
            result2.addParameter((Couple<String>)Couple.of((Object)(parameterInfo != null ? parameterInfo.name : p.getName()), (Object)this.getStringType(p, parameterInfo)));
            if (parameterInfo == null) continue;
            PsiElement scope2 = settings2.getIntroductionScope().getParent();
            LinkedHashSet<JSTypeGenericId> ids = new LinkedHashSet<JSTypeGenericId>(parameterInfo.genericIds);
            if (scope2 instanceof TypeScriptTypeParameterListOwner) {
                ids.removeAll(ContainerUtil.map((Object[])((TypeScriptTypeParameterListOwner)scope2).getTypeParameters(), gp -> gp.getGenericId()));
            }
            generics.addAll(ContainerUtil.map(ids, i -> i.getName()));
        }
        if (referencesArguments) {
            result2.addParameter((Couple<String>)Couple.of((Object)"arguments", (Object)"$varArgs$"));
        }
        if (!generics.isEmpty()) {
            result2.setTypeParameterList("<" + String.join((CharSequence)",", generics) + ">");
        }
    }

    @Nullable
    protected String getStringType(@NotNull JSNamedElement variable, @Nullable JSExtractFunctionSettings.ParameterInfo parameterInfo) {
        if (variable == null) {
            JSExtractedFunctionSignatureInfoBuilder.$$$reportNull$$$0(6);
        }
        return null;
    }

    protected static void setAccessType(JSFunctionSignatureInfo result2, JSExtractFunctionSettings settings2) {
        result2.setAccessType(settings2.getAccessType());
    }

    @Nullable
    protected static String getStringTypeImpl(@NotNull JSNamedElement variable, @Nullable JSExtractFunctionSettings.ParameterInfo parameterInfo) {
        JSType elementType;
        JSType variableType;
        if (variable == null) {
            JSExtractedFunctionSignatureInfoBuilder.$$$reportNull$$$0(7);
        }
        String type2 = null;
        if (parameterInfo != null) {
            return parameterInfo.type;
        }
        if (variable instanceof JSTypeOwner && (variableType = ((JSTypeOwner)((Object)variable)).getJSType()) != null) {
            type2 = JSExtractedFunctionSignatureInfoBuilder.getTypeString(variable, variableType);
        }
        if (type2 == null && DialectDetector.isTypeScript((PsiElement)variable) && (elementType = JSResolveUtil.getElementJSType((PsiElement)variable)) != null) {
            type2 = JSExtractedFunctionSignatureInfoBuilder.getTypeString(variable, elementType);
        }
        return type2;
    }

    @Nullable
    static String getTypeString(@NotNull JSNamedElement variable, JSType variableType) {
        if (variable == null) {
            JSExtractedFunctionSignatureInfoBuilder.$$$reportNull$$$0(8);
        }
        variableType = TypeScriptTypeRelations.expandAndOptimizeTypeRecursive(variableType);
        if (DialectDetector.isTypeScript((PsiElement)variable)) {
            TypeScriptConfig file = TypeScriptConfigUtil.getConfigForPsiFile(variable.getContainingFile());
            if (file != null && file.noImplicitAny()) {
                return variableType == null || JSTypeUtils.isAnyType(variableType) ? "any" : variableType.getTypeText(JSType.TypeTextFormat.CODE);
            }
            if (JSTypeUtils.isAnyType(variableType) && variable instanceof JSTypeDeclarationOwner && ((JSTypeDeclarationOwner)((Object)variable)).getTypeElement() == null) {
                return null;
            }
        }
        if (variableType == null || variableType instanceof JSCodeBasedType) {
            return null;
        }
        return variableType.getTypeText(JSType.TypeTextFormat.CODE);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 1 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "settings";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/javascript/refactoring/extractMethod/JSExtractedFunctionSignatureInfoBuilder";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "result";
                break;
            }
            case 6: 
            case 7: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "variable";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/javascript/refactoring/extractMethod/JSExtractedFunctionSignatureInfoBuilder";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getSignature";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getSignature";
                break;
            }
            case 1: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "getSignatureInfo";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "getScope";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "setParams";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "getStringType";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "getStringTypeImpl";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "getTypeString";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 1 -> new IllegalStateException(string);
        };
    }
}

