/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.refactoring.changeSignature;

import com.intellij.codeInsight.highlighting.ReadWriteAccessDetector;
import com.intellij.lang.ecmascript6.psi.ES6ExportDefaultAssignment;
import com.intellij.lang.ecmascript6.psi.ES6ImportSpecifierAlias;
import com.intellij.lang.ecmascript6.psi.ES6ImportedBinding;
import com.intellij.lang.ecmascript6.resolve.ES6PsiUtil;
import com.intellij.lang.javascript.DialectDetector;
import com.intellij.lang.javascript.DialectOptionHolder;
import com.intellij.lang.javascript.JSLanguageDialect;
import com.intellij.lang.javascript.JavaScriptBundle;
import com.intellij.lang.javascript.JavaScriptSupportLoader;
import com.intellij.lang.javascript.dialects.JSLanguageFeature;
import com.intellij.lang.javascript.findUsages.JSReadWriteAccessDetector;
import com.intellij.lang.javascript.flex.ECMAScriptImportOptimizer;
import com.intellij.lang.javascript.flex.ImportUtils;
import com.intellij.lang.javascript.inspections.ES6RedundantNestingInTemplateLiteralInspection;
import com.intellij.lang.javascript.modules.imports.JSImportAction;
import com.intellij.lang.javascript.modules.imports.JSImportCandidateWithExecutor;
import com.intellij.lang.javascript.names.JSNameSuggestionsUtil;
import com.intellij.lang.javascript.presentable.JSFormatUtil;
import com.intellij.lang.javascript.psi.JSArgumentList;
import com.intellij.lang.javascript.psi.JSAssignmentExpression;
import com.intellij.lang.javascript.psi.JSCallExpression;
import com.intellij.lang.javascript.psi.JSCallLikeExpression;
import com.intellij.lang.javascript.psi.JSDefinitionExpression;
import com.intellij.lang.javascript.psi.JSElement;
import com.intellij.lang.javascript.psi.JSEmbeddedContent;
import com.intellij.lang.javascript.psi.JSExpression;
import com.intellij.lang.javascript.psi.JSField;
import com.intellij.lang.javascript.psi.JSFunction;
import com.intellij.lang.javascript.psi.JSFunctionExpression;
import com.intellij.lang.javascript.psi.JSLiteralExpression;
import com.intellij.lang.javascript.psi.JSParameter;
import com.intellij.lang.javascript.psi.JSParameterList;
import com.intellij.lang.javascript.psi.JSParameterListElement;
import com.intellij.lang.javascript.psi.JSPipeExpression;
import com.intellij.lang.javascript.psi.JSPsiElementBase;
import com.intellij.lang.javascript.psi.JSRecursiveWalkingElementVisitor;
import com.intellij.lang.javascript.psi.JSReferenceExpression;
import com.intellij.lang.javascript.psi.JSThisExpression;
import com.intellij.lang.javascript.psi.JSTypeUtils;
import com.intellij.lang.javascript.psi.JSVariable;
import com.intellij.lang.javascript.psi.e4x.JSE4XNamespaceReference;
import com.intellij.lang.javascript.psi.ecma6.ES6TaggedTemplateExpression;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptType;
import com.intellij.lang.javascript.psi.ecmal4.JSAttributeList;
import com.intellij.lang.javascript.psi.ecmal4.JSAttributeListOwner;
import com.intellij.lang.javascript.psi.ecmal4.JSClass;
import com.intellij.lang.javascript.psi.ecmal4.JSPackageStatement;
import com.intellij.lang.javascript.psi.ecmal4.JSQualifiedNamedElement;
import com.intellij.lang.javascript.psi.ecmal4.JSSuperExpression;
import com.intellij.lang.javascript.psi.impl.JSChangeUtil;
import com.intellij.lang.javascript.psi.impl.JSPsiElementFactory;
import com.intellij.lang.javascript.psi.impl.JSPsiImplUtils;
import com.intellij.lang.javascript.psi.resolve.JSInheritanceUtil;
import com.intellij.lang.javascript.psi.resolve.JSResolveResult;
import com.intellij.lang.javascript.psi.resolve.JSResolveUtil;
import com.intellij.lang.javascript.psi.resolve.ResolveProcessor;
import com.intellij.lang.javascript.psi.util.JSStubBasedPsiTreeUtil;
import com.intellij.lang.javascript.psi.util.JSUtils;
import com.intellij.lang.javascript.refactoring.FormatFixer;
import com.intellij.lang.javascript.refactoring.JSChangeVisibilityUtil;
import com.intellij.lang.javascript.refactoring.JSDefaultRenameProcessor;
import com.intellij.lang.javascript.refactoring.JSVisibilityUtil;
import com.intellij.lang.javascript.refactoring.changeSignature.ChangeSignatureUsageViewDescriptor;
import com.intellij.lang.javascript.refactoring.changeSignature.JSChangeSignatureUtil;
import com.intellij.lang.javascript.refactoring.changeSignature.JSMethodDescriptor;
import com.intellij.lang.javascript.refactoring.changeSignature.JSParameterInfo;
import com.intellij.lang.javascript.refactoring.util.JSRefactoringConflictsUtil;
import com.intellij.lang.javascript.refactoring.util.JSRefactoringUtil;
import com.intellij.lang.javascript.validation.ValidateTypesUtil;
import com.intellij.lang.javascript.validation.fixes.JSAttributeListWrapper;
import com.intellij.lang.typescript.psi.TypeScriptPsiUtil;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.Conditions;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.Trinity;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.ElementDescriptionLocation;
import com.intellij.psi.ElementDescriptionUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiReference;
import com.intellij.psi.ResolveResult;
import com.intellij.psi.ResolveState;
import com.intellij.psi.SmartPointerManager;
import com.intellij.psi.SmartPsiElementPointer;
import com.intellij.psi.search.SearchScope;
import com.intellij.psi.search.searches.ReferencesSearch;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.xml.XmlAttributeValue;
import com.intellij.psi.xml.XmlTag;
import com.intellij.refactoring.BaseRefactoringProcessor;
import com.intellij.refactoring.RefactoringBundle;
import com.intellij.refactoring.listeners.RefactoringEventData;
import com.intellij.refactoring.util.RefactoringDescriptionLocation;
import com.intellij.refactoring.util.RefactoringUIUtil;
import com.intellij.usageView.UsageInfo;
import com.intellij.usageView.UsageViewDescriptor;
import com.intellij.util.ArrayUtil;
import com.intellij.util.ObjectUtils;
import com.intellij.util.PairConsumer;
import com.intellij.util.Processor;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.MultiMap;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.Consumer;
import java.util.function.Function;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JSChangeSignatureProcessor
extends BaseRefactoringProcessor {
    public static final Logger LOG = Logger.getInstance((String)JSChangeSignatureProcessor.class.getName());
    @NotNull
    protected final JSPsiElementBase myNamedElement;
    @NotNull
    protected final JSFunction myMethod;
    @Nullable
    private final JSAttributeList.AccessType myVisibility;
    @Nullable
    private final String myMethodName;
    private final String myReturnType;
    protected final JSParameterInfo[] myParameters;
    private final Set<? extends JSFunction> myMethodsToPropagateParameters;
    private final Set<? extends PsiElement> myImportedElements;
    private final boolean myForceSharpPrivate;
    private final boolean myChangeVisibility;
    @NotNull
    private Condition<JSPsiElementBase> myDeclarationsFilter;
    @NotNull
    private Condition<JSCallExpression> myCallFilter;
    private final int myMethodParamsNumber;

    public JSChangeSignatureProcessor(@NotNull JSFunction method, @Nullable JSAttributeList.AccessType visibility, @Nullable String methodName, String returnType, JSParameterInfo[] parameters, Set<? extends JSFunction> methodsToPropagateParameters, Set<? extends PsiElement> importedElements) {
        if (method == null) {
            JSChangeSignatureProcessor.$$$reportNull$$$0(0);
        }
        this(method, visibility, methodName, returnType, parameters, methodsToPropagateParameters, importedElements, false);
    }

    public JSChangeSignatureProcessor(@NotNull JSFunction method, @Nullable JSAttributeList.AccessType visibility, @Nullable String methodName, String returnType, JSParameterInfo[] parameters, Set<? extends JSFunction> methodsToPropagateParameters, Set<? extends PsiElement> importedElements, boolean forceSharpPrivate) {
        if (method == null) {
            JSChangeSignatureProcessor.$$$reportNull$$$0(1);
        }
        super(method.getProject());
        this.myDeclarationsFilter = Conditions.alwaysTrue();
        this.myCallFilter = Conditions.alwaysTrue();
        this.myMethod = method;
        this.myNamedElement = JSChangeSignatureUtil.getMemberFromFunction(method);
        this.myMethodParamsNumber = JSChangeSignatureProcessor.getNumberOfParams(method);
        this.myVisibility = visibility;
        this.myMethodName = methodName;
        this.myReturnType = returnType;
        this.myParameters = parameters;
        this.myMethodsToPropagateParameters = methodsToPropagateParameters;
        this.myImportedElements = importedElements;
        this.myForceSharpPrivate = forceSharpPrivate;
        JSAttributeList attributeList = this.myNamedElement instanceof JSAttributeListOwner ? ((JSAttributeListOwner)((Object)this.myNamedElement)).getAttributeList() : null;
        this.myChangeVisibility = JSChangeSignatureProcessor.supportsVisibilityModifiers(this.getLangForProcessing()) && this.myVisibility != null && attributeList != null && this.myVisibility != attributeList.getAccessType() || !JSUtils.isPrivateSharpItem(method) && forceSharpPrivate || JSUtils.isPrivateSharpItem(method) && visibility == JSAttributeList.AccessType.PUBLIC;
    }

    @NonNls
    @Nullable
    protected String getRefactoringId() {
        return "refactoring.javascript.change.signature";
    }

    @Nullable
    protected RefactoringEventData getBeforeData() {
        RefactoringEventData data = new RefactoringEventData();
        data.addElement((PsiElement)this.myMethod);
        return data;
    }

    @Nullable
    protected RefactoringEventData getAfterData(UsageInfo @NotNull [] usages) {
        if (usages == null) {
            JSChangeSignatureProcessor.$$$reportNull$$$0(2);
        }
        RefactoringEventData data = new RefactoringEventData();
        data.addElement((PsiElement)this.myMethod);
        return data;
    }

    public void setDeclarationsFilter(@NotNull Condition<JSPsiElementBase> declarationsFilter) {
        if (declarationsFilter == null) {
            JSChangeSignatureProcessor.$$$reportNull$$$0(3);
        }
        this.myDeclarationsFilter = declarationsFilter;
    }

    public void setCallFilter(@NotNull Condition<JSCallExpression> callFilter) {
        if (callFilter == null) {
            JSChangeSignatureProcessor.$$$reportNull$$$0(4);
        }
        this.myCallFilter = callFilter;
    }

    @NotNull
    protected UsageViewDescriptor createUsageViewDescriptor(UsageInfo @NotNull [] usages) {
        if (usages == null) {
            JSChangeSignatureProcessor.$$$reportNull$$$0(5);
        }
        return new ChangeSignatureUsageViewDescriptor(usages);
    }

    protected UsageInfo @NotNull [] findUsages() {
        Collection<UsageInfo> declarations = Collections.synchronizedCollection(new HashSet());
        Collection<OtherUsageInfo> usages = Collections.synchronizedCollection(new HashSet());
        Function<JSPsiElementBase, Consumer> referenceConsumer = rebindTo -> {
            JSFunction member = JSChangeSignatureUtil.getFunctionFromMember((PsiElement)rebindTo);
            return new MyProcessor(usages, (JSElement)rebindTo, member, this.myParameters);
        };
        Consumer<JSPsiElementBase> declarationConsumer = elementBase -> declarations.add(new FunctionDeclarationUsageInfo((JSPsiElementBase)elementBase, null));
        JSField field = null;
        if (this.myMethod instanceof JSFunctionExpression) {
            this.processMemberWithHierarchy(this.myNamedElement, this.myMethod, declarationConsumer, referenceConsumer);
            PsiElement parent = this.myMethod.getParent();
            if (parent instanceof ES6ExportDefaultAssignment) {
                ReferencesSearch.search((PsiElement)this.myMethod, (SearchScope)this.myMethod.getUseScope()).forEach((Consumer)new MyProcessor(usages, this.myMethod, this.myMethod, this.myParameters));
                declarations.add(new FunctionDeclarationUsageInfo(this.myMethod, null));
            }
        } else {
            Object complementary = null;
            if (this.myMethod.isGetProperty()) {
                clazz = JSUtils.getMemberContainingClass(this.myMethod);
                complementary = clazz.findFunctionByNameAndKind(this.myMethod.getName(), JSFunction.FunctionKind.SETTER);
                field = clazz.findFieldByName(JSRefactoringUtil.transformAccessorNameToPropertyName(this.myMethod.getName(), this.myMethod));
            } else if (this.myMethod.isSetProperty()) {
                clazz = JSUtils.getMemberContainingClass(this.myMethod);
                complementary = clazz.findFunctionByNameAndKind(this.myMethod.getName(), JSFunction.FunctionKind.GETTER);
                field = clazz.findFieldByName(JSRefactoringUtil.transformAccessorNameToPropertyName(this.myMethod.getName(), this.myMethod));
            }
            this.processMemberWithHierarchy(this.myNamedElement, this.myMethod, declarationConsumer, referenceConsumer);
            if (complementary != null) {
                this.processMemberWithHierarchy((JSPsiElementBase)complementary, (JSFunction)complementary, declarationConsumer, referenceConsumer);
            }
        }
        this.findPropagationUsages(declarations, usages);
        if (field != null) {
            declarations.add(new FieldDeclarationUsageInfo(field));
            ReferencesSearch.search((PsiElement)field, (SearchScope)field.getUseScope()).forEach((Consumer)new MyProcessor(usages, field, null, JSParameterInfo.EMPTY_ARRAY));
        }
        for (UsageInfo usageInfo : declarations) {
            if (!(usageInfo instanceof FunctionDeclarationUsageInfo)) continue;
            ((FunctionDeclarationUsageInfo)usageInfo).searchForParametersUsages();
        }
        ArrayList<UsageInfo> result2 = new ArrayList<UsageInfo>(declarations);
        result2.addAll(usages);
        UsageInfo[] usageInfoArray = result2.toArray(UsageInfo.EMPTY_ARRAY);
        if (usageInfoArray == null) {
            JSChangeSignatureProcessor.$$$reportNull$$$0(6);
        }
        return usageInfoArray;
    }

    private static void processMember(@NotNull JSPsiElementBase namedElement, @Nullable JSFunction function2, @NotNull Consumer<? super JSPsiElementBase> declarationConsumer, @NotNull Function<? super JSPsiElementBase, ? extends Consumer<? super PsiReference>> getReferenceConsumer) {
        if (namedElement == null) {
            JSChangeSignatureProcessor.$$$reportNull$$$0(7);
        }
        if (declarationConsumer == null) {
            JSChangeSignatureProcessor.$$$reportNull$$$0(8);
        }
        if (getReferenceConsumer == null) {
            JSChangeSignatureProcessor.$$$reportNull$$$0(9);
        }
        if (function2 == null) {
            return;
        }
        if (namedElement != function2) {
            if (function2.getNameIdentifier() == null) {
                declarationConsumer.accept(function2);
            } else {
                declarationConsumer.accept(namedElement);
                ReferencesSearch.search((PsiElement)namedElement, (SearchScope)namedElement.getUseScope()).forEach(getReferenceConsumer.apply(namedElement));
            }
        } else {
            declarationConsumer.accept(function2);
        }
        ReferencesSearch.search((PsiElement)function2, (SearchScope)function2.getUseScope()).forEach(getReferenceConsumer.apply(function2));
    }

    private void processMemberWithHierarchy(@NotNull JSPsiElementBase member, @Nullable JSFunction function2, @NotNull Consumer<? super JSPsiElementBase> declarationConsumer, @NotNull Function<? super JSPsiElementBase, ? extends Consumer<? super PsiReference>> getReferenceConsumer) {
        if (member == null) {
            JSChangeSignatureProcessor.$$$reportNull$$$0(10);
        }
        if (declarationConsumer == null) {
            JSChangeSignatureProcessor.$$$reportNull$$$0(11);
        }
        if (getReferenceConsumer == null) {
            JSChangeSignatureProcessor.$$$reportNull$$$0(12);
        }
        Set<JSPsiElementBase> inheritors = Collections.synchronizedSet(new HashSet());
        JSInheritanceUtil.iterateMembersDown(member, (Processor<? super JSPsiElementBase>)((Processor)hierarchyMember -> {
            if (this.myDeclarationsFilter.value(hierarchyMember)) {
                inheritors.add(hierarchyMember);
            }
            return true;
        }));
        for (JSPsiElementBase inheritor : inheritors) {
            JSFunction inheritorFunction = JSChangeSignatureUtil.getFunctionFromMember((PsiElement)inheritor);
            JSChangeSignatureProcessor.processMember(inheritor, inheritorFunction, declarationConsumer, getReferenceConsumer);
        }
        JSChangeSignatureProcessor.processMember(member, function2, declarationConsumer, getReferenceConsumer);
    }

    protected void findPropagationUsages(Collection<UsageInfo> declarations, Collection<OtherUsageInfo> usages) {
        Object[] addedParams = (JSParameterInfo[])Arrays.stream(this.myParameters).filter(parameter -> parameter.isNew() && StringUtil.isNotEmpty((String)parameter.getDefaultValue())).toArray(JSParameterInfo[]::new);
        for (JSFunction jSFunction : this.myMethodsToPropagateParameters) {
            JSParameterInfo[] newDeclarationParams = ContainerUtil.append(JSMethodDescriptor.getParameters(jSFunction), (Object[])addedParams).toArray(JSParameterInfo.EMPTY_ARRAY);
            Consumer<JSPsiElementBase> declarationConsumer = elementBase -> declarations.add(new FunctionDeclarationUsageInfo((JSPsiElementBase)elementBase, newDeclarationParams));
            Function<JSPsiElementBase, Consumer> getReferenceConsumer = element -> new MyProcessor(usages, null, toPropagate, newDeclarationParams);
            for (JSPsiElementBase topMember : JSInheritanceUtil.findTopMembers(JSChangeSignatureUtil.getMemberFromFunction(jSFunction))) {
                this.processMemberWithHierarchy(topMember, JSChangeSignatureUtil.getFunctionFromMember((PsiElement)topMember), declarationConsumer, getReferenceConsumer);
            }
        }
    }

    protected void performRefactoring(UsageInfo @NotNull [] usageInfos) {
        if (usageInfos == null) {
            JSChangeSignatureProcessor.$$$reportNull$$$0(13);
        }
        RequiredImportProcessor importProcessor = JSChangeSignatureProcessor.createImportProcessor(this.getLangForProcessing(), this.myImportedElements);
        ArrayList formatters = new ArrayList();
        ArrayList<OtherUsageInfo> secondStepUsages = new ArrayList<OtherUsageInfo>();
        for (UsageInfo usage : usageInfos) {
            if (usage instanceof FunctionDeclarationUsageInfo) {
                ContainerUtil.addIfNotNull(formatters, (Object)this.refactorFunctionDeclaration((FunctionDeclarationUsageInfo)usage, importProcessor));
                continue;
            }
            if (usage instanceof FieldDeclarationUsageInfo) {
                this.refactorFieldDeclaration((FieldDeclarationUsageInfo)usage, importProcessor);
                continue;
            }
            if (!(usage instanceof OtherUsageInfo)) continue;
            secondStepUsages.add((OtherUsageInfo)usage);
        }
        for (OtherUsageInfo usage : secondStepUsages) {
            ContainerUtil.addIfNotNull(formatters, (Object)this.refactorUsage(usage, importProcessor));
        }
        importProcessor.finish();
        JSRefactoringUtil.format(formatters);
    }

    @NotNull
    private static RequiredImportProcessor createImportProcessor(JSLanguageDialect language, Set<? extends PsiElement> importedElements) {
        DialectOptionHolder optionHolder = language.getOptionHolder();
        if (optionHolder.isECMA4) {
            return new ActionScriptImportProcessor();
        }
        if (optionHolder.isTypeScript || optionHolder.isECMA6) {
            return new ES6CompatibleImportProcessor(importedElements);
        }
        RequiredImportProcessor requiredImportProcessor = RequiredImportProcessor.EMPTY;
        if (requiredImportProcessor == null) {
            JSChangeSignatureProcessor.$$$reportNull$$$0(14);
        }
        return requiredImportProcessor;
    }

    @Nullable
    private FormatFixer refactorFunctionDeclaration(FunctionDeclarationUsageInfo usage, RequiredImportProcessor requiredImportProcessor) {
        JSPsiElementBase namedElement = usage.getElement();
        JSFunction function2 = usage.getFunction();
        if (function2 == null || namedElement == null) {
            JSChangeSignatureProcessor.logCouldNotRestoreElement(usage);
            return null;
        }
        JSParameterInfo[] paramsOverride = usage.getParamsOverride();
        MultiMap<JSParameter, UsageInfo> paramsUsages = usage.getParamsUsages();
        FormatFixer fixer = null;
        if (paramsOverride != null) {
            fixer = JSChangeSignatureUtil.setParameters(function2, paramsUsages, requiredImportProcessor, this.getLangForProcessing(), paramsOverride);
        } else if (function2.getKind() != this.myMethod.getKind() || this.myMethodParamsNumber == JSChangeSignatureProcessor.getNumberOfParams(function2)) {
            fixer = this.refactorMethodDeclaration(function2, namedElement, requiredImportProcessor, paramsUsages);
        }
        return fixer;
    }

    @Nullable
    private FormatFixer refactorUsage(OtherUsageInfo u, RequiredImportProcessor importProcessor) {
        PsiElement el = u.getElement();
        if (el == null) {
            JSChangeSignatureProcessor.logCouldNotRestoreElement(u);
            return null;
        }
        JSElement target = u.getRebindTo();
        PsiReference reference = el.getReference();
        if (target != null && reference != null) {
            JSChangeSignatureProcessor.rebindTarget(reference, target);
        }
        FormatFixer fixer = null;
        PsiElement parent = el.getParent();
        if (parent instanceof JSCallExpression) {
            JSE4XNamespaceReference namespaceRef;
            JSCallExpression callExpression = (JSCallExpression)parent;
            JSExpression methodExpression = callExpression.getMethodExpression();
            boolean superCall = methodExpression instanceof JSReferenceExpression && ((JSReferenceExpression)methodExpression).getQualifier() instanceof JSSuperExpression;
            fixer = this.refactorCall(callExpression, u.getParameters(), u.isPropagate() || superCall, u.myMinParams, u.myMaxParams, importProcessor);
            if (this.myChangeVisibility && (namespaceRef = (JSE4XNamespaceReference)PsiTreeUtil.findChildOfType((PsiElement)methodExpression, JSE4XNamespaceReference.class)) != null) {
                namespaceRef.delete();
            }
        }
        if (parent instanceof JSPipeExpression) {
            fixer = this.refactorPipe((JSPipeExpression)parent, u.getParameters(), u.isPropagate(), importProcessor);
        }
        if (parent instanceof ES6TaggedTemplateExpression) {
            this.refactorTaggedTemplate((ES6TaggedTemplateExpression)parent, u.getParameters(), u.isPropagate(), importProcessor);
        }
        return fixer;
    }

    private static void rebindTarget(@NotNull PsiReference el, @NotNull JSElement target) {
        if (el == null) {
            JSChangeSignatureProcessor.$$$reportNull$$$0(15);
        }
        if (target == null) {
            JSChangeSignatureProcessor.$$$reportNull$$$0(16);
        }
        if (el instanceof JSReferenceExpression) {
            PsiElement localResolveResult = JSChangeSignatureProcessor.resolveInModule((JSReferenceExpression)el);
            if (!(localResolveResult instanceof ES6ImportedBinding) && !(localResolveResult instanceof ES6ImportSpecifierAlias)) {
                el.bindToElement((PsiElement)target);
            }
        } else {
            el.bindToElement((PsiElement)target);
        }
    }

    @Nullable
    private static PsiElement resolveInModule(@NotNull JSReferenceExpression referenceExpression) {
        PsiElement es6Module;
        if (referenceExpression == null) {
            JSChangeSignatureProcessor.$$$reportNull$$$0(17);
        }
        return (es6Module = ES6PsiUtil.findExternalModule((PsiElement)referenceExpression)) != null && referenceExpression.getReferenceName() != null ? JSStubBasedPsiTreeUtil.resolveLocally(referenceExpression.getReferenceName(), es6Module) : null;
    }

    private static boolean hasSpreadElement(@Nullable JSCallExpression callExpression) {
        return callExpression != null && callExpression.getArgumentList() != null && callExpression.getArgumentList().hasSpreadElement();
    }

    private void refactorTaggedTemplate(@NotNull ES6TaggedTemplateExpression taggedTemplateExpression, JSParameterInfo @NotNull [] originalParameters, boolean propagate, @NotNull RequiredImportProcessor importProcessor) {
        if (taggedTemplateExpression == null) {
            JSChangeSignatureProcessor.$$$reportNull$$$0(18);
        }
        if (importProcessor == null) {
            JSChangeSignatureProcessor.$$$reportNull$$$0(19);
        }
        if (originalParameters == null) {
            JSChangeSignatureProcessor.$$$reportNull$$$0(20);
        }
        JSParameterInfo[] params = (JSParameterInfo[])ArrayUtil.copyOf((Object[])originalParameters);
        List<JSExpression> newArguments = this.buildCallArgumentsList(taggedTemplateExpression, params, propagate, importProcessor);
        JSExpression @NotNull [] arguments = taggedTemplateExpression.getArguments();
        for (int i = 0; i < arguments.length; ++i) {
            JSExpression argument = arguments[i];
            if (i + 1 >= newArguments.size()) {
                JSLiteralExpression newArg = (JSLiteralExpression)argument.replace(JSPsiElementFactory.createJSExpression("''", (PsiElement)argument, JSLiteralExpression.class));
                ES6RedundantNestingInTemplateLiteralInspection.inlineArgument(newArg, Objects.requireNonNull(taggedTemplateExpression.getTemplateExpression()));
                break;
            }
            JSExpression expression = newArguments.get(i + 1);
            argument.replace(expression);
        }
    }

    @NotNull
    private FormatFixer refactorPipe(@NotNull JSPipeExpression pipeExpression, JSParameterInfo @NotNull [] originalParameters, boolean propagate, @NotNull RequiredImportProcessor importProcessor) {
        if (pipeExpression == null) {
            JSChangeSignatureProcessor.$$$reportNull$$$0(21);
        }
        if (importProcessor == null) {
            JSChangeSignatureProcessor.$$$reportNull$$$0(22);
        }
        if (originalParameters == null) {
            JSChangeSignatureProcessor.$$$reportNull$$$0(23);
        }
        JSParameterInfo[] params = (JSParameterInfo[])ArrayUtil.copyOf((Object[])originalParameters);
        List<JSExpression> newArguments = this.buildCallArgumentsList(pipeExpression, params, propagate, importProcessor);
        JSCallExpression dummyCallExpression = JSPsiElementFactory.createJSExpression("dummy()", (PsiElement)pipeExpression, JSCallExpression.class);
        JSArgumentList newArgList = Objects.requireNonNull(dummyCallExpression.getArgumentList());
        JSChangeSignatureProcessor.addCommaIfNeeded(newArgList);
        String name = JSNameSuggestionsUtil.ensureUniqueVariableName("_", (PsiElement)pipeExpression, new HashSet<String>(), false);
        newArgList.addBefore((PsiElement)JSPsiElementFactory.createJSExpression(name, (PsiElement)pipeExpression), newArgList.getLastChild());
        for (int i = 1; i < newArguments.size(); ++i) {
            JSExpression argument = newArguments.get(i);
            JSChangeSignatureProcessor.addCommaIfNeeded(newArgList);
            newArgList.addBefore((PsiElement)argument, newArgList.getLastChild());
        }
        JSExpression methodExpression = pipeExpression.getMethodExpression();
        JSExpression newExpression = JSPsiElementFactory.createJSExpression("(" + name + " => " + methodExpression.getText() + newArgList.getText() + ")", (PsiElement)pipeExpression);
        methodExpression.replace(newExpression);
        FormatFixer formatFixer = FormatFixer.create((PsiElement)pipeExpression, FormatFixer.Mode.Reformat);
        if (formatFixer == null) {
            JSChangeSignatureProcessor.$$$reportNull$$$0(24);
        }
        return formatFixer;
    }

    @Nullable
    private FormatFixer refactorCall(@NotNull JSCallExpression callExpression, JSParameterInfo @NotNull [] parameters, boolean propagate, int minParams, int maxParams, @NotNull RequiredImportProcessor importProcessor) {
        JSExpression methodExpression;
        PsiElement parent;
        PsiElement callParent;
        if (callExpression == null) {
            JSChangeSignatureProcessor.$$$reportNull$$$0(25);
        }
        if (importProcessor == null) {
            JSChangeSignatureProcessor.$$$reportNull$$$0(26);
        }
        if (parameters == null) {
            JSChangeSignatureProcessor.$$$reportNull$$$0(27);
        }
        JSExpression[] oldArguments = callExpression.getArguments();
        if (this.getLangForProcessing().getOptionHolder().isECMA4 && (oldArguments.length < minParams || oldArguments.length > maxParams) || JSChangeSignatureProcessor.hasSpreadElement(callExpression) || !this.myCallFilter.value((Object)callExpression)) {
            return null;
        }
        if (parameters.length == 1 && (callParent = callExpression.getParent()) instanceof JSFunctionExpression && (parent = JSUtils.getParentSkipParentheses(callParent)) instanceof JSPipeExpression && PsiTreeUtil.isAncestor((PsiElement)(methodExpression = ((JSPipeExpression)parent).getMethodExpression()), (PsiElement)callParent, (boolean)false)) {
            methodExpression.replace(callExpression.getMethodExpression());
            return null;
        }
        List<JSExpression> newArguments = this.buildCallArgumentsList(callExpression, parameters, propagate, importProcessor);
        JSCallExpression dummyCallExpression = JSPsiElementFactory.createJSExpression("dummy()", (PsiElement)callExpression, JSCallExpression.class);
        JSArgumentList newArgList = Objects.requireNonNull(dummyCallExpression.getArgumentList());
        for (JSExpression argument : newArguments) {
            JSChangeSignatureProcessor.addCommaIfNeeded(newArgList);
            newArgList.addBefore((PsiElement)argument, newArgList.getLastChild());
        }
        JSArgumentList list2 = callExpression.getArgumentList();
        newArgList = list2 != null ? (JSArgumentList)list2.replace((PsiElement)newArgList) : (JSArgumentList)callExpression.addAfter((PsiElement)newArgList, (PsiElement)callExpression.getMethodExpression());
        return FormatFixer.create((PsiElement)newArgList, FormatFixer.Mode.Reformat);
    }

    @NotNull
    private List<JSExpression> buildCallArgumentsList(@NotNull JSCallLikeExpression callExpression, JSParameterInfo @NotNull [] parameters, boolean propagate, @NotNull RequiredImportProcessor importProcessor) {
        if (callExpression == null) {
            JSChangeSignatureProcessor.$$$reportNull$$$0(28);
        }
        if (importProcessor == null) {
            JSChangeSignatureProcessor.$$$reportNull$$$0(29);
        }
        if (parameters == null) {
            JSChangeSignatureProcessor.$$$reportNull$$$0(30);
        }
        JSExpression[] oldArguments = callExpression.getArguments();
        ArrayList<JSExpression> newArguments = new ArrayList<JSExpression>();
        for (int i = 0; i < parameters.length; ++i) {
            JSParameterInfo parameter = parameters[i];
            if (parameter.isNew()) {
                String value;
                if (StringUtil.isEmpty((String)parameter.getDefaultValue())) {
                    for (int j = i; j < parameters.length; ++j) {
                        JSParameterInfo p2 = parameters[j];
                        LOG.assertTrue((StringUtil.isNotEmpty((String)p2.getInitializer()) || p2.isRest()) && StringUtil.isEmpty((String)p2.getDefaultValue()));
                    }
                    continue;
                }
                if (propagate) {
                    value = parameter.getDeclarationText();
                } else {
                    String defaultValue = parameter.getDefaultValue();
                    if (StringUtil.isEmpty((String)defaultValue)) {
                        defaultValue = JSTypeUtils.defaultValueOfType(parameter.getTypeText());
                    } else {
                        importProcessor.computeImportsForExpression(defaultValue, (PsiElement)callExpression);
                    }
                    value = JSChangeSignatureProcessor.getEscaped(defaultValue, (PsiElement)callExpression);
                }
                this.ensureArgumentsCount(newArguments, i, callExpression);
                newArguments.add(JSPsiElementFactory.createJSExpression(value, (PsiElement)callExpression));
                continue;
            }
            int oldIndex = parameter.getOldIndex() - callExpression.getFirstArgumentIndex();
            if (oldIndex < 0) continue;
            if (parameter.isRest() && oldIndex < oldArguments.length) {
                newArguments.addAll(Arrays.asList(oldArguments).subList(oldIndex, oldArguments.length));
                ArrayList<JSExpression> arrayList = newArguments;
                if (arrayList == null) {
                    JSChangeSignatureProcessor.$$$reportNull$$$0(31);
                }
                return arrayList;
            }
            if (oldIndex >= oldArguments.length) continue;
            this.ensureArgumentsCount(newArguments, i, callExpression);
            newArguments.add(oldArguments[oldIndex]);
        }
        ArrayList<JSExpression> arrayList = newArguments;
        if (arrayList == null) {
            JSChangeSignatureProcessor.$$$reportNull$$$0(32);
        }
        return arrayList;
    }

    private void ensureArgumentsCount(@NotNull List<JSExpression> result2, int count, @NotNull JSElement context2) {
        if (result2 == null) {
            JSChangeSignatureProcessor.$$$reportNull$$$0(33);
        }
        if (context2 == null) {
            JSChangeSignatureProcessor.$$$reportNull$$$0(34);
        }
        while (result2.size() < count) {
            String defaultValue = this.myParameters[result2.size()].getInitializer();
            String replacement = result2.size() < this.myParameters.length && !StringUtil.isEmpty((String)defaultValue) ? defaultValue : "undefined";
            result2.add(JSPsiElementFactory.createJSExpression(replacement, (PsiElement)context2));
        }
    }

    private static List<String> computeRequiredActionScriptImports(String text2, PsiElement context2) {
        ArrayList<String> result2 = new ArrayList<String>();
        JSExpression expression = JSChangeUtil.createExpressionPsiWithContext(text2, context2, JSExpression.class);
        if (expression == null) {
            return ContainerUtil.emptyList();
        }
        JSChangeSignatureProcessor.processUnresolvedReferencesForElement((PsiElement)expression, context2, (PairConsumer<JSReferenceExpression, ResolveResult[]>)((PairConsumer)(__, resolveResults) -> {
            String qName;
            if (((ResolveResult[])resolveResults).length != 1) {
                return;
            }
            JSResolveResult resolveResult = (JSResolveResult)resolveResults[0];
            if (resolveResult.getElement() == null || resolveResult.getResolveProblemKind() != null && JSResolveResult.ProblemKind.QUALIFIED_NAME_IS_NOT_IMPORTED != resolveResult.getResolveProblemKind()) {
                return;
            }
            PsiElement resolved = resolveResult.getElement();
            if (JSResolveUtil.isConstructorFunction(resolved)) {
                resolved = resolved.getParent();
            }
            if ((resolved instanceof JSClass || (resolved instanceof JSFunction || resolved instanceof JSVariable) && resolved.getParent() instanceof JSPackageStatement) && (qName = ((JSQualifiedNamedElement)resolved).getQualifiedName()) != null && qName.contains(".") && JSPsiImplUtils.differentPackageName(StringUtil.getPackageName((String)qName), JSResolveUtil.getPackageNameFromPlace(context2))) {
                result2.add(qName);
            }
        }));
        return result2;
    }

    public static void createRequiredES6ImportsForElement(@NotNull PsiElement element, @NotNull PsiElement context2, @NotNull Set<? extends PsiElement> importedElements) {
        if (element == null) {
            JSChangeSignatureProcessor.$$$reportNull$$$0(35);
        }
        if (context2 == null) {
            JSChangeSignatureProcessor.$$$reportNull$$$0(36);
        }
        if (importedElements == null) {
            JSChangeSignatureProcessor.$$$reportNull$$$0(37);
        }
        JSChangeSignatureProcessor.processUnresolvedReferencesForElement(element, context2, (PairConsumer<JSReferenceExpression, ResolveResult[]>)((PairConsumer)(refExpression, resolveResults) -> {
            if (((ResolveResult[])resolveResults).length == 0 || ((ResolveResult[])resolveResults).length == 1 && ((JSResolveResult)resolveResults[0]).getResolveProblemKind() == JSResolveResult.ProblemKind.JS_NEED_TO_BE_IMPORTED) {
                String name = refExpression.getReferenceName();
                if (name == null) {
                    return;
                }
                JSImportAction importAction = new JSImportAction(null, context2, name);
                List acceptableCandidates = importAction.getFilteredCandidates();
                if (acceptableCandidates.size() == 1) {
                    importAction.executeFor(acceptableCandidates.get(0), null);
                }
                if ((acceptableCandidates = ContainerUtil.filter(acceptableCandidates, el -> importedElements.contains(el.getElement()))).size() == 1) {
                    importAction.executeFor((JSImportCandidateWithExecutor)acceptableCandidates.get(0), null);
                }
            }
        }));
    }

    private static void processUnresolvedReferencesForElement(@NotNull PsiElement element, @NotNull PsiElement context2, final @NotNull PairConsumer<JSReferenceExpression, ResolveResult[]> candidateProcessor) {
        if (element == null) {
            JSChangeSignatureProcessor.$$$reportNull$$$0(38);
        }
        if (context2 == null) {
            JSChangeSignatureProcessor.$$$reportNull$$$0(39);
        }
        if (candidateProcessor == null) {
            JSChangeSignatureProcessor.$$$reportNull$$$0(40);
        }
        element.getContainingFile().putUserData(JSResolveUtil.contextKey, (Object)context2);
        element.accept((PsiElementVisitor)new JSRecursiveWalkingElementVisitor(){

            @Override
            public void visitJSReferenceExpression(@NotNull JSReferenceExpression node) {
                Object[] resolveResults;
                if (node == null) {
                    1.$$$reportNull$$$0(0);
                }
                if ((resolveResults = node.multiResolve(false)).length > 1 || ContainerUtil.or((Object[])resolveResults, r -> r.isValidResult() || !(r instanceof JSResolveResult))) {
                    return;
                }
                candidateProcessor.consume((Object)node, (Object)resolveResults);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "node", "com/intellij/lang/javascript/refactoring/changeSignature/JSChangeSignatureProcessor$1", "visitJSReferenceExpression"));
            }
        });
    }

    private static String getEscaped(String value, PsiElement context2) {
        if (value.contains("\"")) {
            if (JSChangeSignatureProcessor.needsApos(context2)) {
                return value.replace('\"', '\'');
            }
        } else if (value.contains("'") && !JSChangeSignatureProcessor.needsApos(context2)) {
            return value.replace('\'', '\"');
        }
        return value;
    }

    private static boolean needsApos(PsiElement context2) {
        if (context2.getContainingFile().getContext() instanceof XmlAttributeValue) {
            return true;
        }
        JSEmbeddedContent embeddedContent = (JSEmbeddedContent)PsiTreeUtil.getParentOfType((PsiElement)context2, JSEmbeddedContent.class, (boolean)true);
        return embeddedContent != null && !(embeddedContent.getParent() instanceof XmlTag);
    }

    private static void addCommaIfNeeded(JSArgumentList newArgList) {
        if (newArgList.getArguments().length > 0) {
            newArgList.addBefore(JSChangeUtil.createCommaPsiElement((PsiElement)newArgList), newArgList.getLastChild());
        }
    }

    @Nullable
    private FormatFixer refactorMethodDeclaration(JSFunction function2, JSPsiElementBase namedElement, RequiredImportProcessor requiredImportProcessor, MultiMap<JSParameter, UsageInfo> paramsUsages) {
        if (StringUtil.isNotEmpty((String)this.myMethodName)) {
            PsiElement element;
            JSExpression expression;
            JSExpression lOperand;
            PsiElement parent;
            if (function2 instanceof JSFunctionExpression && (parent = function2.getParent()) instanceof JSAssignmentExpression && (lOperand = ((JSAssignmentExpression)parent).getLOperand()) instanceof JSDefinitionExpression && (expression = ((JSDefinitionExpression)lOperand).getExpression()) instanceof JSReferenceExpression && (element = ((JSReferenceExpression)expression).resolve()) instanceof JSVariable) {
                ((JSVariable)element).setName(this.myMethodName);
            }
            function2.setName(this.myMethodName);
        }
        if (this.myChangeVisibility && namedElement instanceof JSAttributeListOwner) {
            JSAttributeListWrapper wrapper;
            JSAttributeListOwner attributeListOwner = (JSAttributeListOwner)((Object)namedElement);
            JSClass clazz = JSUtils.getMemberContainingClass((PsiElement)namedElement);
            JSAttributeList attributeList = attributeListOwner.getAttributeList();
            if (clazz != null && (this.myVisibility == JSAttributeList.AccessType.PACKAGE_LOCAL && function2.isConstructor() || clazz.isInterface())) {
                JSChangeVisibilityUtil.removeAccessModifier(function2);
            } else if (attributeList != null && attributeList.getAccessType() != this.myVisibility && this.myVisibility != null && (wrapper = JSChangeVisibilityUtil.createVisibilityOverrideWrapper(attributeListOwner, this.myVisibility, null)) != null) {
                if (this.myForceSharpPrivate) {
                    wrapper.setForcePrivateSharp(true);
                }
                wrapper.applyTo(attributeListOwner, true);
            }
        }
        FormatFixer fixer = null;
        if (this.myMethod.getKind() == function2.getKind()) {
            if (this.getLangForProcessing().getOptionHolder().hasFeature(JSLanguageFeature.TYPES)) {
                JSRefactoringUtil.setType(function2, this.myReturnType);
                requiredImportProcessor.computeImportsForType(this.myReturnType, function2);
            }
            fixer = JSChangeSignatureUtil.setParameters(function2, paramsUsages, requiredImportProcessor, this.getLangForProcessing(), this.myParameters);
        } else if (this.myMethod.isGetProperty() && function2.isSetProperty()) {
            JSParameterListElement[] params = function2.getParameters();
            String name = params.length > 0 ? params[0].getName() : "value";
            fixer = JSChangeSignatureUtil.setParameters(function2, paramsUsages, requiredImportProcessor, this.getLangForProcessing(), new JSParameterInfo(name, this.myReturnType, "", "", -1));
        } else if (this.myMethod.isSetProperty() && function2.isGetProperty()) {
            requiredImportProcessor.computeImportsForType(this.myParameters[0].getTypeText(), function2);
            JSRefactoringUtil.setType(function2, this.myParameters[0].getTypeText());
        }
        return fixer;
    }

    private void refactorFieldDeclaration(@NotNull FieldDeclarationUsageInfo usage, RequiredImportProcessor importProcessor) {
        JSField field;
        if (usage == null) {
            JSChangeSignatureProcessor.$$$reportNull$$$0(41);
        }
        if ((field = usage.getElement()) == null) {
            JSChangeSignatureProcessor.logCouldNotRestoreElement(usage);
            return;
        }
        field.setName(JSRefactoringUtil.transformAccessorNameToPropertyName(this.myMethodName, (PsiElement)field));
        String returnType = this.myMethod.isGetProperty() ? this.myReturnType : this.myParameters[0].getTypeText();
        JSRefactoringUtil.setType(field, returnType);
        importProcessor.computeImportsForType(returnType, (PsiElement)field);
    }

    @NotNull
    protected String getCommandName() {
        String methodDescription = JSFormatUtil.formatMethod(this.myMethod, 4353, 0, 0, null);
        String string = RefactoringBundle.message((String)"changing.signature.of.0", (Object[])new Object[]{methodDescription});
        if (string == null) {
            JSChangeSignatureProcessor.$$$reportNull$$$0(42);
        }
        return string;
    }

    private static int getNumberOfParams(@NotNull JSFunction function2) {
        if (function2 == null) {
            JSChangeSignatureProcessor.$$$reportNull$$$0(43);
        }
        return function2.getParameters().length;
    }

    protected boolean preprocessUsages(@NotNull Ref<UsageInfo[]> refUsages) {
        if (refUsages == null) {
            JSChangeSignatureProcessor.$$$reportNull$$$0(44);
        }
        MultiMap conflicts = new MultiMap();
        JSClass containingClass = JSUtils.getMemberContainingClass((PsiElement)this.myNamedElement);
        for (UsageInfo usageInfo : (UsageInfo[])refUsages.get()) {
            if (usageInfo instanceof FunctionDeclarationUsageInfo) {
                JSFunction pattern;
                JSClass clazz;
                JSPsiElementBase namedElement = ((FunctionDeclarationUsageInfo)usageInfo).getElement();
                JSFunction method = ((FunctionDeclarationUsageInfo)usageInfo).getFunction();
                if (method == null || namedElement == null) {
                    JSChangeSignatureProcessor.logCouldNotRestoreElement(usageInfo);
                    continue;
                }
                boolean ignored = false;
                JSParameterInfo[] paramsOverride = ((FunctionDeclarationUsageInfo)usageInfo).getParamsOverride();
                if (paramsOverride != null || this.myMethod.getKind() == method.getKind()) {
                    if (paramsOverride != null || this.myMethodParamsNumber == JSChangeSignatureProcessor.getNumberOfParams(method)) {
                        JSParameterInfo[] newParameters = paramsOverride != null ? paramsOverride : this.myParameters;
                        JSChangeSignatureProcessor.checkLocalCollisions(namedElement, method, newParameters, (MultiMap<PsiElement, String>)conflicts);
                    } else {
                        String methodDescription = RefactoringUIUtil.getDescription((PsiElement)method, (boolean)true);
                        conflicts.putValue((Object)method, (Object)JavaScriptBundle.message(containingClass != null && containingClass.isInterface() ? "change.signature.conflict.incompatible.implementation" : "change.signature.conflict.incompatible.override", methodDescription, RefactoringUIUtil.getDescription((PsiElement)this.myMethod, (boolean)true), StringUtil.capitalize((String)methodDescription)));
                        ignored = true;
                    }
                } else if (this.myMethod.isGetProperty() && method.isSetProperty()) {
                    JSParameterListElement[] params = method.getParameters();
                    String name = params.length > 0 ? params[0].getName() : "value";
                    JSChangeSignatureProcessor.checkLocalCollisions(namedElement, method, new JSParameterInfo[]{new JSParameterInfo(name, this.myReturnType, "", "", -1)}, (MultiMap<PsiElement, String>)conflicts);
                }
                if (ignored || paramsOverride != null || Objects.equals(this.myMethodName, method.getName()) || (clazz = JSUtils.getMemberContainingClass(method)) == null || (pattern = JSPsiElementFactory.createJSClass("class Dummy{function " + this.myMethodName + "(){}}", this.myMethod).findFunctionByName(this.myMethodName)) == null) continue;
                JSRefactoringConflictsUtil.checkMemberExist(pattern, clazz, (MultiMap<PsiElement, String>)conflicts);
                continue;
            }
            if (usageInfo instanceof FieldDeclarationUsageInfo) {
                JSField field = ((FieldDeclarationUsageInfo)usageInfo).getElement();
                if (field == null) {
                    JSChangeSignatureProcessor.logCouldNotRestoreElement(usageInfo);
                    continue;
                }
                JSClass clazz = JSUtils.getMemberContainingClass((PsiElement)field);
                String fieldName = JSRefactoringUtil.transformAccessorNameToPropertyName(this.myMethodName, this.myMethod);
                JSField pattern = JSPsiElementFactory.createJSClass("class Dummy{var " + fieldName + ";}", this.myMethod).findFieldByName(fieldName);
                if (pattern == null) continue;
                JSRefactoringConflictsUtil.checkMemberExist(pattern, clazz, (MultiMap<PsiElement, String>)conflicts);
                continue;
            }
            if (!(usageInfo instanceof OtherUsageInfo)) continue;
            PsiElement element = usageInfo.getElement();
            if (element == null) {
                JSChangeSignatureProcessor.logCouldNotRestoreElement(usageInfo);
                continue;
            }
            PsiElement elementParent = element.getParent();
            if (elementParent instanceof JSCallExpression && JSChangeSignatureProcessor.hasSpreadElement((JSCallExpression)elementParent)) {
                conflicts.putValue((Object)elementParent, (Object)JavaScriptBundle.message("change.signature.call.expression.contains.spreads", new Object[0]));
            }
            if (!(elementParent instanceof ES6TaggedTemplateExpression) || ((ES6TaggedTemplateExpression)elementParent).getTemplateExpression() != null && JSChangeSignatureProcessor.canChangeTaggedTemplate((OtherUsageInfo)usageInfo)) continue;
            conflicts.putValue((Object)elementParent, (Object)JavaScriptBundle.message("change.signature.tagged.template.issue", new Object[0]));
        }
        if (this.myChangeVisibility && containingClass != null) {
            boolean differentPackages;
            assert (this.myVisibility != null);
            String topClassQName = containingClass.getQualifiedName();
            Ref hasSubMethods = new Ref((Object)false);
            boolean bl = differentPackages = !JSInheritanceUtil.iterateMembersDown(this.myNamedElement, (Processor<? super JSPsiElementBase>)((Processor)jsFunction -> {
                hasSubMethods.set((Object)true);
                String qName = JSUtils.getMemberContainingClass((PsiElement)jsFunction).getQualifiedName();
                return !JSPsiImplUtils.differentPackageName(topClassQName, qName);
            }));
            if (((Boolean)hasSubMethods.get()).booleanValue() && (this.myVisibility == JSAttributeList.AccessType.PRIVATE || differentPackages && this.myVisibility == JSAttributeList.AccessType.PACKAGE_LOCAL)) {
                String message = JavaScriptBundle.message("{0}.visibility.will.break.methods.hierarchy", ElementDescriptionUtil.getElementDescription((PsiElement)this.myNamedElement, (ElementDescriptionLocation)RefactoringDescriptionLocation.WITH_PARENT), JSFormatUtil.formatVisibility(this.myVisibility));
                conflicts.putValue((Object)this.myNamedElement, (Object)StringUtil.capitalize((String)message));
            }
            for (UsageInfo usageInfo : (UsageInfo[])refUsages.get()) {
                JSElement rebindTo;
                if (!(usageInfo instanceof OtherUsageInfo) || !((rebindTo = ((OtherUsageInfo)usageInfo).getRebindTo()) instanceof JSAttributeListOwner)) continue;
                JSRefactoringConflictsUtil.checkAccessibility((JSAttributeListOwner)rebindTo, null, this.myVisibility.name(), usageInfo.getElement(), (MultiMap<PsiElement, String>)conflicts, true, JSVisibilityUtil.DEFAULT_OPTIONS);
            }
        }
        return this.showConflicts(conflicts, (UsageInfo[])refUsages.get());
    }

    private static boolean canChangeTaggedTemplate(OtherUsageInfo usageInfo) {
        JSParameterInfo[] parameters = usageInfo.myParameters;
        if (parameters.length < 1) {
            return false;
        }
        JSParameterInfo parameter = parameters[0];
        if (parameter.getOldIndex() != 0) {
            return false;
        }
        for (JSParameterInfo info2 : parameters) {
            if (!info2.isNew()) continue;
            return false;
        }
        return true;
    }

    private static void checkLocalCollisions(JSPsiElementBase namedElement, JSFunction function2, JSParameterInfo[] newParameters, MultiMap<PsiElement, String> conflicts) {
        HashSet deletedOrRenamedParameters = new HashSet();
        Object[] oldParameters = function2.getParameterVariables();
        ContainerUtil.addAll(deletedOrRenamedParameters, (Object[])oldParameters);
        for (JSParameterInfo parameterInfo : newParameters) {
            if (parameterInfo.isNew()) continue;
            Object oldParameter = oldParameters[parameterInfo.getOldIndex()];
            if (!parameterInfo.getName().equals(oldParameter.getName())) continue;
            deletedOrRenamedParameters.remove(oldParameter);
        }
        boolean isDeclaringMethod = !JSInheritanceUtil.hasSuperMembers(namedElement);
        Condition filter = psiElement -> !(psiElement instanceof JSParameter) || isDeclaringMethod && !deletedOrRenamedParameters.contains(psiElement);
        boolean isTsConstructor = function2.isConstructor() && DialectDetector.isTypeScript(function2);
        for (JSParameterInfo parameterInfo : newParameters) {
            if (parameterInfo.isDestructuringParameter()) continue;
            int oldParameterIndex = parameterInfo.getOldIndex();
            boolean isNewParameter = parameterInfo.isNew();
            if (!isNewParameter) {
                Object parameter = oldParameters[oldParameterIndex];
                if (!parameterInfo.getName().equals(parameter.getName())) {
                    JSChangeSignatureProcessor.reportLocalCollisions(function2, parameterInfo.getName(), false, conflicts, (Condition<PsiElement>)filter);
                }
            } else {
                JSChangeSignatureProcessor.reportLocalCollisions(function2, parameterInfo.getName(), true, conflicts, (Condition<PsiElement>)filter);
            }
            String text2 = parameterInfo.getModifiersText();
            if (!isTsConstructor) continue;
            if (!StringUtil.isEmpty((String)text2)) {
                JSChangeSignatureProcessor.reportFieldCollisions(function2, parameterInfo.getName(), conflicts, isNewParameter);
            }
            if (isNewParameter) continue;
            Object parameter = oldParameters[oldParameterIndex];
            JSChangeSignatureProcessor.checkFieldParameterAccessibilityConflicts((JSParameter)parameter, parameterInfo, conflicts);
        }
    }

    private static void checkFieldParameterAccessibilityConflicts(JSParameter parameter, JSParameterInfo info2, MultiMap<PsiElement, String> conflicts) {
        String oldModifiers;
        String newModifiers = info2.getModifiersText();
        if (Objects.equals(newModifiers, oldModifiers = info2.getOldModifiers()) || StringUtil.isEmpty((String)oldModifiers) || oldModifiers.equals("readonly") && newModifiers != null && newModifiers.equals("public readonly") || oldModifiers.equals("public readonly") && newModifiers != null && newModifiers.equals("readonly")) {
            return;
        }
        boolean wasReadonly = oldModifiers.endsWith("readonly");
        boolean isNowReadonly = !StringUtil.isEmpty((String)newModifiers) && newModifiers.endsWith("readonly");
        JSAttributeList.AccessType oldAccessType = JSChangeSignatureProcessor.getAccessType(oldModifiers);
        assert (oldAccessType != null) : oldModifiers;
        JSAttributeList.AccessType newAccessType = JSChangeSignatureProcessor.getAccessType(newModifiers);
        if (wasReadonly == isNowReadonly || wasReadonly) {
            if (newAccessType == JSAttributeList.AccessType.PUBLIC) {
                return;
            }
            if (newAccessType == JSAttributeList.AccessType.PROTECTED && oldAccessType == JSAttributeList.AccessType.PRIVATE) {
                return;
            }
            if (oldAccessType == newAccessType) {
                return;
            }
        }
        Collection allRefs = ReferencesSearch.search((PsiElement)parameter, (SearchScope)parameter.getUseScope()).findAll();
        for (PsiReference reference : allRefs) {
            PsiElement element = reference.getElement();
            if (newAccessType == null && element instanceof JSReferenceExpression && ((JSReferenceExpression)element).getQualifier() instanceof JSThisExpression) {
                conflicts.putValue((Object)element, (Object)JavaScriptBundle.message("change.signature.conflict.eliminating.parameter.property.breaks.usages", RefactoringUIUtil.getDescription((PsiElement)parameter, (boolean)true)));
            }
            JSRefactoringConflictsUtil.checkAccessibility(parameter, null, newAccessType == null ? JSAttributeList.AccessType.PUBLIC.name() : newAccessType.name(), element, conflicts, true, JSVisibilityUtil.DEFAULT_OPTIONS);
            if (wasReadonly || !isNowReadonly || JSReadWriteAccessDetector.ourInstance.getExpressionAccess(element) == ReadWriteAccessDetector.Access.Read) continue;
            conflicts.putValue((Object)element, (Object)JavaScriptBundle.message("change.signature.conflict.readonly.parameter.property.write.usage", RefactoringUIUtil.getDescription((PsiElement)parameter, (boolean)true)));
        }
    }

    @Nullable
    private static JSAttributeList.AccessType getAccessType(String modifiers) {
        return modifiers.equals("readonly") || modifiers.startsWith("public") ? JSAttributeList.AccessType.PUBLIC : (modifiers.startsWith("private") ? JSAttributeList.AccessType.PRIVATE : (modifiers.startsWith("protected") ? JSAttributeList.AccessType.PROTECTED : null));
    }

    private static void reportFieldCollisions(JSPsiElementBase element, String name, MultiMap<PsiElement, String> conflicts, boolean isNewParameter) {
        JSClass jsClass = JSResolveUtil.getClassOfContext((PsiElement)element);
        if (jsClass == null) {
            return;
        }
        for (JSElement jSElement : jsClass.getMembers()) {
            if (jSElement instanceof JSParameter && TypeScriptPsiUtil.isFieldParameter((JSParameter)jSElement) || !name.equals(jSElement.getName())) continue;
            JSChangeSignatureProcessor.reportThereIsAlreadySameNamedItem(conflicts, isNewParameter, (PsiElement)jSElement, jsClass);
        }
    }

    private static void reportThereIsAlreadySameNamedItem(MultiMap<PsiElement, String> conflicts, boolean isNewParameter, PsiElement member, PsiElement container) {
        String message = RefactoringBundle.message((String)(isNewParameter ? "there.is.already.a.0.in.1.it.will.conflict.with.the.new.parameter" : "there.is.already.a.0.in.the.1.it.will.conflict.with.the.renamed.parameter"), (Object[])new Object[]{RefactoringUIUtil.getDescription((PsiElement)member, (boolean)false), RefactoringUIUtil.getDescription((PsiElement)container, (boolean)true)});
        conflicts.putValue((Object)member, (Object)StringUtil.capitalize((String)message));
    }

    @Nullable
    public static PsiElement getCollidingLocal(JSFunction function2, final String name, final Condition<? super PsiElement> filter) {
        final Ref result2 = new Ref();
        ResolveProcessor processor = new ResolveProcessor(name){

            public boolean execute(@NotNull PsiElement element, @NotNull ResolveState state) {
                if (element == null) {
                    2.$$$reportNull$$$0(0);
                }
                if (state == null) {
                    2.$$$reportNull$$$0(1);
                }
                if (element instanceof JSVariable && name.equals(((JSVariable)element).getName()) && filter.value((Object)element)) {
                    result2.set((Object)element);
                    return false;
                }
                return true;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[3];
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[0] = "element";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[0] = "state";
                        break;
                    }
                }
                objectArray[1] = "com/intellij/lang/javascript/refactoring/changeSignature/JSChangeSignatureProcessor$2";
                objectArray[2] = "execute";
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        };
        function2.processDeclarations(processor, ResolveState.initial(), function2.getFirstChild(), function2);
        return (PsiElement)result2.get();
    }

    private static void reportLocalCollisions(JSFunction function2, String name, boolean newParameter, MultiMap<PsiElement, String> conflicts, Condition<PsiElement> filter) {
        PsiElement element = JSChangeSignatureProcessor.getCollidingLocal(function2, name, filter);
        if (element != null) {
            JSChangeSignatureProcessor.reportThereIsAlreadySameNamedItem(conflicts, newParameter, element, function2);
        }
    }

    protected boolean shouldPropagate(PsiElement element) {
        return this.myMethodsToPropagateParameters.contains(PsiTreeUtil.getParentOfType((PsiElement)element, JSFunction.class));
    }

    @NotNull
    private JSLanguageDialect getLangForProcessing() {
        JSLanguageDialect dialect = DialectDetector.languageDialectOfElement(this.myMethod);
        JSLanguageDialect jSLanguageDialect = dialect != null ? dialect : JavaScriptSupportLoader.ECMA_SCRIPT_L4;
        if (jSLanguageDialect == null) {
            JSChangeSignatureProcessor.$$$reportNull$$$0(45);
        }
        return jSLanguageDialect;
    }

    private static boolean supportsVisibilityModifiers(@NotNull JSLanguageDialect dialect) {
        if (dialect == null) {
            JSChangeSignatureProcessor.$$$reportNull$$$0(46);
        }
        return dialect.getOptionHolder().hasFeature(JSLanguageFeature.VISIBILITY_MODIFIERS);
    }

    private static void logCouldNotRestoreElement(@NotNull UsageInfo u) {
        if (u == null) {
            JSChangeSignatureProcessor.$$$reportNull$$$0(47);
        }
        LOG.error(String.format("Could not restore element from pointer [%s] in usageInfo [%s]", u.getSmartPointer(), u));
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 6, 14, 24, 31, 32, 42, 45 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "method";
                break;
            }
            case 2: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "usages";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "declarationsFilter";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "callFilter";
                break;
            }
            case 6: 
            case 14: 
            case 24: 
            case 31: 
            case 32: 
            case 42: 
            case 45: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/javascript/refactoring/changeSignature/JSChangeSignatureProcessor";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "namedElement";
                break;
            }
            case 8: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "declarationConsumer";
                break;
            }
            case 9: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "getReferenceConsumer";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "member";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "usageInfos";
                break;
            }
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "el";
                break;
            }
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "target";
                break;
            }
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "referenceExpression";
                break;
            }
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "taggedTemplateExpression";
                break;
            }
            case 19: 
            case 22: 
            case 26: 
            case 29: {
                objectArray2 = objectArray3;
                objectArray3[0] = "importProcessor";
                break;
            }
            case 20: 
            case 23: {
                objectArray2 = objectArray3;
                objectArray3[0] = "originalParameters";
                break;
            }
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "pipeExpression";
                break;
            }
            case 25: 
            case 28: {
                objectArray2 = objectArray3;
                objectArray3[0] = "callExpression";
                break;
            }
            case 27: 
            case 30: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parameters";
                break;
            }
            case 33: {
                objectArray2 = objectArray3;
                objectArray3[0] = "result";
                break;
            }
            case 34: 
            case 36: 
            case 39: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 35: 
            case 38: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 37: {
                objectArray2 = objectArray3;
                objectArray3[0] = "importedElements";
                break;
            }
            case 40: {
                objectArray2 = objectArray3;
                objectArray3[0] = "candidateProcessor";
                break;
            }
            case 41: {
                objectArray2 = objectArray3;
                objectArray3[0] = "usage";
                break;
            }
            case 43: {
                objectArray2 = objectArray3;
                objectArray3[0] = "function";
                break;
            }
            case 44: {
                objectArray2 = objectArray3;
                objectArray3[0] = "refUsages";
                break;
            }
            case 46: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dialect";
                break;
            }
            case 47: {
                objectArray2 = objectArray3;
                objectArray3[0] = "u";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/javascript/refactoring/changeSignature/JSChangeSignatureProcessor";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "findUsages";
                break;
            }
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "createImportProcessor";
                break;
            }
            case 24: {
                objectArray = objectArray2;
                objectArray2[1] = "refactorPipe";
                break;
            }
            case 31: 
            case 32: {
                objectArray = objectArray2;
                objectArray2[1] = "buildCallArgumentsList";
                break;
            }
            case 42: {
                objectArray = objectArray2;
                objectArray2[1] = "getCommandName";
                break;
            }
            case 45: {
                objectArray = objectArray2;
                objectArray2[1] = "getLangForProcessing";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "getAfterData";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "setDeclarationsFilter";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "setCallFilter";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "createUsageViewDescriptor";
                break;
            }
            case 6: 
            case 14: 
            case 24: 
            case 31: 
            case 32: 
            case 42: 
            case 45: {
                break;
            }
            case 7: 
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "processMember";
                break;
            }
            case 10: 
            case 11: 
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "processMemberWithHierarchy";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "performRefactoring";
                break;
            }
            case 15: 
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "rebindTarget";
                break;
            }
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "resolveInModule";
                break;
            }
            case 18: 
            case 19: 
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "refactorTaggedTemplate";
                break;
            }
            case 21: 
            case 22: 
            case 23: {
                objectArray = objectArray;
                objectArray[2] = "refactorPipe";
                break;
            }
            case 25: 
            case 26: 
            case 27: {
                objectArray = objectArray;
                objectArray[2] = "refactorCall";
                break;
            }
            case 28: 
            case 29: 
            case 30: {
                objectArray = objectArray;
                objectArray[2] = "buildCallArgumentsList";
                break;
            }
            case 33: 
            case 34: {
                objectArray = objectArray;
                objectArray[2] = "ensureArgumentsCount";
                break;
            }
            case 35: 
            case 36: 
            case 37: {
                objectArray = objectArray;
                objectArray[2] = "createRequiredES6ImportsForElement";
                break;
            }
            case 38: 
            case 39: 
            case 40: {
                objectArray = objectArray;
                objectArray[2] = "processUnresolvedReferencesForElement";
                break;
            }
            case 41: {
                objectArray = objectArray;
                objectArray[2] = "refactorFieldDeclaration";
                break;
            }
            case 43: {
                objectArray = objectArray;
                objectArray[2] = "getNumberOfParams";
                break;
            }
            case 44: {
                objectArray = objectArray;
                objectArray[2] = "preprocessUsages";
                break;
            }
            case 46: {
                objectArray = objectArray;
                objectArray[2] = "supportsVisibilityModifiers";
                break;
            }
            case 47: {
                objectArray = objectArray;
                objectArray[2] = "logCouldNotRestoreElement";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 6, 14, 24, 31, 32, 42, 45 -> new IllegalStateException(string);
        };
    }

    class MyProcessor
    implements Consumer<PsiReference> {
        @NotNull
        private final Collection<OtherUsageInfo> myUsages;
        private final JSElement myRebindTo;
        private final JSParameterInfo[] myParameters;
        private final Trinity<Integer, Integer, Boolean> myMinMaxParameters;

        MyProcessor(@Nullable Collection<OtherUsageInfo> usages, @Nullable JSElement rebindTo, @NotNull JSFunction function2, JSParameterInfo[] parameters) {
            if (usages == null) {
                MyProcessor.$$$reportNull$$$0(0);
            }
            if (parameters == null) {
                MyProcessor.$$$reportNull$$$0(1);
            }
            this.myUsages = usages;
            this.myRebindTo = rebindTo;
            this.myParameters = parameters;
            this.myMinMaxParameters = function2 != null ? ValidateTypesUtil.getMinMaxParameters(function2.getParameters()) : Trinity.create((Object)0, (Object)0, (Object)false);
        }

        @Override
        public void accept(PsiReference psiReference) {
            if (!JSDefaultRenameProcessor.isStrictEnoughReference(psiReference)) {
                return;
            }
            PsiElement element = psiReference.getElement();
            if (JSResolveUtil.isSelfReference(element)) {
                return;
            }
            this.myUsages.add(new OtherUsageInfo(element, this.myRebindTo, this.myParameters, JSChangeSignatureProcessor.this.shouldPropagate(element), (Integer)this.myMinMaxParameters.first, (Integer)this.myMinMaxParameters.second));
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "usages";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "parameters";
                    break;
                }
            }
            objectArray[1] = "com/intellij/lang/javascript/refactoring/changeSignature/JSChangeSignatureProcessor$MyProcessor";
            objectArray[2] = "<init>";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    static class FunctionDeclarationUsageInfo
    extends UsageInfo {
        private final JSParameterInfo[] myParamsOverride;
        private final MultiMap<JSParameter, UsageInfo> myParamsUsages;

        FunctionDeclarationUsageInfo(@NotNull JSPsiElementBase element, JSParameterInfo @Nullable [] paramsOverride) {
            if (element == null) {
                FunctionDeclarationUsageInfo.$$$reportNull$$$0(0);
            }
            super((PsiElement)element);
            this.myParamsUsages = new MultiMap();
            this.myParamsOverride = paramsOverride;
        }

        @Nullable
        public JSPsiElementBase getElement() {
            return (JSPsiElementBase)ObjectUtils.tryCast((Object)super.getElement(), JSPsiElementBase.class);
        }

        @Nullable
        protected JSFunction getFunction() {
            JSPsiElementBase element = this.getElement();
            return element != null ? JSChangeSignatureUtil.getFunctionFromMember((PsiElement)element) : null;
        }

        public JSParameterInfo[] getParamsOverride() {
            return this.myParamsOverride;
        }

        public MultiMap<JSParameter, UsageInfo> getParamsUsages() {
            return this.myParamsUsages;
        }

        public void searchForParametersUsages() {
            JSFunction function2 = this.getFunction();
            if (function2 == null) {
                return;
            }
            JSParameterList parameterList = function2.getParameterList();
            if (parameterList == null) {
                return;
            }
            for (JSParameter parameter : parameterList.getParameterVariables()) {
                for (PsiReference reference : ReferencesSearch.search((PsiElement)parameter, (SearchScope)parameter.getUseScope()).findAll()) {
                    if (JSResolveUtil.isSelfReference((PsiElement)parameter, reference.getElement())) continue;
                    this.myParamsUsages.putValue((Object)parameter, (Object)new UsageInfo(reference));
                }
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/lang/javascript/refactoring/changeSignature/JSChangeSignatureProcessor$FunctionDeclarationUsageInfo", "<init>"));
        }
    }

    private static class FieldDeclarationUsageInfo
    extends UsageInfo {
        FieldDeclarationUsageInfo(JSField field) {
            super((PsiElement)field);
        }

        public JSField getElement() {
            return (JSField)super.getElement();
        }
    }

    public static interface RequiredImportProcessor {
        public static final RequiredImportProcessor EMPTY = new RequiredImportProcessor(){

            @Override
            public void computeImportsForExpression(@Nullable String newlyAddedText, @NotNull PsiElement context2) {
                if (context2 == null) {
                    1.$$$reportNull$$$0(0);
                }
            }

            @Override
            public void computeImportsForType(@Nullable String newlyAddedType, @NotNull PsiElement context2) {
                if (context2 == null) {
                    1.$$$reportNull$$$0(1);
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[3];
                objectArray2[0] = "context";
                objectArray2[1] = "com/intellij/lang/javascript/refactoring/changeSignature/JSChangeSignatureProcessor$RequiredImportProcessor$1";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[2] = "computeImportsForExpression";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[2] = "computeImportsForType";
                        break;
                    }
                }
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        };

        public void computeImportsForExpression(@Nullable String var1, @NotNull PsiElement var2);

        public void computeImportsForType(@Nullable String var1, @NotNull PsiElement var2);

        default public void finish() {
        }
    }

    protected static class OtherUsageInfo
    extends UsageInfo {
        @Nullable
        private final SmartPsiElementPointer<JSElement> myRebindTo;
        private final JSParameterInfo[] myParameters;
        private final boolean myPropagate;
        private final int myMinParams;
        private final int myMaxParams;

        public OtherUsageInfo(PsiElement element, @Nullable JSElement rebindTo, JSParameterInfo[] parameters, boolean propagate, int minParams, int maxParams) {
            super(element);
            this.myRebindTo = rebindTo == null ? null : SmartPointerManager.getInstance((Project)this.getProject()).createSmartPsiElementPointer((PsiElement)rebindTo);
            this.myParameters = parameters;
            this.myPropagate = propagate;
            this.myMinParams = minParams;
            this.myMaxParams = maxParams;
        }

        @Nullable
        public JSElement getRebindTo() {
            return this.myRebindTo == null ? null : (JSElement)this.myRebindTo.getElement();
        }

        public JSParameterInfo[] getParameters() {
            return this.myParameters;
        }

        public boolean isPropagate() {
            return this.myPropagate;
        }
    }

    private static class ActionScriptImportProcessor
    implements RequiredImportProcessor {
        private final MultiMap<PsiElement, String> imports = new MultiMap();

        private ActionScriptImportProcessor() {
        }

        @Override
        public void computeImportsForExpression(@Nullable String newlyAddedText, @NotNull PsiElement context2) {
            if (context2 == null) {
                ActionScriptImportProcessor.$$$reportNull$$$0(0);
            }
            this.imports.putValues((Object)context2, JSChangeSignatureProcessor.computeRequiredActionScriptImports(newlyAddedText, context2));
        }

        @Override
        public void computeImportsForType(@Nullable String type2, @NotNull PsiElement context2) {
            if (context2 == null) {
                ActionScriptImportProcessor.$$$reportNull$$$0(1);
            }
            String currentPackage = JSResolveUtil.getPackageNameFromPlace(context2);
            if (type2 != null && type2.contains(".") && JSPsiImplUtils.differentPackageName(StringUtil.getPackageName((String)type2), currentPackage)) {
                this.imports.putValue((Object)context2, (Object)type2);
            }
        }

        @Override
        public void finish() {
            List elements = ContainerUtil.map((Collection)this.imports.keySet(), SmartPointerManager::createPointer);
            for (Map.Entry entry : this.imports.entrySet()) {
                FormatFixer formatFixer;
                if (((Collection)entry.getValue()).isEmpty() || (formatFixer = ImportUtils.insertImportStatements((PsiElement)entry.getKey(), (Collection)entry.getValue())) == null) continue;
                formatFixer.fixFormat();
            }
            List<PsiFile> toOptimizeImports = elements.stream().map(element -> element.getContainingFile()).filter(file -> file != null).distinct().toList();
            ArrayList<FormatFixer> formatters = new ArrayList<FormatFixer>();
            for (PsiFile file2 : toOptimizeImports) {
                formatters.addAll(ECMAScriptImportOptimizer.executeNoFormat(file2));
            }
            JSRefactoringUtil.format(formatters);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            objectArray2[0] = "context";
            objectArray2[1] = "com/intellij/lang/javascript/refactoring/changeSignature/JSChangeSignatureProcessor$ActionScriptImportProcessor";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "computeImportsForExpression";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "computeImportsForType";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private static class ES6CompatibleImportProcessor
    implements RequiredImportProcessor {
        @NotNull
        private final Set<? extends PsiElement> myImportedElements;

        ES6CompatibleImportProcessor(@NotNull Set<? extends PsiElement> importedElements) {
            if (importedElements == null) {
                ES6CompatibleImportProcessor.$$$reportNull$$$0(0);
            }
            this.myImportedElements = importedElements;
        }

        @Override
        public void computeImportsForExpression(@Nullable String newlyAddedText, @NotNull PsiElement context2) {
            if (context2 == null) {
                ES6CompatibleImportProcessor.$$$reportNull$$$0(1);
            }
            if (StringUtil.isEmpty((String)newlyAddedText)) {
                return;
            }
            JSExpression expression = JSChangeUtil.createExpressionPsiWithContext(newlyAddedText, context2, JSExpression.class);
            if (expression == null) {
                return;
            }
            JSChangeSignatureProcessor.createRequiredES6ImportsForElement((PsiElement)expression, context2, this.myImportedElements);
        }

        @Override
        public void computeImportsForType(@Nullable String newlyAddedType, @NotNull PsiElement context2) {
            if (context2 == null) {
                ES6CompatibleImportProcessor.$$$reportNull$$$0(2);
            }
            if (StringUtil.isEmpty((String)newlyAddedType) || !DialectDetector.hasFeature(context2, JSLanguageFeature.TYPES)) {
                return;
            }
            TypeScriptType type2 = JSPsiElementFactory.createTypeScriptType(newlyAddedType, context2);
            JSChangeSignatureProcessor.createRequiredES6ImportsForElement((PsiElement)type2, context2, this.myImportedElements);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "importedElements";
                    break;
                }
                case 1: 
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "context";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/lang/javascript/refactoring/changeSignature/JSChangeSignatureProcessor$ES6CompatibleImportProcessor";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "computeImportsForExpression";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[2] = "computeImportsForType";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

