/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.psi.types.recordImpl;

import com.intellij.lang.javascript.psi.JSRecordType;
import com.intellij.lang.javascript.psi.JSType;
import com.intellij.lang.javascript.psi.types.JSRecordMemberSourceFactory;
import com.intellij.lang.javascript.psi.types.guard.JSTypeGuardUtil;
import com.intellij.lang.javascript.psi.types.recordImpl.PropertySignatureCommonImpl;
import com.intellij.psi.PsiElement;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PropertySignatureImpl
implements PropertySignatureCommonImpl {
    @NotNull
    private final String name;
    @Nullable
    private final JSType type;
    @Nullable
    private final JSType setterType;
    private final boolean optional;
    private final boolean privateName;
    private final int privateNameDepth;
    private final boolean isReadonly;
    @NotNull
    private final JSRecordType.MemberSource mySource;
    private final boolean myIsNumericKey;
    private volatile JSType myKeyType;

    public PropertySignatureImpl(@NotNull String name, @Nullable JSType type2, boolean optional, boolean isReadonly, @Nullable PsiElement singleSource) {
        if (name == null) {
            PropertySignatureImpl.$$$reportNull$$$0(0);
        }
        this(name, type2, optional, isReadonly, JSRecordMemberSourceFactory.createSource(singleSource));
    }

    public PropertySignatureImpl(@NotNull String name, boolean privateName, int privateNameDepth, boolean isReadonly, @Nullable JSType type2, boolean optional, @Nullable PsiElement singleSource) {
        if (name == null) {
            PropertySignatureImpl.$$$reportNull$$$0(1);
        }
        this(name, privateName, privateNameDepth, isReadonly, type2, null, optional, false, JSRecordMemberSourceFactory.createSource(singleSource));
    }

    public PropertySignatureImpl(@NotNull String name, @Nullable JSType type2, boolean optional, boolean isReadonly, @NotNull JSRecordType.MemberSource source) {
        if (name == null) {
            PropertySignatureImpl.$$$reportNull$$$0(2);
        }
        if (source == null) {
            PropertySignatureImpl.$$$reportNull$$$0(3);
        }
        this(name, false, -1, isReadonly, type2, null, optional, false, source);
    }

    public PropertySignatureImpl(@NotNull String name, boolean privateName, int privateNameDepth, boolean isReadonly, @Nullable JSType type2, @Nullable JSType keyType, boolean optional, boolean isNumericKey, @NotNull JSRecordType.MemberSource source) {
        if (name == null) {
            PropertySignatureImpl.$$$reportNull$$$0(4);
        }
        if (source == null) {
            PropertySignatureImpl.$$$reportNull$$$0(5);
        }
        this(name, privateName, privateNameDepth, isReadonly, type2, keyType, null, optional, isNumericKey, source);
    }

    public PropertySignatureImpl(@NotNull String name, boolean privateName, int privateNameDepth, boolean isReadonly, @Nullable JSType type2, @Nullable JSType keyType, @Nullable JSType setterType, boolean optional, boolean isNumericKey, @NotNull JSRecordType.MemberSource source) {
        if (name == null) {
            PropertySignatureImpl.$$$reportNull$$$0(6);
        }
        if (source == null) {
            PropertySignatureImpl.$$$reportNull$$$0(7);
        }
        this.name = name;
        this.privateName = privateName;
        this.privateNameDepth = privateNameDepth;
        this.type = type2;
        this.setterType = setterType;
        this.optional = optional;
        this.isReadonly = isReadonly;
        this.mySource = source;
        this.myIsNumericKey = isNumericKey;
        this.myKeyType = keyType;
    }

    public PropertySignatureImpl(@NotNull String name, boolean privateName, int privateNameDepth, boolean isReadonly, @Nullable JSType type2, boolean optional) {
        if (name == null) {
            PropertySignatureImpl.$$$reportNull$$$0(8);
        }
        this(name, privateName, privateNameDepth, isReadonly, type2, null, optional, false, JSRecordMemberSourceFactory.createEmptySource());
    }

    public PropertySignatureImpl(@NotNull String name, @Nullable JSType type2, boolean optional, boolean isReadonly) {
        if (name == null) {
            PropertySignatureImpl.$$$reportNull$$$0(9);
        }
        this(name, false, -1, isReadonly, type2, null, optional, false, JSRecordMemberSourceFactory.createEmptySource());
    }

    @Override
    @NotNull
    public String getMemberName() {
        String string = this.name;
        if (string == null) {
            PropertySignatureImpl.$$$reportNull$$$0(10);
        }
        return string;
    }

    @Override
    @Nullable
    public JSType getJSType() {
        return this.type;
    }

    @Override
    @Nullable
    public JSType getSetterJSType() {
        return this.setterType != null ? this.setterType : this.type;
    }

    @Override
    public boolean isPrivateName() {
        return this.privateName;
    }

    @Override
    public int getPrivateNameDepth() {
        return this.privateNameDepth;
    }

    @Override
    @Nullable
    public JSType getKeyType() {
        if (this.myKeyType == null) {
            this.myKeyType = this.getKeyTypeImpl();
        }
        return this.myKeyType;
    }

    @Nullable
    private JSType getKeyTypeImpl() {
        return PropertySignatureCommonImpl.super.getKeyType();
    }

    @Override
    @Nullable
    public JSType getJSTypeWithOptionality() {
        JSType type2 = this.getJSType();
        if (this.isOptional() && type2 != null) {
            return JSTypeGuardUtil.wrapWithUndefined(type2, type2.getSource());
        }
        return type2;
    }

    @Override
    public boolean isOptional() {
        return this.optional;
    }

    @Override
    @NotNull
    public JSRecordType.MemberSource getMemberSource() {
        JSRecordType.MemberSource memberSource = this.mySource;
        if (memberSource == null) {
            PropertySignatureImpl.$$$reportNull$$$0(11);
        }
        return memberSource;
    }

    public String toString() {
        return "PropertySignatureImpl@" + this.name;
    }

    @Override
    public boolean isConst() {
        return this.isReadonly;
    }

    @Override
    public boolean isNumericKey() {
        return this.myIsNumericKey;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 10, 11 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 3: 
            case 5: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "source";
                break;
            }
            case 10: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/javascript/psi/types/recordImpl/PropertySignatureImpl";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/javascript/psi/types/recordImpl/PropertySignatureImpl";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "getMemberName";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "getMemberSource";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 10: 
            case 11: {
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 10, 11 -> new IllegalStateException(string);
        };
    }
}

