/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.psi.types.guard;

import com.intellij.lang.javascript.JSTokenTypes;
import com.intellij.lang.javascript.ecmascript6.TypeScriptUtil;
import com.intellij.lang.javascript.psi.JSArrayLiteralExpression;
import com.intellij.lang.javascript.psi.JSAssignmentExpression;
import com.intellij.lang.javascript.psi.JSBinaryExpression;
import com.intellij.lang.javascript.psi.JSCommonTypeNames;
import com.intellij.lang.javascript.psi.JSExpression;
import com.intellij.lang.javascript.psi.JSField;
import com.intellij.lang.javascript.psi.JSInitializerOwner;
import com.intellij.lang.javascript.psi.JSOptionalOwner;
import com.intellij.lang.javascript.psi.JSParameter;
import com.intellij.lang.javascript.psi.JSParenthesizedExpression;
import com.intellij.lang.javascript.psi.JSRecordType;
import com.intellij.lang.javascript.psi.JSReferenceExpression;
import com.intellij.lang.javascript.psi.JSType;
import com.intellij.lang.javascript.psi.JSTypeOwner;
import com.intellij.lang.javascript.psi.JSTypeUtils;
import com.intellij.lang.javascript.psi.JSVariable;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptEnumField;
import com.intellij.lang.javascript.psi.ecma6.impl.TypeScriptFieldImpl;
import com.intellij.lang.javascript.psi.ecmal4.JSAttributeList;
import com.intellij.lang.javascript.psi.resolve.JSEvaluateContext;
import com.intellij.lang.javascript.psi.resolve.JSResolveUtil;
import com.intellij.lang.javascript.psi.resolve.JSTypeGuardEvaluator;
import com.intellij.lang.javascript.psi.types.JSAnyType;
import com.intellij.lang.javascript.psi.types.JSBigIntLiteralTypeImpl;
import com.intellij.lang.javascript.psi.types.JSCompositeTypeFactory;
import com.intellij.lang.javascript.psi.types.JSContext;
import com.intellij.lang.javascript.psi.types.JSElvisType;
import com.intellij.lang.javascript.psi.types.JSLiteralType;
import com.intellij.lang.javascript.psi.types.JSNamedTypeFactory;
import com.intellij.lang.javascript.psi.types.JSNumberLiteralTypeImpl;
import com.intellij.lang.javascript.psi.types.JSPsiBasedTypeOfType;
import com.intellij.lang.javascript.psi.types.JSRecordTypeImpl;
import com.intellij.lang.javascript.psi.types.JSResolvableType;
import com.intellij.lang.javascript.psi.types.JSResolvedTypeInfo;
import com.intellij.lang.javascript.psi.types.JSStringLiteralTypeImpl;
import com.intellij.lang.javascript.psi.types.JSTemplateLiteralType;
import com.intellij.lang.javascript.psi.types.JSTypeSource;
import com.intellij.lang.javascript.psi.types.JSTypeSourceFactory;
import com.intellij.lang.javascript.psi.types.JSUnionOrIntersectionType;
import com.intellij.lang.javascript.psi.types.JSUnionType;
import com.intellij.lang.javascript.psi.types.TypeScriptStringMappingTypeImpl;
import com.intellij.lang.javascript.psi.types.guard.JSTypeGuardChecker;
import com.intellij.lang.javascript.psi.types.guard.TypeScriptTypeRelations;
import com.intellij.lang.javascript.psi.types.guard.operations.JSApplyTypeOperationContext;
import com.intellij.lang.javascript.psi.types.primitives.JSBigIntType;
import com.intellij.lang.javascript.psi.types.primitives.JSNullType;
import com.intellij.lang.javascript.psi.types.primitives.JSNumberType;
import com.intellij.lang.javascript.psi.types.primitives.JSObjectType;
import com.intellij.lang.javascript.psi.types.primitives.JSPrimitiveFunctionType;
import com.intellij.lang.javascript.psi.types.primitives.JSStringType;
import com.intellij.lang.javascript.psi.types.primitives.JSUndefinedType;
import com.intellij.lang.javascript.psi.types.primitives.TypeScriptNeverType;
import com.intellij.lang.javascript.psi.types.recordImpl.PropertySignatureImpl;
import com.intellij.lang.javascript.psi.util.JSDestructuringUtil;
import com.intellij.lang.typescript.psi.TypeScriptPsiUtil;
import com.intellij.lang.typescript.tsconfig.TypeScriptConfig;
import com.intellij.lang.typescript.tsconfig.TypeScriptConfigUtil;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.tree.IElementType;
import com.intellij.util.ArrayUtil;
import com.intellij.util.Function;
import com.intellij.util.NullableFunction;
import com.intellij.util.ProcessingContext;
import com.intellij.util.containers.ContainerUtil;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class JSTypeGuardUtil {
    @NotNull
    public static JSType appendProperty(@NotNull JSType type2, @NotNull String name, @Nullable PsiElement navigationElement, @NotNull PsiElement context2) {
        if (type2 == null) {
            JSTypeGuardUtil.$$$reportNull$$$0(0);
        }
        if (name == null) {
            JSTypeGuardUtil.$$$reportNull$$$0(1);
        }
        if (context2 == null) {
            JSTypeGuardUtil.$$$reportNull$$$0(2);
        }
        if (StringUtil.isEmpty((String)name)) {
            JSType jSType = type2;
            if (jSType == null) {
                JSTypeGuardUtil.$$$reportNull$$$0(3);
            }
            return jSType;
        }
        if (!JSTypeGuardUtil.isTypeCanBeExtended(type2, name)) {
            JSType jSType = type2;
            if (jSType == null) {
                JSTypeGuardUtil.$$$reportNull$$$0(4);
            }
            return jSType;
        }
        PropertySignatureImpl signature = new PropertySignatureImpl(name, null, false, false, navigationElement);
        JSTypeSource source = JSTypeSourceFactory.createTypeSource(context2, false);
        List<JSType> types2 = List.of(new JSRecordTypeImpl(source, Collections.singletonList(signature)), type2);
        return JSTypeGuardUtil.getUnionType(types2, source);
    }

    private static boolean isTypeCanBeExtended(@NotNull JSType type2, @NotNull String name) {
        if (type2 == null) {
            JSTypeGuardUtil.$$$reportNull$$$0(5);
        }
        if (name == null) {
            JSTypeGuardUtil.$$$reportNull$$$0(6);
        }
        if (!type2.isSourceStrict() && !(type2 instanceof JSRecordType)) {
            return true;
        }
        JSRecordType record = type2.asRecordType();
        return record.findPropertySignature(name) == null;
    }

    public static boolean isSourceTypeAnyAndTargetTypeFunctionOrObject(@Nullable JSType type2, @Nullable JSType guardType) {
        return type2 instanceof JSAnyType && (guardType instanceof JSPrimitiveFunctionType || guardType instanceof JSObjectType);
    }

    @NotNull
    public static JSType getUnionType(@NotNull Collection<? extends JSType> types2, @NotNull JSTypeSource source) {
        if (types2 == null) {
            JSTypeGuardUtil.$$$reportNull$$$0(7);
        }
        if (source == null) {
            JSTypeGuardUtil.$$$reportNull$$$0(8);
        }
        JSType jSType = TypeScriptTypeRelations.getUnionType(types2, source);
        if (jSType == null) {
            JSTypeGuardUtil.$$$reportNull$$$0(9);
        }
        return jSType;
    }

    public static boolean isPrimitiveType(@NotNull String name) {
        if (name == null) {
            JSTypeGuardUtil.$$$reportNull$$$0(10);
        }
        return ArrayUtil.contains((String)name, (String[])JSCommonTypeNames.TYPEOF_VALUES);
    }

    @Nullable
    public static JSExpression getReferenceCandidate(@Nullable JSExpression expression) {
        if (expression instanceof JSParenthesizedExpression) {
            return JSTypeGuardUtil.getReferenceCandidate(((JSParenthesizedExpression)expression).getInnerExpression());
        }
        if (expression instanceof JSBinaryExpression) {
            IElementType sign = ((JSBinaryExpression)expression).getOperationSign();
            if (sign == JSTokenTypes.EQ) {
                return JSTypeGuardUtil.getReferenceCandidate(((JSBinaryExpression)expression).getLOperand());
            }
            if (sign == JSTokenTypes.COMMA) {
                return JSTypeGuardUtil.getReferenceCandidate(((JSBinaryExpression)expression).getROperand());
            }
        }
        return expression;
    }

    public static JSType replacePrimitivesWithLiterals(@Nullable JSType typeWithPrimitives, @Nullable JSType typeWithLiterals, @NotNull PsiElement context2) {
        if (context2 == null) {
            JSTypeGuardUtil.$$$reportNull$$$0(11);
        }
        if (typeWithPrimitives == null || typeWithLiterals == null) {
            return typeWithPrimitives;
        }
        if (!JSTypeUtils.hasTypes(typeWithPrimitives, JSStringType.class, JSNumberType.class, JSBigIntType.class, JSTemplateLiteralType.class)) {
            return typeWithPrimitives;
        }
        if (!JSTypeUtils.hasTypes(typeWithLiterals, JSNumberLiteralTypeImpl.class, JSBigIntLiteralTypeImpl.class, JSStringLiteralTypeImpl.class, JSTemplateLiteralType.class, TypeScriptStringMappingTypeImpl.class)) {
            return typeWithPrimitives;
        }
        JSType numberLiterals = TypeScriptTypeRelations.filterType(typeWithLiterals, t -> t instanceof JSNumberType, context2);
        JSType bigIntLiterals = TypeScriptTypeRelations.filterType(typeWithLiterals, t -> t instanceof JSBigIntType, context2);
        JSType stringLiterals = TypeScriptTypeRelations.filterType(typeWithLiterals, t -> t instanceof JSStringType || t instanceof JSTemplateLiteralType || t instanceof TypeScriptStringMappingTypeImpl, context2);
        JSType patternLiterals = TypeScriptTypeRelations.filterType(typeWithLiterals, t -> t instanceof JSStringLiteralTypeImpl, context2);
        if (numberLiterals instanceof TypeScriptNeverType && stringLiterals instanceof TypeScriptNeverType && bigIntLiterals instanceof TypeScriptNeverType && patternLiterals instanceof TypeScriptNeverType) {
            return typeWithPrimitives;
        }
        boolean isCompatibleWithPatternLiteral = !JSTypeUtils.hasTypes(typeWithLiterals, t -> t instanceof JSTemplateLiteralType || t instanceof TypeScriptStringMappingTypeImpl || t instanceof JSStringType && !(t instanceof JSLiteralType));
        return typeWithPrimitives.transformTypeHierarchy((Function<? super JSType, ? extends JSType>)((Function)toProcess -> {
            if (toProcess instanceof JSLiteralType) {
                return toProcess;
            }
            if (toProcess instanceof JSNumberType) {
                return numberLiterals;
            }
            if (toProcess instanceof JSBigIntType) {
                return bigIntLiterals;
            }
            if (toProcess instanceof JSStringType) {
                return stringLiterals;
            }
            if (TypeScriptTypeRelations.isPatternLiteralType(toProcess) && isCompatibleWithPatternLiteral) {
                return patternLiterals;
            }
            return toProcess;
        }));
    }

    @Contract(value="null->null; !null->!null")
    @Nullable
    public static JSType getBaseTypeOfLiteralType(@Nullable JSType type2) {
        JSResolvedTypeInfo resolvedType;
        if (type2 == null) {
            return null;
        }
        if ((type2 = JSTypeUtils.unwrapType(type2)) instanceof JSResolvableType && type2.isTypeScript() && (resolvedType = ((JSResolvableType)type2).resolveType()).isEnumLiteral()) {
            return TypeScriptUtil.getBaseTypeOfEnumLiteralType((JSResolvableType)type2);
        }
        if (type2 instanceof JSLiteralType) {
            return ((JSLiteralType)type2).asPrimitiveType();
        }
        if (type2 instanceof JSUnionType) {
            return ((JSUnionType)type2).transformTypes((NullableFunction<? super JSType, JSType>)((NullableFunction)JSTypeGuardUtil::getBaseTypeOfLiteralType));
        }
        return type2;
    }

    @Nullable
    public static JSExpression getInitializerExpression(@Nullable PsiElement element) {
        if (element instanceof JSAssignmentExpression) {
            element = ((JSAssignmentExpression)element).getDefinitionExpression();
        }
        if (element instanceof JSInitializerOwner) {
            return ((JSInitializerOwner)element).getInitializer();
        }
        return null;
    }

    public static boolean isDiscriminantType(@Nullable JSType rawType) {
        if (rawType == null) {
            return false;
        }
        if (JSTypeGuardUtil.isUnitType(rawType = JSTypeUtils.unwrapType(rawType))) {
            return true;
        }
        if (rawType instanceof JSUnionType) {
            List<JSType> types2 = ((JSUnionType)rawType).getTypes();
            boolean isDiscriminant = false;
            for (JSType type2 : types2) {
                if (JSTypeGuardUtil.isUnitType(type2) || TypeScriptTypeRelations.isPatternLiteralType(type2)) {
                    isDiscriminant = true;
                }
                if (!TypeScriptTypeRelations.isGenericIndexType(type2)) continue;
                return false;
            }
            return isDiscriminant;
        }
        return false;
    }

    public static boolean isUnitType(@Nullable JSType rawType) {
        return (rawType = JSTypeUtils.unwrapType(rawType)) instanceof JSLiteralType || rawType instanceof JSUndefinedType || rawType instanceof JSNullType || JSTypeUtils.isEnumLiteral(rawType) && rawType.isSourceStrict();
    }

    public static boolean checkReferenceDiscriminantType(@NotNull JSApplyTypeOperationContext context2, @NotNull JSType type2, @NotNull JSType topOwnerType, @Nullable String propertyName) {
        if (context2 == null) {
            JSTypeGuardUtil.$$$reportNull$$$0(12);
        }
        if (type2 == null) {
            JSTypeGuardUtil.$$$reportNull$$$0(13);
        }
        if (topOwnerType == null) {
            JSTypeGuardUtil.$$$reportNull$$$0(14);
        }
        if (propertyName == null) {
            return false;
        }
        if ((topOwnerType = JSTypeUtils.unwrapType(topOwnerType)) instanceof JSUnionType) {
            return JSTypeGuardUtil.isDiscriminantProperty(context2, type2, topOwnerType, propertyName);
        }
        return false;
    }

    public static boolean isDiscriminantProperty(@NotNull JSApplyTypeOperationContext context2, @Nullable JSType type2, @Nullable JSType topOwnerType, @NotNull String propertyName) {
        if (context2 == null) {
            JSTypeGuardUtil.$$$reportNull$$$0(15);
        }
        if (propertyName == null) {
            JSTypeGuardUtil.$$$reportNull$$$0(16);
        }
        JSType jSType = topOwnerType = context2.strictNullChecks() ? topOwnerType : JSTypeUtils.removeNullableComponents(topOwnerType);
        if (!(topOwnerType instanceof JSUnionType) || type2 == null) {
            return false;
        }
        JSRecordType recordType = (type2 = JSTypeUtils.removeNullableComponents(type2)).asRecordType();
        JSRecordType.PropertySignature signature = recordType.findPropertySignature(propertyName);
        if (signature != null) {
            JSRecordType.MemberSource source = signature.getMemberSource();
            if (type2 instanceof JSUnionType && !source.isEmpty() && !source.isUnion()) {
                return false;
            }
            JSType signatureType = JSTypeGuardChecker.getExactType(signature.getJSType());
            return JSTypeGuardUtil.isDiscriminantType(signatureType);
        }
        return false;
    }

    @NotNull
    public static JSType getOperationType(@NotNull JSExpression expression) {
        if (expression == null) {
            JSTypeGuardUtil.$$$reportNull$$$0(17);
        }
        return new JSPsiBasedTypeOfType((PsiElement)expression, false);
    }

    @Nullable
    public static JSType getTypeIfAffectedByTypeGuard(@NotNull JSReferenceExpression expression) {
        PsiElement resolve;
        if (expression == null) {
            JSTypeGuardUtil.$$$reportNull$$$0(18);
        }
        if ((resolve = expression.resolve()) instanceof JSTypeOwner && !(resolve instanceof TypeScriptEnumField)) {
            JSType typeFromTypeGuard;
            JSType type2 = JSTypeUtils.getTypeOfElement(resolve);
            if (type2 != null && resolve instanceof JSOptionalOwner && ((JSOptionalOwner)resolve).isOptional() && TypeScriptConfigUtil.strictNullChecks(resolve)) {
                type2 = JSTypeGuardUtil.wrapWithUndefined(type2, type2.getSource());
            }
            if ((typeFromTypeGuard = JSTypeGuardEvaluator.applyToExpressionType(type2, expression, resolve, new JSEvaluateContext(expression.getContainingFile()))) != null && JSTypeGuardUtil.isDistinct(type2, typeFromTypeGuard) && JSTypeGuardUtil.isDistinct(TypeScriptTypeRelations.expandAndOptimizeTypeRecursive(type2), typeFromTypeGuard)) {
                return JSResolveUtil.getExpressionJSType(expression);
            }
        }
        return null;
    }

    private static boolean isDistinct(JSType type2, JSType typeFromTypeGuard) {
        JSType fromGuardWithoutUndefined = JSTypeGuardUtil.stripUndefined(typeFromTypeGuard);
        return !(typeFromTypeGuard.isEquivalentTo(type2, null) || fromGuardWithoutUndefined != typeFromTypeGuard && fromGuardWithoutUndefined.isEquivalentTo(type2, null) || JSTypeGuardUtil.areSameComponentUnionsOrIntersections(type2, typeFromTypeGuard) || fromGuardWithoutUndefined != typeFromTypeGuard && JSTypeGuardUtil.areSameComponentUnionsOrIntersections(type2, fromGuardWithoutUndefined));
    }

    private static boolean areSameComponentUnionsOrIntersections(JSType type2, JSType fromTypeGuard) {
        ProcessingContext ctx = new ProcessingContext();
        if (!(type2 instanceof JSUnionOrIntersectionType) || !(fromTypeGuard instanceof JSUnionOrIntersectionType)) {
            return false;
        }
        if (type2.getClass() != fromTypeGuard.getClass()) {
            return false;
        }
        List<JSType> types1 = ((JSUnionOrIntersectionType)type2).getTypes();
        List<JSType> types2 = ((JSUnionOrIntersectionType)fromTypeGuard).getTypes();
        if (types1.size() != types2.size()) {
            return false;
        }
        for (JSType type1 : types1) {
            boolean hadEquivalent = false;
            for (JSType type22 : types2) {
                if (!type22.isEquivalentTo(type1, ctx, true)) continue;
                hadEquivalent = true;
                break;
            }
            if (hadEquivalent) continue;
            return false;
        }
        return true;
    }

    @Contract(value="null -> null; !null -> !null")
    @Nullable
    private static JSType stripUndefined(@Nullable JSType type2) {
        return type2 instanceof JSUnionType ? ((JSUnionType)type2).transformTypes((NullableFunction<? super JSType, JSType>)((NullableFunction)t -> t instanceof JSUndefinedType ? null : t)) : type2;
    }

    @Nullable
    public static Pair<Boolean, Boolean> getAutoTypeStates(@NotNull PsiElement resolveResult) {
        if (resolveResult == null) {
            JSTypeGuardUtil.$$$reportNull$$$0(19);
        }
        if (!JSTypeGuardUtil.isElementAcceptableForAutoTypes(resolveResult)) {
            return null;
        }
        JSVariable variable = (JSVariable)resolveResult;
        JSExpression initializer = variable.getInitializer();
        boolean useAutoVariableType = !variable.isConst() && (initializer == null || JSTypeGuardChecker.isUndefinedOrNullExpression(initializer));
        boolean useAutoArrayType = !useAutoVariableType && JSTypeGuardUtil.isEmptyArrayExpression(initializer);
        return Pair.create((Object)useAutoVariableType, (Object)useAutoArrayType);
    }

    public static boolean isElementAcceptableForAutoTypes(@NotNull PsiElement resolveResult) {
        JSVariable result2;
        block9: {
            block8: {
                if (resolveResult == null) {
                    JSTypeGuardUtil.$$$reportNull$$$0(20);
                }
                if (resolveResult instanceof JSField) {
                    return JSTypeGuardUtil.isAutoTypeField(resolveResult);
                }
                if (!(resolveResult instanceof JSVariable)) break block8;
                result2 = (JSVariable)resolveResult;
                if (!(resolveResult instanceof JSParameter)) break block9;
            }
            return false;
        }
        if (JSDestructuringUtil.isDestructuring(resolveResult.getParent())) {
            return false;
        }
        if (result2.getTypeElement() != null) {
            return false;
        }
        JSAttributeList list2 = result2.getAttributeList();
        if (list2 != null && list2.hasModifier(JSAttributeList.ModifierType.EXPORT)) {
            return false;
        }
        return !TypeScriptPsiUtil.isAmbientDeclaration(resolveResult);
    }

    public static boolean isAcceptableForTypeGuard(@Nullable PsiElement element) {
        return JSTypeGuardUtil.isPossibleAutoTypeDeclaration(element) || element instanceof JSReferenceExpression;
    }

    public static boolean isPossibleAutoTypeDeclaration(@Nullable PsiElement element) {
        return element instanceof JSField;
    }

    public static boolean isAutoTypeField(@Nullable PsiElement element) {
        if (!(element instanceof JSField)) {
            return false;
        }
        JSField field = (JSField)element;
        PsiFile file = field.getContainingFile();
        TypeScriptConfig config = TypeScriptConfigUtil.getConfigForPsiFile(file);
        if (config == null || TypeScriptUtil.isDefinitionFile(file)) {
            return false;
        }
        return field instanceof TypeScriptFieldImpl && !(field instanceof TypeScriptEnumField) && !field.hasModifier(JSAttributeList.ModifierType.STATIC) && field.getJSType() == null && field.getInitializer() == null && config.noImplicitAny();
    }

    public static boolean isEmptyArrayExpression(@Nullable JSExpression expression) {
        return expression instanceof JSArrayLiteralExpression && ((JSArrayLiteralExpression)expression).isEmpty();
    }

    @Contract(value="null, _ -> null; !null, _ -> !null")
    @Nullable
    public static JSType wrapWithUndefined(@Nullable JSType startType, @Nullable JSTypeSource source) {
        if (startType == null) {
            return null;
        }
        if (source == null) {
            source = startType.getSource();
        }
        if (!source.isTypeScript()) {
            return startType;
        }
        if (startType instanceof JSElvisType) {
            return ((JSElvisType)startType).isHadNullableComponent() ? startType : new JSElvisType(startType.getSource(), ((JSElvisType)startType).getOriginalType(), true);
        }
        if (startType instanceof JSUnionType && ContainerUtil.exists(((JSUnionType)startType).getTypes(), t -> t instanceof JSUndefinedType)) {
            return startType;
        }
        return JSTypeGuardUtil.unionWithUndefined(startType, source);
    }

    @NotNull
    private static JSType unionWithUndefined(@NotNull JSType startType, @NotNull JSTypeSource source) {
        if (startType == null) {
            JSTypeGuardUtil.$$$reportNull$$$0(21);
        }
        if (source == null) {
            JSTypeGuardUtil.$$$reportNull$$$0(22);
        }
        JSType jSType = JSCompositeTypeFactory.createUnionType(source, startType, JSNamedTypeFactory.createType("undefined", source, JSContext.UNKNOWN));
        if (jSType == null) {
            JSTypeGuardUtil.$$$reportNull$$$0(23);
        }
        return jSType;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 3, 4, 9, 23 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "type";
                break;
            }
            case 1: 
            case 6: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 2: 
            case 11: 
            case 12: 
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 3: 
            case 4: 
            case 9: 
            case 23: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/javascript/psi/types/guard/JSTypeGuardUtil";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "types";
                break;
            }
            case 8: 
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "source";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "topOwnerType";
                break;
            }
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "propertyName";
                break;
            }
            case 17: 
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "expression";
                break;
            }
            case 19: 
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "resolveResult";
                break;
            }
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "startType";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/javascript/psi/types/guard/JSTypeGuardUtil";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "appendProperty";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "getUnionType";
                break;
            }
            case 23: {
                objectArray = objectArray2;
                objectArray2[1] = "unionWithUndefined";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "appendProperty";
                break;
            }
            case 3: 
            case 4: 
            case 9: 
            case 23: {
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "isTypeCanBeExtended";
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "getUnionType";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "isPrimitiveType";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "replacePrimitivesWithLiterals";
                break;
            }
            case 12: 
            case 13: 
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "checkReferenceDiscriminantType";
                break;
            }
            case 15: 
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "isDiscriminantProperty";
                break;
            }
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "getOperationType";
                break;
            }
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "getTypeIfAffectedByTypeGuard";
                break;
            }
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "getAutoTypeStates";
                break;
            }
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "isElementAcceptableForAutoTypes";
                break;
            }
            case 21: 
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "unionWithUndefined";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 3, 4, 9, 23 -> new IllegalStateException(string);
        };
    }
}

