/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.psi.types.guard;

import com.intellij.lang.javascript.DialectDetector;
import com.intellij.lang.javascript.DialectOptionHolder;
import com.intellij.lang.javascript.JSTokenTypes;
import com.intellij.lang.javascript.dialects.JSDialectSpecificHandlersFactory;
import com.intellij.lang.javascript.index.JSSymbolUtil;
import com.intellij.lang.javascript.psi.JSDefinitionExpression;
import com.intellij.lang.javascript.psi.JSElement;
import com.intellij.lang.javascript.psi.JSExecutionScope;
import com.intellij.lang.javascript.psi.JSExpression;
import com.intellij.lang.javascript.psi.JSFunction;
import com.intellij.lang.javascript.psi.JSFunctionProperty;
import com.intellij.lang.javascript.psi.JSLiteralExpression;
import com.intellij.lang.javascript.psi.JSPrefixExpression;
import com.intellij.lang.javascript.psi.JSPsiElementBase;
import com.intellij.lang.javascript.psi.JSReferenceExpression;
import com.intellij.lang.javascript.psi.JSThisExpression;
import com.intellij.lang.javascript.psi.JSType;
import com.intellij.lang.javascript.psi.ecma6.JSTypeDeclaration;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptEnumField;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptFunctionSignature;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptIndexSignature;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptModule;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptNotNullExpression;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptTypeMember;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptTypeParameterList;
import com.intellij.lang.javascript.psi.ecmal4.JSClass;
import com.intellij.lang.javascript.psi.ecmal4.JSSuperExpression;
import com.intellij.lang.javascript.psi.types.JSBooleanLiteralTypeImpl;
import com.intellij.lang.javascript.psi.types.JSCompositeTypeFactory;
import com.intellij.lang.javascript.psi.types.JSDecoratedType;
import com.intellij.lang.javascript.psi.types.JSExoticStringLiteralType;
import com.intellij.lang.javascript.psi.types.JSNamedTypeFactory;
import com.intellij.lang.javascript.psi.types.JSPrimitiveLiteralType;
import com.intellij.lang.javascript.psi.types.JSUnionType;
import com.intellij.lang.javascript.psi.types.guard.JSTypeGuardUtil;
import com.intellij.lang.javascript.psi.types.guard.TypeScriptTypeGuard;
import com.intellij.lang.javascript.psi.types.guard.TypeScriptTypeRelations;
import com.intellij.lang.javascript.psi.types.guard.operations.JSApplyTypeOperationContext;
import com.intellij.lang.javascript.psi.types.guard.operations.JSApplyTypeOperationContextImpl;
import com.intellij.lang.javascript.psi.types.guard.operations.JSDeclaredTypeOperation;
import com.intellij.lang.javascript.psi.types.guard.operations.JSInferDecoratorsContext;
import com.intellij.lang.javascript.psi.types.guard.operations.JSTypeOperation;
import com.intellij.lang.javascript.psi.types.primitives.JSBooleanType;
import com.intellij.lang.javascript.psi.types.primitives.TypeScriptNeverType;
import com.intellij.lang.javascript.psi.util.JSDestructuringUtil;
import com.intellij.lang.javascript.psi.util.JSUtils;
import com.intellij.lang.typescript.psi.TypeScriptPsiUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.util.CachedValueProvider;
import com.intellij.psi.util.CachedValuesManager;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class JSTypeGuardChecker {
    public static final EnumSet<JSDecoratedType.TypeDecoration> NOTNULL_UNDEFINED_PRIMITIVE = EnumSet.of(JSDecoratedType.TypeDecoration.INFERRED_NOTNULL, JSDecoratedType.TypeDecoration.INFERRED_NOTUNDEFINED, JSDecoratedType.TypeDecoration.INFERRED_PRIMITIVE);
    public static final EnumSet<JSDecoratedType.TypeDecoration> NOTNULL_NOTUNDEFINED = EnumSet.of(JSDecoratedType.TypeDecoration.INFERRED_NOTNULL, JSDecoratedType.TypeDecoration.INFERRED_NOTUNDEFINED);
    public static final EnumSet<JSDecoratedType.TypeDecoration> NULL_OR_UNDEFINED = EnumSet.of(JSDecoratedType.TypeDecoration.INFERRED_NULL_OR_UNDEFINED);
    public static final Set<JSDecoratedType.TypeDecoration> NULL_UNDEFINED_ALL = EnumSet.of(JSDecoratedType.TypeDecoration.INFERRED_NULL, new JSDecoratedType.TypeDecoration[]{JSDecoratedType.TypeDecoration.INFERRED_UNDEFINED, JSDecoratedType.TypeDecoration.INFERRED_NULL_OR_UNDEFINED, JSDecoratedType.TypeDecoration.INFERRED_POSSIBLY_NULL, JSDecoratedType.TypeDecoration.INFERRED_POSSIBLY_UNDEFINED, JSDecoratedType.TypeDecoration.INFERRED_POSSIBLY_NULL_OR_UNDEFINED});
    public static final Set<JSDecoratedType.TypeDecoration> NULL_UNDEFINED_ALL_STRICT = EnumSet.of(JSDecoratedType.TypeDecoration.INFERRED_NULL, JSDecoratedType.TypeDecoration.INFERRED_UNDEFINED, JSDecoratedType.TypeDecoration.INFERRED_NULL_OR_UNDEFINED);
    @NotNull
    private final PsiElement myElement;
    @NotNull
    private final JSApplyTypeOperationContext myApplyTypeOperationContext;
    private final boolean myIsTypeScript;

    public static boolean isNarrowableReference(@Nullable JSExpression expression) {
        if (expression instanceof TypeScriptNotNullExpression) {
            expression = ((TypeScriptNotNullExpression)expression).getExpression();
        }
        if (expression instanceof JSThisExpression || expression instanceof JSSuperExpression) {
            return true;
        }
        if (expression instanceof JSReferenceExpression) {
            JSExpression qualifier = ((JSReferenceExpression)expression).getQualifier();
            return qualifier == null || JSTypeGuardChecker.isNarrowableReference(qualifier);
        }
        return false;
    }

    public static boolean containsDecorator(@NotNull JSExpression expression, JSDecoratedType.TypeDecoration ... decorator) {
        if (expression == null) {
            JSTypeGuardChecker.$$$reportNull$$$0(0);
        }
        if (decorator == null) {
            JSTypeGuardChecker.$$$reportNull$$$0(1);
        }
        if (!(expression instanceof JSReferenceExpression)) {
            return false;
        }
        Set<JSDecoratedType.TypeDecoration> decorators = JSTypeGuardChecker.getDecoratorsForExpression((JSReferenceExpression)expression);
        for (JSDecoratedType.TypeDecoration dec : decorator) {
            if (!decorators.contains((Object)dec)) continue;
            return true;
        }
        return false;
    }

    @NotNull
    public static Set<JSDecoratedType.TypeDecoration> getDecoratorsForExpression(@NotNull JSReferenceExpression candidate) {
        if (candidate == null) {
            JSTypeGuardChecker.$$$reportNull$$$0(2);
        }
        if (!JSTypeGuardChecker.checkPlaceContext(candidate) || !JSTypeGuardChecker.supportsTypeGuard(DialectDetector.dialectOfElement((PsiElement)candidate))) {
            Set<JSDecoratedType.TypeDecoration> set = Collections.emptySet();
            if (set == null) {
                JSTypeGuardChecker.$$$reportNull$$$0(3);
            }
            return set;
        }
        JSTypeOperation operations = JSTypeGuardChecker.getCachedTypeGuardOperations((PsiElement)candidate);
        Set<JSDecoratedType.TypeDecoration> set = operations.inferTypeDecorators(new JSInferDecoratorsContext(){
            private final HashMap<JSTypeOperation, Set<JSDecoratedType.TypeDecoration>> map = new HashMap();

            @Override
            @Nullable
            public Set<JSDecoratedType.TypeDecoration> getCachedValue(@NotNull JSTypeOperation operation) {
                if (operation == null) {
                    1.$$$reportNull$$$0(0);
                }
                return this.map.get(operation);
            }

            @Override
            public void putCachedValue(@NotNull JSTypeOperation operation, @NotNull Set<JSDecoratedType.TypeDecoration> decorations) {
                if (operation == null) {
                    1.$$$reportNull$$$0(1);
                }
                if (decorations == null) {
                    1.$$$reportNull$$$0(2);
                }
                this.map.put(operation, decorations);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2;
                Object[] objectArray3 = new Object[3];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "operation";
                        break;
                    }
                    case 2: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "decorations";
                        break;
                    }
                }
                objectArray2[1] = "com/intellij/lang/javascript/psi/types/guard/JSTypeGuardChecker$1";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[2] = "getCachedValue";
                        break;
                    }
                    case 1: 
                    case 2: {
                        objectArray = objectArray2;
                        objectArray2[2] = "putCachedValue";
                        break;
                    }
                }
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        });
        if (set == null) {
            JSTypeGuardChecker.$$$reportNull$$$0(4);
        }
        return set;
    }

    public static boolean isAvailable(@NotNull PsiElement place, @NotNull PsiElement candidate) {
        if (place == null) {
            JSTypeGuardChecker.$$$reportNull$$$0(5);
        }
        if (candidate == null) {
            JSTypeGuardChecker.$$$reportNull$$$0(6);
        }
        if (!JSTypeGuardChecker.isAcceptableResolveElement(candidate)) {
            return false;
        }
        DialectOptionHolder holder = DialectDetector.dialectOfElement(place);
        if (!JSTypeGuardChecker.supportsTypeGuard(holder)) {
            return false;
        }
        boolean isTypeScript = holder.isTypeScript;
        if (isTypeScript && candidate instanceof JSDefinitionExpression) {
            return false;
        }
        if (JSTypeGuardUtil.isPossibleAutoTypeDeclaration(place)) {
            return true;
        }
        if (!(place instanceof JSExpression) || !JSTypeGuardChecker.isNarrowableReference((JSExpression)place)) {
            return false;
        }
        return JSTypeGuardChecker.checkPlaceContext((JSExpression)place);
    }

    public static boolean supportsTypeGuard(@Nullable DialectOptionHolder holder) {
        return holder != null && holder.supportsTypeGuard();
    }

    public static boolean checkPlaceContext(@NotNull JSExpression place) {
        if (place == null) {
            JSTypeGuardChecker.$$$reportNull$$$0(7);
        }
        if (JSDestructuringUtil.parentIsDestructuringAssignmentLHS(place)) {
            return false;
        }
        JSElement scopeParent = (JSElement)PsiTreeUtil.getContextOfType((PsiElement)place, (Class[])new Class[]{JSClass.class, JSExecutionScope.class, JSTypeDeclaration.class, TypeScriptTypeParameterList.class});
        return scopeParent instanceof JSExecutionScope && !(scopeParent instanceof JSTypeDeclaration) && !(scopeParent instanceof TypeScriptTypeMember) && !TypeScriptPsiUtil.isAmbientDeclaration((PsiElement)scopeParent);
    }

    private static boolean isAcceptableResolveElement(@Nullable PsiElement candidate) {
        if (candidate instanceof JSClass || candidate instanceof TypeScriptEnumField || candidate instanceof JSFunction && !(candidate instanceof JSFunctionProperty) && !((JSFunction)candidate).isGetProperty() && !(candidate instanceof TypeScriptFunctionSignature) || candidate instanceof TypeScriptModule) {
            return false;
        }
        return candidate instanceof JSPsiElementBase || candidate instanceof TypeScriptIndexSignature;
    }

    public JSTypeGuardChecker(@NotNull PsiElement element, @Nullable JSType startType, boolean autoArrayType, boolean autoVariableType, boolean strictNullCheck) {
        if (element == null) {
            JSTypeGuardChecker.$$$reportNull$$$0(8);
        }
        this.myElement = element;
        this.myIsTypeScript = DialectDetector.isTypeScript(element);
        this.myApplyTypeOperationContext = new JSApplyTypeOperationContextImpl(element, startType, autoArrayType, autoVariableType, strictNullCheck);
    }

    @Nullable
    private JSType getTypeFromOperation() {
        PsiElement element = this.myElement;
        JSTypeOperation operations = JSTypeGuardChecker.getCachedTypeGuardOperations(element);
        if (operations == JSDeclaredTypeOperation.DECLARED_TYPE) {
            return this.myApplyTypeOperationContext.getRealType();
        }
        JSType result2 = operations.apply(this.myApplyTypeOperationContext, this.myApplyTypeOperationContext.getDeclaredType());
        return this.myApplyTypeOperationContext.isEvolvingArrayType(result2) && TypeScriptTypeGuard.isEvolvingArrayOperationTarget(element) ? this.myApplyTypeOperationContext.getDeclaredType() : this.myApplyTypeOperationContext.finalizeEvolvingArrayType(result2);
    }

    @NotNull
    public static JSTypeOperation getCachedTypeGuardOperations(@NotNull PsiElement element) {
        if (element == null) {
            JSTypeGuardChecker.$$$reportNull$$$0(9);
        }
        if (!JSTypeGuardUtil.isAcceptableForTypeGuard(element)) {
            JSDeclaredTypeOperation jSDeclaredTypeOperation = JSDeclaredTypeOperation.DECLARED_TYPE;
            if (jSDeclaredTypeOperation == null) {
                JSTypeGuardChecker.$$$reportNull$$$0(10);
            }
            return jSDeclaredTypeOperation;
        }
        JSTypeOperation jSTypeOperation = (JSTypeOperation)CachedValuesManager.getCachedValue((PsiElement)element, () -> {
            TypeScriptTypeGuard guard = JSDialectSpecificHandlersFactory.forElement(element).createTypeGuard(element);
            JSTypeOperation operations = guard.getNarrowedTypeOperations();
            return CachedValueProvider.Result.create((Object)operations, (Object[])new Object[]{element.getContainingFile()});
        });
        if (jSTypeOperation == null) {
            JSTypeGuardChecker.$$$reportNull$$$0(11);
        }
        return jSTypeOperation;
    }

    @Nullable
    public JSType getNarrowedType() {
        JSType realType = this.myApplyTypeOperationContext.getRealType();
        JSType result2 = this.getTypeFromOperation();
        if (!this.myIsTypeScript && result2 instanceof TypeScriptNeverType) {
            return realType;
        }
        if (realType == (result2 = JSTypeGuardChecker.collapseBooleanLiterals(result2))) {
            return realType;
        }
        JSType declaredType = this.myApplyTypeOperationContext.getDeclaredType();
        if (result2 == declaredType) {
            return realType;
        }
        return result2;
    }

    @Nullable
    public static JSType collapseBooleanLiterals(@Nullable JSType type2) {
        if (type2 instanceof JSUnionType) {
            ArrayList<JSType> resultType = new ArrayList<JSType>();
            List<JSType> unionTypes = ((JSUnionType)type2).getTypes();
            boolean hasTrue = false;
            boolean hasFalse = false;
            for (JSType t : unionTypes) {
                if (t instanceof JSBooleanLiteralTypeImpl) {
                    if (((JSBooleanLiteralTypeImpl)t).getLiteral().booleanValue()) {
                        hasTrue = true;
                        continue;
                    }
                    hasFalse = true;
                    continue;
                }
                resultType.add(t);
            }
            if (hasFalse && hasTrue) {
                JSBooleanType booleanType = JSNamedTypeFactory.createBooleanPrimitiveType(type2.getSource());
                if (resultType.isEmpty()) {
                    type2 = booleanType;
                } else {
                    resultType.add(booleanType);
                    type2 = JSCompositeTypeFactory.createUnionType(type2.getSource(), resultType);
                }
            }
        }
        return type2;
    }

    @Nullable
    public static JSPrefixExpression getTypeOfPrefixExpression(@Nullable JSExpression candidate) {
        if (candidate instanceof JSPrefixExpression && ((JSPrefixExpression)candidate).getOperationSign() == JSTokenTypes.TYPEOF_KEYWORD) {
            return (JSPrefixExpression)candidate;
        }
        return null;
    }

    public static boolean isStringLiteralExpression(@Nullable JSExpression right) {
        return right instanceof JSLiteralExpression && ((JSLiteralExpression)right).isQuotedLiteral();
    }

    @Contract(value="!null -> !null")
    public static JSType getExactType(@Nullable JSType type2) {
        if (null == type2) {
            return null;
        }
        JSPrimitiveLiteralType<String> valuableType = type2.substitute();
        if (valuableType instanceof JSUnionType) {
            List<JSType> types2 = ((JSUnionType)((Object)valuableType)).getTypes();
            List expanded = ContainerUtil.map(types2, el -> TypeScriptTypeRelations.getAsUnionIfBooleanOrEnum(el));
            if (ContainerUtil.equalsIdentity((List)expanded, types2)) {
                return valuableType;
            }
            return JSCompositeTypeFactory.getCommonType(expanded, valuableType.getSource(), true);
        }
        if ((valuableType = TypeScriptTypeRelations.getAsUnionIfBooleanOrEnum(valuableType)) instanceof JSExoticStringLiteralType) {
            valuableType = ((JSExoticStringLiteralType)((Object)valuableType)).asSimpleLiteralType();
        }
        return valuableType;
    }

    public static boolean isUndefinedOrNullExpression(@Nullable JSExpression toCheck) {
        return JSSymbolUtil.isUndefinedExpression(toCheck) || JSSymbolUtil.isNullLiteral(toCheck);
    }

    @NotNull
    public static Set<JSDecoratedType.TypeDecoration> getDecoratorsForNullOrUndefinedExpression(boolean doubleEquals, @Nullable JSExpression expression, boolean assumeTrue) {
        boolean isNull;
        boolean isUndefined = JSSymbolUtil.isUndefinedExpression(expression = JSUtils.unparenthesize(expression));
        boolean bl = isNull = !isUndefined && JSSymbolUtil.isNullLiteral(expression);
        if (!isUndefined && !isNull) {
            Set<JSDecoratedType.TypeDecoration> set = Collections.emptySet();
            if (set == null) {
                JSTypeGuardChecker.$$$reportNull$$$0(12);
            }
            return set;
        }
        if (!assumeTrue) {
            EnumSet<JSDecoratedType.TypeDecoration> enumSet = doubleEquals ? NOTNULL_NOTUNDEFINED : (isNull ? EnumSet.of(JSDecoratedType.TypeDecoration.INFERRED_NOTNULL) : EnumSet.of(JSDecoratedType.TypeDecoration.INFERRED_NOTUNDEFINED));
            if (enumSet == null) {
                JSTypeGuardChecker.$$$reportNull$$$0(13);
            }
            return enumSet;
        }
        EnumSet<JSDecoratedType.TypeDecoration> enumSet = doubleEquals ? NULL_OR_UNDEFINED : (isNull ? EnumSet.of(JSDecoratedType.TypeDecoration.INFERRED_NULL) : EnumSet.of(JSDecoratedType.TypeDecoration.INFERRED_UNDEFINED));
        if (enumSet == null) {
            JSTypeGuardChecker.$$$reportNull$$$0(14);
        }
        return enumSet;
    }

    public static boolean isNegativeSign(@NotNull IElementType sign) {
        if (sign == null) {
            JSTypeGuardChecker.$$$reportNull$$$0(15);
        }
        return sign == JSTokenTypes.NE || sign == JSTokenTypes.NEQEQ;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 3, 4, 10, 11, 12, 13, 14 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "expression";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "decorator";
                break;
            }
            case 2: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "candidate";
                break;
            }
            case 3: 
            case 4: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/javascript/psi/types/guard/JSTypeGuardChecker";
                break;
            }
            case 5: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "place";
                break;
            }
            case 8: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sign";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/javascript/psi/types/guard/JSTypeGuardChecker";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getDecoratorsForExpression";
                break;
            }
            case 10: 
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "getCachedTypeGuardOperations";
                break;
            }
            case 12: 
            case 13: 
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "getDecoratorsForNullOrUndefinedExpression";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "containsDecorator";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "getDecoratorsForExpression";
                break;
            }
            case 3: 
            case 4: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: {
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "isAvailable";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "checkPlaceContext";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "getCachedTypeGuardOperations";
                break;
            }
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "isNegativeSign";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 3, 4, 10, 11, 12, 13, 14 -> new IllegalStateException(string);
        };
    }

    public static interface TypeRelation {
        public boolean isRelated(@Nullable JSType var1, @Nullable JSType var2);
    }
}

