/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.psi.types;

import com.intellij.lang.ecmascript6.psi.ES6ComputedName;
import com.intellij.lang.javascript.ecmascript6.TypeScriptLiteralKeyUtil;
import com.intellij.lang.javascript.ecmascript6.TypeScriptTypeEvaluator;
import com.intellij.lang.javascript.psi.JSApplyGenericsTransformer;
import com.intellij.lang.javascript.psi.JSConstStatusOwner;
import com.intellij.lang.javascript.psi.JSElementBase;
import com.intellij.lang.javascript.psi.JSFunction;
import com.intellij.lang.javascript.psi.JSNamedElement;
import com.intellij.lang.javascript.psi.JSOptionalOwner;
import com.intellij.lang.javascript.psi.JSRecordType;
import com.intellij.lang.javascript.psi.JSType;
import com.intellij.lang.javascript.psi.JSTypeUtils;
import com.intellij.lang.javascript.psi.ecma6.JSComputedPropertyNameOwner;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptPropertySignature;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptTypeMember;
import com.intellij.lang.javascript.psi.ecmal4.JSClass;
import com.intellij.lang.javascript.psi.impl.JSPsiImplUtils;
import com.intellij.lang.javascript.psi.resolve.JSResolveUtil;
import com.intellij.lang.javascript.psi.resolve.generic.JSTypeSubstitutorImpl;
import com.intellij.lang.javascript.psi.types.JSContext;
import com.intellij.lang.javascript.psi.types.JSNumberLiteralTypeImpl;
import com.intellij.lang.javascript.psi.types.JSStringLiteralTypeImpl;
import com.intellij.lang.javascript.psi.types.JSTypeSource;
import com.intellij.lang.javascript.psi.types.JSTypeSubstitutor;
import com.intellij.lang.javascript.psi.types.JSUniqueSymbolTypeImpl;
import com.intellij.lang.javascript.psi.types.TypeScriptGenericThisTypeImpl;
import com.intellij.lang.javascript.psi.types.TypeScriptJSFunctionTypeImpl;
import com.intellij.lang.javascript.psi.types.TypeScriptTypeParser;
import com.intellij.lang.javascript.psi.types.recordImpl.CallSignatureImpl;
import com.intellij.lang.javascript.psi.types.recordImpl.ComputedPropertySignatureImpl;
import com.intellij.lang.javascript.psi.types.recordImpl.PropertySignatureImpl;
import com.intellij.lang.javascript.psi.util.JSUtils;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiNamedElement;
import com.intellij.util.Function;
import com.intellij.util.ObjectUtils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class TypeScriptTypeMemberParser {
    @Nullable
    public static JSRecordType.TypeMember buildTypeMember(@NotNull JSRecordType.TypeMember member, @Nullable Function<? super JSType, ? extends JSType> applier) {
        ES6ComputedName computedName;
        if (member == null) {
            TypeScriptTypeMemberParser.$$$reportNull$$$0(0);
        }
        if (applier == null) {
            if (member instanceof PsiElement && TypeScriptTypeMemberParser.isPropertyNameEmpty((PsiElement)member)) {
                return TypeScriptTypeMemberParser.buildComputedPropertySignature((PsiElement)member);
            }
            return member;
        }
        if (member instanceof TypeScriptPropertySignature && (computedName = ((TypeScriptPropertySignature)member).getComputedPropertyName()) != null) {
            member = TypeScriptTypeMemberParser.copyPropertySignature((TypeScriptPropertySignature)member, computedName);
        }
        return member.copyTypeHierarchy(applier);
    }

    @Nullable
    public static JSRecordType.TypeMember buildComputedPropertySignature(@NotNull PsiElement member) {
        if (member == null) {
            TypeScriptTypeMemberParser.$$$reportNull$$$0(1);
        }
        if (member instanceof JSComputedPropertyNameOwner && member instanceof JSRecordType.PropertySignature) {
            String referenceName;
            ES6ComputedName name = ((JSComputedPropertyNameOwner)member).getComputedPropertyName();
            String string = referenceName = name == null ? null : name.getExpressionAsReferenceName();
            if (referenceName != null) {
                return new ComputedPropertySignatureImpl(referenceName, ((JSRecordType.PropertySignature)member).getJSType(), ((JSRecordType.PropertySignature)member).isOptional(), ((JSRecordType.PropertySignature)member).isConst(), ((JSRecordType.PropertySignature)member).getMemberSource());
            }
        }
        return null;
    }

    @Nullable
    public static String tryGetComputedName(@NotNull JSComputedPropertyNameOwner member) {
        ES6ComputedName computedName;
        if (member == null) {
            TypeScriptTypeMemberParser.$$$reportNull$$$0(2);
        }
        JSType type2 = (computedName = member.getComputedPropertyName()) == null ? null : TypeScriptLiteralKeyUtil.getTypeForComputedPropExpression(computedName);
        return TypeScriptTypeMemberParser.getComputedPropNameFromType(type2);
    }

    @Nullable
    public static String getComputedPropNameFromType(JSType type2) {
        if (type2 == null) {
            return null;
        }
        if (type2 instanceof JSNumberLiteralTypeImpl) {
            return type2.getTypeText();
        }
        if (type2 instanceof JSStringLiteralTypeImpl) {
            return ((JSStringLiteralTypeImpl)type2).getLiteral();
        }
        if (type2 instanceof JSUniqueSymbolTypeImpl) {
            JSUniqueSymbolTypeImpl uniqueSymbolType = (JSUniqueSymbolTypeImpl)type2;
            JSNamedElement namedElement = (JSNamedElement)ObjectUtils.tryCast((Object)uniqueSymbolType.getSourceElement(), JSNamedElement.class);
            if (namedElement == null) {
                namedElement = uniqueSymbolType.getElement();
            }
            if (namedElement != null) {
                return namedElement.getName();
            }
        }
        return null;
    }

    @NotNull
    private static JSRecordType.TypeMember copyPropertySignature(@NotNull TypeScriptPropertySignature propertySignature, @NotNull ES6ComputedName computedName) {
        String computedPropertyName;
        if (propertySignature == null) {
            TypeScriptTypeMemberParser.$$$reportNull$$$0(3);
        }
        if (computedName == null) {
            TypeScriptTypeMemberParser.$$$reportNull$$$0(4);
        }
        if (StringUtil.isNotEmpty((String)(computedPropertyName = computedName.getExpressionAsReferenceName()))) {
            return new ComputedPropertySignatureImpl(computedPropertyName, propertySignature.getJSType(), propertySignature.isOptional(), propertySignature.isConst(), propertySignature.getMemberSource());
        }
        TypeScriptPropertySignature typeScriptPropertySignature = propertySignature;
        if (typeScriptPropertySignature == null) {
            TypeScriptTypeMemberParser.$$$reportNull$$$0(5);
        }
        return typeScriptPropertySignature;
    }

    static boolean isPropertyNameEmpty(@NotNull PsiElement member) {
        if (member == null) {
            TypeScriptTypeMemberParser.$$$reportNull$$$0(6);
        }
        return member instanceof JSRecordType.PropertySignature && StringUtil.isEmpty((String)((JSRecordType.PropertySignature)member).getMemberName());
    }

    public static JSRecordType.TypeMember buildTypeMember(@NotNull TypeScriptTypeMember member) {
        if (member == null) {
            TypeScriptTypeMemberParser.$$$reportNull$$$0(7);
        }
        return TypeScriptTypeMemberParser.buildTypeMember(member, null);
    }

    @Nullable
    public static JSRecordType.TypeMember buildTypeMemberFromElement(@Nullable JSClass ownerClass, @NotNull PsiElement member, boolean isStatic, @NotNull JSTypeSource source, @Nullable JSTypeSubstitutor typeSubstitutor) {
        if (member == null) {
            TypeScriptTypeMemberParser.$$$reportNull$$$0(8);
        }
        if (source == null) {
            TypeScriptTypeMemberParser.$$$reportNull$$$0(9);
        }
        if (ownerClass != null && JSResolveUtil.isConstructorFunction(member)) {
            if (isStatic) {
                JSType constructorReturnType = TypeScriptTypeParser.createConstructorReturnType(ownerClass, source);
                TypeScriptJSFunctionTypeImpl functionType2 = TypeScriptTypeParser.buildFunctionTypeImpl((JSFunction)member, constructorReturnType);
                TypeScriptJSFunctionTypeImpl type2 = (TypeScriptJSFunctionTypeImpl)JSTypeUtils.applyGenericArguments(functionType2, typeSubstitutor);
                return new CallSignatureImpl(true, type2);
            }
            return null;
        }
        if (!TypeScriptTypeMemberParser.checkStatics(member, isStatic)) {
            return null;
        }
        if (member instanceof TypeScriptTypeMember) {
            return TypeScriptTypeMemberParser.buildTypeMember((TypeScriptTypeMember)member, TypeScriptTypeMemberParser.createApplier(typeSubstitutor, member));
        }
        JSClass memberClass = JSUtils.getMemberContainingClass(member);
        JSType typeForProperty = null;
        boolean typeForPropertySet = false;
        if (ownerClass != null && memberClass != null && !ownerClass.equals(memberClass)) {
            JSType ownerType;
            typeForProperty = TypeScriptTypeParser.buildTypeFromClassMember(member);
            typeForPropertySet = true;
            if (JSTypeUtils.hasTypes(typeForProperty, TypeScriptGenericThisTypeImpl.class) && (ownerType = TypeScriptTypeEvaluator.createTypeForThisTypeSubstitution(ownerClass, typeForProperty.getSource())) != null) {
                typeSubstitutor = JSTypeSubstitutorImpl.of(typeSubstitutor);
                ((JSTypeSubstitutorImpl)typeSubstitutor).put(TypeScriptGenericThisTypeImpl.THIS_TYPE_GENERIC_ID, ownerType);
            }
        }
        if (JSTypeSubstitutor.isEmptySubstitutor(typeSubstitutor) && member instanceof JSRecordType.TypeMember) {
            if (TypeScriptTypeMemberParser.isPropertyNameEmpty(member)) {
                return TypeScriptTypeMemberParser.buildComputedPropertySignature(member);
            }
            return (JSRecordType.TypeMember)member;
        }
        if (!typeForPropertySet) {
            typeForProperty = TypeScriptTypeParser.buildTypeFromClassMember(member);
        }
        return TypeScriptTypeMemberParser.createPropertySignatureForMember(member, typeForProperty, typeSubstitutor);
    }

    private static JSRecordType.TypeMember createPropertySignatureForMember(@NotNull PsiElement member, @Nullable JSType typeForProperty, @Nullable JSTypeSubstitutor typeSubstitutor) {
        String name;
        if (member == null) {
            TypeScriptTypeMemberParser.$$$reportNull$$$0(10);
        }
        String string = name = member instanceof PsiNamedElement ? ((PsiNamedElement)member).getName() : null;
        if (name == null && member instanceof JSComputedPropertyNameOwner) {
            name = JSPsiImplUtils.getComputedPropertyNameWithoutBrackets((JSComputedPropertyNameOwner)member);
        }
        if (name == null) {
            return null;
        }
        JSType type2 = JSTypeUtils.applyGenericArguments(typeForProperty, typeSubstitutor);
        boolean optional = member instanceof JSOptionalOwner && ((JSOptionalOwner)member).isOptional();
        boolean isReadonly = member instanceof JSConstStatusOwner && ((JSConstStatusOwner)member).isConst();
        boolean privateName = JSUtils.isPrivateSharpItem(member);
        int privateNameDepth = JSPsiImplUtils.getPrivateNameDepthOfContext(privateName, member);
        return new PropertySignatureImpl(name, privateName, privateNameDepth, isReadonly, type2, optional, member);
    }

    private static boolean checkStatics(@NotNull PsiElement member, boolean isStatic) {
        if (member == null) {
            TypeScriptTypeMemberParser.$$$reportNull$$$0(11);
        }
        if (!(member instanceof JSElementBase)) {
            return true;
        }
        JSContext context2 = ((JSElementBase)member).getJSContext();
        boolean isContextStatic = context2 == JSContext.STATIC;
        return isStatic == isContextStatic;
    }

    @Nullable
    static Function<JSType, JSType> createApplier(@Nullable JSTypeSubstitutor typeSubstitutor, @Nullable PsiElement context2) {
        return JSTypeSubstitutor.isEmptySubstitutor(typeSubstitutor) ? null : new JSApplyGenericsTransformer(typeSubstitutor, context2, false, null);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 5 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "member";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "propertySignature";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "computedName";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/javascript/psi/types/TypeScriptTypeMemberParser";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "source";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/javascript/psi/types/TypeScriptTypeMemberParser";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "copyPropertySignature";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "buildTypeMember";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "buildComputedPropertySignature";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "tryGetComputedName";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "copyPropertySignature";
                break;
            }
            case 5: {
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "isPropertyNameEmpty";
                break;
            }
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "buildTypeMemberFromElement";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "createPropertySignatureForMember";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "checkStatics";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 5 -> new IllegalStateException(string);
        };
    }
}

