/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.psi.types;

import com.intellij.lang.javascript.ecmascript6.TypeScriptLiteralKeyUtil;
import com.intellij.lang.javascript.psi.JSElement;
import com.intellij.lang.javascript.psi.JSField;
import com.intellij.lang.javascript.psi.JSRecordType;
import com.intellij.lang.javascript.psi.JSResolvedTypeId;
import com.intellij.lang.javascript.psi.JSType;
import com.intellij.lang.javascript.psi.JSTypeOwner;
import com.intellij.lang.javascript.psi.JSTypeSubstitutionContext;
import com.intellij.lang.javascript.psi.JSTypeTextBuilder;
import com.intellij.lang.javascript.psi.JSTypeUtils;
import com.intellij.lang.javascript.psi.JSTypeWithIncompleteSubstitution;
import com.intellij.lang.javascript.psi.ecma6.EnumConstantValue;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptEnum;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptEnumField;
import com.intellij.lang.javascript.psi.ecmal4.JSClass;
import com.intellij.lang.javascript.psi.types.JSAnyType;
import com.intellij.lang.javascript.psi.types.JSCompositeTypeFactory;
import com.intellij.lang.javascript.psi.types.JSEvaluableType;
import com.intellij.lang.javascript.psi.types.JSGenericParameterImpl;
import com.intellij.lang.javascript.psi.types.JSIntersectionType;
import com.intellij.lang.javascript.psi.types.JSLiteralType;
import com.intellij.lang.javascript.psi.types.JSNamedTypeFactory;
import com.intellij.lang.javascript.psi.types.JSNumberLiteralTypeImpl;
import com.intellij.lang.javascript.psi.types.JSPrimitiveLiteralType;
import com.intellij.lang.javascript.psi.types.JSPsiBasedTypeOfType;
import com.intellij.lang.javascript.psi.types.JSRecordTypeImpl;
import com.intellij.lang.javascript.psi.types.JSRecursiveTypeVisitor;
import com.intellij.lang.javascript.psi.types.JSResolvableType;
import com.intellij.lang.javascript.psi.types.JSResolvedTypeInfo;
import com.intellij.lang.javascript.psi.types.JSStringLiteralTypeImpl;
import com.intellij.lang.javascript.psi.types.JSTupleType;
import com.intellij.lang.javascript.psi.types.JSTypeBaseImpl;
import com.intellij.lang.javascript.psi.types.JSTypeSerializer;
import com.intellij.lang.javascript.psi.types.JSTypeSource;
import com.intellij.lang.javascript.psi.types.JSTypeSourceFactory;
import com.intellij.lang.javascript.psi.types.JSTypeSubstitutionContextImpl;
import com.intellij.lang.javascript.psi.types.JSUnionType;
import com.intellij.lang.javascript.psi.types.JSUniqueSymbolTypeImpl;
import com.intellij.lang.javascript.psi.types.guard.JSTypeGuardUtil;
import com.intellij.lang.javascript.psi.types.primitives.TypeScriptNeverType;
import com.intellij.lang.typescript.tsconfig.TypeScriptConfigUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.util.Function;
import com.intellij.util.ProcessingContext;
import com.intellij.util.SmartList;
import com.intellij.util.containers.ContainerUtil;
import java.text.CharacterIterator;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class TypeScriptIndexedAccessJSTypeImpl
extends JSTypeBaseImpl
implements JSEvaluableType,
JSTypeWithIncompleteSubstitution {
    @NotNull
    private final JSType myOwner;
    @NotNull
    private final JSType myParameterType;

    @ApiStatus.Internal
    public TypeScriptIndexedAccessJSTypeImpl(@NotNull JSType owner, @NotNull JSType parameterType, @NotNull JSTypeSource source) {
        if (owner == null) {
            TypeScriptIndexedAccessJSTypeImpl.$$$reportNull$$$0(0);
        }
        if (parameterType == null) {
            TypeScriptIndexedAccessJSTypeImpl.$$$reportNull$$$0(1);
        }
        if (source == null) {
            TypeScriptIndexedAccessJSTypeImpl.$$$reportNull$$$0(2);
        }
        super(source);
        this.myOwner = owner;
        this.myParameterType = parameterType;
    }

    TypeScriptIndexedAccessJSTypeImpl(@NotNull JSTypeSource source, @NotNull CharacterIterator inputStream) {
        if (source == null) {
            TypeScriptIndexedAccessJSTypeImpl.$$$reportNull$$$0(3);
        }
        if (inputStream == null) {
            TypeScriptIndexedAccessJSTypeImpl.$$$reportNull$$$0(4);
        }
        super(source);
        this.myOwner = JSTypeSerializer.TYPE_SERIALIZER.read(source, inputStream);
        this.myParameterType = JSTypeSerializer.TYPE_SERIALIZER.read(source, inputStream);
    }

    @Override
    public void serialize(@NotNull StringBuilder outputStream) {
        if (outputStream == null) {
            TypeScriptIndexedAccessJSTypeImpl.$$$reportNull$$$0(5);
        }
        super.serialize(outputStream);
        JSTypeSerializer.TYPE_SERIALIZER.write(this.myOwner, outputStream);
        JSTypeSerializer.TYPE_SERIALIZER.write(this.myParameterType, outputStream);
    }

    @Override
    protected void buildTypeTextImpl(@NotNull JSType.TypeTextFormat format, @NotNull JSTypeTextBuilder builder2) {
        JSType owner;
        boolean shouldWrap;
        if (format == null) {
            TypeScriptIndexedAccessJSTypeImpl.$$$reportNull$$$0(6);
        }
        if (builder2 == null) {
            TypeScriptIndexedAccessJSTypeImpl.$$$reportNull$$$0(7);
        }
        if (shouldWrap = JSTypeUtils.isNeedWrapTypeForSerialization(owner = this.getOwner())) {
            builder2.append("(");
        }
        owner.buildTypeText(format, builder2);
        if (shouldWrap) {
            builder2.append(")");
        }
        builder2.append("[");
        JSType type2 = this.getParameterType();
        type2.buildTypeText(format, builder2);
        builder2.append("]");
    }

    @Override
    protected int hashCodeImpl() {
        return Objects.hash(this.getOwner(), this.getParameterType());
    }

    @Override
    @NotNull
    protected JSType copyTypeHierarchy(@NotNull Function<? super JSType, ? extends JSType> childTransform, @NotNull JSTypeSource newSource) {
        if (childTransform == null) {
            TypeScriptIndexedAccessJSTypeImpl.$$$reportNull$$$0(8);
        }
        if (newSource == null) {
            TypeScriptIndexedAccessJSTypeImpl.$$$reportNull$$$0(9);
        }
        JSType newOwner = JSTypeUtils.transformTypeHierarchySafe(this.getOwner(), childTransform);
        JSType newParameterType = JSTypeUtils.transformTypeHierarchySafe(this.getParameterType(), childTransform);
        if (newOwner == this.getOwner() && newParameterType == this.getParameterType()) {
            TypeScriptIndexedAccessJSTypeImpl typeScriptIndexedAccessJSTypeImpl = this;
            if (typeScriptIndexedAccessJSTypeImpl == null) {
                TypeScriptIndexedAccessJSTypeImpl.$$$reportNull$$$0(10);
            }
            return typeScriptIndexedAccessJSTypeImpl;
        }
        JSType jSType = JSCompositeTypeFactory.createIndexedAccessType(newOwner, newParameterType, newSource);
        if (jSType == null) {
            TypeScriptIndexedAccessJSTypeImpl.$$$reportNull$$$0(11);
        }
        return jSType;
    }

    @Override
    protected boolean isDirectlyAssignableTypeImpl(@NotNull JSType elementType, @NotNull ProcessingContext processingContext) {
        JSType subst;
        JSType constraintType;
        JSType substitute;
        if (elementType == null) {
            TypeScriptIndexedAccessJSTypeImpl.$$$reportNull$$$0(12);
        }
        if (processingContext == null) {
            TypeScriptIndexedAccessJSTypeImpl.$$$reportNull$$$0(13);
        }
        if (!((substitute = this.substituteCompletely()) instanceof JSAnyType) && substitute != this && substitute.isDirectlyAssignableType(elementType, processingContext)) {
            return true;
        }
        JSType parameterType = this.getParameterType();
        if (elementType instanceof TypeScriptIndexedAccessJSTypeImpl && parameterType instanceof JSGenericParameterImpl && ((TypeScriptIndexedAccessJSTypeImpl)elementType).getParameterType() instanceof JSGenericParameterImpl) {
            JSType thisOwner = this.getOwner();
            JSType otherOwner = ((TypeScriptIndexedAccessJSTypeImpl)elementType).getOwner();
            return thisOwner.isDirectlyAssignableType(otherOwner, processingContext);
        }
        JSType owner = this.getOwner();
        if (owner instanceof JSGenericParameterImpl && (constraintType = ((JSGenericParameterImpl)owner).getConstraintType()) != null && JSCompositeTypeFactory.createIndexedAccessType(constraintType, parameterType, this.getSource()).isDirectlyAssignableType(elementType, processingContext)) {
            return true;
        }
        if (parameterType instanceof JSGenericParameterImpl && (constraintType = ((JSGenericParameterImpl)parameterType).getConstraintType()) != null && (subst = constraintType.substitute()) instanceof JSUnionType) {
            for (JSType type2 : ((JSUnionType)subst).getTypes()) {
                if (!JSCompositeTypeFactory.createIndexedAccessType(owner, type2, this.getSource()).isDirectlyAssignableType(elementType, processingContext)) continue;
                return true;
            }
        }
        return super.isDirectlyAssignableTypeImpl(elementType, processingContext);
    }

    @Override
    @NotNull
    protected JSType copyWithNewSource(@NotNull JSTypeSource source) {
        if (source == null) {
            TypeScriptIndexedAccessJSTypeImpl.$$$reportNull$$$0(14);
        }
        return new TypeScriptIndexedAccessJSTypeImpl(this.getOwner(), this.getParameterType(), source);
    }

    @Override
    protected boolean isEquivalentToWithSameClass(@NotNull JSType type2, ProcessingContext context2, boolean allowResolve) {
        TypeScriptIndexedAccessJSTypeImpl indexedAccessJSType;
        if (type2 == null) {
            TypeScriptIndexedAccessJSTypeImpl.$$$reportNull$$$0(15);
        }
        return (indexedAccessJSType = (TypeScriptIndexedAccessJSTypeImpl)type2).getOwner().isEquivalentTo(this.getOwner(), context2, allowResolve) && indexedAccessJSType.getParameterType().isEquivalentTo(this.getParameterType(), context2, allowResolve);
    }

    @Override
    @Nullable
    public JSType substituteImpl(@NotNull JSTypeSubstitutionContext context2) {
        if (context2 == null) {
            TypeScriptIndexedAccessJSTypeImpl.$$$reportNull$$$0(16);
        }
        if (JSTypeUtils.hasSignificantGenericParameter(this, Collections.emptySet())) {
            return this;
        }
        return this.substituteInternal(context2);
    }

    @Override
    @NotNull
    public JSType substituteCompletely() {
        if (JSTypeUtils.hasSignificantGenericParameter(this, Collections.emptySet())) {
            JSType jSType = this.getResolveCachedType(() -> this.substituteInternal(new JSTypeSubstitutionContextImpl()), SUBSTITUTE_COMPLETE);
            if (jSType == null) {
                TypeScriptIndexedAccessJSTypeImpl.$$$reportNull$$$0(17);
            }
            return jSType;
        }
        JSType jSType = this.substitute();
        if (jSType == null) {
            TypeScriptIndexedAccessJSTypeImpl.$$$reportNull$$$0(18);
        }
        return jSType;
    }

    @Nullable
    public JSType substituteInternal(@NotNull JSTypeSubstitutionContext context2) {
        JSRecordType.IndexSignature applicableIndexer;
        JSType type2;
        String str;
        JSLiteralType strOrSymbol;
        JSType owner;
        JSType ownerType;
        if (context2 == null) {
            TypeScriptIndexedAccessJSTypeImpl.$$$reportNull$$$0(19);
        }
        if ((ownerType = context2.substituteNested(owner = this.getOwner())) == null) {
            return null;
        }
        JSType parameterType = this.getParameterType();
        JSType parameterTypeExpanded = context2.substituteNested(parameterType);
        if (parameterTypeExpanded == null) {
            return null;
        }
        Collection<JSLiteralType> keys = TypeScriptIndexedAccessJSTypeImpl.getParameterStringsAndSymbols(parameterTypeExpanded);
        if (ownerType instanceof JSTupleType && keys.size() == 1 && (strOrSymbol = (JSLiteralType)ContainerUtil.getFirstItem(keys)) instanceof JSPrimitiveLiteralType && StringUtil.isNotEmpty((String)(str = TypeScriptIndexedAccessJSTypeImpl.getLiteralValue(strOrSymbol))) && StringUtil.isDecimalDigit((char)str.charAt(0))) {
            try {
                int index = (int)Double.parseDouble(str);
                if (((JSTupleType)ownerType).hasTypeByIndex(index) && (type2 = ((JSTupleType)ownerType).getTypeByIndex(index)) != null) {
                    return type2;
                }
            }
            catch (NumberFormatException index) {
                // empty catch block
            }
        }
        JSRecordType recordType = null;
        SmartList result2 = new SmartList();
        HashSet<String> processed = new HashSet<String>();
        if (!keys.isEmpty()) {
            HashMap<String, JSRecordType.PropertySignature> allSignatures = null;
            recordType = ownerType.asRecordType();
            boolean isStrictNullChecks = TypeScriptConfigUtil.strictNullChecks(this.getSourceElement());
            for (JSLiteralType keyType : keys) {
                JSType type3;
                JSTypeOwner propertySignature = null;
                if (keyType instanceof JSPrimitiveLiteralType) {
                    String name = TypeScriptIndexedAccessJSTypeImpl.getLiteralValue(keyType);
                    if (name == null || !processed.add(name)) continue;
                    propertySignature = recordType.findPropertySignature(name);
                    if (propertySignature == null) {
                        if (allSignatures == null) {
                            allSignatures = new HashMap<String, JSRecordType.PropertySignature>();
                            TypeScriptIndexedAccessJSTypeImpl.collectPropertySignatures(ownerType, allSignatures);
                        }
                        propertySignature = (JSRecordType.PropertySignature)allSignatures.get(name);
                    }
                } else if (keyType instanceof JSUniqueSymbolTypeImpl) {
                    JSUniqueSymbolTypeImpl symbolType = (JSUniqueSymbolTypeImpl)keyType;
                    propertySignature = recordType.findComputedPropertySignatureByKeyType(symbolType);
                }
                if (propertySignature == null || (type3 = propertySignature.getJSType()) == null) continue;
                TypeScriptIndexedAccessJSTypeImpl.resolvePsiBasedTypeAndAdd((List<JSType>)result2, type3, isStrictNullChecks && propertySignature.isOptional());
            }
            if (!result2.isEmpty()) {
                return JSCompositeTypeFactory.createUnionType(this.getSource(), (Collection<? extends JSType>)result2);
            }
        }
        if ((type2 = TypeScriptLiteralKeyUtil.getTypeFromComputedNameProperty(ownerType, parameterType)) != null) {
            return type2;
        }
        if (recordType == null) {
            recordType = ownerType.asRecordType();
        }
        if ((applicableIndexer = JSRecordTypeImpl.findApplicableIndexer(recordType, parameterType)) != null) {
            return applicableIndexer.getMemberType();
        }
        if (parameterTypeExpanded instanceof TypeScriptNeverType) {
            return JSNamedTypeFactory.createNeverType(this.getSource());
        }
        return JSAnyType.get(this.getSource());
    }

    private static void resolvePsiBasedTypeAndAdd(@NotNull List<JSType> result2, @NotNull JSType type2, boolean addUndefined) {
        if (result2 == null) {
            TypeScriptIndexedAccessJSTypeImpl.$$$reportNull$$$0(20);
        }
        if (type2 == null) {
            TypeScriptIndexedAccessJSTypeImpl.$$$reportNull$$$0(21);
        }
        if (type2 instanceof JSPsiBasedTypeOfType) {
            TypeScriptIndexedAccessJSTypeImpl.wrapWithUndefinedAndAdd(result2, type2.substitute(), addUndefined);
            return;
        }
        TypeScriptIndexedAccessJSTypeImpl.wrapWithUndefinedAndAdd(result2, type2, addUndefined);
    }

    private static void wrapWithUndefinedAndAdd(@NotNull List<JSType> result2, @NotNull JSType type2, boolean addUndefined) {
        if (result2 == null) {
            TypeScriptIndexedAccessJSTypeImpl.$$$reportNull$$$0(22);
        }
        if (type2 == null) {
            TypeScriptIndexedAccessJSTypeImpl.$$$reportNull$$$0(23);
        }
        if (addUndefined) {
            type2 = JSTypeGuardUtil.wrapWithUndefined(type2, type2.getSource());
        }
        result2.add(type2);
    }

    private static void collectPropertySignatures(@Nullable JSType ownerType, @NotNull Map<String, JSRecordType.PropertySignature> signatures) {
        if (signatures == null) {
            TypeScriptIndexedAccessJSTypeImpl.$$$reportNull$$$0(24);
        }
        if (ownerType instanceof JSResolvableType) {
            JSResolvedTypeInfo resolvedTypeInfo = ((JSResolvableType)ownerType).resolveType();
            TypeScriptIndexedAccessJSTypeImpl.collectClassSignatures(resolvedTypeInfo, signatures);
        }
        if (ownerType instanceof JSIntersectionType) {
            for (JSType type2 : ((JSIntersectionType)ownerType).getTypes()) {
                TypeScriptIndexedAccessJSTypeImpl.collectPropertySignatures(type2, signatures);
            }
        }
    }

    private static void collectClassSignatures(@Nullable JSResolvedTypeInfo resolvedTypeInfo, @NotNull Map<String, JSRecordType.PropertySignature> signatures) {
        if (signatures == null) {
            TypeScriptIndexedAccessJSTypeImpl.$$$reportNull$$$0(25);
        }
        if (resolvedTypeInfo == null) {
            return;
        }
        for (JSClass jsClass : resolvedTypeInfo.getDeclarationsOfType(JSClass.class)) {
            for (JSElement jSElement : jsClass.getMembers()) {
                if (!(jSElement instanceof JSRecordType.PropertySignature)) continue;
                signatures.put(((JSRecordType.PropertySignature)((Object)jSElement)).getMemberName(), (JSRecordType.PropertySignature)((Object)jSElement));
            }
        }
    }

    @Nullable
    private static String getEnumConstFieldValue(TypeScriptEnumField field) {
        EnumConstantValue value = field.getConstantValue();
        String stringValue = value.getStringValue();
        if (stringValue != null) {
            return stringValue;
        }
        Double numericValue = value.getNumericValue();
        if (numericValue != null) {
            return value.getAsString();
        }
        return null;
    }

    @Nullable
    private static String getLiteralValue(@NotNull JSLiteralType el) {
        if (el == null) {
            TypeScriptIndexedAccessJSTypeImpl.$$$reportNull$$$0(26);
        }
        if (el instanceof JSStringLiteralTypeImpl) {
            return ((JSStringLiteralTypeImpl)el).getLiteral();
        }
        return el instanceof JSPrimitiveLiteralType ? ((JSPrimitiveLiteralType)el).getValueAsString() : null;
    }

    @NotNull
    private static Collection<JSLiteralType> getParameterStringsAndSymbols(@NotNull JSType expandedType) {
        if (expandedType == null) {
            TypeScriptIndexedAccessJSTypeImpl.$$$reportNull$$$0(27);
        }
        if (expandedType instanceof JSUniqueSymbolTypeImpl) {
            List list2 = ContainerUtil.createMaybeSingletonList((Object)((JSUniqueSymbolTypeImpl)expandedType));
            if (list2 == null) {
                TypeScriptIndexedAccessJSTypeImpl.$$$reportNull$$$0(28);
            }
            return list2;
        }
        if (expandedType instanceof JSStringLiteralTypeImpl) {
            List list3 = ContainerUtil.createMaybeSingletonList((Object)((JSStringLiteralTypeImpl)expandedType));
            if (list3 == null) {
                TypeScriptIndexedAccessJSTypeImpl.$$$reportNull$$$0(29);
            }
            return list3;
        }
        if (expandedType instanceof JSNumberLiteralTypeImpl) {
            List list4 = ContainerUtil.createMaybeSingletonList((Object)((JSNumberLiteralTypeImpl)expandedType));
            if (list4 == null) {
                TypeScriptIndexedAccessJSTypeImpl.$$$reportNull$$$0(30);
            }
            return list4;
        }
        if (expandedType instanceof JSResolvableType) {
            TypeScriptEnum tsEnum;
            String constFieldValue;
            TypeScriptEnumField field;
            JSResolvedTypeInfo info2 = ((JSResolvableType)expandedType).resolveType();
            if (info2.isEnumLiteral() && (field = info2.getDeclarationOfType(TypeScriptEnumField.class)) != null && (constFieldValue = TypeScriptIndexedAccessJSTypeImpl.getEnumConstFieldValue(field)) != null) {
                List list5 = ContainerUtil.createMaybeSingletonList((Object)new JSStringLiteralTypeImpl(constFieldValue, false, JSTypeSourceFactory.createTypeSource((PsiElement)field, true)));
                if (list5 == null) {
                    TypeScriptIndexedAccessJSTypeImpl.$$$reportNull$$$0(31);
                }
                return list5;
            }
            if (info2.isEnumWithLiteralValues() && (tsEnum = info2.getDeclarationOfType(TypeScriptEnum.class)) != null) {
                JSField[] fields = tsEnum.getFields();
                ArrayList<JSLiteralType> fieldValues = new ArrayList<JSLiteralType>(fields.length);
                for (JSField field2 : fields) {
                    String constFieldValue2 = TypeScriptIndexedAccessJSTypeImpl.getEnumConstFieldValue((TypeScriptEnumField)field2);
                    if (constFieldValue2 == null) {
                        List list6 = ContainerUtil.emptyList();
                        if (list6 == null) {
                            TypeScriptIndexedAccessJSTypeImpl.$$$reportNull$$$0(32);
                        }
                        return list6;
                    }
                    fieldValues.add(new JSStringLiteralTypeImpl(constFieldValue2, false, JSTypeSourceFactory.createTypeSource((PsiElement)field2, true)));
                }
                ArrayList<JSLiteralType> arrayList = fieldValues;
                if (arrayList == null) {
                    TypeScriptIndexedAccessJSTypeImpl.$$$reportNull$$$0(33);
                }
                return arrayList;
            }
            Set<JSLiteralType> set = Collections.emptySet();
            if (set == null) {
                TypeScriptIndexedAccessJSTypeImpl.$$$reportNull$$$0(34);
            }
            return set;
        }
        if (expandedType instanceof JSGenericParameterImpl) {
            JSType constraintType = ((JSGenericParameterImpl)expandedType).getConstraintType();
            if (constraintType != null) {
                return TypeScriptIndexedAccessJSTypeImpl.getParameterStringsAndSymbols(constraintType.substitute());
            }
            Set<JSLiteralType> set = Collections.emptySet();
            if (set == null) {
                TypeScriptIndexedAccessJSTypeImpl.$$$reportNull$$$0(35);
            }
            return set;
        }
        if (expandedType instanceof JSUnionType) {
            LinkedHashSet<JSLiteralType> result2 = new LinkedHashSet<JSLiteralType>();
            for (JSType jsType : ((JSUnionType)expandedType).getTypes()) {
                result2.addAll(TypeScriptIndexedAccessJSTypeImpl.getParameterStringsAndSymbols(jsType));
            }
            LinkedHashSet<JSLiteralType> linkedHashSet = result2;
            if (linkedHashSet == null) {
                TypeScriptIndexedAccessJSTypeImpl.$$$reportNull$$$0(36);
            }
            return linkedHashSet;
        }
        if (expandedType instanceof JSIntersectionType) {
            HashSet<JSLiteralType> result3 = new HashSet<JSLiteralType>();
            for (JSType constituent : ((JSIntersectionType)expandedType).getTypes()) {
                if (result3.isEmpty()) {
                    result3.addAll(TypeScriptIndexedAccessJSTypeImpl.getParameterStringsAndSymbols(constituent));
                    continue;
                }
                Collection<JSLiteralType> elements = TypeScriptIndexedAccessJSTypeImpl.getParameterStringsAndSymbols(constituent);
                List ids = ContainerUtil.map(elements, type2 -> TypeScriptIndexedAccessJSTypeImpl.getPrimitiveId(type2));
                result3.removeIf(el -> !ids.contains(TypeScriptIndexedAccessJSTypeImpl.getPrimitiveId(el)));
            }
            HashSet<JSLiteralType> hashSet = result3;
            if (hashSet == null) {
                TypeScriptIndexedAccessJSTypeImpl.$$$reportNull$$$0(37);
            }
            return hashSet;
        }
        JSType substitute = JSTypeWithIncompleteSubstitution.substituteCompletely(expandedType);
        if (substitute != expandedType) {
            return TypeScriptIndexedAccessJSTypeImpl.getParameterStringsAndSymbols(substitute);
        }
        List list7 = ContainerUtil.emptyList();
        if (list7 == null) {
            TypeScriptIndexedAccessJSTypeImpl.$$$reportNull$$$0(38);
        }
        return list7;
    }

    @NotNull
    private static JSResolvedTypeId getPrimitiveId(@NotNull JSLiteralType type2) {
        if (type2 == null) {
            TypeScriptIndexedAccessJSTypeImpl.$$$reportNull$$$0(39);
        }
        JSType primitiveType = type2.asPrimitiveType();
        JSResolvedTypeId jSResolvedTypeId = primitiveType.getResolvedTypeId();
        if (jSResolvedTypeId == null) {
            TypeScriptIndexedAccessJSTypeImpl.$$$reportNull$$$0(40);
        }
        return jSResolvedTypeId;
    }

    @Override
    public void acceptChildren(@NotNull JSRecursiveTypeVisitor visitor) {
        if (visitor == null) {
            TypeScriptIndexedAccessJSTypeImpl.$$$reportNull$$$0(41);
        }
        this.getOwner().accept(visitor);
        this.getParameterType().accept(visitor);
    }

    @NotNull
    public JSType getOwner() {
        JSType jSType = this.myOwner;
        if (jSType == null) {
            TypeScriptIndexedAccessJSTypeImpl.$$$reportNull$$$0(42);
        }
        return jSType;
    }

    @NotNull
    public JSType getParameterType() {
        JSType jSType = this.myParameterType;
        if (jSType == null) {
            TypeScriptIndexedAccessJSTypeImpl.$$$reportNull$$$0(43);
        }
        return jSType;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 10, 11, 17, 18, 28, 29, 30, 31, 32, 33, 34, 35, 36, 37, 38, 40, 42, 43 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "owner";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parameterType";
                break;
            }
            case 2: 
            case 3: 
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "source";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "inputStream";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "outputStream";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "format";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "builder";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "childTransform";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "newSource";
                break;
            }
            case 10: 
            case 11: 
            case 17: 
            case 18: 
            case 28: 
            case 29: 
            case 30: 
            case 31: 
            case 32: 
            case 33: 
            case 34: 
            case 35: 
            case 36: 
            case 37: 
            case 38: 
            case 40: 
            case 42: 
            case 43: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/javascript/psi/types/TypeScriptIndexedAccessJSTypeImpl";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "elementType";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "processingContext";
                break;
            }
            case 15: 
            case 21: 
            case 23: 
            case 39: {
                objectArray2 = objectArray3;
                objectArray3[0] = "type";
                break;
            }
            case 16: 
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 20: 
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "result";
                break;
            }
            case 24: 
            case 25: {
                objectArray2 = objectArray3;
                objectArray3[0] = "signatures";
                break;
            }
            case 26: {
                objectArray2 = objectArray3;
                objectArray3[0] = "el";
                break;
            }
            case 27: {
                objectArray2 = objectArray3;
                objectArray3[0] = "expandedType";
                break;
            }
            case 41: {
                objectArray2 = objectArray3;
                objectArray3[0] = "visitor";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/javascript/psi/types/TypeScriptIndexedAccessJSTypeImpl";
                break;
            }
            case 10: 
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "copyTypeHierarchy";
                break;
            }
            case 17: 
            case 18: {
                objectArray = objectArray2;
                objectArray2[1] = "substituteCompletely";
                break;
            }
            case 28: 
            case 29: 
            case 30: 
            case 31: 
            case 32: 
            case 33: 
            case 34: 
            case 35: 
            case 36: 
            case 37: 
            case 38: {
                objectArray = objectArray2;
                objectArray2[1] = "getParameterStringsAndSymbols";
                break;
            }
            case 40: {
                objectArray = objectArray2;
                objectArray2[1] = "getPrimitiveId";
                break;
            }
            case 42: {
                objectArray = objectArray2;
                objectArray2[1] = "getOwner";
                break;
            }
            case 43: {
                objectArray = objectArray2;
                objectArray2[1] = "getParameterType";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "serialize";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "buildTypeTextImpl";
                break;
            }
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "copyTypeHierarchy";
                break;
            }
            case 10: 
            case 11: 
            case 17: 
            case 18: 
            case 28: 
            case 29: 
            case 30: 
            case 31: 
            case 32: 
            case 33: 
            case 34: 
            case 35: 
            case 36: 
            case 37: 
            case 38: 
            case 40: 
            case 42: 
            case 43: {
                break;
            }
            case 12: 
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "isDirectlyAssignableTypeImpl";
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "copyWithNewSource";
                break;
            }
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "isEquivalentToWithSameClass";
                break;
            }
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "substituteImpl";
                break;
            }
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "substituteInternal";
                break;
            }
            case 20: 
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "resolvePsiBasedTypeAndAdd";
                break;
            }
            case 22: 
            case 23: {
                objectArray = objectArray;
                objectArray[2] = "wrapWithUndefinedAndAdd";
                break;
            }
            case 24: {
                objectArray = objectArray;
                objectArray[2] = "collectPropertySignatures";
                break;
            }
            case 25: {
                objectArray = objectArray;
                objectArray[2] = "collectClassSignatures";
                break;
            }
            case 26: {
                objectArray = objectArray;
                objectArray[2] = "getLiteralValue";
                break;
            }
            case 27: {
                objectArray = objectArray;
                objectArray[2] = "getParameterStringsAndSymbols";
                break;
            }
            case 39: {
                objectArray = objectArray;
                objectArray[2] = "getPrimitiveId";
                break;
            }
            case 41: {
                objectArray = objectArray;
                objectArray[2] = "acceptChildren";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 10, 11, 17, 18, 28, 29, 30, 31, 32, 33, 34, 35, 36, 37, 38, 40, 42, 43 -> new IllegalStateException(string);
        };
    }
}

