/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.psi.types;

import com.intellij.lang.javascript.DialectDetector;
import com.intellij.lang.javascript.dialects.JSDialectSpecificHandlersFactory;
import com.intellij.lang.javascript.ecmascript6.types.TypeScriptOverloadContextualType;
import com.intellij.lang.javascript.evaluation.JSCodeBasedTypeFactory;
import com.intellij.lang.javascript.psi.ExpectedTypeEvaluator;
import com.intellij.lang.javascript.psi.JSArgumentList;
import com.intellij.lang.javascript.psi.JSArrayLiteralExpression;
import com.intellij.lang.javascript.psi.JSExpectedTypeKind;
import com.intellij.lang.javascript.psi.JSExpression;
import com.intellij.lang.javascript.psi.JSFunction;
import com.intellij.lang.javascript.psi.JSFunctionExpression;
import com.intellij.lang.javascript.psi.JSFunctionItem;
import com.intellij.lang.javascript.psi.JSLiteralExpression;
import com.intellij.lang.javascript.psi.JSObjectLiteralExpression;
import com.intellij.lang.javascript.psi.JSParenthesizedExpression;
import com.intellij.lang.javascript.psi.JSProperty;
import com.intellij.lang.javascript.psi.JSRecordType;
import com.intellij.lang.javascript.psi.JSReturnStatement;
import com.intellij.lang.javascript.psi.JSSpreadExpression;
import com.intellij.lang.javascript.psi.JSType;
import com.intellij.lang.javascript.psi.JSTypeSubstitutionContext;
import com.intellij.lang.javascript.psi.JSTypeTextBuilder;
import com.intellij.lang.javascript.psi.JSTypeUtils;
import com.intellij.lang.javascript.psi.ecma6.JSStringTemplateExpression;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptCastExpression;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptConstType;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptVariable;
import com.intellij.lang.javascript.psi.resolve.JSEvaluateContext;
import com.intellij.lang.javascript.psi.resolve.JSEvaluationRecursionGuard;
import com.intellij.lang.javascript.psi.resolve.JSTypeEvaluationResultProcessor;
import com.intellij.lang.javascript.psi.resolve.complexity.JSEvaluationTask;
import com.intellij.lang.javascript.psi.types.JSArrayType;
import com.intellij.lang.javascript.psi.types.JSCodeBasedType;
import com.intellij.lang.javascript.psi.types.JSCompositeTypeFactory;
import com.intellij.lang.javascript.psi.types.JSDistributedType;
import com.intellij.lang.javascript.psi.types.JSEvaluableType;
import com.intellij.lang.javascript.psi.types.JSFreshObjectLiteralType;
import com.intellij.lang.javascript.psi.types.JSFunctionTypeImpl;
import com.intellij.lang.javascript.psi.types.JSGenericTypeImpl;
import com.intellij.lang.javascript.psi.types.JSLiteralType;
import com.intellij.lang.javascript.psi.types.JSPsiBasedTypeOfType;
import com.intellij.lang.javascript.psi.types.JSReadonlyArrayTypeImpl;
import com.intellij.lang.javascript.psi.types.JSRecordTypeImpl;
import com.intellij.lang.javascript.psi.types.JSRecursiveTypeVisitor;
import com.intellij.lang.javascript.psi.types.JSTupleType;
import com.intellij.lang.javascript.psi.types.JSTypeBaseImpl;
import com.intellij.lang.javascript.psi.types.JSTypeSerializer;
import com.intellij.lang.javascript.psi.types.JSTypeSource;
import com.intellij.lang.javascript.psi.types.JSTypeSourceFactory;
import com.intellij.lang.javascript.psi.types.JSTypeWithWidening;
import com.intellij.lang.javascript.psi.types.JSTypeofTypeImpl;
import com.intellij.lang.javascript.psi.types.JSUnionOrIntersectionType;
import com.intellij.lang.javascript.psi.types.JSUnionType;
import com.intellij.lang.javascript.psi.types.JSUtilType;
import com.intellij.lang.javascript.psi.types.JSWrapperType;
import com.intellij.lang.javascript.psi.types.evaluable.JSPropertiesOwnerType;
import com.intellij.lang.javascript.psi.types.guard.TypeScriptTypeRelations;
import com.intellij.lang.javascript.psi.types.primitives.JSNullType;
import com.intellij.lang.javascript.psi.types.primitives.JSUndefinedType;
import com.intellij.lang.javascript.psi.types.recordImpl.PropertySignatureImpl;
import com.intellij.lang.javascript.psi.types.typescript.TypeScriptGenericParameterImpl;
import com.intellij.lang.javascript.psi.util.JSDestructuringUtil;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.RecursionManager;
import com.intellij.openapi.util.Ref;
import com.intellij.psi.PsiElement;
import com.intellij.util.Function;
import com.intellij.util.ObjectUtils;
import com.intellij.util.ProcessingContext;
import com.intellij.util.containers.ContainerUtil;
import java.text.CharacterIterator;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class JSWidenType
extends JSTypeBaseImpl
implements JSWrapperType,
JSCodeBasedType {
    @NotNull
    private final Widening myWideningFunction;
    @NotNull
    private final JSType myType;
    private static final int EVALUATE_MAX_ITERATIONS = 100;

    @Contract(value="null, _ -> null")
    public static JSType createWidening(@Nullable JSType type2, @Nullable PsiElement contextOwner) {
        if (type2 == null || type2 instanceof JSUtilType && !(type2 instanceof JSNullType) && !(type2 instanceof JSUndefinedType) && !(type2 instanceof JSTypeWithWidening)) {
            return type2;
        }
        if (contextOwner instanceof TypeScriptVariable) {
            boolean isConst;
            boolean bl = isConst = ((TypeScriptVariable)contextOwner).isConst() && !JSDestructuringUtil.isDestructuring(contextOwner.getParent());
            if (type2 instanceof JSLiteralType) {
                return isConst || !((JSTypeWithWidening)type2).allowWidening() ? (JSTypeWithWidening)type2 : ((JSTypeWithWidening)type2).widen(false);
            }
            return new JSWidenType(type2, isConst);
        }
        if (contextOwner instanceof JSArrayLiteralExpression || contextOwner instanceof JSProperty) {
            return new JSWidenType(type2, new ExpectedTypeWidening(contextOwner));
        }
        if (contextOwner instanceof JSObjectLiteralExpression && contextOwner.getParent() instanceof JSArgumentList) {
            return new JSWidenType(type2, new OnlyApplyConstContext(contextOwner));
        }
        if (type2 instanceof JSLiteralType) {
            return ((JSLiteralType)type2).allowWidening() ? ((JSTypeWithWidening)type2).widen(false) : type2;
        }
        return new JSWidenType(type2);
    }

    @Nullable
    private static JSType getTypeIfConstantContext(@NotNull JSType type2, @Nullable PsiElement element) {
        ConstContextKind constContextKind;
        if (type2 == null) {
            JSWidenType.$$$reportNull$$$0(0);
        }
        if (JSWidenType.dependsOnConstContext(type2) && (constContextKind = JSWidenType.getConstContextKind(element)) != ConstContextKind.NONE) {
            return JSWidenType.getTypeInConstContext(type2, constContextKind.isApplyConstDeep(), JSWidenType.createEvaluateContext(element));
        }
        return null;
    }

    @NotNull
    private static ConstContextKind getConstContextKind(@Nullable PsiElement element) {
        JSExpression expression;
        if (JSWidenType.isConstContextSimple(element)) {
            ConstContextKind constContextKind = ConstContextKind.SIMPLE;
            if (constContextKind == null) {
                JSWidenType.$$$reportNull$$$0(1);
            }
            return constContextKind;
        }
        if (element instanceof JSExpression && JSWidenType.canBeInGenericConstContext(expression = (JSExpression)element) && JSWidenType.isConstContextByGenericParamConstModifier(expression)) {
            ConstContextKind constContextKind = ConstContextKind.GENERIC_PARAM_CONST_MODIFIER;
            if (constContextKind == null) {
                JSWidenType.$$$reportNull$$$0(2);
            }
            return constContextKind;
        }
        ConstContextKind constContextKind = ConstContextKind.NONE;
        if (constContextKind == null) {
            JSWidenType.$$$reportNull$$$0(3);
        }
        return constContextKind;
    }

    private static JSEvaluateContext createEvaluateContext(@Nullable PsiElement element) {
        return new JSEvaluateContext(element != null ? element.getContainingFile() : null);
    }

    private static boolean dependsOnConstContext(@NotNull JSType original) {
        if (original == null) {
            JSWidenType.$$$reportNull$$$0(4);
        }
        return original instanceof JSTupleType || original instanceof JSRecordType || original instanceof JSLiteralType || original instanceof JSArrayType;
    }

    @Nullable
    public static JSType getTypeInConstContext(@NotNull JSType original, boolean deep, JSEvaluateContext evaluateContext) {
        if (original == null) {
            JSWidenType.$$$reportNull$$$0(5);
        }
        return (JSType)JSEvaluationRecursionGuard.evaluateWithGuard(original, evaluateContext, () -> {
            if (original instanceof JSTupleType) {
                return JSWidenType.getReadonlyTupleType((JSTupleType)original, deep, evaluateContext);
            }
            if (original instanceof JSRecordType) {
                return JSWidenType.makePropsReadonly(original, deep, evaluateContext);
            }
            if (original instanceof JSLiteralType) {
                return ((JSLiteralType)original).copyWithAllowWidening(false);
            }
            if (original instanceof JSArrayType) {
                JSType itemType = ((JSArrayType)original).getType();
                JSType newItemType = deep && itemType != null ? JSWidenType.getTypeInConstContext(itemType, deep, evaluateContext) : itemType;
                return new JSReadonlyArrayTypeImpl(newItemType, original.getSource());
            }
            if (deep) {
                JSType reevaluated = JSWidenType.evaluateAsConst(original, evaluateContext);
                if (reevaluated == null) {
                    return original;
                }
                return JSWidenType.getTypeInConstContext(reevaluated.substitute(), deep, evaluateContext);
            }
            return original;
        });
    }

    @NotNull
    private static JSType getReadonlyTupleType(@NotNull JSTupleType original, boolean deep, JSEvaluateContext evaluateContext) {
        if (original == null) {
            JSWidenType.$$$reportNull$$$0(6);
        }
        List types2 = deep ? ContainerUtil.map(original.getTypes(), type2 -> JSWidenType.getTypeInConstContext(type2, deep, evaluateContext)) : original.getTypes();
        JSType jSType = JSCompositeTypeFactory.createTupleType(original.getSource(), types2, original.isSourceStrict(), original.getOptionalStart(), true);
        if (jSType == null) {
            JSWidenType.$$$reportNull$$$0(7);
        }
        return jSType;
    }

    @NotNull
    private static JSType makePropsReadonly(@NotNull JSType original, boolean deep, JSEvaluateContext evaluateContext) {
        if (original == null) {
            JSWidenType.$$$reportNull$$$0(8);
        }
        List<JSRecordType.TypeMember> originalMembers = ((JSRecordType)original).getTypeMembers();
        ArrayList<JSRecordType.TypeMember> members = new ArrayList<JSRecordType.TypeMember>(originalMembers.size());
        boolean modified = false;
        for (JSRecordType.TypeMember member : originalMembers) {
            JSRecordType.PropertySignature propertySignature = (JSRecordType.PropertySignature)ObjectUtils.tryCast((Object)member, JSRecordType.PropertySignature.class);
            if (propertySignature != null) {
                modified = true;
                JSType propertyType = deep && propertySignature.getJSType() != null ? JSWidenType.getTypeInConstContext(propertySignature.getJSType(), deep, evaluateContext) : propertySignature.getJSType();
                members.add(new PropertySignatureImpl(propertySignature.getMemberName(), propertySignature.isPrivateName(), propertySignature.getPrivateNameDepth(), true, propertyType, null, propertySignature.isOptional(), propertySignature.isNumericKey(), member.getMemberSource()));
                continue;
            }
            members.add(member);
        }
        JSType jSType = modified ? new JSRecordTypeImpl(original.getSource(), members) : original;
        if (jSType == null) {
            JSWidenType.$$$reportNull$$$0(9);
        }
        return jSType;
    }

    @Contract(value="null -> false")
    public static boolean isConstContext(@Nullable PsiElement element) {
        return JSWidenType.getConstContextKind(element) != ConstContextKind.NONE;
    }

    private static JSType evaluateAsConst(JSType inputType, JSEvaluateContext evaluateContext) {
        HashSet<JSType> seenTypes = new HashSet<JSType>();
        JSType type2 = inputType;
        for (int i = 0; i < 100; ++i) {
            if (type2 == null) {
                return null;
            }
            if (!seenTypes.add(type2)) {
                Logger.getInstance(JSWidenType.class).error("Possibly endless evaluation of: " + inputType + ", already seen type: " + type2);
                return type2;
            }
            if (type2 instanceof JSWidenType) {
                type2 = ((JSWidenType)type2).getOriginalType();
                continue;
            }
            if (type2 instanceof JSPsiBasedTypeOfType) {
                type2 = JSWidenType.evaluatePsiType((JSPsiBasedTypeOfType)type2, evaluateContext);
                continue;
            }
            if (type2 instanceof JSTypeofTypeImpl && type2.getSourceElement() != null) {
                type2 = JSWidenType.evaluatePsiType(JSCodeBasedTypeFactory.getPsiBasedType(type2.getSourceElement(), evaluateContext), evaluateContext);
                continue;
            }
            return type2;
        }
        Logger.getInstance(JSWidenType.class).error("Evaluation exceeded max iterations: " + inputType);
        return type2;
    }

    private static JSType evaluatePsiType(JSPsiBasedTypeOfType type2, JSEvaluateContext evaluateContext) {
        JSEvaluationTask evaluationTask = type2.evaluate(evaluateContext);
        JSTypeEvaluationResultProcessor processor = new JSTypeEvaluationResultProcessor();
        evaluationTask.applyWithContext(processor, evaluateContext);
        if (processor.getResult().getResults().size() == 1) {
            return processor.getResult().getResults().get(0).getType();
        }
        return null;
    }

    @Contract(value="null -> false")
    public static boolean isConstContextSimple(@Nullable PsiElement element) {
        PsiElement grandParent;
        if (element == null) {
            return false;
        }
        PsiElement parent = element.getContext();
        if (parent instanceof TypeScriptCastExpression) {
            return ((TypeScriptCastExpression)parent).getType() instanceof TypeScriptConstType;
        }
        if (parent instanceof JSParenthesizedExpression) {
            return JSWidenType.isConstContextSimple(parent);
        }
        if (parent instanceof JSArrayLiteralExpression) {
            return JSWidenType.isConstContextSimple(parent);
        }
        JSProperty property = (JSProperty)ObjectUtils.coalesce((Object)((JSProperty)ObjectUtils.tryCast((Object)parent, JSProperty.class)), (Object)((JSProperty)ObjectUtils.tryCast((Object)element, JSProperty.class)));
        if (property != null && (grandParent = property.getContext()) instanceof JSObjectLiteralExpression) {
            return JSWidenType.isConstContextSimple(grandParent);
        }
        if (parent instanceof JSSpreadExpression) {
            return JSWidenType.isConstContextSimple(parent);
        }
        if (parent instanceof JSStringTemplateExpression) {
            return JSWidenType.isConstContextSimple(parent);
        }
        return false;
    }

    public static boolean isConstContextByGenericParamConstModifier(@NotNull JSExpression expression) {
        TypeScriptGenericParameterImpl genericParam;
        JSType exprType;
        if (expression == null) {
            JSWidenType.$$$reportNull$$$0(10);
        }
        return (exprType = (JSType)RecursionManager.doPreventingRecursion((Object)expression, (boolean)false, () -> JSDialectSpecificHandlersFactory.findExpectedType(expression, JSExpectedTypeKind.CONTEXTUAL))) instanceof TypeScriptGenericParameterImpl && (genericParam = (TypeScriptGenericParameterImpl)exprType).isConst() && JSWidenType.isCorrectConstConstraintType(genericParam.getConstraintType());
    }

    private static boolean isCorrectConstConstraintType(@Nullable JSType constraintType) {
        if (constraintType instanceof JSTupleType) {
            JSTupleType tupleType = (JSTupleType)constraintType;
            return tupleType.isReadonly();
        }
        if (constraintType instanceof JSArrayType) {
            JSArrayType arrayType = (JSArrayType)constraintType;
            return arrayType.isReadonly();
        }
        return true;
    }

    public static boolean canBeInGenericConstContext(@NotNull JSExpression expression) {
        if (expression == null) {
            JSWidenType.$$$reportNull$$$0(11);
        }
        if (!DialectDetector.isTypeScript((PsiElement)expression)) {
            return false;
        }
        JSExpression element = expression;
        while (element instanceof JSLiteralExpression || element instanceof JSProperty || element instanceof JSObjectLiteralExpression || element instanceof JSArrayLiteralExpression) {
            if (element.getParent() instanceof JSArgumentList) {
                return true;
            }
            element = element.getParent();
        }
        return false;
    }

    @Contract(value="null, _ -> false")
    private static boolean isTupleLikeType(@Nullable JSType type2, boolean isTypeScript) {
        Ref isTuple;
        if (type2 == null) {
            return false;
        }
        if (JSTypeUtils.isSingleTypeAlias(type2)) {
            type2 = type2.substitute();
        }
        if (type2 instanceof JSUnionType) {
            isTuple = Ref.create((Object)false);
            for (JSType jsType : ((JSUnionType)type2).getTypes()) {
                RecursionManager.doPreventingRecursion((Object)type2.getResolvedTypeId(), (boolean)false, () -> {
                    isTuple.set((Object)JSWidenType.isTupleLikeType(jsType, isTypeScript));
                    return true;
                });
                if (!((Boolean)isTuple.get()).booleanValue()) continue;
                return true;
            }
        }
        if (type2 instanceof JSTupleType) {
            return true;
        }
        if (type2 instanceof JSGenericTypeImpl) {
            type2 = JSArrayType.GenericArrayBuilder.asArrayIfGenericType(type2);
        }
        if (!isTypeScript || type2 instanceof JSUtilType) {
            return false;
        }
        if (type2 instanceof TypeScriptOverloadContextualType) {
            return true;
        }
        isTuple = Ref.create((Object)false);
        JSType finalType = type2;
        RecursionManager.doPreventingRecursion((Object)type2.getResolvedTypeId(), (boolean)false, () -> {
            isTuple.set((Object)finalType.asRecordType().hasProperty("0"));
            return true;
        });
        return (Boolean)isTuple.get();
    }

    @Nullable
    private static JSType widenMultiStatementReturnType(@NotNull JSFunctionItem function2, @NotNull JSUnionType returnType, @NotNull JSTypeSubstitutionContext context2) {
        if (function2 == null) {
            JSWidenType.$$$reportNull$$$0(12);
        }
        if (returnType == null) {
            JSWidenType.$$$reportNull$$$0(13);
        }
        if (context2 == null) {
            JSWidenType.$$$reportNull$$$0(14);
        }
        JSType type2 = returnType.substitute(context2);
        boolean prohibitWidening = false;
        if (type2 instanceof JSUnionType && ((JSUnionType)type2).getTypes().stream().allMatch(JSTypeUtils::containsLiteralTypes)) {
            prohibitWidening = true;
        }
        if (!prohibitWidening) {
            return TypeScriptTypeRelations.subtypeReduction(JSTypeUtils.getApparentType(JSCompositeTypeFactory.optimizeTypeIfComposite(type2)), (PsiElement)function2);
        }
        return TypeScriptTypeRelations.subtypeReduction(JSCompositeTypeFactory.optimizeTypeIfComposite(type2), (PsiElement)function2);
    }

    @NotNull
    private static JSType widenOneStatementReturnType(@NotNull JSFunctionItem function2, @NotNull JSExpectedTypeKind kind, @NotNull JSType returnType, @NotNull JSTypeSubstitutionContext context2) {
        JSType type2;
        if (function2 == null) {
            JSWidenType.$$$reportNull$$$0(15);
        }
        if (kind == null) {
            JSWidenType.$$$reportNull$$$0(16);
        }
        if (returnType == null) {
            JSWidenType.$$$reportNull$$$0(17);
        }
        if (context2 == null) {
            JSWidenType.$$$reportNull$$$0(18);
        }
        boolean prohibitWidening = false;
        if (function2 instanceof JSFunctionExpression) {
            if (kind != JSExpectedTypeKind.CONTEXTUAL) {
                JSType jSType = returnType;
                if (jSType == null) {
                    JSWidenType.$$$reportNull$$$0(19);
                }
                return jSType;
            }
            JSType expectedType = JSDialectSpecificHandlersFactory.findExpectedType((JSExpression)((Object)function2), JSExpectedTypeKind.WIDENING);
            if (expectedType instanceof JSFunctionTypeImpl && JSTypeUtils.containsLiteralTypes(((JSFunctionTypeImpl)expectedType).getReturnType())) {
                prohibitWidening = true;
            }
        }
        if (!prohibitWidening && (type2 = returnType.substitute(context2)) instanceof JSUnionType && JSTypeUtils.containsLiteralTypes(type2)) {
            prohibitWidening = true;
        }
        if (!prohibitWidening) {
            returnType = JSTypeUtils.getApparentType(returnType);
        }
        JSType jSType = returnType;
        if (jSType == null) {
            JSWidenType.$$$reportNull$$$0(20);
        }
        return jSType;
    }

    public JSWidenType(@NotNull JSType type2, @NotNull Widening wideningFunction) {
        if (type2 == null) {
            JSWidenType.$$$reportNull$$$0(21);
        }
        if (wideningFunction == null) {
            JSWidenType.$$$reportNull$$$0(22);
        }
        this(type2, type2.getSource(), wideningFunction);
    }

    private JSWidenType(@NotNull JSType type2, boolean isConstVariable) {
        if (type2 == null) {
            JSWidenType.$$$reportNull$$$0(23);
        }
        this(type2, isConstVariable ? SimpleWidening.CONST_VARIABLE : SimpleWidening.INSTANCE);
    }

    private JSWidenType(@NotNull JSType type2) {
        if (type2 == null) {
            JSWidenType.$$$reportNull$$$0(24);
        }
        this(type2, SimpleWidening.INSTANCE);
    }

    private JSWidenType(@NotNull JSType type2, @NotNull JSTypeSource source, @NotNull Widening wideningFunction) {
        if (type2 == null) {
            JSWidenType.$$$reportNull$$$0(25);
        }
        if (source == null) {
            JSWidenType.$$$reportNull$$$0(26);
        }
        if (wideningFunction == null) {
            JSWidenType.$$$reportNull$$$0(27);
        }
        super(source);
        this.myType = type2 instanceof JSWidenType && ((JSWidenType)type2).getContextTypeProvider() == wideningFunction ? ((JSWidenType)type2).getOriginalType() : type2;
        this.myWideningFunction = wideningFunction;
    }

    public JSWidenType(@NotNull JSTypeSource source, @NotNull CharacterIterator inputStream) {
        if (source == null) {
            JSWidenType.$$$reportNull$$$0(28);
        }
        if (inputStream == null) {
            JSWidenType.$$$reportNull$$$0(29);
        }
        super(source);
        this.myType = JSTypeSerializer.TYPE_SERIALIZER.read(source, inputStream);
        boolean isConstVariable = JSTypeSerializer.readBoolean(inputStream);
        this.myWideningFunction = isConstVariable ? SimpleWidening.CONST_VARIABLE : SimpleWidening.INSTANCE;
    }

    @Override
    public void serialize(@NotNull StringBuilder outputStream) {
        if (outputStream == null) {
            JSWidenType.$$$reportNull$$$0(30);
        }
        super.serialize(outputStream);
        JSTypeSerializer.TYPE_SERIALIZER.write(this.myType, outputStream);
        assert (this.myWideningFunction instanceof SimpleWidening);
        JSTypeSerializer.writeBoolean(((SimpleWidening)this.myWideningFunction).myIsConstVariable, outputStream);
    }

    @Override
    public void acceptChildren(@NotNull JSRecursiveTypeVisitor visitor) {
        if (visitor == null) {
            JSWidenType.$$$reportNull$$$0(31);
        }
        this.myType.accept(visitor);
    }

    @Override
    @NotNull
    public JSType distributeType() {
        JSType substitute = this.substitute();
        if (substitute != this && substitute instanceof JSDistributedType) {
            JSType jSType = ((JSDistributedType)((Object)substitute)).distributeType();
            if (jSType == null) {
                JSWidenType.$$$reportNull$$$0(32);
            }
            return jSType;
        }
        JSWidenType jSWidenType = this;
        if (jSWidenType == null) {
            JSWidenType.$$$reportNull$$$0(33);
        }
        return jSWidenType;
    }

    @Override
    protected boolean isDirectlyAssignableTypeImpl(@NotNull JSType elementType, @NotNull ProcessingContext processingContext) {
        JSType jsType;
        if (elementType == null) {
            JSWidenType.$$$reportNull$$$0(34);
        }
        if (processingContext == null) {
            JSWidenType.$$$reportNull$$$0(35);
        }
        if ((jsType = this.substitute()) == this) {
            return true;
        }
        return jsType.isDirectlyAssignableType(elementType, processingContext);
    }

    @Override
    @NotNull
    protected JSType copyTypeHierarchy(@NotNull Function<? super JSType, ? extends JSType> childTransform, @NotNull JSTypeSource newSource) {
        JSType processed;
        if (childTransform == null) {
            JSWidenType.$$$reportNull$$$0(36);
        }
        if (newSource == null) {
            JSWidenType.$$$reportNull$$$0(37);
        }
        if ((processed = this.myType.transformTypeHierarchy(childTransform)) == this.myType) {
            JSWidenType jSWidenType = this;
            if (jSWidenType == null) {
                JSWidenType.$$$reportNull$$$0(38);
            }
            return jSWidenType;
        }
        if (processed instanceof JSLiteralType && this.myWideningFunction == SimpleWidening.INSTANCE) {
            JSType jSType = ((JSLiteralType)processed).widen(false);
            if (jSType == null) {
                JSWidenType.$$$reportNull$$$0(39);
            }
            return jSType;
        }
        return new JSWidenType(processed, this.myWideningFunction);
    }

    @Override
    @NotNull
    protected JSType copyWithNewSource(@NotNull JSTypeSource source) {
        if (source == null) {
            JSWidenType.$$$reportNull$$$0(40);
        }
        return new JSWidenType(this.myType, source, this.myWideningFunction);
    }

    @Override
    protected boolean isEquivalentToWithSameClass(@NotNull JSType type2, @Nullable ProcessingContext context2, boolean allowResolve) {
        if (type2 == null) {
            JSWidenType.$$$reportNull$$$0(41);
        }
        JSWidenType rType = (JSWidenType)type2;
        return this.myType.isEquivalentTo(rType.myType, context2, allowResolve) && Objects.equals(this.myWideningFunction, rType.myWideningFunction);
    }

    @Override
    protected int hashCodeImpl() {
        return Objects.hash(this.myType, this.myWideningFunction);
    }

    @Override
    @NotNull
    public JSType getOriginalType() {
        JSType jSType = this.myType;
        if (jSType == null) {
            JSWidenType.$$$reportNull$$$0(42);
        }
        return jSType;
    }

    @Override
    protected void buildTypeTextImpl(@NotNull JSType.TypeTextFormat format, @NotNull JSTypeTextBuilder builder2) {
        if (format == null) {
            JSWidenType.$$$reportNull$$$0(43);
        }
        if (builder2 == null) {
            JSWidenType.$$$reportNull$$$0(44);
        }
        if (format == JSType.TypeTextFormat.SIMPLE) {
            builder2.append("(widen ");
            this.myType.buildTypeText(format, builder2);
            builder2.append(")");
            return;
        }
        JSType substitute = this.substitute();
        if (substitute == this) {
            substitute = this.myType;
        }
        substitute.buildTypeText(format, builder2);
    }

    @Override
    @Nullable
    public JSType substituteImpl(@NotNull JSTypeSubstitutionContext context2) {
        if (context2 == null) {
            JSWidenType.$$$reportNull$$$0(45);
        }
        return this.myWideningFunction.apply(this.myType, context2);
    }

    @NotNull
    public Widening getContextTypeProvider() {
        Widening widening = this.myWideningFunction;
        if (widening == null) {
            JSWidenType.$$$reportNull$$$0(46);
        }
        return widening;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 1, 2, 3, 7, 9, 19, 20, 32, 33, 38, 39, 42, 46 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "type";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 7: 
            case 9: 
            case 19: 
            case 20: 
            case 32: 
            case 33: 
            case 38: 
            case 39: 
            case 42: 
            case 46: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/javascript/psi/types/JSWidenType";
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "original";
                break;
            }
            case 10: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "expression";
                break;
            }
            case 12: 
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "function";
                break;
            }
            case 13: 
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "returnType";
                break;
            }
            case 14: 
            case 18: 
            case 45: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "kind";
                break;
            }
            case 22: 
            case 27: {
                objectArray2 = objectArray3;
                objectArray3[0] = "wideningFunction";
                break;
            }
            case 26: 
            case 28: 
            case 40: {
                objectArray2 = objectArray3;
                objectArray3[0] = "source";
                break;
            }
            case 29: {
                objectArray2 = objectArray3;
                objectArray3[0] = "inputStream";
                break;
            }
            case 30: {
                objectArray2 = objectArray3;
                objectArray3[0] = "outputStream";
                break;
            }
            case 31: {
                objectArray2 = objectArray3;
                objectArray3[0] = "visitor";
                break;
            }
            case 34: {
                objectArray2 = objectArray3;
                objectArray3[0] = "elementType";
                break;
            }
            case 35: {
                objectArray2 = objectArray3;
                objectArray3[0] = "processingContext";
                break;
            }
            case 36: {
                objectArray2 = objectArray3;
                objectArray3[0] = "childTransform";
                break;
            }
            case 37: {
                objectArray2 = objectArray3;
                objectArray3[0] = "newSource";
                break;
            }
            case 43: {
                objectArray2 = objectArray3;
                objectArray3[0] = "format";
                break;
            }
            case 44: {
                objectArray2 = objectArray3;
                objectArray3[0] = "builder";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/javascript/psi/types/JSWidenType";
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getConstContextKind";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getReadonlyTupleType";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "makePropsReadonly";
                break;
            }
            case 19: 
            case 20: {
                objectArray = objectArray2;
                objectArray2[1] = "widenOneStatementReturnType";
                break;
            }
            case 32: 
            case 33: {
                objectArray = objectArray2;
                objectArray2[1] = "distributeType";
                break;
            }
            case 38: 
            case 39: {
                objectArray = objectArray2;
                objectArray2[1] = "copyTypeHierarchy";
                break;
            }
            case 42: {
                objectArray = objectArray2;
                objectArray2[1] = "getOriginalType";
                break;
            }
            case 46: {
                objectArray = objectArray2;
                objectArray2[1] = "getContextTypeProvider";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getTypeIfConstantContext";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 7: 
            case 9: 
            case 19: 
            case 20: 
            case 32: 
            case 33: 
            case 38: 
            case 39: 
            case 42: 
            case 46: {
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "dependsOnConstContext";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "getTypeInConstContext";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "getReadonlyTupleType";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "makePropsReadonly";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "isConstContextByGenericParamConstModifier";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "canBeInGenericConstContext";
                break;
            }
            case 12: 
            case 13: 
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "widenMultiStatementReturnType";
                break;
            }
            case 15: 
            case 16: 
            case 17: 
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "widenOneStatementReturnType";
                break;
            }
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 26: 
            case 27: 
            case 28: 
            case 29: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 30: {
                objectArray = objectArray;
                objectArray[2] = "serialize";
                break;
            }
            case 31: {
                objectArray = objectArray;
                objectArray[2] = "acceptChildren";
                break;
            }
            case 34: 
            case 35: {
                objectArray = objectArray;
                objectArray[2] = "isDirectlyAssignableTypeImpl";
                break;
            }
            case 36: 
            case 37: {
                objectArray = objectArray;
                objectArray[2] = "copyTypeHierarchy";
                break;
            }
            case 40: {
                objectArray = objectArray;
                objectArray[2] = "copyWithNewSource";
                break;
            }
            case 41: {
                objectArray = objectArray;
                objectArray[2] = "isEquivalentToWithSameClass";
                break;
            }
            case 43: 
            case 44: {
                objectArray = objectArray;
                objectArray[2] = "buildTypeTextImpl";
                break;
            }
            case 45: {
                objectArray = objectArray;
                objectArray[2] = "substituteImpl";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 1, 2, 3, 7, 9, 19, 20, 32, 33, 38, 39, 42, 46 -> new IllegalStateException(string);
        };
    }

    public static final class ExpectedTypeWidening
    implements Widening {
        @NotNull
        private final PsiElement myElement;

        public ExpectedTypeWidening(@NotNull PsiElement element) {
            if (element == null) {
                ExpectedTypeWidening.$$$reportNull$$$0(0);
            }
            this.myElement = element;
        }

        @Override
        @Nullable
        public JSType apply(@NotNull JSType original, @NotNull JSTypeSubstitutionContext context2) {
            JSType typeIfConstContext;
            if (original == null) {
                ExpectedTypeWidening.$$$reportNull$$$0(1);
            }
            if (context2 == null) {
                ExpectedTypeWidening.$$$reportNull$$$0(2);
            }
            if ((typeIfConstContext = JSWidenType.getTypeIfConstantContext(original, this.myElement)) != null) {
                return typeIfConstContext;
            }
            if (this.myElement instanceof JSArrayLiteralExpression) {
                if (!(original instanceof JSTupleType)) {
                    return original;
                }
                JSType contextType = this.getContextType();
                original = ExpectedTypeWidening.widenTupleTypeNestedTypes(contextType, (JSTupleType)original, context2, this.myElement);
                boolean isTypeScript = DialectDetector.isTypeScript(this.myElement);
                if (!isTypeScript && ContainerUtil.exists(((JSTupleType)original).getTypes(), ExpectedTypeWidening::isPropertyOwner)) {
                    return original;
                }
                return JSWidenType.isTupleLikeType(contextType, isTypeScript) ? original : ((JSTupleType)original).toArrayType(true);
            }
            JSType nested = original.substitute(context2);
            if (nested == null) {
                return null;
            }
            if (!this.isWideningApplicable(nested)) {
                return nested;
            }
            JSType expectedType = this.getContextType();
            return expectedType instanceof TypeScriptOverloadContextualType ? nested : JSTypeUtils.expandEnumAndLiteralTypeByExpectedType(nested, JSTypeUtils.getValuableType(expectedType));
        }

        private static boolean isPropertyOwner(@NotNull JSType type2) {
            if (type2 == null) {
                ExpectedTypeWidening.$$$reportNull$$$0(3);
            }
            if (type2 instanceof JSPsiBasedTypeOfType) {
                Object element = ((JSPsiBasedTypeOfType)type2).getElement();
                return element instanceof JSObjectLiteralExpression;
            }
            return type2 instanceof JSRecordType || type2 instanceof JSPropertiesOwnerType;
        }

        @NotNull
        private static JSTupleType widenTupleTypeNestedTypes(@Nullable JSType arrayContextualType, @NotNull JSTupleType type2, @NotNull JSTypeSubstitutionContext context2, @NotNull PsiElement element) {
            if (type2 == null) {
                ExpectedTypeWidening.$$$reportNull$$$0(4);
            }
            if (context2 == null) {
                ExpectedTypeWidening.$$$reportNull$$$0(5);
            }
            if (element == null) {
                ExpectedTypeWidening.$$$reportNull$$$0(6);
            }
            if (arrayContextualType == null) {
                JSTupleType jSTupleType = type2.transformTypes((el, i) -> el instanceof JSWidenType ? el : JSTypeUtils.widenLiteralTypes(el, true));
                if (jSTupleType == null) {
                    ExpectedTypeWidening.$$$reportNull$$$0(7);
                }
                return jSTupleType;
            }
            boolean makeStrict = arrayContextualType instanceof TypeScriptGenericParameterImpl && ((TypeScriptGenericParameterImpl)arrayContextualType).getConstraintType() instanceof JSTupleType;
            JSTypeSource source = JSTypeSourceFactory.createTypeSource(element, true);
            JSTupleType jSTupleType = type2.transformTypes((el, i) -> {
                JSType from = ExpectedTypeEvaluator.getArrayElementTypeForIndex(arrayContextualType, i, source);
                return JSTypeUtils.expandEnumAndLiteralTypeByExpectedType(el, from == null ? null : context2.substituteNested(from));
            }, makeStrict);
            if (jSTupleType == null) {
                ExpectedTypeWidening.$$$reportNull$$$0(8);
            }
            return jSTupleType;
        }

        private boolean isWideningApplicable(@NotNull JSType type2) {
            if (type2 == null) {
                ExpectedTypeWidening.$$$reportNull$$$0(9);
            }
            if (type2 instanceof JSLiteralType) {
                return ((JSLiteralType)type2).allowWidening();
            }
            if (type2 instanceof JSEvaluableType) {
                return true;
            }
            if (type2 instanceof JSUnionOrIntersectionType) {
                return ((JSUnionOrIntersectionType)type2).getTypes().stream().anyMatch(this::isWideningApplicable);
            }
            return false;
        }

        @Nullable
        private JSType getContextType() {
            JSExpectedTypeKind kind = JSExpectedTypeKind.WIDENING;
            if (this.myElement instanceof JSProperty) {
                return JSDialectSpecificHandlersFactory.findExpectedType((JSProperty)this.myElement, kind);
            }
            if (this.myElement instanceof JSExpression) {
                return JSDialectSpecificHandlersFactory.findExpectedType((JSExpression)this.myElement, kind);
            }
            return null;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            ExpectedTypeWidening widening = (ExpectedTypeWidening)o;
            return this.myElement.equals(widening.myElement);
        }

        public int hashCode() {
            return Objects.hash(this.myElement);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 7, 8 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "element";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "original";
                    break;
                }
                case 2: 
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "context";
                    break;
                }
                case 3: 
                case 4: 
                case 9: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "type";
                    break;
                }
                case 7: 
                case 8: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/lang/javascript/psi/types/JSWidenType$ExpectedTypeWidening";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/lang/javascript/psi/types/JSWidenType$ExpectedTypeWidening";
                    break;
                }
                case 7: 
                case 8: {
                    objectArray = objectArray2;
                    objectArray2[1] = "widenTupleTypeNestedTypes";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 1: 
                case 2: {
                    objectArray = objectArray;
                    objectArray[2] = "apply";
                    break;
                }
                case 3: {
                    objectArray = objectArray;
                    objectArray[2] = "isPropertyOwner";
                    break;
                }
                case 4: 
                case 5: 
                case 6: {
                    objectArray = objectArray;
                    objectArray[2] = "widenTupleTypeNestedTypes";
                    break;
                }
                case 7: 
                case 8: {
                    break;
                }
                case 9: {
                    objectArray = objectArray;
                    objectArray[2] = "isWideningApplicable";
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 7, 8 -> new IllegalStateException(string);
            };
        }
    }

    static interface Widening {
        @Nullable
        public JSType apply(@NotNull JSType var1, JSTypeSubstitutionContext var2);
    }

    private static final class OnlyApplyConstContext
    implements Widening {
        @NotNull
        private final PsiElement myElement;

        OnlyApplyConstContext(@NotNull PsiElement element) {
            if (element == null) {
                OnlyApplyConstContext.$$$reportNull$$$0(0);
            }
            this.myElement = element;
        }

        @Override
        @Nullable
        public JSType apply(@NotNull JSType original, JSTypeSubstitutionContext context2) {
            JSType typeIfConstContext;
            if (original == null) {
                OnlyApplyConstContext.$$$reportNull$$$0(1);
            }
            if ((typeIfConstContext = JSWidenType.getTypeIfConstantContext(original, this.myElement)) != null) {
                return typeIfConstContext;
            }
            return original;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "element";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "original";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/lang/javascript/psi/types/JSWidenType$OnlyApplyConstContext";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "apply";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private static enum ConstContextKind {
        NONE,
        SIMPLE,
        GENERIC_PARAM_CONST_MODIFIER;


        boolean isApplyConstDeep() {
            return switch (this) {
                default -> throw new IncompatibleClassChangeError();
                case SIMPLE -> false;
                case GENERIC_PARAM_CONST_MODIFIER -> true;
                case NONE -> throw new IllegalArgumentException(String.valueOf((Object)this));
            };
        }
    }

    private static final class SimpleWidening
    implements Widening {
        private static final SimpleWidening INSTANCE = new SimpleWidening(false);
        private static final SimpleWidening CONST_VARIABLE = new SimpleWidening(true);
        private final boolean myIsConstVariable;

        private SimpleWidening(boolean isConstVariable) {
            this.myIsConstVariable = isConstVariable;
        }

        @Override
        @Nullable
        public JSType apply(@NotNull JSType original, JSTypeSubstitutionContext context2) {
            PsiElement element;
            if (original == null) {
                SimpleWidening.$$$reportNull$$$0(0);
            }
            if ((element = original.getSourceElement()) == null) {
                return original;
            }
            JSType nested = original.substitute(context2);
            if (nested == null) {
                return null;
            }
            if (nested instanceof JSCodeBasedType) {
                return original;
            }
            JSType typeIfConstContext = JSWidenType.getTypeIfConstantContext(nested, nested.getSourceElement());
            if (typeIfConstContext != null) {
                return typeIfConstContext;
            }
            if (nested instanceof JSTupleType && ((JSTupleType)nested).allowWidening()) {
                JSTupleType tupleType = ((JSTupleType)nested).transformTypes((el, i) -> JSTypeUtils.widenLiteralTypes(el, true));
                nested = tupleType.toArrayType(true);
            }
            if (this.myIsConstVariable) {
                return nested;
            }
            JSType widen = JSTypeUtils.getApparentType(JSTypeUtils.widenLiteralTypes(nested, true));
            if (widen instanceof JSFreshObjectLiteralType) {
                widen = ((JSFreshObjectLiteralType)widen).removeFreshness();
            }
            return widen;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "original", "com/intellij/lang/javascript/psi/types/JSWidenType$SimpleWidening", "apply"));
        }
    }

    public static final class ReturnTypeWidening
    implements Widening {
        @NotNull
        private final JSFunctionItem myFunction;
        @NotNull
        private final JSExpectedTypeKind myKind;

        public ReturnTypeWidening(@NotNull JSFunctionItem function2, @NotNull JSExpectedTypeKind kind) {
            if (function2 == null) {
                ReturnTypeWidening.$$$reportNull$$$0(0);
            }
            if (kind == null) {
                ReturnTypeWidening.$$$reportNull$$$0(1);
            }
            this.myFunction = function2;
            this.myKind = kind;
        }

        @Override
        @Nullable
        public JSType apply(@NotNull JSType original, JSTypeSubstitutionContext context2) {
            PsiElement sourceElement;
            if (original == null) {
                ReturnTypeWidening.$$$reportNull$$$0(2);
            }
            if ((sourceElement = original.getSourceElement()) == null) {
                return original;
            }
            PsiElement elContext = sourceElement.getContext();
            if (elContext instanceof JSReturnStatement || elContext instanceof JSFunction && ((JSFunction)elContext).isShorthandArrowFunction()) {
                return JSWidenType.widenOneStatementReturnType(this.myFunction, this.myKind, original, context2);
            }
            if (original instanceof JSUnionType && sourceElement == this.myFunction) {
                return JSWidenType.widenMultiStatementReturnType(this.myFunction, (JSUnionType)original, context2);
            }
            return original;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            ReturnTypeWidening widening = (ReturnTypeWidening)o;
            return this.myFunction.equals(widening.myFunction) && this.myKind == widening.myKind;
        }

        public int hashCode() {
            return Objects.hash(new Object[]{this.myFunction, this.myKind});
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "function";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "kind";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "original";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/lang/javascript/psi/types/JSWidenType$ReturnTypeWidening";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[2] = "apply";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

