/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.psi.types;

import com.intellij.lang.javascript.psi.JSType;
import com.intellij.lang.javascript.psi.ecma6.JSDocDecoratedType;
import com.intellij.lang.javascript.psi.ecma6.JSDocFunctionType;
import com.intellij.lang.javascript.psi.ecma6.JSTypeDeclaration;
import com.intellij.lang.javascript.psi.ecma6.JSTypeDeclarationProvider;
import com.intellij.lang.javascript.psi.ecma6.impl.jsdoc.JSDocSingleTypeImpl;
import com.intellij.lang.javascript.psi.impl.JSStubElementImpl;
import com.intellij.lang.javascript.psi.types.JSTypeSerializer;
import com.intellij.lang.javascript.psi.types.JSTypeSource;
import com.intellij.lang.typescript.resolve.TypeScriptCompilerEvaluationFacade;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.util.registry.RegistryValue;
import com.intellij.psi.PsiElement;
import com.intellij.psi.util.CachedValueProvider;
import com.intellij.psi.util.ParameterizedCachedValue;
import java.text.StringCharacterIterator;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.TestOnly;

public final class JSTypeDeclarationProviderImpl
implements JSTypeDeclarationProvider {
    @NotNull
    public static final Key<ParameterizedCachedValue<JSType, JSTypeDeclaration>> CACHED_TYPE_KEY = Key.create((String)"js.type.declaration.cached");
    public static final Key<JSStubElementImpl.StubBuildCachedValue<JSType>> STUB_BUILDING_CACHED_TYPE_KEY = Key.create((String)"js.stub.building.type.declaration.cached");
    @TestOnly
    private static boolean CHECK_TYPE = false;

    @TestOnly
    public static void setCheckType(boolean checkType, @NotNull Disposable testRootDisposable) {
        if (testRootDisposable == null) {
            JSTypeDeclarationProviderImpl.$$$reportNull$$$0(0);
        }
        boolean old = CHECK_TYPE;
        CHECK_TYPE = checkType;
        Disposer.register((Disposable)testRootDisposable, () -> {
            CHECK_TYPE = old;
        });
    }

    @Override
    @NotNull
    public JSType calculateType(@NotNull JSTypeDeclaration type2) {
        if (type2 == null) {
            JSTypeDeclarationProviderImpl.$$$reportNull$$$0(1);
        }
        JSType jSType = JSStubElementImpl.getCachedValueStubBuildOptimized((PsiElement)type2, CACHED_TYPE_KEY, STUB_BUILDING_CACHED_TYPE_KEY, it -> {
            TypeScriptCompilerEvaluationFacade facade;
            if (JSTypeDeclarationProviderImpl.isTSServiceEnabled() && !JSTypeDeclarationProviderImpl.isJsDocType(type2) && (facade = TypeScriptCompilerEvaluationFacade.getInstance(type2.getProject())) != null) {
                JSType value = facade.getTypeFromService((PsiElement)type2);
                if (value == null) {
                    throw new NullPointerException("Null service-JSType for type declaration " + type2);
                }
                if (CHECK_TYPE) {
                    JSTypeDeclarationProviderImpl.validateType(value, it);
                }
                return CachedValueProvider.Result.create((Object)value, (Object[])new Object[]{it.getContainingFile()});
            }
            JSType value = it.calculateType();
            if (CHECK_TYPE) {
                JSTypeDeclarationProviderImpl.validateType(value, it);
            }
            return CachedValueProvider.Result.create((Object)value, (Object[])new Object[]{it.getContainingFile()});
        }, type2);
        if (jSType == null) {
            JSTypeDeclarationProviderImpl.$$$reportNull$$$0(2);
        }
        return jSType;
    }

    private static boolean isTSServiceEnabled() {
        RegistryValue value = Registry.get((String)"typescript.compiler.evaluation.jsTypeDeclaration");
        return value.isBoolean() && value.asBoolean();
    }

    private static boolean isJsDocType(@NotNull JSTypeDeclaration type2) {
        if (type2 == null) {
            JSTypeDeclarationProviderImpl.$$$reportNull$$$0(3);
        }
        return type2 instanceof JSDocDecoratedType || type2 instanceof JSDocFunctionType || type2 instanceof JSDocSingleTypeImpl;
    }

    private static void validateType(@NotNull JSType type2, @NotNull JSTypeDeclaration psiType) {
        JSType result2;
        if (type2 == null) {
            JSTypeDeclarationProviderImpl.$$$reportNull$$$0(4);
        }
        if (psiType == null) {
            JSTypeDeclarationProviderImpl.$$$reportNull$$$0(5);
        }
        if (!Objects.equals((result2 = JSTypeDeclarationProviderImpl.serializeAndDeserialize(type2, type2.getSource())).toString(), type2.toString())) {
            throw new RuntimeException("Serialization problem: \n" + type2 + "\nafter: \n" + result2 + "\nclass " + psiType.getClass());
        }
    }

    private static JSType serializeAndDeserialize(@NotNull JSType type2, @NotNull JSTypeSource source) {
        if (type2 == null) {
            JSTypeDeclarationProviderImpl.$$$reportNull$$$0(6);
        }
        if (source == null) {
            JSTypeDeclarationProviderImpl.$$$reportNull$$$0(7);
        }
        StringBuilder builder2 = new StringBuilder();
        JSTypeSerializer.TYPE_SERIALIZER.write(type2, builder2);
        String serialized = builder2.toString();
        return JSTypeSerializer.TYPE_SERIALIZER.read(source, new StringCharacterIterator(serialized));
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 2 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "testRootDisposable";
                break;
            }
            case 1: 
            case 3: 
            case 4: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "type";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/javascript/psi/types/JSTypeDeclarationProviderImpl";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "psiType";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "source";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/javascript/psi/types/JSTypeDeclarationProviderImpl";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "calculateType";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "setCheckType";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "calculateType";
                break;
            }
            case 2: {
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "isJsDocType";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "validateType";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "serializeAndDeserialize";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 2 -> new IllegalStateException(string);
        };
    }
}

