/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.psi.stubs.impl;

import com.intellij.lang.javascript.JSStubElementTypes;
import com.intellij.lang.javascript.index.flags.BooleanStructureElement;
import com.intellij.lang.javascript.index.flags.EnumStructureElement;
import com.intellij.lang.javascript.index.flags.FlagsStructure;
import com.intellij.lang.javascript.psi.jsdoc.JSDocComment;
import com.intellij.lang.javascript.psi.jsdoc.impl.JSDocCommentImpl;
import com.intellij.lang.javascript.psi.stubs.JSDocCommentStub;
import com.intellij.lang.javascript.psi.stubs.JSDocModulesIndex;
import com.intellij.lang.javascript.psi.stubs.JSGenericsIndex;
import com.intellij.lang.javascript.psi.stubs.impl.JSPossiblyStoredStubImpl;
import com.intellij.lang.javascript.psi.types.JSContext;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.Ref;
import com.intellij.psi.stubs.IStubElementType;
import com.intellij.psi.stubs.IndexSink;
import com.intellij.psi.stubs.StubElement;
import com.intellij.psi.stubs.StubInputStream;
import com.intellij.psi.stubs.StubOutputStream;
import com.intellij.util.ObjectUtils;
import com.intellij.util.SmartList;
import com.intellij.util.io.DataInputOutputUtil;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class JSDocCommentStubImpl
extends JSPossiblyStoredStubImpl<JSDocComment>
implements JSDocCommentStub {
    private static final BooleanStructureElement HAS_GENERIC_PARAMETERS_FLAG = new BooleanStructureElement();
    private static final BooleanStructureElement IS_INTERFACE_FLAG = new BooleanStructureElement();
    private static final BooleanStructureElement HAS_CONSTRUCTS_TAG_FLAG = new BooleanStructureElement();
    private static final BooleanStructureElement HAS_NAMESPACE_TAG_FLAG = new BooleanStructureElement();
    private static final EnumStructureElement<JSContext> JS_CONTEXT_FLAG = new EnumStructureElement<JSContext>(JSContext.class);
    private static final EnumStructureElement<JSDocComment.BrowserFamily> BROWSER_FAMILY_FLAG = new EnumStructureElement<JSDocComment.BrowserFamily>(JSDocComment.BrowserFamily.class);
    private static final BooleanStructureElement IS_CLASS_EXPLICITLY_FLAG = new BooleanStructureElement();
    private static final BooleanStructureElement HAS_ABSTRACT_TAG_FLAG = new BooleanStructureElement();
    private static final BooleanStructureElement HAS_CONST_TAG_FLAG = new BooleanStructureElement();
    private static final BooleanStructureElement HAS_MODULE_TAG_FLAG = new BooleanStructureElement();
    private static final BooleanStructureElement HAS_ALIAS_TAG_FLAG = new BooleanStructureElement();
    private static final BooleanStructureElement IS_NAMESPACE_EXPLICITLY_DECLARED = new BooleanStructureElement();
    private static final FlagsStructure FLAGS_STRUCTURE = new FlagsStructure(JSPossiblyStoredStubImpl.FLAGS_STRUCTURE, HAS_GENERIC_PARAMETERS_FLAG, IS_INTERFACE_FLAG, HAS_CONSTRUCTS_TAG_FLAG, HAS_NAMESPACE_TAG_FLAG, JS_CONTEXT_FLAG, BROWSER_FAMILY_FLAG, IS_CLASS_EXPLICITLY_FLAG, HAS_ABSTRACT_TAG_FLAG, HAS_CONST_TAG_FLAG, HAS_MODULE_TAG_FLAG, HAS_ALIAS_TAG_FLAG, IS_NAMESPACE_EXPLICITLY_DECLARED);
    @NotNull
    private final @NotNull List<Pair<@NotNull String, @Nullable String>> myGenericParameters;
    @Nullable
    private final String myNamespaceForGenericParameters;
    @Nullable
    private final String myModuleName;
    @Nullable
    private final String myAlias;

    public JSDocCommentStubImpl(JSDocComment psi, StubElement parent) {
        this(psi, parent, (Ref<List<Pair<String, String>>>)Ref.create(), (Ref<String>)Ref.create(), (Ref<String>)Ref.create(), (Ref<String>)Ref.create());
    }

    private JSDocCommentStubImpl(JSDocComment psi, StubElement parent, Ref<List<Pair<@NotNull String, @Nullable String>>> genericParametersRef, Ref<String> namespaceForGenericParametersRef, Ref<String> moduleNameRef, Ref<String> aliasRef) {
        super(psi, parent, JSStubElementTypes.DOC_COMMENT, JSDocCommentStubImpl.initFromPsi(psi, genericParametersRef, namespaceForGenericParametersRef, moduleNameRef, aliasRef));
        this.myGenericParameters = (List)genericParametersRef.get();
        this.myNamespaceForGenericParameters = (String)namespaceForGenericParametersRef.get();
        this.myModuleName = (String)moduleNameRef.get();
        this.myAlias = (String)aliasRef.get();
    }

    private static int initFromPsi(JSDocComment psi, Ref<List<Pair<@NotNull String, @Nullable String>>> genericParametersRef, Ref<String> namespaceForGenericParametersRef, Ref<String> moduleNameRef, Ref<String> aliasRef) {
        List<Pair<String, String>> typedefs;
        List<Pair<@NotNull String, @Nullable String>> genericParameters = psi.getGenericParameters();
        genericParametersRef.set(genericParameters);
        String namespaceForGenericParameters = null;
        if (!genericParameters.isEmpty() && (namespaceForGenericParameters = psi.findNameOfClassAppliedTo()) == null && !(typedefs = psi.getTypedefs()).isEmpty()) {
            namespaceForGenericParameters = (String)typedefs.get((int)0).first;
        }
        namespaceForGenericParametersRef.set((Object)namespaceForGenericParameters);
        int flags = 0;
        flags = JSDocCommentStubImpl.writeFlag(flags, FLAGS_STRUCTURE, IS_INTERFACE_FLAG, psi.hasInterfaceTag());
        flags = JSDocCommentStubImpl.writeFlag(flags, FLAGS_STRUCTURE, HAS_CONSTRUCTS_TAG_FLAG, psi.hasConstructsTag());
        flags = JSDocCommentStubImpl.writeFlag(flags, FLAGS_STRUCTURE, JS_CONTEXT_FLAG, psi.getJSContext());
        flags = JSDocCommentStubImpl.writeFlag(flags, FLAGS_STRUCTURE, BROWSER_FAMILY_FLAG, psi.getBrowserFamily());
        flags = JSDocCommentStubImpl.writeFlag(flags, FLAGS_STRUCTURE, HAS_NAMESPACE_TAG_FLAG, psi.hasNamespaceTag());
        flags = JSDocCommentStubImpl.writeFlag(flags, FLAGS_STRUCTURE, HAS_GENERIC_PARAMETERS_FLAG, !genericParameters.isEmpty());
        flags = JSDocCommentStubImpl.writeFlag(flags, FLAGS_STRUCTURE, IS_CLASS_EXPLICITLY_FLAG, psi.isClassExplicitly());
        flags = JSDocCommentStubImpl.writeFlag(flags, FLAGS_STRUCTURE, HAS_ABSTRACT_TAG_FLAG, psi.hasAbstractTag());
        flags = JSDocCommentStubImpl.writeFlag(flags, FLAGS_STRUCTURE, HAS_CONST_TAG_FLAG, psi.hasConstTag());
        String explicitName = psi.getExplicitName();
        boolean hasModule = explicitName != null && explicitName.startsWith("module:");
        flags = JSDocCommentStubImpl.writeFlag(flags, FLAGS_STRUCTURE, HAS_MODULE_TAG_FLAG, hasModule);
        moduleNameRef.set(hasModule ? explicitName.substring("module:".length()) : null);
        String alias = psi.getAlias();
        flags = JSDocCommentStubImpl.writeFlag(flags, FLAGS_STRUCTURE, HAS_ALIAS_TAG_FLAG, alias != null);
        aliasRef.set((Object)alias);
        flags = JSDocCommentStubImpl.writeFlag(flags, FLAGS_STRUCTURE, IS_NAMESPACE_EXPLICITLY_DECLARED, psi.isNamespaceExplicitlyDeclared());
        return flags;
    }

    public JSDocCommentStubImpl(StubInputStream stream, StubElement stub) throws IOException {
        super(stream, stub, JSStubElementTypes.DOC_COMMENT);
        boolean hasGenericParameters = this.readFlag(HAS_GENERIC_PARAMETERS_FLAG);
        if (hasGenericParameters) {
            int size = DataInputOutputUtil.readINT((DataInput)stream);
            this.myGenericParameters = new SmartList();
            for (int i = 0; i < size; ++i) {
                this.myGenericParameters.add((Pair<String, String>)Pair.create((Object)((String)ObjectUtils.notNull((Object)stream.readNameString(), (Object)"")), (Object)stream.readNameString()));
            }
        } else {
            this.myGenericParameters = Collections.emptyList();
        }
        this.myNamespaceForGenericParameters = hasGenericParameters ? stream.readNameString() : null;
        boolean hasModule = this.readFlag(HAS_MODULE_TAG_FLAG);
        this.myModuleName = hasModule ? stream.readNameString() : null;
        boolean hasAlias = this.readFlag(HAS_ALIAS_TAG_FLAG);
        this.myAlias = hasAlias ? stream.readNameString() : null;
    }

    @Override
    public void serialize(StubOutputStream dataStream) throws IOException {
        super.serialize(dataStream);
        if (this.readFlag(HAS_GENERIC_PARAMETERS_FLAG).booleanValue()) {
            DataInputOutputUtil.writeINT((DataOutput)dataStream, (int)this.myGenericParameters.size());
            for (Pair<String, String> pair : this.myGenericParameters) {
                dataStream.writeName((String)pair.getFirst());
                dataStream.writeName((String)pair.getSecond());
            }
            dataStream.writeName(this.myNamespaceForGenericParameters);
        } else assert (this.myNamespaceForGenericParameters == null);
        if (this.readFlag(HAS_MODULE_TAG_FLAG).booleanValue()) {
            dataStream.writeName(this.myModuleName);
        }
        if (this.readFlag(HAS_ALIAS_TAG_FLAG).booleanValue()) {
            dataStream.writeName(this.myAlias);
        }
    }

    @Override
    public JSDocComment createPsi() {
        return new JSDocCommentImpl(this, (IStubElementType)JSStubElementTypes.DOC_COMMENT);
    }

    @Override
    public void index(@NotNull IndexSink sink) {
        if (sink == null) {
            JSDocCommentStubImpl.$$$reportNull$$$0(0);
        }
        super.index(sink);
        if (!this.myGenericParameters.isEmpty() && this.myNamespaceForGenericParameters != null) {
            sink.occurrence(JSGenericsIndex.KEY, (Object)this.myNamespaceForGenericParameters);
        }
        if (this.myModuleName != null) {
            sink.occurrence(JSDocModulesIndex.KEY, (Object)this.myModuleName);
        }
    }

    @Override
    public boolean hasInterfaceTag() {
        return this.readFlag(IS_INTERFACE_FLAG);
    }

    @Override
    public boolean hasConstructsTag() {
        return this.readFlag(HAS_CONSTRUCTS_TAG_FLAG);
    }

    @Override
    @NotNull
    protected FlagsStructure getFlagsStructure() {
        FlagsStructure flagsStructure = FLAGS_STRUCTURE;
        if (flagsStructure == null) {
            JSDocCommentStubImpl.$$$reportNull$$$0(1);
        }
        return flagsStructure;
    }

    @Override
    @NotNull
    public JSContext getJSContext() {
        JSContext jSContext = this.readFlag(JS_CONTEXT_FLAG);
        if (jSContext == null) {
            JSDocCommentStubImpl.$$$reportNull$$$0(2);
        }
        return jSContext;
    }

    @Override
    @NotNull
    public JSDocComment.BrowserFamily getBrowserFamily() {
        JSDocComment.BrowserFamily browserFamily = this.readFlag(BROWSER_FAMILY_FLAG);
        if (browserFamily == null) {
            JSDocCommentStubImpl.$$$reportNull$$$0(3);
        }
        return browserFamily;
    }

    @Override
    @NotNull
    public @NotNull List<Pair<@NotNull String, @Nullable String>> getGenericParameters() {
        List<Pair<String, String>> list2 = this.myGenericParameters;
        if (list2 == null) {
            JSDocCommentStubImpl.$$$reportNull$$$0(4);
        }
        return list2;
    }

    @Override
    public boolean hasNamespaceTag() {
        return this.readFlag(HAS_NAMESPACE_TAG_FLAG);
    }

    @Override
    public boolean isClassExplicitly() {
        return this.readFlag(IS_CLASS_EXPLICITLY_FLAG);
    }

    @Override
    public boolean hasAbstractTag() {
        return this.readFlag(HAS_ABSTRACT_TAG_FLAG);
    }

    @Override
    public boolean hasConstTag() {
        return this.readFlag(HAS_CONST_TAG_FLAG);
    }

    @Override
    @Nullable
    public String getAlias() {
        return this.myAlias;
    }

    @Override
    public boolean isNamespaceExplicitlyDeclared() {
        return this.readFlag(IS_NAMESPACE_EXPLICITLY_DECLARED);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 1, 2, 3, 4 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sink";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/javascript/psi/stubs/impl/JSDocCommentStubImpl";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/javascript/psi/stubs/impl/JSDocCommentStubImpl";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getFlagsStructure";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getJSContext";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getBrowserFamily";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getGenericParameters";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "index";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 1, 2, 3, 4 -> new IllegalStateException(string);
        };
    }
}

