/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.psi.resolve;

import com.intellij.lang.javascript.DialectDetector;
import com.intellij.lang.javascript.ecmascript6.TypeScriptUtil;
import com.intellij.lang.javascript.psi.JSElement;
import com.intellij.lang.javascript.psi.JSFunction;
import com.intellij.lang.javascript.psi.JSProperty;
import com.intellij.lang.javascript.psi.JSRecordType;
import com.intellij.lang.javascript.psi.JSType;
import com.intellij.lang.javascript.psi.JSTypeUtils;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptInterface;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptPropertySignature;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptType;
import com.intellij.lang.javascript.psi.ecmal4.JSClass;
import com.intellij.lang.javascript.psi.resolve.JSQualifiedNameResolver;
import com.intellij.lang.javascript.psi.types.JSContextualUnionType;
import com.intellij.lang.javascript.psi.types.JSRecordTypeImpl;
import com.intellij.lang.javascript.psi.types.JSUnionOrIntersectionType;
import com.intellij.lang.javascript.psi.types.JSUnionType;
import com.intellij.lang.javascript.psi.types.guard.TypeScriptTypeRelations;
import com.intellij.lang.javascript.psi.types.recordImpl.PropertySignatureImpl;
import com.intellij.psi.PsiElement;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class JSVariantRecordTypeConverter {
    @Nullable
    public static JSRecordType getTypeAsRecord(@Nullable JSType type2, @Nullable PsiElement context2) {
        JSRecordType recordType;
        PsiElement sourceElement;
        JSRecordType mergedMembers;
        if (type2 == null) {
            return null;
        }
        if ((type2 = TypeScriptTypeRelations.expandAndOptimizeTypeRecursive(type2)) instanceof JSRecordType) {
            return (JSRecordType)type2;
        }
        if (type2.getSource().isEcma()) {
            return null;
        }
        if ((type2 instanceof JSUnionType || type2 instanceof JSContextualUnionType) && (mergedMembers = JSVariantRecordTypeConverter.mergeMappedRecordTypes(type2, context2, ((JSUnionOrIntersectionType)type2).getTypes())) != null) {
            return mergedMembers;
        }
        if (context2 != null && (DialectDetector.isTypeScript(context2) || type2.isTypeScript())) {
            return type2.asRecordType();
        }
        if (context2 != null && type2.isJavaScript() && ((sourceElement = type2.getSource().getSourceElement()) != null && JSQualifiedNameResolver.isFromJSDoc(sourceElement) || sourceElement instanceof TypeScriptType) && (recordType = type2.asRecordType()).hasProperties()) {
            return recordType;
        }
        Collection<TypeScriptInterface> classTypes = JSTypeUtils.getTypeScriptInterfaceInJavaScriptContext(type2);
        return JSVariantRecordTypeConverter.buildSimpleRecordType(type2, classTypes);
    }

    @Nullable
    private static JSRecordType mergeMappedRecordTypes(@NotNull JSType type2, @Nullable PsiElement context2, @NotNull List<? extends JSType> types2) {
        if (type2 == null) {
            JSVariantRecordTypeConverter.$$$reportNull$$$0(0);
        }
        if (types2 == null) {
            JSVariantRecordTypeConverter.$$$reportNull$$$0(1);
        }
        ArrayList<JSRecordType.TypeMember> typeMembers = new ArrayList<JSRecordType.TypeMember>();
        for (JSType jSType : types2) {
            JSRecordType record = JSVariantRecordTypeConverter.getTypeAsRecord(jSType, context2);
            if (record == null) continue;
            typeMembers.addAll(record.getTypeMembers());
        }
        if (!typeMembers.isEmpty()) {
            return new JSRecordTypeImpl(type2.getSource(), typeMembers);
        }
        return null;
    }

    @Nullable
    public static JSRecordType buildSimpleRecordType(@NotNull JSType type2, Collection<? extends TypeScriptInterface> types2) {
        if (type2 == null) {
            JSVariantRecordTypeConverter.$$$reportNull$$$0(2);
        }
        if (types2.isEmpty()) {
            return null;
        }
        ArrayList<PropertySignatureImpl> recordMembers2 = new ArrayList<PropertySignatureImpl>();
        for (JSClass jSClass : types2) {
            Collection<JSClass> parents2 = TypeScriptUtil.getNonStrictParents(jSClass, true);
            for (JSClass jsClass : parents2) {
                Iterable<? extends JSElement> members = jsClass.getMembers();
                for (JSElement jSElement : members) {
                    String name;
                    if (!(jSElement instanceof JSFunction) && !(jSElement instanceof JSProperty) && !(jSElement instanceof TypeScriptPropertySignature) || (name = jSElement.getName()) == null) continue;
                    recordMembers2.add(new PropertySignatureImpl(jSElement.getName(), null, false, false));
                }
            }
        }
        return new JSRecordTypeImpl(type2.getSource(), recordMembers2);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "type";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "types";
                break;
            }
        }
        objectArray2[1] = "com/intellij/lang/javascript/psi/resolve/JSVariantRecordTypeConverter";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "mergeMappedRecordTypes";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "buildSimpleRecordType";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

