/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.psi.resolve;

import com.intellij.lang.ecmascript6.psi.JSClassExpression;
import com.intellij.lang.ecmascript6.resolve.ES6TypeEvaluator;
import com.intellij.lang.javascript.DialectDetector;
import com.intellij.lang.javascript.psi.JSNamespace;
import com.intellij.lang.javascript.psi.JSType;
import com.intellij.lang.javascript.psi.JSTypeEvaluationResult;
import com.intellij.lang.javascript.psi.JSTypeUtils;
import com.intellij.lang.javascript.psi.resolve.JSEvaluateContext;
import com.intellij.lang.javascript.psi.resolve.JSTypeProcessor;
import com.intellij.lang.javascript.psi.resolve.complexity.JSEvaluationResultElement;
import com.intellij.lang.javascript.psi.types.JSCompositeTypeFactory;
import com.intellij.lang.javascript.psi.types.JSContext;
import com.intellij.lang.javascript.psi.types.JSNamedTypeFactory;
import com.intellij.lang.javascript.psi.types.JSTypeSource;
import com.intellij.lang.javascript.psi.types.JSTypeSourceFactory;
import com.intellij.lang.javascript.psi.types.JSTypeWithOuterGenerics;
import com.intellij.lang.javascript.psi.types.JSUnionType;
import com.intellij.lang.javascript.psi.types.TypeScriptTypeParser;
import com.intellij.lang.javascript.psi.types.evaluable.JSClassExpressionType;
import com.intellij.util.containers.ContainerUtil;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class JSSimpleTypeProcessor
implements JSTypeProcessor {
    @NotNull
    private final JSTypeEvaluationResult myResult = new JSTypeEvaluationResult();

    @Override
    public void process(@NotNull JSType type2, @NotNull JSEvaluateContext evaluateContext) {
        if (type2 == null) {
            JSSimpleTypeProcessor.$$$reportNull$$$0(0);
        }
        if (evaluateContext == null) {
            JSSimpleTypeProcessor.$$$reportNull$$$0(1);
        }
        this.addPossibleOption(type2, evaluateContext);
    }

    @Override
    public void processAdditionalType(@NotNull JSType type2, @NotNull JSEvaluateContext evaluateContext) {
        if (type2 == null) {
            JSSimpleTypeProcessor.$$$reportNull$$$0(2);
        }
        if (evaluateContext == null) {
            JSSimpleTypeProcessor.$$$reportNull$$$0(3);
        }
        this.myResult.addResultElement(new JSEvaluationResultElement(type2, true, evaluateContext));
    }

    private void addPossibleOption(@NotNull JSType option, @NotNull JSEvaluateContext context2) {
        if (option == null) {
            JSSimpleTypeProcessor.$$$reportNull$$$0(4);
        }
        if (context2 == null) {
            JSSimpleTypeProcessor.$$$reportNull$$$0(5);
        }
        List typesToAdd = option instanceof JSUnionType && !option.isSourceStrict() ? ContainerUtil.map(((JSUnionType)option).getTypes(), t -> JSTypeUtils.copyWithStrict(t, false)) : Collections.singletonList(option);
        for (JSType newType2 : typesToAdd) {
            this.myResult.addResultElement(new JSEvaluationResultElement(newType2, false, context2));
        }
    }

    @Nullable
    public JSType getType() {
        List<JSEvaluationResultElement> results = this.myResult.getResults();
        LinkedHashSet<JSType> types2 = new LinkedHashSet<JSType>(results.size());
        boolean hasUnknownElement = false;
        for (JSEvaluationResultElement result2 : results) {
            JSClassExpressionType classType;
            JSClassExpression classExpression;
            JSType innerType;
            JSType type2 = result2.getType();
            JSType jSType = innerType = type2 instanceof JSTypeWithOuterGenerics ? ((JSTypeWithOuterGenerics)type2).getType() : type2;
            if (innerType instanceof JSClassExpressionType && (classExpression = (classType = (JSClassExpressionType)innerType).findAssociatedExpression()) != null) {
                JSNamespace namespace;
                boolean isNamedTypeAdded = false;
                if (DialectDetector.isJavaScript(classExpression) && ES6TypeEvaluator.useNamedTypeForClassExpression(classExpression) && (namespace = JSNamedTypeFactory.buildProvidedNamespace(classExpression, true)) != null && !(namespace instanceof JSClassExpressionType)) {
                    isNamedTypeAdded = true;
                    innerType = namespace.copyWithTypeContext(classType.getTypeContext());
                }
                if (!isNamedTypeAdded) {
                    innerType = TypeScriptTypeParser.buildTypeFromClass(classExpression, classType.getJSContext() == JSContext.STATIC);
                }
                JSType jSType2 = type2 = type2 instanceof JSTypeWithOuterGenerics ? JSTypeUtils.applyGenericArguments(innerType, ((JSTypeWithOuterGenerics)type2).getOuterArguments()) : innerType;
            }
            if (type2 == null) continue;
            hasUnknownElement |= !type2.isSourceStrict();
            types2.add(type2);
        }
        if (types2.isEmpty()) {
            return null;
        }
        JSTypeSource typeSource = JSTypeSourceFactory.copyTypeSource(((JSType)ContainerUtil.getFirstItem(types2)).getSource(), !hasUnknownElement);
        return types2.size() == 1 ? ((JSType)ContainerUtil.getFirstItem(types2)).copyWithStrict(!hasUnknownElement) : (hasUnknownElement ? JSCompositeTypeFactory.createUnionType(typeSource, types2) : JSCompositeTypeFactory.createContextualUnionType(types2, typeSource));
    }

    @NotNull
    public JSTypeEvaluationResult getResult() {
        JSTypeEvaluationResult jSTypeEvaluationResult = this.myResult;
        if (jSTypeEvaluationResult == null) {
            JSSimpleTypeProcessor.$$$reportNull$$$0(6);
        }
        return jSTypeEvaluationResult;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 6 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "type";
                break;
            }
            case 1: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "evaluateContext";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "option";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/javascript/psi/resolve/JSSimpleTypeProcessor";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/javascript/psi/resolve/JSSimpleTypeProcessor";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getResult";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "process";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "processAdditionalType";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "addPossibleOption";
                break;
            }
            case 6: {
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 6 -> new IllegalStateException(string);
        };
    }
}

