/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.psi.resolve;

import com.intellij.lang.ASTNode;
import com.intellij.lang.actionscript.ActionScriptElementTypes;
import com.intellij.lang.actionscript.psi.impl.ActionScriptFunctionImpl;
import com.intellij.lang.actionscript.psi.impl.ActionScriptVariableImpl;
import com.intellij.lang.ecmascript6.psi.ES6Class;
import com.intellij.lang.ecmascript6.psi.ES6ExportDeclaration;
import com.intellij.lang.ecmascript6.psi.ES6ExportDefaultAssignment;
import com.intellij.lang.ecmascript6.psi.ES6ExportSpecifier;
import com.intellij.lang.ecmascript6.psi.ES6ExportSpecifierAlias;
import com.intellij.lang.ecmascript6.psi.ES6ExportedDefaultBinding;
import com.intellij.lang.ecmascript6.psi.ES6ImportDeclaration;
import com.intellij.lang.ecmascript6.psi.ES6ImportSpecifierAlias;
import com.intellij.lang.ecmascript6.psi.ES6ImportedBinding;
import com.intellij.lang.ecmascript6.psi.ES6NamespaceExport;
import com.intellij.lang.injection.InjectedLanguageManager;
import com.intellij.lang.javascript.DialectDetector;
import com.intellij.lang.javascript.psi.JSBlockStatement;
import com.intellij.lang.javascript.psi.JSBoundNameOwner;
import com.intellij.lang.javascript.psi.JSDefinitionExpression;
import com.intellij.lang.javascript.psi.JSDestructuringContainer;
import com.intellij.lang.javascript.psi.JSElement;
import com.intellij.lang.javascript.psi.JSExpression;
import com.intellij.lang.javascript.psi.JSExpressionStatement;
import com.intellij.lang.javascript.psi.JSFile;
import com.intellij.lang.javascript.psi.JSFunction;
import com.intellij.lang.javascript.psi.JSFunctionExpression;
import com.intellij.lang.javascript.psi.JSLiteralExpression;
import com.intellij.lang.javascript.psi.JSNamedElement;
import com.intellij.lang.javascript.psi.JSObjectLiteralExpression;
import com.intellij.lang.javascript.psi.JSParameter;
import com.intellij.lang.javascript.psi.JSProperty;
import com.intellij.lang.javascript.psi.JSRecursiveWalkingElementVisitor;
import com.intellij.lang.javascript.psi.JSSourceElement;
import com.intellij.lang.javascript.psi.JSType;
import com.intellij.lang.javascript.psi.JSVarStatement;
import com.intellij.lang.javascript.psi.JSVariable;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptExportAssignment;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptImportStatement;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptInterface;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptModule;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptObjectType;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptType;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptTypeMember;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptVariable;
import com.intellij.lang.javascript.psi.ecmal4.JSAttributeList;
import com.intellij.lang.javascript.psi.ecmal4.JSAttributeListOwner;
import com.intellij.lang.javascript.psi.ecmal4.JSClass;
import com.intellij.lang.javascript.psi.ecmal4.JSImportStatement;
import com.intellij.lang.javascript.psi.ecmal4.JSIncludeDirective;
import com.intellij.lang.javascript.psi.ecmal4.JSNamespaceDeclaration;
import com.intellij.lang.javascript.psi.ecmal4.JSPackageStatement;
import com.intellij.lang.javascript.psi.ecmal4.JSUseNamespaceDirective;
import com.intellij.lang.javascript.psi.ecmal4.impl.JSAttributeListImpl;
import com.intellij.lang.javascript.psi.ecmal4.impl.JSClassBase;
import com.intellij.lang.javascript.psi.impl.JSFileBaseImpl;
import com.intellij.lang.javascript.psi.impl.JSStubElementImpl;
import com.intellij.lang.javascript.psi.jsdoc.JSDocComment;
import com.intellij.lang.javascript.psi.resolve.ImplicitJSVariableImpl;
import com.intellij.lang.javascript.psi.resolve.JSResolveUtil;
import com.intellij.lang.javascript.psi.stubs.JSAttributeListStub;
import com.intellij.lang.javascript.psi.stubs.JSElementIndexingData;
import com.intellij.lang.javascript.psi.stubs.JSImplicitElement;
import com.intellij.lang.javascript.psi.stubs.impl.JSImplicitElementImpl;
import com.intellij.lang.javascript.psi.util.JSClassUtils;
import com.intellij.lang.javascript.psi.util.JSDirectiveCommentUtil;
import com.intellij.lang.javascript.psi.util.JSStubBasedPsiTreeUtil;
import com.intellij.lang.typescript.psi.TypeScriptPsiUtil;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiComment;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiFile;
import com.intellij.psi.stubs.StubElement;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.util.CachedValue;
import com.intellij.psi.util.CachedValueProvider;
import com.intellij.psi.util.CachedValuesManager;
import com.intellij.psi.util.ParameterizedCachedValue;
import com.intellij.util.SmartList;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.text.StringTokenizer;
import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectOpenHashMap;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class JSScopeNamesCache {
    private static final Key<ParameterizedCachedValue<Int2ObjectMap<Object>, JSElement>> CACHED_DEFS_KEY = Key.create((String)"JS.CachedDefs");
    private static final Key<JSStubElementImpl.StubBuildCachedValue<Int2ObjectMap<Object>>> STUB_BUILDING_CACHED_DEFS_KEY = Key.create((String)"JS.stub.building.CachedDefs");
    public static final Key<CachedValue<Int2ObjectMap<Object>>> STUBBED_CACHED_DEFS_KEY = Key.create((String)"Stubbed.JS.CachedDefs");

    @NotNull
    public static List<JSElement> getNamedElementsInScope(@NotNull JSElement scope2, @Nullable String name, boolean stubSafe) {
        Int2ObjectMap<Object> defsMap;
        if (scope2 == null) {
            JSScopeNamesCache.$$$reportNull$$$0(0);
        }
        Int2ObjectMap<Object> int2ObjectMap = defsMap = stubSafe ? JSScopeNamesCache.getOrCreateNamesForStubScope((PsiElement)scope2) : JSScopeNamesCache.getOrCreateNamesForScope(scope2);
        if (name != null) {
            return JSScopeNamesCache.getElementsWithName(name, defsMap);
        }
        List elementsByName = ContainerUtil.map((Collection)defsMap.values(), e -> e instanceof JSElement ? Collections.singletonList((JSElement)e) : new SmartList((Object[])((JSElement[])e)));
        List list2 = ContainerUtil.concat((Iterable)elementsByName);
        if (list2 == null) {
            JSScopeNamesCache.$$$reportNull$$$0(1);
        }
        return list2;
    }

    @NotNull
    public static Int2ObjectMap<Object> getOrCreateNamesForScope(@NotNull JSElement scope2) {
        if (scope2 == null) {
            JSScopeNamesCache.$$$reportNull$$$0(2);
        }
        if (scope2 instanceof JSFileBaseImpl && ((JSFileBaseImpl)scope2).getStub() != null) {
            return JSScopeNamesCache.getOrCreateNamesForStubScope((PsiElement)scope2);
        }
        Int2ObjectMap<Object> int2ObjectMap = JSStubElementImpl.getCachedValueStubBuildOptimized((PsiElement)scope2, CACHED_DEFS_KEY, STUB_BUILDING_CACHED_DEFS_KEY, it -> {
            Int2ObjectOpenHashMap relevantDefs = new Int2ObjectOpenHashMap();
            JSNamesCacheVisitor elementVisitor = new JSNamesCacheVisitor((JSElement)it, (Int2ObjectMap<Object>)relevantDefs);
            elementVisitor.startVisiting((JSElement)it);
            return new CachedValueProvider.Result((Object)relevantDefs, new Object[]{it});
        }, scope2);
        if (int2ObjectMap == null) {
            JSScopeNamesCache.$$$reportNull$$$0(3);
        }
        return int2ObjectMap;
    }

    @NotNull
    private static Int2ObjectMap<Object> getOrCreateNamesForStubScope(@NotNull PsiElement scope2) {
        if (scope2 == null) {
            JSScopeNamesCache.$$$reportNull$$$0(4);
        }
        Int2ObjectMap int2ObjectMap = (Int2ObjectMap)CachedValuesManager.getCachedValue((PsiElement)scope2, STUBBED_CACHED_DEFS_KEY, () -> {
            Int2ObjectMap<Object> relevantDefs = JSStubBasedPsiTreeUtil.buildStubBasedNamesMap(scope2);
            return new CachedValueProvider.Result(relevantDefs, new Object[]{scope2});
        });
        if (int2ObjectMap == null) {
            JSScopeNamesCache.$$$reportNull$$$0(5);
        }
        return int2ObjectMap;
    }

    @NotNull
    public static List<JSElement> findNamedElementsInStubScope(@NotNull String name, @NotNull PsiElement scope2) {
        if (name == null) {
            JSScopeNamesCache.$$$reportNull$$$0(6);
        }
        if (scope2 == null) {
            JSScopeNamesCache.$$$reportNull$$$0(7);
        }
        Int2ObjectMap<Object> defs = JSScopeNamesCache.getOrCreateNamesForStubScope(scope2);
        return JSScopeNamesCache.getElementsWithName(name, defs);
    }

    @NotNull
    private static List<JSElement> getElementsWithName(@NotNull String name, Int2ObjectMap<Object> defsMap) {
        Object defs;
        if (name == null) {
            JSScopeNamesCache.$$$reportNull$$$0(8);
        }
        if ((defs = defsMap.get(name.hashCode())) instanceof JSElement) {
            List<JSElement> list2 = Collections.singletonList((JSElement)defs);
            if (list2 == null) {
                JSScopeNamesCache.$$$reportNull$$$0(9);
            }
            return list2;
        }
        if (defs instanceof JSElement[]) {
            List<JSElement> list3 = Arrays.asList((JSElement[])defs);
            if (list3 == null) {
                JSScopeNamesCache.$$$reportNull$$$0(10);
            }
            return list3;
        }
        List list4 = ContainerUtil.emptyList();
        if (list4 == null) {
            JSScopeNamesCache.$$$reportNull$$$0(11);
        }
        return list4;
    }

    public static void addElementCompact(@NotNull Int2ObjectMap<Object> defs, @NotNull JSElement node, int key2) {
        Object o;
        if (defs == null) {
            JSScopeNamesCache.$$$reportNull$$$0(12);
        }
        if (node == null) {
            JSScopeNamesCache.$$$reportNull$$$0(13);
        }
        if ((o = defs.get(key2)) == null) {
            defs.put(key2, (Object)node);
        } else if (o instanceof JSElement) {
            JSElement[] newO = new JSElement[]{(JSElement)o, node};
            defs.put(key2, (Object)newO);
        } else {
            JSElement[] oldO = (JSElement[])o;
            JSElement[] newO = Arrays.copyOf(oldO, oldO.length + 1);
            newO[oldO.length] = node;
            defs.put(key2, (Object)newO);
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 1, 3, 5, 9, 10, 11 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "scope";
                break;
            }
            case 1: 
            case 3: 
            case 5: 
            case 9: 
            case 10: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/javascript/psi/resolve/JSScopeNamesCache";
                break;
            }
            case 6: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "defs";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "node";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/javascript/psi/resolve/JSScopeNamesCache";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getNamedElementsInScope";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getOrCreateNamesForScope";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getOrCreateNamesForStubScope";
                break;
            }
            case 9: 
            case 10: 
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "getElementsWithName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getNamedElementsInScope";
                break;
            }
            case 1: 
            case 3: 
            case 5: 
            case 9: 
            case 10: 
            case 11: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "getOrCreateNamesForScope";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "getOrCreateNamesForStubScope";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "findNamedElementsInStubScope";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "getElementsWithName";
                break;
            }
            case 12: 
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "addElementCompact";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 1, 3, 5, 9, 10, 11 -> new IllegalStateException(string);
        };
    }

    public static final class JSNamesCacheVisitor
    extends JSRecursiveWalkingElementVisitor {
        private Set<JSFile> visitedIncludes;
        private final Int2ObjectMap<Object> myRelevantDefs;
        private final JSElement myBase;
        private JSElement context;
        private final boolean isTypeScript;
        private final boolean isActionScript;

        public JSNamesCacheVisitor(JSElement base, Int2ObjectMap<Object> relevantDefs) {
            this.myRelevantDefs = relevantDefs;
            this.myBase = base;
            this.context = base;
            this.isTypeScript = DialectDetector.isTypeScript((PsiElement)base);
            this.isActionScript = DialectDetector.isActionScript((PsiElement)base);
        }

        /*
         * WARNING - void declaration
         */
        public void startVisiting(JSElement jsElement2) {
            PsiElement first = null;
            JSElement[] arrayElementsToScan = null;
            if (jsElement2 instanceof JSFunction) {
                JSBlockStatement jSBlockStatement = ((JSFunction)jsElement2).getBlock();
                if (jSBlockStatement != null) {
                    ASTNode node = jSBlockStatement.getNode().getFirstChildNode();
                    first = node != null ? node.getPsi() : null;
                }
            } else if (jsElement2 instanceof TypeScriptInterface) {
                TypeScriptObjectType typeScriptObjectType = ((TypeScriptInterface)jsElement2).getBody();
                if (typeScriptObjectType != null) {
                    arrayElementsToScan = new PsiElement[]{typeScriptObjectType};
                }
            } else if (jsElement2 instanceof TypeScriptObjectType) {
                arrayElementsToScan = new PsiElement[]{jsElement2};
            } else if (jsElement2 instanceof JSClass || jsElement2 instanceof JSPackageStatement || jsElement2 instanceof TypeScriptModule) {
                arrayElementsToScan = JSResolveUtil.getSourceElements((PsiElement)jsElement2);
            } else if (jsElement2 instanceof TypeScriptVariable) {
                TypeScriptType typeScriptType = ((TypeScriptVariable)jsElement2).getTypeElement();
                if (typeScriptType instanceof TypeScriptObjectType) {
                    arrayElementsToScan = new PsiElement[]{typeScriptType};
                }
            } else if (jsElement2 instanceof JSVariable) {
                arrayElementsToScan = PsiElement.EMPTY_ARRAY;
            } else if (jsElement2 instanceof JSObjectLiteralExpression) {
                arrayElementsToScan = ((JSObjectLiteralExpression)jsElement2).getProperties();
            } else if (jsElement2 instanceof JSFile && (this.isActionScript || this.isTypeScript)) {
                arrayElementsToScan = JSResolveUtil.getSourceElements((PsiElement)jsElement2);
            } else if (jsElement2 instanceof JSVarStatement) {
                arrayElementsToScan = this.isActionScript || this.isTypeScript ? ((JSVarStatement)jsElement2).getStubSafeVariables() : ((JSVarStatement)jsElement2).getVariables();
            } else {
                first = jsElement2.getFirstChild();
            }
            if (arrayElementsToScan != null) {
                for (JSSourceElement jSSourceElement : arrayElementsToScan) {
                    jSSourceElement.accept(this);
                }
            } else {
                void var4_10;
                PsiElement psiElement = first;
                while (var4_10 != null) {
                    if (var4_10 instanceof JSSourceElement || var4_10 instanceof JSVariable || var4_10 instanceof JSProperty || var4_10 instanceof JSDestructuringContainer || var4_10 instanceof PsiComment) {
                        var4_10.accept((PsiElementVisitor)this);
                    }
                    PsiElement psiElement2 = var4_10.getNextSibling();
                }
            }
            if (jsElement2 instanceof JSClassBase && JSClassUtils.canHavePrototypeProperty((JSClass)jsElement2) && !this.myRelevantDefs.containsKey("prototype".hashCode())) {
                this.addRelevantDef(JSClassUtils.getImplicitPrototypeProperty((JSClassBase)jsElement2));
            }
        }

        @Override
        public void visitJSDefinitionExpression(@NotNull JSDefinitionExpression node) {
            if (node == null) {
                JSNamesCacheVisitor.$$$reportNull$$$0(0);
            }
        }

        @Override
        public void visitJSExpressionStatement(@NotNull JSExpressionStatement node) {
            String text2;
            String rawText;
            JSExpression expression;
            if (node == null) {
                JSNamesCacheVisitor.$$$reportNull$$$0(1);
            }
            if ((expression = node.getExpression()) instanceof JSLiteralExpression && (rawText = expression.getText()).contains("use strict") && ("'use strict'".equals(text2 = InjectedLanguageManager.getInstance((Project)node.getProject()).getUnescapedText((PsiElement)expression)) || "\"use strict\"".equals(text2))) {
                this.addRelevantDef(new ImplicitJSVariableImpl("use strict", (JSType)null, (PsiElement)node));
            }
            if (expression != null) {
                this.visitJSExpression(expression);
            }
        }

        @Override
        public void visitJSVariable(@NotNull JSVariable node) {
            if (node == null) {
                JSNamesCacheVisitor.$$$reportNull$$$0(2);
            }
            if (node.hasBlockScope()) {
                return;
            }
            if (node instanceof ActionScriptVariableImpl && ((ActionScriptVariableImpl)node).hasQualifiedName()) {
                return;
            }
            this.processUseDirectiveInAttrList(node);
            this.addRelevantDef(node);
        }

        private void processUseDirectiveInAttrList(JSAttributeListOwner node) {
            JSAttributeList attributeList = node.getAttributeList();
            if (attributeList != null) {
                PsiElement elt;
                JSAttributeListStub stub;
                if (attributeList instanceof JSAttributeListImpl) {
                    JSAttributeListImpl attributeListImpl = (JSAttributeListImpl)attributeList;
                    v0 = (JSAttributeListStub)attributeListImpl.getStub();
                } else {
                    v0 = stub = null;
                }
                if (stub != null) {
                    StubElement useNamespaceDirectiveInStub = stub.findChildStubByType(ActionScriptElementTypes.USE_NAMESPACE_DIRECTIVE);
                    elt = useNamespaceDirectiveInStub != null ? useNamespaceDirectiveInStub.getPsi() : null;
                } else {
                    ASTNode useNs = attributeList.getNode().findChildByType((IElementType)ActionScriptElementTypes.USE_NAMESPACE_DIRECTIVE);
                    PsiElement psiElement = elt = useNs != null ? useNs.getPsi() : null;
                }
                if (elt != null) {
                    elt.accept((PsiElementVisitor)this);
                }
            }
        }

        @Override
        public void visitJSIncludeDirective(@NotNull JSIncludeDirective includeDirective) {
            JSFile file;
            block7: {
                block6: {
                    PsiFile _file;
                    if (includeDirective == null) {
                        JSNamesCacheVisitor.$$$reportNull$$$0(3);
                    }
                    if (!((_file = includeDirective.resolveFile()) instanceof JSFile)) break block6;
                    file = (JSFile)_file;
                    if (this.myBase.getContainingFile() != _file) break block7;
                }
                return;
            }
            if (this.visitedIncludes != null && this.visitedIncludes.contains(file)) {
                return;
            }
            if (this.visitedIncludes == null) {
                this.visitedIncludes = new HashSet<JSFile>();
            }
            this.visitedIncludes.add(file);
            JSElement prevContext = this.context;
            this.context = file;
            this.context.putUserData(JSResolveUtil.contextKey, this.myBase);
            this.startVisiting(file);
            this.context = prevContext;
        }

        @Override
        public void visitJSVarStatement(@NotNull JSVarStatement node) {
            JSVariable[] variables;
            if (node == null) {
                JSNamesCacheVisitor.$$$reportNull$$$0(4);
            }
            for (JSVariable var : variables = this.isActionScript || this.isTypeScript ? node.getStubSafeVariables() : node.getVariables()) {
                var.accept(this);
            }
        }

        @Override
        public void visitES6ExportDefaultAssignment(@NotNull ES6ExportDefaultAssignment node) {
            JSElement el;
            if (node == null) {
                JSNamesCacheVisitor.$$$reportNull$$$0(5);
            }
            if ((el = node.getStubSafeElement()) instanceof JSClass) {
                this.visitJSClass((JSClass)el);
            }
        }

        @Override
        public void visitTypeScriptExportAssignment(@NotNull TypeScriptExportAssignment exportAssignment) {
            if (exportAssignment == null) {
                JSNamesCacheVisitor.$$$reportNull$$$0(6);
            }
        }

        @Override
        public void visitJSParameter(@NotNull JSParameter node) {
            if (node == null) {
                JSNamesCacheVisitor.$$$reportNull$$$0(7);
            }
        }

        @Override
        public void visitJSFunctionExpression(@NotNull JSFunctionExpression node) {
            if (node == null) {
                JSNamesCacheVisitor.$$$reportNull$$$0(8);
            }
        }

        @Override
        public void visitJSProperty(@NotNull JSProperty node) {
            if (node == null) {
                JSNamesCacheVisitor.$$$reportNull$$$0(9);
            }
            this.addRelevantDef(node);
        }

        @Override
        public void visitJSObjectLiteralExpression(@NotNull JSObjectLiteralExpression node) {
            if (node == null) {
                JSNamesCacheVisitor.$$$reportNull$$$0(10);
            }
        }

        @Override
        public void visitJSClass(@NotNull JSClass aClass) {
            if (aClass == null) {
                JSNamesCacheVisitor.$$$reportNull$$$0(11);
            }
            if (aClass instanceof ES6Class && ((ES6Class)aClass).hasBlockScope()) {
                return;
            }
            this.processUseDirectiveInAttrList(aClass);
            this.addRelevantDef(aClass);
        }

        @Override
        public void visitJSPackageStatement(@NotNull JSPackageStatement packageStatement) {
            if (packageStatement == null) {
                JSNamesCacheVisitor.$$$reportNull$$$0(12);
            }
        }

        @Override
        public void visitTypeScriptModule(@NotNull TypeScriptModule module) {
            if (module == null) {
                JSNamesCacheVisitor.$$$reportNull$$$0(13);
            }
            this.addRelevantDef(module);
        }

        @Override
        public void visitJSFunctionDeclaration(@NotNull JSFunction node) {
            if (node == null) {
                JSNamesCacheVisitor.$$$reportNull$$$0(14);
            }
            if (node instanceof ActionScriptFunctionImpl && ((ActionScriptFunctionImpl)node).hasQualifiedName()) {
                return;
            }
            this.processUseDirectiveInAttrList(node);
            this.addRelevantDef(node);
            if (this.isTypeScript) {
                for (JSParameter parameter : node.getParameterVariables()) {
                    if (!TypeScriptPsiUtil.isClassMember(parameter)) continue;
                    this.addRelevantDef(parameter);
                }
            }
        }

        @Override
        public void visitJSNamespaceDeclaration(@NotNull JSNamespaceDeclaration namespaceDeclaration) {
            if (namespaceDeclaration == null) {
                JSNamesCacheVisitor.$$$reportNull$$$0(15);
            }
            this.addRelevantDef(namespaceDeclaration);
        }

        @Override
        public void visitJSImportStatement(@NotNull JSImportStatement importStatement) {
            if (importStatement == null) {
                JSNamesCacheVisitor.$$$reportNull$$$0(16);
            }
        }

        @Override
        public void visitTypeScriptImportStatement(@NotNull TypeScriptImportStatement importStatement) {
            if (importStatement == null) {
                JSNamesCacheVisitor.$$$reportNull$$$0(17);
            }
            this.addRelevantDef(importStatement);
        }

        @Override
        public void visitTypeScriptObjectType(@NotNull TypeScriptObjectType objectType) {
            if (objectType == null) {
                JSNamesCacheVisitor.$$$reportNull$$$0(18);
            }
            for (TypeScriptTypeMember member : objectType.getTypeMembers()) {
                if (!(member instanceof JSNamedElement)) continue;
                this.addRelevantDef(member);
            }
        }

        @Override
        public void visitJSUseNamespaceDirective(@NotNull JSUseNamespaceDirective useNamespaceDirective) {
            String namespaceToBeUsed;
            if (useNamespaceDirective == null) {
                JSNamesCacheVisitor.$$$reportNull$$$0(19);
            }
            if ((namespaceToBeUsed = useNamespaceDirective.getNamespaceToBeUsed()) != null) {
                this.addNamedElement(useNamespaceDirective, namespaceToBeUsed.hashCode());
            }
        }

        @Override
        public void visitES6ImportDeclaration(@NotNull ES6ImportDeclaration importDeclaration) {
            if (importDeclaration == null) {
                JSNamesCacheVisitor.$$$reportNull$$$0(20);
            }
            ES6ImportedBinding[] bindings = importDeclaration.getImportedBindings();
            for (ES6ImportedBinding eS6ImportedBinding : bindings) {
                this.addRelevantDef(eS6ImportedBinding);
            }
            for (JSBoundNameOwner jSBoundNameOwner : importDeclaration.getImportSpecifiers()) {
                ES6ImportSpecifierAlias alias = jSBoundNameOwner.getAlias();
                if (alias != null) {
                    this.addRelevantDef(alias);
                    continue;
                }
                this.addNamedElement(jSBoundNameOwner, jSBoundNameOwner.getReferenceName().hashCode());
            }
        }

        @Override
        public void visitES6ExportDeclaration(@NotNull ES6ExportDeclaration exportDeclaration) {
            ES6ExportedDefaultBinding defaultBinding;
            if (exportDeclaration == null) {
                JSNamesCacheVisitor.$$$reportNull$$$0(21);
            }
            for (ES6ExportSpecifier specifier : exportDeclaration.getExportSpecifiers()) {
                ES6ExportSpecifierAlias alias = specifier.getAlias();
                if (alias != null) {
                    this.addRelevantDef(alias);
                    continue;
                }
                String name = specifier.getReferenceName();
                if (name == null) continue;
                this.addNamedElement(specifier, name.hashCode());
            }
            ES6NamespaceExport export = exportDeclaration.getNamespaceExport();
            if (export != null) {
                this.addRelevantDef(export);
            }
            if ((defaultBinding = exportDeclaration.getExportedDefaultBinding()) != null) {
                this.addRelevantDef(defaultBinding);
            }
        }

        @Override
        public void visitJSDocComment(@NotNull JSDocComment docComment) {
            if (docComment == null) {
                JSNamesCacheVisitor.$$$reportNull$$$0(22);
            }
            List<Pair<@Nullable String, @NotNull String>> typedefs = docComment.getTypedefs();
            if (!(this.isTypeScript || this.isActionScript || typedefs.isEmpty())) {
                Collection<JSImplicitElement> elements;
                JSElementIndexingData indexingData = docComment.getIndexingData();
                Collection<JSImplicitElement> collection = elements = indexingData != null ? indexingData.getImplicitElements() : null;
                if (elements != null) {
                    Set typedefNames = ContainerUtil.map2SetNotNull(typedefs, it -> (String)it.first);
                    for (JSImplicitElement element : elements) {
                        if (!typedefNames.contains(element.getQualifiedName())) continue;
                        this.addRelevantDef(element);
                    }
                }
            }
            super.visitJSDocComment(docComment);
        }

        public void visitComment(@NotNull PsiComment comment) {
            if (comment == null) {
                JSNamesCacheVisitor.$$$reportNull$$$0(23);
            }
            if (!JSDirectiveCommentUtil.isDirectiveCommentTokenType(comment)) {
                return;
            }
            String text2 = comment.getText();
            int bodyStartIndex = JSDirectiveCommentUtil.getGlobalDirectiveBodyStartIndex(text2);
            if (bodyStartIndex > 0 && bodyStartIndex <= text2.length() - 2) {
                text2 = text2.substring(bodyStartIndex, text2.length() - 2);
                StringTokenizer t = new StringTokenizer(text2, ",");
                while (t.hasMoreElements()) {
                    String s = t.nextElement();
                    int i = s.indexOf(58);
                    boolean readOnly = false;
                    if (i != -1) {
                        readOnly = StringUtil.equalsIgnoreCase((CharSequence)"false", (CharSequence)s.substring(i + 1).trim());
                        s = s.substring(0, i);
                    }
                    if (!StringUtil.isJavaIdentifier((String)(s = s.trim()))) continue;
                    EnumSet<JSImplicitElement.Property> properties = EnumSet.of(JSImplicitElement.Property.MinorImportance);
                    if (readOnly) {
                        properties.add(JSImplicitElement.Property.Constant);
                    }
                    JSImplicitElementImpl.Builder builder2 = new JSImplicitElementImpl.Builder(s, (PsiElement)comment).setProperties(properties).setType(JSImplicitElement.Type.Variable);
                    this.addRelevantDef(new JSImplicitElementImpl(builder2));
                }
            }
        }

        private void addRelevantDef(@NotNull JSElement node) {
            String name;
            if (node == null) {
                JSNamesCacheVisitor.$$$reportNull$$$0(24);
            }
            if ((name = node.getName()) != null) {
                int key2 = name.hashCode();
                this.addNamedElement(node, key2);
            }
        }

        private void addNamedElement(JSElement node, int key2) {
            JSScopeNamesCache.addElementCompact(this.myRelevantDefs, node, key2);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "node";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "includeDirective";
                    break;
                }
                case 6: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "exportAssignment";
                    break;
                }
                case 11: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "aClass";
                    break;
                }
                case 12: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "packageStatement";
                    break;
                }
                case 13: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "module";
                    break;
                }
                case 15: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "namespaceDeclaration";
                    break;
                }
                case 16: 
                case 17: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "importStatement";
                    break;
                }
                case 18: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "objectType";
                    break;
                }
                case 19: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "useNamespaceDirective";
                    break;
                }
                case 20: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "importDeclaration";
                    break;
                }
                case 21: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "exportDeclaration";
                    break;
                }
                case 22: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "docComment";
                    break;
                }
                case 23: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "comment";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/lang/javascript/psi/resolve/JSScopeNamesCache$JSNamesCacheVisitor";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "visitJSDefinitionExpression";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "visitJSExpressionStatement";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[2] = "visitJSVariable";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[2] = "visitJSIncludeDirective";
                    break;
                }
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[2] = "visitJSVarStatement";
                    break;
                }
                case 5: {
                    objectArray = objectArray2;
                    objectArray2[2] = "visitES6ExportDefaultAssignment";
                    break;
                }
                case 6: {
                    objectArray = objectArray2;
                    objectArray2[2] = "visitTypeScriptExportAssignment";
                    break;
                }
                case 7: {
                    objectArray = objectArray2;
                    objectArray2[2] = "visitJSParameter";
                    break;
                }
                case 8: {
                    objectArray = objectArray2;
                    objectArray2[2] = "visitJSFunctionExpression";
                    break;
                }
                case 9: {
                    objectArray = objectArray2;
                    objectArray2[2] = "visitJSProperty";
                    break;
                }
                case 10: {
                    objectArray = objectArray2;
                    objectArray2[2] = "visitJSObjectLiteralExpression";
                    break;
                }
                case 11: {
                    objectArray = objectArray2;
                    objectArray2[2] = "visitJSClass";
                    break;
                }
                case 12: {
                    objectArray = objectArray2;
                    objectArray2[2] = "visitJSPackageStatement";
                    break;
                }
                case 13: {
                    objectArray = objectArray2;
                    objectArray2[2] = "visitTypeScriptModule";
                    break;
                }
                case 14: {
                    objectArray = objectArray2;
                    objectArray2[2] = "visitJSFunctionDeclaration";
                    break;
                }
                case 15: {
                    objectArray = objectArray2;
                    objectArray2[2] = "visitJSNamespaceDeclaration";
                    break;
                }
                case 16: {
                    objectArray = objectArray2;
                    objectArray2[2] = "visitJSImportStatement";
                    break;
                }
                case 17: {
                    objectArray = objectArray2;
                    objectArray2[2] = "visitTypeScriptImportStatement";
                    break;
                }
                case 18: {
                    objectArray = objectArray2;
                    objectArray2[2] = "visitTypeScriptObjectType";
                    break;
                }
                case 19: {
                    objectArray = objectArray2;
                    objectArray2[2] = "visitJSUseNamespaceDirective";
                    break;
                }
                case 20: {
                    objectArray = objectArray2;
                    objectArray2[2] = "visitES6ImportDeclaration";
                    break;
                }
                case 21: {
                    objectArray = objectArray2;
                    objectArray2[2] = "visitES6ExportDeclaration";
                    break;
                }
                case 22: {
                    objectArray = objectArray2;
                    objectArray2[2] = "visitJSDocComment";
                    break;
                }
                case 23: {
                    objectArray = objectArray2;
                    objectArray2[2] = "visitComment";
                    break;
                }
                case 24: {
                    objectArray = objectArray2;
                    objectArray2[2] = "addRelevantDef";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

