/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.psi.resolve;

import com.intellij.codeInsight.daemon.impl.CollectHighlightsUtil;
import com.intellij.lang.Language;
import com.intellij.lang.ecmascript6.psi.JSClassExpression;
import com.intellij.lang.javascript.JavaScriptSupportLoader;
import com.intellij.lang.javascript.dialects.JSDialectSpecificHandlersFactory;
import com.intellij.lang.javascript.flex.JSResolveHelper;
import com.intellij.lang.javascript.frameworks.jsx.references.JSXResolveUtil;
import com.intellij.lang.javascript.psi.JSFile;
import com.intellij.lang.javascript.psi.JSNamespace;
import com.intellij.lang.javascript.psi.JSQualifiedName;
import com.intellij.lang.javascript.psi.JSRecordType;
import com.intellij.lang.javascript.psi.JSReferenceExpression;
import com.intellij.lang.javascript.psi.JSType;
import com.intellij.lang.javascript.psi.JSTypeUtils;
import com.intellij.lang.javascript.psi.JSXmlLiteralExpression;
import com.intellij.lang.javascript.psi.ecma6.impl.JSXXmlLiteralExpressionImpl;
import com.intellij.lang.javascript.psi.ecmal4.JSAttributeNameValuePair;
import com.intellij.lang.javascript.psi.ecmal4.JSReferenceList;
import com.intellij.lang.javascript.psi.ecmal4.JSReferenceListMember;
import com.intellij.lang.javascript.psi.jsdoc.JSDocTagType;
import com.intellij.lang.javascript.psi.resolve.JSImportHandler;
import com.intellij.lang.javascript.psi.resolve.JSImportedElementResolveResult;
import com.intellij.lang.javascript.psi.resolve.JSResolveUtil;
import com.intellij.lang.javascript.psi.resolve.JSTypeResolveResult;
import com.intellij.lang.javascript.psi.resolve.ResolveProcessor;
import com.intellij.lang.javascript.psi.types.JSGenericTypeImpl;
import com.intellij.lang.javascript.psi.types.evaluable.JSTypeWithDeclarations;
import com.intellij.lang.javascript.psi.util.JSStubBasedPsiTreeUtil;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiNamedElement;
import com.intellij.psi.scope.PsiScopeProcessor;
import com.intellij.psi.xml.XmlAttributeValue;
import com.intellij.psi.xml.XmlTag;
import com.intellij.util.containers.ContainerUtil;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class JSImportHandlingUtil {
    @Nullable
    public static String resolveTypeName(@Nullable String _str, @NotNull PsiElement context2) {
        if (context2 == null) {
            JSImportHandlingUtil.$$$reportNull$$$0(0);
        }
        if (_str == null) {
            return null;
        }
        JSImportHandler importHandler = JSDialectSpecificHandlersFactory.forElement(context2).getImportHandler();
        return importHandler.getQualifiedNameResolvedType(_str, context2);
    }

    @Nullable
    public static JSImportedElementResolveResult resolveTypeNameUsingImports(@NotNull JSReferenceExpression expr) {
        if (expr == null) {
            JSImportHandlingUtil.$$$reportNull$$$0(1);
        }
        JSImportHandler importHandler = JSDialectSpecificHandlersFactory.forElement((PsiElement)expr).getImportHandler();
        return importHandler.resolveTypeNameUsingImports(expr);
    }

    public static boolean tryResolveImports(PsiScopeProcessor processor, PsiNamedElement parent, @NotNull PsiElement place) {
        if (place == null) {
            JSImportHandlingUtil.$$$reportNull$$$0(2);
        }
        if (!JSImportHandlingUtil.isAdequatePlaceForImport(parent, place, processor)) {
            return true;
        }
        JSImportHandler importHandler = JSDialectSpecificHandlersFactory.forElement((PsiElement)parent).getImportHandler();
        return importHandler.importClass(processor, parent);
    }

    public static boolean isAdequatePlaceForImport(PsiNamedElement parent, @NotNull PsiElement place, PsiScopeProcessor processor) {
        PsiFile containingFile2;
        if (place == null) {
            JSImportHandlingUtil.$$$reportNull$$$0(3);
        }
        if ((containingFile2 = parent.getContainingFile()) instanceof JSFile && !containingFile2.getLanguage().isKindOf((Language)JavaScriptSupportLoader.ECMA_SCRIPT_L4)) {
            return false;
        }
        if (processor instanceof ResolveProcessor && ((ResolveProcessor)processor).isForceImportsForPlace()) {
            return true;
        }
        if (place instanceof JSReferenceExpression) {
            PsiElement currentParent;
            PsiElement placeParent = place.getParent();
            if (placeParent instanceof JSReferenceExpression && (JSResolveUtil.isSelfReference(currentParent = JSResolveUtil.getTopReferenceParent(placeParent), place) || currentParent instanceof JSReferenceListMember || currentParent instanceof JSReferenceList)) {
                return false;
            }
        } else if (!(place instanceof JSDocTagType || place instanceof JSAttributeNameValuePair || place instanceof XmlAttributeValue || place instanceof XmlTag || place instanceof JSFile)) {
            return JSImportHandlingUtil.isAdequatePlaceForImportViaHelper(place);
        }
        return true;
    }

    private static boolean isAdequatePlaceForImportViaHelper(PsiElement place) {
        for (JSResolveHelper helper : JSResolveHelper.EP_NAME.getExtensionList()) {
            if (!helper.isAdequatePlaceForImport(place)) continue;
            return true;
        }
        return false;
    }

    @Nullable
    private static JSTypeWithDeclarations asTypeWithDeclarations(@NotNull JSType type2, @NotNull PsiElement resolveContext) {
        if (type2 == null) {
            JSImportHandlingUtil.$$$reportNull$$$0(4);
        }
        if (resolveContext == null) {
            JSImportHandlingUtil.$$$reportNull$$$0(5);
        }
        if (type2.getSourceElement() != resolveContext) {
            return null;
        }
        if (type2 instanceof JSGenericTypeImpl) {
            type2 = ((JSGenericTypeImpl)type2).getType();
        }
        return type2 instanceof JSTypeWithDeclarations ? (JSTypeWithDeclarations)type2 : null;
    }

    @NotNull
    public static Collection<? extends PsiElement> resolveElementsByType(@NotNull JSType type2, @NotNull PsiElement resolveContext) {
        JSQualifiedName name;
        JSTypeWithDeclarations typeWithDeclarations;
        if (type2 == null) {
            JSImportHandlingUtil.$$$reportNull$$$0(6);
        }
        if (resolveContext == null) {
            JSImportHandlingUtil.$$$reportNull$$$0(7);
        }
        if ((typeWithDeclarations = JSImportHandlingUtil.asTypeWithDeclarations(type2, resolveContext)) != null) {
            Collection<PsiElement> collection = typeWithDeclarations.getDeclarations();
            if (collection == null) {
                JSImportHandlingUtil.$$$reportNull$$$0(8);
            }
            return collection;
        }
        String qName = JSTypeUtils.getQualifiedNameMatchingType(type2, false);
        if (qName == null) {
            if (type2 instanceof JSRecordType && resolveContext instanceof JSClassExpression) {
                List list2 = ContainerUtil.createMaybeSingletonList((Object)resolveContext);
                if (list2 == null) {
                    JSImportHandlingUtil.$$$reportNull$$$0(9);
                }
                return list2;
            }
            List list3 = Collections.emptyList();
            if (list3 == null) {
                JSImportHandlingUtil.$$$reportNull$$$0(10);
            }
            return list3;
        }
        if (type2 instanceof JSNamespace && ((JSNamespace)type2).isLocal() && (name = ((JSNamespace)type2).getQualifiedName()) != null && name.getParent() == null) {
            List<PsiElement> list4 = JSStubBasedPsiTreeUtil.resolveLocallyWithMergedResults(name.getName(), resolveContext, true);
            if (list4 == null) {
                JSImportHandlingUtil.$$$reportNull$$$0(11);
            }
            return list4;
        }
        JSTypeResolveResult result2 = JSDialectSpecificHandlersFactory.forElement(resolveContext).getImportHandler().resolveTypeName(qName, resolveContext);
        Collection<? extends PsiElement> collection = result2.getElements();
        if (collection == null) {
            JSImportHandlingUtil.$$$reportNull$$$0(12);
        }
        return collection;
    }

    @Nullable
    public static PsiElement findUnresolvedImportableReference(@NotNull Editor editor, @NotNull PsiFile file, int offset) {
        if (editor == null) {
            JSImportHandlingUtil.$$$reportNull$$$0(13);
        }
        if (file == null) {
            JSImportHandlingUtil.$$$reportNull$$$0(14);
        }
        Document document2 = editor.getDocument();
        int lineNumber = document2.getLineNumber(offset);
        int startOffset = document2.getLineStartOffset(lineNumber);
        int endOffset = document2.getLineEndOffset(lineNumber);
        List elements = CollectHighlightsUtil.getElementsInRange((PsiElement)file, (int)startOffset, (int)endOffset);
        for (PsiElement element : elements) {
            String name;
            if (element instanceof JSReferenceExpression && ((JSReferenceExpression)element).getQualifier() == null && ((JSReferenceExpression)element).multiResolve(false).length == 0) {
                return element;
            }
            if (!(element instanceof JSXXmlLiteralExpressionImpl) || !JSXResolveUtil.isComponentName(name = ((JSXXmlLiteralExpressionImpl)element).getName()) || !JSXResolveUtil.areReferencesResolvedOrEmpty((JSXmlLiteralExpression)element)) continue;
            return element;
        }
        return null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 8, 9, 10, 11, 12 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "expr";
                break;
            }
            case 2: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "place";
                break;
            }
            case 4: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "type";
                break;
            }
            case 5: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "resolveContext";
                break;
            }
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/javascript/psi/resolve/JSImportHandlingUtil";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "editor";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/javascript/psi/resolve/JSImportHandlingUtil";
                break;
            }
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "resolveElementsByType";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "resolveTypeName";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "resolveTypeNameUsingImports";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "tryResolveImports";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "isAdequatePlaceForImport";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "asTypeWithDeclarations";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "resolveElementsByType";
                break;
            }
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: {
                break;
            }
            case 13: 
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "findUnresolvedImportableReference";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 8, 9, 10, 11, 12 -> new IllegalStateException(string);
        };
    }
}

