/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.psi.jsdoc.impl;

import com.intellij.lang.ASTNode;
import com.intellij.lang.javascript.JSDocTokenTypes;
import com.intellij.lang.javascript.documentation.JSDocumentationUtils;
import com.intellij.lang.javascript.psi.JSElementVisitor;
import com.intellij.lang.javascript.psi.impl.JSElementImpl;
import com.intellij.lang.javascript.psi.jsdoc.JSDocDescription;
import com.intellij.lang.javascript.psi.jsdoc.JSDocInlineTag;
import com.intellij.lang.javascript.psi.jsdoc.JSDocInlineTags;
import com.intellij.lang.javascript.psi.jsdoc.JSDocTagDefinition;
import com.intellij.lang.javascript.psi.jsdoc.JSDocTagNamepath;
import com.intellij.lang.javascript.psi.jsdoc.JSDocTagPart;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.TokenType;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.ObjectUtils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class JSDocTagInlineImpl
extends JSElementImpl
implements JSDocInlineTag {
    public JSDocTagInlineImpl(IElementType elementType) {
        super(elementType);
    }

    @Override
    @NotNull
    public JSDocTagDefinition getTagDefinition() {
        JSDocTagDefinition jSDocTagDefinition = JSDocInlineTags.definitionFor(this.getName());
        if (jSDocTagDefinition == null) {
            JSDocTagInlineImpl.$$$reportNull$$$0(0);
        }
        return jSDocTagDefinition;
    }

    @Override
    @NotNull
    public String getName() {
        ASTNode element = this.findChildByType(JSDocTokenTypes.DOC_TAG_NAME);
        return element != null ? element.getText().substring(1) : "<null>";
    }

    @Override
    public boolean is(@NotNull String name) {
        if (name == null) {
            JSDocTagInlineImpl.$$$reportNull$$$0(1);
        }
        return this.getTagDefinition().equals(JSDocInlineTags.definitionFor(name));
    }

    @Override
    public boolean is(@NotNull JSDocTagDefinition tag) {
        if (tag == null) {
            JSDocTagInlineImpl.$$$reportNull$$$0(2);
        }
        return this.getTagDefinition().equals(tag);
    }

    @Override
    public void accept(@NotNull PsiElementVisitor visitor) {
        if (visitor == null) {
            JSDocTagInlineImpl.$$$reportNull$$$0(3);
        }
        if (visitor instanceof JSElementVisitor) {
            ((JSElementVisitor)visitor).visitJSDocInlineTag(this);
        } else {
            visitor.visitElement((PsiElement)this);
        }
    }

    @Override
    @Nullable
    public JSDocDescription getParameter() {
        JSDocTagPart[] parts = (JSDocTagPart[])PsiTreeUtil.getChildrenOfType((PsiElement)this, JSDocTagPart.class);
        if (parts == null || parts.length <= 1) {
            return null;
        }
        return (JSDocDescription)ObjectUtils.tryCast((Object)parts[0], JSDocDescription.class);
    }

    @Override
    @Nullable
    public JSDocDescription getValue() {
        JSDocTagPart[] parts = (JSDocTagPart[])PsiTreeUtil.getChildrenOfType((PsiElement)this, JSDocTagPart.class);
        if (parts == null || parts.length == 0) {
            return null;
        }
        return (JSDocDescription)ObjectUtils.tryCast((Object)parts[parts.length - 1], JSDocDescription.class);
    }

    @Override
    @Nullable
    public JSDocTagNamepath getNamepath() {
        return (JSDocTagNamepath)PsiTreeUtil.getChildOfType((PsiElement)this, JSDocTagNamepath.class);
    }

    @Override
    @Nullable
    public String getValueText() {
        JSDocDescription value = this.getValue();
        return value != null ? value.getDescriptionText(JSDocumentationUtils.DEFAULT_DESCRIPTION_PROCESSOR) : null;
    }

    @Override
    @Nullable
    public String getParameterText() {
        JSDocDescription parameter = this.getParameter();
        return parameter != null ? parameter.getDescriptionText(JSDocumentationUtils.DEFAULT_DESCRIPTION_PROCESSOR) : null;
    }

    public void delete() throws IncorrectOperationException {
        ASTNode treePrev;
        ASTNode node = this.getNode();
        ASTNode parentNode = node.getTreeParent();
        for (treePrev = node.getTreePrev(); treePrev != null && (treePrev.getElementType() == TokenType.WHITE_SPACE || treePrev.getElementType() == JSDocTokenTypes.DOC_COMMENT_LEADING_ASTERISK); treePrev = treePrev.getTreePrev()) {
            node = treePrev;
            parentNode.removeChild(node);
        }
        if (treePrev != null && treePrev.getElementType() == JSDocTokenTypes.DOC_COMMENT_START) {
            ASTNode treeNext;
            for (treeNext = this.getNode().getTreeNext(); treeNext != null && (treeNext.getElementType() == TokenType.WHITE_SPACE || treeNext.getElementType() == JSDocTokenTypes.DOC_COMMENT_LEADING_ASTERISK); treeNext = treeNext.getTreeNext()) {
            }
            if (treeNext != null && treeNext.getElementType() == JSDocTokenTypes.DOC_COMMENT_END) {
                parentNode.getTreeParent().removeChild(parentNode);
                return;
            }
        }
        super.delete();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 2;
            case 1, 2, 3 -> 3;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/javascript/psi/jsdoc/impl/JSDocTagInlineImpl";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "tag";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "visitor";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getTagDefinition";
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/javascript/psi/jsdoc/impl/JSDocTagInlineImpl";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "is";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "accept";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalStateException(string);
            case 1, 2, 3 -> new IllegalArgumentException(string);
        };
    }
}

