/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.psi.jsdoc.impl;

import com.intellij.lang.javascript.documentation.JSDocumentationUtils;
import com.intellij.lang.javascript.frameworks.commonjs.CommonJSUtil;
import com.intellij.lang.javascript.index.JSSymbolUtil;
import com.intellij.lang.javascript.psi.JSAssignmentExpression;
import com.intellij.lang.javascript.psi.JSDefinitionExpression;
import com.intellij.lang.javascript.psi.JSExpression;
import com.intellij.lang.javascript.psi.JSExpressionStatement;
import com.intellij.lang.javascript.psi.JSFunction;
import com.intellij.lang.javascript.psi.JSQualifiedName;
import com.intellij.lang.javascript.psi.JSQualifiedNameImpl;
import com.intellij.lang.javascript.psi.JSReferenceExpression;
import com.intellij.lang.javascript.psi.impl.ActionScriptTextReferenceResolver;
import com.intellij.lang.javascript.psi.impl.JSReferenceSet;
import com.intellij.lang.javascript.psi.impl.JSTextReference;
import com.intellij.lang.javascript.psi.jsdoc.JSDocComment;
import com.intellij.lang.javascript.psi.jsdoc.JSDocTagNamepath;
import com.intellij.lang.javascript.psi.jsdoc.JSDocTagType;
import com.intellij.lang.javascript.psi.jsdoc.impl.JSDocReferenceResolver;
import com.intellij.lang.javascript.psi.resolve.ES6QualifiedNameResolver;
import com.intellij.lang.javascript.psi.resolve.JSReferenceResolver;
import com.intellij.lang.javascript.psi.resolve.JSResolveResult;
import com.intellij.lang.javascript.psi.stubs.JSElementIndexingData;
import com.intellij.lang.javascript.psi.stubs.JSImplicitElement;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.ResolveResult;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.QualifiedName;
import com.intellij.util.containers.ContainerUtil;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class JSDocReference
extends JSTextReference {
    private final boolean myMethodRef;

    JSDocReference(@NotNull JSReferenceSet set, @NotNull String s, @NotNull TextRange rangeInElement, boolean methodRef) {
        if (set == null) {
            JSDocReference.$$$reportNull$$$0(0);
        }
        if (s == null) {
            JSDocReference.$$$reportNull$$$0(1);
        }
        if (rangeInElement == null) {
            JSDocReference.$$$reportNull$$$0(2);
        }
        super(set, s, rangeInElement);
        this.myMethodRef = methodRef;
    }

    @Override
    protected ResolveResult @NotNull [] doResolve() {
        List implicitElements;
        String qualifiedName;
        List<JSImplicitElement> implicitElements2;
        JSElementIndexingData indexingData;
        JSDocComment docComment;
        PsiElement element = this.mySet.getElement();
        if ("int".equals(this.myCanonicalText) || "uint".equals(this.myCanonicalText) || ("Null".equals(this.myCanonicalText) || "null".equals(this.myCanonicalText) || "true".equals(this.myCanonicalText) || "false".equals(this.myCanonicalText) || "Undefined".equals(this.myCanonicalText)) && this.getElement() instanceof JSDocTagType) {
            ResolveResult[] resolveResultArray = new ResolveResult[]{new JSResolveResult(element)};
            if (resolveResultArray == null) {
                JSDocReference.$$$reportNull$$$0(3);
            }
            return resolveResultArray;
        }
        if (element instanceof JSDocTagNamepath && (docComment = (JSDocComment)PsiTreeUtil.getParentOfType((PsiElement)element, JSDocComment.class)) != null && (indexingData = docComment.getIndexingData()) != null && !(implicitElements2 = indexingData.findElementsByNameOrQName(qualifiedName = this.getReferenceQualifiedName().getQualifiedName())).isEmpty()) {
            ResolveResult[] resolveResultArray = JSResolveResult.toResolveResults(implicitElements2);
            if (resolveResultArray == null) {
                JSDocReference.$$$reportNull$$$0(4);
            }
            return resolveResultArray;
        }
        PsiFile psiFile = element.getContainingFile();
        if (this.useActionScriptIndex(psiFile)) {
            ResolveResult[] resolveResultArray = ActionScriptTextReferenceResolver.resolve(this);
            if (resolveResultArray == null) {
                JSDocReference.$$$reportNull$$$0(5);
            }
            return resolveResultArray;
        }
        JSQualifiedName qName = this.getReferenceQualifiedName();
        if (qName.getParent() == null && qName.getName().startsWith("module:") && !(implicitElements = ContainerUtil.flatMap(CommonJSUtil.resolveJSDocCommentsWithModuleTag(element, StringUtil.trimStart((String)qName.getName(), (String)"module:")), c2 -> {
            JSElementIndexingData indexingData = c2.getIndexingData();
            return indexingData != null ? indexingData.findElementsByQualifiedName(qName.getQualifiedName()) : Collections.emptyList();
        })).isEmpty()) {
            ResolveResult[] resolveResultArray = JSResolveResult.toResolveResults(implicitElements);
            if (resolveResultArray == null) {
                JSDocReference.$$$reportNull$$$0(6);
            }
            return resolveResultArray;
        }
        ResolveResult[] resolveResultArray = new ES6QualifiedNameResolver(element, false, true, true).resolveQualifiedName(qName, false);
        if (resolveResultArray == null) {
            JSDocReference.$$$reportNull$$$0(7);
        }
        return resolveResultArray;
    }

    @Override
    @NotNull
    public JSReferenceResolver createResolver() {
        return new JSDocReferenceResolver(this.getElement(), this.isPrimary(), this.myMethodRef);
    }

    public boolean isMethodRef() {
        return this.myMethodRef;
    }

    private boolean isImportType() {
        return this.myCanonicalText.startsWith("import");
    }

    @Override
    @NotNull
    public JSQualifiedName getQualifiedName() {
        if (this.mySet.getReferences().length == 1) {
            JSQualifiedName name;
            if (this.myRangeInElement.getStartOffset() > 0 && (name = this.buildQualifiedNameForRelativeLink()) != null) {
                JSQualifiedName jSQualifiedName = name;
                if (jSQualifiedName == null) {
                    JSDocReference.$$$reportNull$$$0(8);
                }
                return jSQualifiedName;
            }
            PsiElement elt = this.getElement();
            if ((elt instanceof JSDocTagType || elt instanceof JSDocComment) && !this.myMethodRef) {
                JSQualifiedNameImpl jSQualifiedNameImpl = JSQualifiedNameImpl.create(JSDocumentationUtils.doCapitalizeCommentTypeIfNeeded(this.myCanonicalText), null);
                if (jSQualifiedNameImpl == null) {
                    JSDocReference.$$$reportNull$$$0(9);
                }
                return jSQualifiedNameImpl;
            }
        }
        JSQualifiedName jSQualifiedName = super.getQualifiedName();
        if (jSQualifiedName == null) {
            JSDocReference.$$$reportNull$$$0(10);
        }
        return jSQualifiedName;
    }

    @Nullable
    private JSQualifiedName buildQualifiedNameForRelativeLink() {
        JSExpression expression;
        PsiElement elt = this.mySet.getElement();
        if (this.myMethodRef && elt instanceof JSExpressionStatement && (expression = ((JSExpressionStatement)elt).getExpression()) instanceof JSAssignmentExpression) {
            JSExpression jsExpression = ((JSAssignmentExpression)expression).getLOperand();
            if (jsExpression instanceof JSDefinitionExpression) {
                jsExpression = ((JSDefinitionExpression)jsExpression).getExpression();
            }
            if (jsExpression instanceof JSReferenceExpression) {
                String qualifier;
                JSExpression rOperand = ((JSAssignmentExpression)expression).getROperand();
                boolean stripQualifier = true;
                if (rOperand instanceof JSFunction && ((JSFunction)((Object)rOperand)).isConstructor()) {
                    stripQualifier = false;
                }
                if (stripQualifier) {
                    jsExpression = ((JSReferenceExpression)jsExpression).getQualifier();
                }
                if (jsExpression != null && (qualifier = JSSymbolUtil.getQualifierOfExprAsString(jsExpression)) != null) {
                    return this.qNameFromNames(QualifiedName.fromDottedString((String)qualifier).getComponents());
                }
            }
        }
        return null;
    }

    @Override
    public boolean isSoft() {
        return super.isSoft() || this.isImportType();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 3, 4, 5, 6, 7, 8, 9, 10 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "set";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "s";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "rangeInElement";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/javascript/psi/jsdoc/impl/JSDocReference";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/javascript/psi/jsdoc/impl/JSDocReference";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "doResolve";
                break;
            }
            case 8: 
            case 9: 
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "getQualifiedName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: {
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 3, 4, 5, 6, 7, 8, 9, 10 -> new IllegalStateException(string);
        };
    }
}

