/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.psi.jsdoc.impl;

import com.intellij.codeInsight.daemon.EmptyResolveMessageProvider;
import com.intellij.lang.javascript.JavaScriptBundle;
import com.intellij.lang.javascript.documentation.JSDocumentationUtils;
import com.intellij.lang.javascript.psi.JSDestructuringContainer;
import com.intellij.lang.javascript.psi.JSDestructuringElement;
import com.intellij.lang.javascript.psi.JSDestructuringObject;
import com.intellij.lang.javascript.psi.JSDestructuringParameter;
import com.intellij.lang.javascript.psi.JSDestructuringProperty;
import com.intellij.lang.javascript.psi.JSFunction;
import com.intellij.lang.javascript.psi.JSParameter;
import com.intellij.lang.javascript.psi.JSParameterList;
import com.intellij.lang.javascript.psi.JSParameterListElement;
import com.intellij.lang.javascript.psi.jsdoc.JSDocComment;
import com.intellij.lang.javascript.psi.jsdoc.JSDocTagNamepath;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.ElementManipulators;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiReference;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.containers.ContainerUtil;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class JSDocParamReference
implements PsiReference,
EmptyResolveMessageProvider {
    @NotNull
    private JSDocTagNamepath myJSDocTag;
    @NotNull
    private TextRange myRangeInElement;
    @Nullable
    private final JSDocParamReference myQualifier;

    private JSDocParamReference(@NotNull JSDocTagNamepath elt, @NotNull TextRange rangeInElement, @Nullable JSDocParamReference qualifier) {
        if (elt == null) {
            JSDocParamReference.$$$reportNull$$$0(0);
        }
        if (rangeInElement == null) {
            JSDocParamReference.$$$reportNull$$$0(1);
        }
        this.myJSDocTag = elt;
        this.myRangeInElement = rangeInElement;
        this.myQualifier = qualifier;
    }

    @NotNull
    public PsiElement getElement() {
        JSDocTagNamepath jSDocTagNamepath = this.myJSDocTag;
        if (jSDocTagNamepath == null) {
            JSDocParamReference.$$$reportNull$$$0(2);
        }
        return jSDocTagNamepath;
    }

    @NotNull
    public TextRange getRangeInElement() {
        TextRange textRange = this.myRangeInElement;
        if (textRange == null) {
            JSDocParamReference.$$$reportNull$$$0(3);
        }
        return textRange;
    }

    @NotNull
    public String getCanonicalText() {
        int offsetInText = this.myRangeInElement.getStartOffset();
        String string = this.myJSDocTag.getText().substring(offsetInText, offsetInText + this.myRangeInElement.getLength());
        if (string == null) {
            JSDocParamReference.$$$reportNull$$$0(4);
        }
        return string;
    }

    public PsiElement handleElementRename(@NotNull String newElementName) throws IncorrectOperationException {
        if (newElementName == null) {
            JSDocParamReference.$$$reportNull$$$0(5);
        }
        this.myJSDocTag = (JSDocTagNamepath)ElementManipulators.handleContentChange((PsiElement)this.myJSDocTag, (TextRange)this.myRangeInElement, (String)newElementName);
        this.myRangeInElement = TextRange.from((int)this.myRangeInElement.getStartOffset(), (int)(this.myRangeInElement.getStartOffset() + newElementName.length()));
        return this.myJSDocTag;
    }

    public PsiElement bindToElement(@NotNull PsiElement element) throws IncorrectOperationException {
        if (element == null) {
            JSDocParamReference.$$$reportNull$$$0(6);
        }
        return null;
    }

    public boolean isReferenceTo(@NotNull PsiElement element) {
        if (element == null) {
            JSDocParamReference.$$$reportNull$$$0(7);
        }
        return element.isEquivalentTo(this.resolve());
    }

    private JSParameterList findParameterList() {
        JSDocComment docComment = this.getDocComment();
        return JSDocParamReference.findParameterList(docComment);
    }

    @Nullable
    public static JSParameterList findParameterList(@NotNull JSDocComment docComment) {
        JSFunction function2;
        if (docComment == null) {
            JSDocParamReference.$$$reportNull$$$0(8);
        }
        return (function2 = JSDocumentationUtils.findFunctionAppliedTo(docComment)) != null ? function2.getParameterList() : null;
    }

    public PsiElement resolve() {
        if (this.myQualifier != null) {
            JSDestructuringContainer target;
            PsiElement destructuringElement;
            PsiElement qualifierResolve = this.myQualifier.resolve();
            Object object = qualifierResolve instanceof JSDestructuringParameter ? qualifierResolve : (destructuringElement = qualifierResolve instanceof JSDestructuringProperty ? ((JSDestructuringProperty)qualifierResolve).getDestructuringElement() : null);
            if (destructuringElement instanceof JSDestructuringElement && (target = ((JSDestructuringElement)destructuringElement).getTarget()) instanceof JSDestructuringObject) {
                return ((JSDestructuringObject)target).findProperty(this.getCanonicalText());
            }
            return null;
        }
        JSDocComment docComment = this.getDocComment();
        JSFunction function2 = JSDocumentationUtils.findFunctionAppliedTo(docComment);
        if (function2 != null) {
            JSParameter[] parameters;
            String name = this.getCanonicalText();
            if ("arguments".equals(name)) {
                return this.getElement();
            }
            HashMap<Integer, String> tagNames = new HashMap<Integer, String>();
            JSDocumentationUtils.JSTagToParameterMap tagToParameters = JSDocumentationUtils.getTagToParameterMap(docComment, function2, tagNames);
            for (Map.Entry entry : tagNames.entrySet()) {
                JSParameterListElement element;
                if (!name.equals(entry.getValue()) || (element = (JSParameterListElement)tagToParameters.getMatchedTags().get(entry.getKey())) == null) continue;
                return element;
            }
            for (JSParameter parameter : parameters = function2.getParameterVariables()) {
                if (!name.equals(parameter.getName())) continue;
                return parameter;
            }
        }
        return null;
    }

    @NotNull
    private JSDocComment getDocComment() {
        JSDocComment docComment = (JSDocComment)PsiTreeUtil.getParentOfType((PsiElement)this.myJSDocTag, JSDocComment.class);
        assert (docComment != null);
        JSDocComment jSDocComment = docComment;
        if (jSDocComment == null) {
            JSDocParamReference.$$$reportNull$$$0(9);
        }
        return jSDocComment;
    }

    public boolean isSoft() {
        return this.findParameterList() == null;
    }

    @NotNull
    public String getUnresolvedMessagePattern() {
        String string = JavaScriptBundle.message("js.comment.matches.signature.inspection.problem2", this.getCanonicalText());
        if (string == null) {
            JSDocParamReference.$$$reportNull$$$0(10);
        }
        return string;
    }

    public static PsiReference @NotNull [] createReferences(@NotNull JSDocTagNamepath namepath, List<Pair<Integer, String>> references) {
        List ranges;
        if (namepath == null) {
            JSDocParamReference.$$$reportNull$$$0(11);
        }
        if ((ranges = ContainerUtil.flatMap(references, ref -> JSDocumentationUtils.getParameterNameRanges((Integer)ref.first, (String)ref.second))).isEmpty()) {
            if (EMPTY_ARRAY == null) {
                JSDocParamReference.$$$reportNull$$$0(12);
            }
            return EMPTY_ARRAY;
        }
        TextRange firstRange = (TextRange)ranges.get(0);
        JSDocParamReference firstRef = new JSDocParamReference(namepath, firstRange, null);
        if (ranges.size() > 1 && firstRef.resolve() instanceof JSDestructuringParameter) {
            JSDocParamReference qualifier = firstRef;
            PsiReference[] result2 = new PsiReference[ranges.size()];
            result2[0] = firstRef;
            for (int i = 1; i < ranges.size(); ++i) {
                TextRange textRange = (TextRange)ranges.get(i);
                qualifier = new JSDocParamReference(namepath, textRange, qualifier);
                result2[i] = qualifier;
            }
            if (result2 == null) {
                JSDocParamReference.$$$reportNull$$$0(13);
            }
            return result2;
        }
        PsiReference[] psiReferenceArray = new PsiReference[]{firstRef};
        if (psiReferenceArray == null) {
            JSDocParamReference.$$$reportNull$$$0(14);
        }
        return psiReferenceArray;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 2, 3, 4, 9, 10, 12, 13, 14 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "elt";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "rangeInElement";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 9: 
            case 10: 
            case 12: 
            case 13: 
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/javascript/psi/jsdoc/impl/JSDocParamReference";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "newElementName";
                break;
            }
            case 6: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "docComment";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "namepath";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/javascript/psi/jsdoc/impl/JSDocParamReference";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getElement";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getRangeInElement";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getCanonicalText";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "getDocComment";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "getUnresolvedMessagePattern";
                break;
            }
            case 12: 
            case 13: 
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "createReferences";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 9: 
            case 10: 
            case 12: 
            case 13: 
            case 14: {
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "handleElementRename";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "bindToElement";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "isReferenceTo";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "findParameterList";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "createReferences";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 2, 3, 4, 9, 10, 12, 13, 14 -> new IllegalStateException(string);
        };
    }
}

