/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.psi.impl;

import com.intellij.lang.javascript.JSTokenTypes;
import com.intellij.lang.javascript.index.JSSymbolUtil;
import com.intellij.lang.javascript.psi.JSDefinitionExpression;
import com.intellij.lang.javascript.psi.JSExpression;
import com.intellij.lang.javascript.psi.JSProperty;
import com.intellij.lang.javascript.psi.JSPsiElementBase;
import com.intellij.lang.javascript.psi.JSReferenceExpression;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptField;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptFunction;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptFunctionSignature;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptPropertySignature;
import com.intellij.lang.javascript.psi.ecmal4.JSClass;
import com.intellij.lang.javascript.psi.resolve.JSInheritanceUtil;
import com.intellij.lang.javascript.psi.resolve.JSPropertyNameResolver;
import com.intellij.lang.javascript.psi.resolve.JSReferenceUtil;
import com.intellij.lang.javascript.psi.resolve.JSResolveResult;
import com.intellij.lang.javascript.psi.resolve.JSResolveUtil;
import com.intellij.lang.javascript.psi.stubs.JSImplicitElement;
import com.intellij.lang.javascript.psi.stubs.TypeScriptProxyImplicitElement;
import com.intellij.lang.javascript.psi.util.JSUtils;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiPolyVariantReference;
import com.intellij.psi.PsiReference;
import com.intellij.psi.ResolveResult;
import com.intellij.psi.impl.source.resolve.reference.ReferenceProvidersRegistry;
import com.intellij.util.ArrayUtil;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class JSPropertyNameReference
implements PsiPolyVariantReference {
    @NotNull
    private final JSProperty myProperty;
    @NotNull
    private final String myPropertyName;

    public JSPropertyNameReference(@NotNull JSProperty property, @NotNull String propertyName) {
        if (property == null) {
            JSPropertyNameReference.$$$reportNull$$$0(0);
        }
        if (propertyName == null) {
            JSPropertyNameReference.$$$reportNull$$$0(1);
        }
        this.myProperty = property;
        this.myPropertyName = propertyName;
    }

    @NotNull
    public JSProperty getElement() {
        JSProperty jSProperty = this.myProperty;
        if (jSProperty == null) {
            JSPropertyNameReference.$$$reportNull$$$0(2);
        }
        return jSProperty;
    }

    @NotNull
    public TextRange getRangeInElement() {
        PsiElement nameIdentifier = this.myProperty.getNameIdentifier();
        if (nameIdentifier == null) {
            TextRange textRange = this.myProperty.getTextRange();
            if (textRange == null) {
                JSPropertyNameReference.$$$reportNull$$$0(3);
            }
            return textRange;
        }
        int quotesDelta = nameIdentifier.getNode().getElementType() == JSTokenTypes.STRING_LITERAL && nameIdentifier.getTextLength() >= 2 ? 1 : 0;
        int startOffsetInParent = nameIdentifier.getStartOffsetInParent();
        return new TextRange(startOffsetInParent + quotesDelta, startOffsetInParent + nameIdentifier.getTextLength() - quotesDelta);
    }

    @Nullable
    public PsiElement resolve() {
        ResolveResult[] resolveResults = this.multiResolve(false);
        return resolveResults.length != 1 || !resolveResults[0].isValidResult() ? null : resolveResults[0].getElement();
    }

    public ResolveResult @NotNull [] multiResolve(boolean incompleteCode) {
        if (!this.myProperty.isValid()) {
            if (ResolveResult.EMPTY_ARRAY == null) {
                JSPropertyNameReference.$$$reportNull$$$0(4);
            }
            return ResolveResult.EMPTY_ARRAY;
        }
        PsiReference[] nameRefs = this.myProperty.getNameIdentifier() != null ? ReferenceProvidersRegistry.getReferencesFromProviders((PsiElement)this.myProperty.getNameIdentifier()) : EMPTY_ARRAY;
        ResolveResult[] results = JSResolveUtil.resolve(this.myProperty.getContainingFile(), this, new JSPropertyNameResolver(), incompleteCode);
        ResolveResult[] resolveResultArray = this.merge(results, nameRefs, incompleteCode);
        if (resolveResultArray == null) {
            JSPropertyNameReference.$$$reportNull$$$0(5);
        }
        return resolveResultArray;
    }

    private ResolveResult[] merge(ResolveResult[] resolves, PsiReference[] refs, boolean incompleteCode) {
        if (refs.length == 0) {
            return resolves;
        }
        ArrayList<ResolveResult> list2 = new ArrayList<ResolveResult>();
        for (ResolveResult resolveResult : resolves) {
            if (resolveResult.getElement() == this.myProperty) continue;
            list2.add(resolveResult);
        }
        for (ResolveResult resolveResult : refs) {
            if (resolveResult instanceof PsiPolyVariantReference) {
                ResolveResult[] results = ((PsiPolyVariantReference)resolveResult).multiResolve(incompleteCode);
                list2.addAll(Arrays.asList(results));
                continue;
            }
            PsiElement resolve = resolveResult.resolve();
            if (resolve == null || !resolve.isValid()) continue;
            list2.add(new JSResolveResult(resolve));
        }
        return list2.toArray(ResolveResult.EMPTY_ARRAY);
    }

    @NotNull
    public String getCanonicalText() {
        String string = this.myPropertyName;
        if (string == null) {
            JSPropertyNameReference.$$$reportNull$$$0(6);
        }
        return string;
    }

    public PsiElement handleElementRename(@NotNull String newElementName) throws IncorrectOperationException {
        if (newElementName == null) {
            JSPropertyNameReference.$$$reportNull$$$0(7);
        }
        this.myProperty.setName(newElementName);
        return null;
    }

    public PsiElement bindToElement(@NotNull PsiElement element) throws IncorrectOperationException {
        if (element == null) {
            JSPropertyNameReference.$$$reportNull$$$0(8);
        }
        return null;
    }

    @NotNull
    private List<PsiElement> resolveAndUnwrapMergedTypeMembers() {
        ResolveResult[] elements;
        PsiElement resolvedElement = this.resolve();
        if (resolvedElement instanceof TypeScriptProxyImplicitElement) {
            List list2 = ContainerUtil.createMaybeSingletonList((Object)((TypeScriptProxyImplicitElement)resolvedElement).getExplicitElement());
            if (list2 == null) {
                JSPropertyNameReference.$$$reportNull$$$0(9);
            }
            return list2;
        }
        if (resolvedElement != null) {
            List list3 = ContainerUtil.createMaybeSingletonList((Object)resolvedElement);
            if (list3 == null) {
                JSPropertyNameReference.$$$reportNull$$$0(10);
            }
            return list3;
        }
        ArrayList<PsiElement> allElements = new ArrayList<PsiElement>();
        for (ResolveResult result2 : elements = this.multiResolve(false)) {
            PsiElement explicitElement;
            PsiElement resultElement = result2.getElement();
            if (!(resultElement instanceof TypeScriptProxyImplicitElement) || allElements.contains(explicitElement = ((TypeScriptProxyImplicitElement)resultElement).getExplicitElement())) continue;
            allElements.add(explicitElement);
        }
        ArrayList<PsiElement> arrayList = allElements;
        if (arrayList == null) {
            JSPropertyNameReference.$$$reportNull$$$0(11);
        }
        return arrayList;
    }

    public boolean isReferenceTo(@NotNull PsiElement element) {
        JSExpression expression;
        if (element == null) {
            JSPropertyNameReference.$$$reportNull$$$0(12);
        }
        if (element instanceof TypeScriptProxyImplicitElement) {
            PsiElement explicitElement = ((TypeScriptProxyImplicitElement)element).getExplicitElement();
            return explicitElement != null && this.isReferenceTo(explicitElement);
        }
        if (element instanceof TypeScriptField || element instanceof TypeScriptFunction) {
            JSClass refElementClass = JSUtils.getMemberContainingClass(element);
            if (refElementClass != null) {
                List<PsiElement> resolvedElements = this.resolveAndUnwrapMergedTypeMembers();
                for (PsiElement el : resolvedElements) {
                    if (el == element) {
                        return true;
                    }
                    JSClass resolvedElementClass = JSUtils.getMemberContainingClass(el);
                    if (resolvedElementClass == null || !(el instanceof JSPsiElementBase) || !JSInheritanceUtil.checkMemberHierarchyIncludeClass((JSPsiElementBase)el, refElementClass)) continue;
                    return true;
                }
                return false;
            }
            if (element instanceof TypeScriptPropertySignature || element instanceof TypeScriptFunctionSignature) {
                return this.resolveAndUnwrapMergedTypeMembers().stream().anyMatch(e -> e == element);
            }
        }
        if (element instanceof JSDefinitionExpression && (expression = ((JSDefinitionExpression)element).getExpression()) instanceof JSReferenceExpression) {
            return this.resolveAndUnwrapMergedTypeMembers().stream().anyMatch(e -> ((JSReferenceExpression)expression).isReferenceTo((PsiElement)e));
        }
        if (element instanceof JSProperty) {
            JSProperty elementAsProperty = (JSProperty)element;
            List<PsiElement> elements2 = this.resolveAndUnwrapMergedTypeMembers();
            for (PsiElement element2 : elements2) {
                if (element == element2 || !(element2 instanceof JSPsiElementBase)) continue;
                JSPsiElementBase element2AsNamed = (JSPsiElementBase)element2;
                if (!StringUtil.equals((CharSequence)elementAsProperty.getName(), (CharSequence)element2AsNamed.getName()) || !JSSymbolUtil.canElementsBeFromSameNamespace(elementAsProperty, element2AsNamed)) continue;
                return true;
            }
        }
        if (element instanceof JSImplicitElement) {
            return JSReferenceUtil.isReferenceTo((PsiPolyVariantReference)this, this.getCanonicalText(), element);
        }
        return false;
    }

    public Object @NotNull [] getVariants() {
        PsiElement identifier = this.myProperty.getNameIdentifier();
        if (identifier == null) {
            if (EMPTY_ARRAY == null) {
                JSPropertyNameReference.$$$reportNull$$$0(13);
            }
            return EMPTY_ARRAY;
        }
        PsiReference[] references = ReferenceProvidersRegistry.getReferencesFromProviders((PsiElement)identifier);
        ArrayList<Object> list2 = new ArrayList<Object>();
        for (PsiReference reference : references) {
            Object[] variants = reference.getVariants();
            if (variants.length <= 0) continue;
            list2.addAll(Arrays.asList(variants));
        }
        Object[] objectArray = ArrayUtil.toObjectArray(list2);
        if (objectArray == null) {
            JSPropertyNameReference.$$$reportNull$$$0(14);
        }
        return objectArray;
    }

    public boolean isSoft() {
        return false;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 2, 3, 4, 5, 6, 9, 10, 11, 13, 14 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "property";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "propertyName";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 9: 
            case 10: 
            case 11: 
            case 13: 
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/javascript/psi/impl/JSPropertyNameReference";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "newElementName";
                break;
            }
            case 8: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/javascript/psi/impl/JSPropertyNameReference";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getElement";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getRangeInElement";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "multiResolve";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getCanonicalText";
                break;
            }
            case 9: 
            case 10: 
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "resolveAndUnwrapMergedTypeMembers";
                break;
            }
            case 13: 
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "getVariants";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 9: 
            case 10: 
            case 11: 
            case 13: 
            case 14: {
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "handleElementRename";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "bindToElement";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "isReferenceTo";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 2, 3, 4, 5, 6, 9, 10, 11, 13, 14 -> new IllegalStateException(string);
        };
    }
}

