/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.psi.impl;

import com.intellij.lang.javascript.DialectDetector;
import com.intellij.lang.javascript.dialects.JSDialectSpecificHandlersFactory;
import com.intellij.lang.javascript.ecmascript6.TypeScriptLiteralKeyUtil;
import com.intellij.lang.javascript.evaluation.JSCodeBasedTypeFactory;
import com.intellij.lang.javascript.psi.JSExpression;
import com.intellij.lang.javascript.psi.JSIndexedPropertyAccessExpression;
import com.intellij.lang.javascript.psi.JSLiteralExpression;
import com.intellij.lang.javascript.psi.JSLiteralExpressionKind;
import com.intellij.lang.javascript.psi.JSType;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptIndexedAccessType;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptStringLiteralType;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptType;
import com.intellij.lang.javascript.psi.impl.JSReferenceSet;
import com.intellij.lang.javascript.psi.impl.JSTextReference;
import com.intellij.lang.javascript.psi.resolve.JSEvaluateContext;
import com.intellij.lang.javascript.psi.resolve.JSReferenceUtil;
import com.intellij.lang.javascript.psi.resolve.JSResolveResult;
import com.intellij.lang.javascript.psi.resolve.JSResolveUtil;
import com.intellij.lang.javascript.psi.resolve.JSTypeEvaluator;
import com.intellij.lang.javascript.psi.resolve.QualifiedItemProcessor;
import com.intellij.lang.javascript.psi.resolve.ResolveResultSink;
import com.intellij.lang.javascript.psi.types.JSLiteralKeyType;
import com.intellij.lang.javascript.psi.types.JSStringLiteralTypeImpl;
import com.intellij.lang.javascript.psi.types.JSTypeSourceFactory;
import com.intellij.lang.javascript.psi.types.evaluable.JSQualifiedReferenceType;
import com.intellij.lang.javascript.statistics.JSResolveStatisticsCollector;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiPolyVariantReference;
import com.intellij.psi.ResolveResult;
import com.intellij.util.IncorrectOperationException;
import java.util.Collection;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class JSLiteralTextReference
extends JSTextReference {
    public JSLiteralTextReference(@NotNull JSReferenceSet set, @NotNull String s, int offset) {
        if (set == null) {
            JSLiteralTextReference.$$$reportNull$$$0(0);
        }
        if (s == null) {
            JSLiteralTextReference.$$$reportNull$$$0(1);
        }
        super(set, s, offset);
    }

    @Override
    protected ResolveResult @NotNull [] doResolve() {
        ResolveResult[] keyResults = JSLiteralTextReference.getLiteralKeyResults(this.mySet.getElement());
        if (keyResults != null) {
            if (keyResults == null) {
                JSLiteralTextReference.$$$reportNull$$$0(2);
            }
            return keyResults;
        }
        ResolveResult[] resolveResultArray = super.doResolve();
        if (resolveResultArray == null) {
            JSLiteralTextReference.$$$reportNull$$$0(3);
        }
        return resolveResultArray;
    }

    public boolean isTextOnlyReference() {
        if (!this.isSoft()) {
            return false;
        }
        PsiElement element = this.getElement();
        return element instanceof JSLiteralExpression && !(element.getParent() instanceof JSIndexedPropertyAccessExpression) && !this.isLiteralKeyReference();
    }

    public boolean isLiteralKeyReference() {
        PsiElement referenceElement = this.mySet.getElement();
        if (referenceElement instanceof JSLiteralExpression && ((JSLiteralExpression)referenceElement).isQuotedLiteral() && ((JSLiteralExpression)referenceElement).getExpressionKind(false) != JSLiteralExpressionKind.TEMPLATE_WITH_ARGS) {
            return JSLiteralTextReference.getLiteralKeyResults(referenceElement) != null;
        }
        return false;
    }

    private static ResolveResult @Nullable [] getLiteralKeyResults(@NotNull PsiElement referenceElement) {
        ResolveResult[] keyRefType;
        if (referenceElement == null) {
            JSLiteralTextReference.$$$reportNull$$$0(4);
        }
        if ((keyRefType = JSLiteralTextReference.getResolveResultsFromTypeScriptKeyTypes(referenceElement)) != null) {
            return keyRefType;
        }
        return JSLiteralTextReference.getResolveResultsFromIndexerProperty(referenceElement);
    }

    private static ResolveResult @Nullable [] getResolveResultsFromIndexerProperty(PsiElement referenceElement) {
        JSType qualifierType;
        PsiElement psiElement;
        Object place;
        if (!(referenceElement instanceof JSLiteralExpression)) {
            return null;
        }
        String propertyName = ((JSLiteralExpression)referenceElement).getValueAsPropertyName();
        if (propertyName == null) {
            return null;
        }
        PsiElement parent = referenceElement.getParent();
        if (parent instanceof JSIndexedPropertyAccessExpression) {
            place = parent;
        } else if (parent instanceof TypeScriptStringLiteralType && (psiElement = parent.getParent()) instanceof TypeScriptIndexedAccessType) {
            TypeScriptIndexedAccessType indexedAccessType = (TypeScriptIndexedAccessType)psiElement;
            place = indexedAccessType;
        } else {
            return null;
        }
        ResolveResultSink sink = new ResolveResultSink((PsiElement)place, propertyName);
        QualifiedItemProcessor<ResolveResultSink> processor = JSDialectSpecificHandlersFactory.forElement(place).createQualifiedItemProcessor(sink, (PsiElement)place);
        processor.setTypeContext(true);
        JSEvaluateContext evaluateContext = new JSEvaluateContext(place.getContainingFile());
        if (place instanceof JSIndexedPropertyAccessExpression) {
            JSIndexedPropertyAccessExpression indexer = (JSIndexedPropertyAccessExpression)place;
            JSExpression qualifier = indexer.getQualifier();
            if (qualifier == null) {
                return null;
            }
            JSTypeEvaluator.evaluateTypes(qualifier, indexer.getContainingFile(), processor);
            qualifierType = JSCodeBasedTypeFactory.getPsiBasedType((PsiElement)qualifier, evaluateContext);
        } else {
            TypeScriptType ownerTypeElement = ((TypeScriptIndexedAccessType)place).getOwnerTypeElement();
            JSType jSType = qualifierType = ownerTypeElement != null ? ownerTypeElement.getJSType() : null;
            if (qualifierType != null) {
                processor.process(qualifierType, evaluateContext);
            }
        }
        ResolveResultSink resultSink = (ResolveResultSink)processor.getResultSink();
        if (processor.resolved.isSuitableForReferenceResolve() || resultSink.getCompleteResult() != null) {
            ResolveResult[] results = processor.getResultsAsResolveResults();
            JSResolveStatisticsCollector.getInstance().consume((Object)JSResolveStatisticsCollector.ResolveSource.QUALIFIED, (Object)results.length);
            return results;
        }
        if (qualifierType == null) {
            return null;
        }
        Collection<PsiElement> declarations = new JSQualifiedReferenceType(propertyName, qualifierType, JSTypeSourceFactory.createTypeSource(place, true)).getDeclarations();
        if (!declarations.isEmpty()) {
            return JSResolveResult.toResolveResults(declarations);
        }
        return null;
    }

    private static ResolveResult @Nullable [] getResolveResultsFromTypeScriptKeyTypes(PsiElement referenceElement) {
        JSType key2;
        if (!(referenceElement instanceof JSLiteralExpression) || !DialectDetector.isTypeScript(referenceElement)) {
            return null;
        }
        JSType expressionType = JSResolveUtil.getExpressionJSType((JSExpression)referenceElement);
        if (expressionType instanceof JSStringLiteralTypeImpl && (key2 = JSLiteralTextReference.getLiteralKeyType((JSLiteralExpression)referenceElement, expressionType)) instanceof JSLiteralKeyType) {
            return ((JSLiteralKeyType)key2).resolveKey();
        }
        return null;
    }

    @Override
    public boolean isReferenceTo(@NotNull PsiElement element) {
        if (element == null) {
            JSLiteralTextReference.$$$reportNull$$$0(5);
        }
        if (element instanceof PsiFile) {
            return false;
        }
        if (this.isLiteralKeyReference()) {
            return JSReferenceUtil.isReferenceTo((PsiPolyVariantReference)this, ((JSLiteralExpression)this.mySet.getElement()).getStringValue(), element);
        }
        return super.isReferenceTo(element);
    }

    @Override
    public PsiElement handleElementRename(@NotNull String newElementName) throws IncorrectOperationException {
        if (newElementName == null) {
            JSLiteralTextReference.$$$reportNull$$$0(6);
        }
        if (this.isLiteralKeyReference()) {
            PsiElement element = this.getElement();
            return JSLiteralTextReference.handleContentChange(element, JSReferenceUtil.getRangeWithoutQuotes(element), newElementName);
        }
        return super.handleElementRename(newElementName);
    }

    @Nullable
    private static JSType getLiteralKeyType(@NotNull JSLiteralExpression rawqualifier, @Nullable JSType type2) {
        if (rawqualifier == null) {
            JSLiteralTextReference.$$$reportNull$$$0(7);
        }
        if (!(type2 instanceof JSStringLiteralTypeImpl)) {
            return null;
        }
        PsiElement parent = rawqualifier.getParent();
        JSType keyType = TypeScriptLiteralKeyUtil.modifyStringLiteralTypeForTaggedLiteralType(rawqualifier, (JSStringLiteralTypeImpl)type2, parent);
        if (keyType != null) {
            return keyType;
        }
        return TypeScriptLiteralKeyUtil.modifyStringLiteralTypeByContextualType(rawqualifier, (JSStringLiteralTypeImpl)type2);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 2, 3 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "set";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "s";
                break;
            }
            case 2: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/javascript/psi/impl/JSLiteralTextReference";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "referenceElement";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "newElementName";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "rawqualifier";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/javascript/psi/impl/JSLiteralTextReference";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "doResolve";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: 
            case 3: {
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "getLiteralKeyResults";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "isReferenceTo";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "handleElementRename";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "getLiteralKeyType";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 2, 3 -> new IllegalStateException(string);
        };
    }
}

