/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.psi.impl;

import com.intellij.extapi.psi.PsiFileBase;
import com.intellij.lang.Language;
import com.intellij.lang.javascript.JSMinifiedFileUtil;
import com.intellij.lang.javascript.JavaScriptBundle;
import com.intellij.lang.javascript.dialects.JSDialectSpecificHandlersFactory;
import com.intellij.lang.javascript.ecmascript6.TypeScriptUtil;
import com.intellij.lang.javascript.index.FrameworkIndexingHandler;
import com.intellij.lang.javascript.index.JSFileCachedDataEvaluator;
import com.intellij.lang.javascript.library.JSCorePredefinedLibrariesProvider;
import com.intellij.lang.javascript.library.JSLibraryUtil;
import com.intellij.lang.javascript.psi.JSFile;
import com.intellij.lang.javascript.psi.JSModuleStatusOwner;
import com.intellij.lang.javascript.psi.JSRecursiveWalkingElementVisitor;
import com.intellij.lang.javascript.psi.JSTestFileType;
import com.intellij.lang.javascript.psi.controlflow.JSControlFlowService;
import com.intellij.lang.javascript.psi.impl.JsTestFileInfo;
import com.intellij.lang.javascript.psi.stubs.impl.JSFileCachedData;
import com.intellij.lang.javascript.psi.stubs.impl.JSFileStubImpl;
import com.intellij.lang.typescript.library.download.TypeScriptDefinitionFilesDirectory;
import com.intellij.navigation.ItemPresentation;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.FileViewProvider;
import com.intellij.psi.PsiElement;
import com.intellij.psi.stubs.StubElement;
import com.intellij.psi.tree.IStubFileElementType;
import com.intellij.util.ObjectUtils;
import java.util.Map;
import java.util.Set;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class JSFileBaseImpl
extends PsiFileBase
implements JSFile {
    @Nullable
    private JSFileCachedData myCachedData;
    @Nullable
    private Set<String> myReferencedPaths;
    @NotNull
    private final JsTestFileInfo myTestFileInfo;

    protected JSFileBaseImpl(@NotNull FileViewProvider viewProvider, @NotNull Language language) {
        if (viewProvider == null) {
            JSFileBaseImpl.$$$reportNull$$$0(0);
        }
        if (language == null) {
            JSFileBaseImpl.$$$reportNull$$$0(1);
        }
        super(viewProvider, language);
        this.myTestFileInfo = new JsTestFileInfo(this);
    }

    @NotNull
    public JSFileCachedData getCachedData() {
        JSFileCachedData cachedData = this.myCachedData;
        if (cachedData == null) {
            JSFileStubImpl stub = this.getGreenJSFileStub();
            if (stub != null) {
                cachedData = stub.getCachedData();
            }
            if (cachedData == null) {
                cachedData = this.createCachedDataFromPsi();
            }
            this.myCachedData = cachedData;
        }
        JSFileCachedData jSFileCachedData = cachedData;
        if (jSFileCachedData == null) {
            JSFileBaseImpl.$$$reportNull$$$0(2);
        }
        return jSFileCachedData;
    }

    @Nullable
    private JSFileStubImpl getGreenJSFileStub() {
        StubElement stub = this.getGreenStub();
        if (stub != null && !(stub instanceof JSFileStubImpl)) {
            IStubFileElementType elementType = this.getElementTypeForStubBuilder();
            String elementTypeName = elementType != null ? elementType.getExternalId() : null;
            Logger.getInstance(JSFileBaseImpl.class).error("stub: " + stub.getClass().getName() + "; file: " + elementTypeName);
            return null;
        }
        return (JSFileStubImpl)stub;
    }

    @Nullable
    public JSFileCachedData tryGetCachedData() {
        return this.myCachedData;
    }

    @NotNull
    private JSFileCachedData createCachedDataFromPsi() {
        JSFileCachedData cachedData = new JSFileCachedData();
        for (FrameworkIndexingHandler handler : FrameworkIndexingHandler.getExtensions(this)) {
            handler.processFile((JSFile)this, cachedData);
        }
        final JSFileCachedDataEvaluator evaluator = JSDialectSpecificHandlersFactory.forLanguage(this.getLanguage()).newFileCachedDataEvaluator(cachedData);
        JSRecursiveWalkingElementVisitor recursiveVisitor = new JSRecursiveWalkingElementVisitor(){

            @Override
            public void visitElement(@NotNull PsiElement element) {
                if (element == null) {
                    1.$$$reportNull$$$0(0);
                }
                evaluator.startElement(element);
                if (!evaluator.isSkipChildren()) {
                    super.visitElement(element);
                }
            }

            @Override
            protected void elementFinished(@NotNull PsiElement element) {
                if (element == null) {
                    1.$$$reportNull$$$0(1);
                }
                evaluator.finishElement();
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[3];
                objectArray2[0] = "element";
                objectArray2[1] = "com/intellij/lang/javascript/psi/impl/JSFileBaseImpl$1";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[2] = "visitElement";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[2] = "elementFinished";
                        break;
                    }
                }
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        };
        this.accept(recursiveVisitor);
        JSFileCachedData jSFileCachedData = cachedData;
        if (jSFileCachedData == null) {
            JSFileBaseImpl.$$$reportNull$$$0(3);
        }
        return jSFileCachedData;
    }

    @Override
    public boolean isMinified() {
        return JSMinifiedFileUtil.isFileContentMinified(this.getViewProvider().getVirtualFile());
    }

    @Override
    @NotNull
    public JSModuleStatusOwner.ModuleStatus getModuleStatus() {
        JSModuleStatusOwner.ModuleStatus moduleStatus = this.getCachedData().getModuleStatus();
        if (moduleStatus == null) {
            JSFileBaseImpl.$$$reportNull$$$0(4);
        }
        return moduleStatus;
    }

    @Override
    public boolean isTestFile() {
        return this.myTestFileInfo.isNamedAsTest() || this.getTestFileType() != null;
    }

    @Override
    @Nullable
    public JSTestFileType getTestFileType() {
        return this.getCachedData().getTestFileType();
    }

    @Override
    public boolean hasES6Syntax() {
        return this.getCachedData().hasES6Syntax();
    }

    @Override
    public boolean hasJSXSyntax() {
        return this.getCachedData().hasJSXSyntax();
    }

    @Override
    @NotNull
    public Map<String, String> getPragmaFlags() {
        Map<String, String> map = this.getCachedData().getPragmaFlags();
        if (map == null) {
            JSFileBaseImpl.$$$reportNull$$$0(5);
        }
        return map;
    }

    public ItemPresentation getPresentation() {
        final ItemPresentation superPresentation = super.getPresentation();
        if (superPresentation == null) {
            return null;
        }
        return new ItemPresentation(){

            @Nullable
            public String getPresentableText() {
                return superPresentation.getPresentableText();
            }

            @Nullable
            public String getLocationString() {
                String libLocation = JSFileBaseImpl.this.getTypesLibraryLocation();
                if (libLocation != null) {
                    return libLocation;
                }
                String fromRoot = JSFileBaseImpl.this.getLocationFromContentRoot();
                if (fromRoot != null) {
                    return fromRoot;
                }
                return superPresentation.getLocationString();
            }

            @Nullable
            public Icon getIcon(boolean unused) {
                return superPresentation.getIcon(false);
            }
        };
    }

    @Nullable
    private String getLocationFromContentRoot() {
        VirtualFile virtualFile = this.getViewProvider().getVirtualFile();
        VirtualFile root = JSLibraryUtil.getContentRootForFile(this.getProject(), virtualFile);
        VirtualFile parent = virtualFile.getParent();
        if (root == null || parent == null) {
            return null;
        }
        String path2 = VfsUtilCore.getRelativePath((VirtualFile)parent, (VirtualFile)root);
        if (StringUtil.isEmpty((String)path2)) {
            return null;
        }
        return path2;
    }

    @Nullable
    private String getTypesLibraryLocation() {
        VirtualFile file = this.getViewProvider().getVirtualFile();
        if (!TypeScriptUtil.isDefinitionFile(file)) {
            return null;
        }
        VirtualFile directory = TypeScriptDefinitionFilesDirectory.getGlobalTypesDirectory();
        String path2 = JSFileBaseImpl.getLocationIfParent(file, directory);
        if (path2 != null) {
            return path2;
        }
        directory = TypeScriptDefinitionFilesDirectory.getGlobalAutoDownloadTypesDirectory();
        path2 = JSFileBaseImpl.getLocationIfParent(file, directory);
        if (path2 != null) {
            return path2;
        }
        if (file.equals(JSCorePredefinedLibrariesProvider.getReactLibraryFile())) {
            return JavaScriptBundle.message("javascript.library.built.in", new Object[0]);
        }
        return null;
    }

    @Nullable
    private static String getLocationIfParent(@NotNull VirtualFile file, @Nullable VirtualFile parent) {
        if (file == null) {
            JSFileBaseImpl.$$$reportNull$$$0(6);
        }
        if (parent != null && VfsUtilCore.isAncestor((VirtualFile)parent, (VirtualFile)file, (boolean)true)) {
            VirtualFile parentForPath = (VirtualFile)ObjectUtils.coalesce((Object)JSLibraryUtil.findUpClosestNodeModulesResolveRoot(file), (Object)parent);
            return VfsUtilCore.getRelativePath((VirtualFile)file.getParent(), (VirtualFile)parentForPath);
        }
        return null;
    }

    @Override
    @NotNull
    public Set<String> getReferencedPaths() {
        Set<String> referencedPaths = this.myReferencedPaths;
        if (referencedPaths != null) {
            Set<String> set = referencedPaths;
            if (set == null) {
                JSFileBaseImpl.$$$reportNull$$$0(7);
            }
            return set;
        }
        JSFileStubImpl stub = this.getGreenJSFileStub();
        if (stub != null) {
            referencedPaths = stub.getReferencedPaths();
        }
        if (referencedPaths == null) {
            referencedPaths = JSFileCachedDataEvaluator.calculateReferencedPaths(this);
        }
        this.myReferencedPaths = referencedPaths;
        Set<String> set = referencedPaths;
        if (set == null) {
            JSFileBaseImpl.$$$reportNull$$$0(8);
        }
        return set;
    }

    public void clearCaches() {
        super.clearCaches();
        this.myCachedData = null;
        this.myReferencedPaths = null;
        this.myTestFileInfo.clearCaches();
        JSControlFlowService.getService(this.getProject()).resetControlFlow(this);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 2, 3, 4, 5, 7, 8 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "viewProvider";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "language";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 7: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/javascript/psi/impl/JSFileBaseImpl";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/javascript/psi/impl/JSFileBaseImpl";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getCachedData";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "createCachedDataFromPsi";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getModuleStatus";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getPragmaFlags";
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getReferencedPaths";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 7: 
            case 8: {
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "getLocationIfParent";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 2, 3, 4, 5, 7, 8 -> new IllegalStateException(string);
        };
    }
}

