/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.psi.ecmal4.impl;

import com.intellij.lang.ASTNode;
import com.intellij.lang.ecmascript6.psi.JSClassExpression;
import com.intellij.lang.javascript.DialectDetector;
import com.intellij.lang.javascript.JSElementTypes;
import com.intellij.lang.javascript.JSStubElementTypes;
import com.intellij.lang.javascript.JSTokenTypes;
import com.intellij.lang.javascript.documentation.JSDocumentationUtils;
import com.intellij.lang.javascript.psi.JSElement;
import com.intellij.lang.javascript.psi.JSElementBase;
import com.intellij.lang.javascript.psi.JSElementVisitor;
import com.intellij.lang.javascript.psi.JSEmbeddedContent;
import com.intellij.lang.javascript.psi.JSExpression;
import com.intellij.lang.javascript.psi.JSField;
import com.intellij.lang.javascript.psi.JSFunction;
import com.intellij.lang.javascript.psi.JSNamespace;
import com.intellij.lang.javascript.psi.JSQualifiedName;
import com.intellij.lang.javascript.psi.JSRecordType;
import com.intellij.lang.javascript.psi.JSType;
import com.intellij.lang.javascript.psi.JSVarStatement;
import com.intellij.lang.javascript.psi.JSVariable;
import com.intellij.lang.javascript.psi.ecmal4.JSAttributeList;
import com.intellij.lang.javascript.psi.ecmal4.JSClass;
import com.intellij.lang.javascript.psi.ecmal4.JSQualifiedNamedElement;
import com.intellij.lang.javascript.psi.ecmal4.JSReferenceList;
import com.intellij.lang.javascript.psi.ecmal4.impl.ActionScriptClassBase;
import com.intellij.lang.javascript.psi.ecmal4.impl.JSIconProvider;
import com.intellij.lang.javascript.psi.impl.JSCachingNamespaceOwner;
import com.intellij.lang.javascript.psi.impl.JSChangeUtil;
import com.intellij.lang.javascript.psi.impl.JSPsiImplUtils;
import com.intellij.lang.javascript.psi.impl.JSQualifiedNamedElementBaseImpl;
import com.intellij.lang.javascript.psi.impl.JSStubElementImpl;
import com.intellij.lang.javascript.psi.resolve.JSClassResolver;
import com.intellij.lang.javascript.psi.resolve.JSInheritanceUtil;
import com.intellij.lang.javascript.psi.resolve.JSResolveUtil;
import com.intellij.lang.javascript.psi.resolve.ResolveProcessor;
import com.intellij.lang.javascript.psi.stubs.JSQualifiedStub;
import com.intellij.lang.javascript.psi.types.JSContext;
import com.intellij.lang.javascript.psi.types.JSNamedTypeFactory;
import com.intellij.lang.javascript.psi.types.JSTypeContext;
import com.intellij.lang.javascript.psi.types.JSTypeSource;
import com.intellij.lang.javascript.psi.types.JSTypeSourceFactory;
import com.intellij.lang.javascript.psi.types.TypeScriptTypeParser;
import com.intellij.lang.javascript.psi.util.JSUtils;
import com.intellij.lang.javascript.refactoring.JSVisibilityUtil;
import com.intellij.lang.typescript.resolve.TypeScriptClassResolver;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiFile;
import com.intellij.psi.ResolveState;
import com.intellij.psi.impl.ElementBase;
import com.intellij.psi.impl.source.tree.TreeUtil;
import com.intellij.psi.scope.PsiScopeProcessor;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.stubs.IStubElementType;
import com.intellij.psi.stubs.StubElement;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.tree.TokenSet;
import com.intellij.psi.util.CachedValue;
import com.intellij.psi.util.CachedValueProvider;
import com.intellij.psi.util.CachedValuesManager;
import com.intellij.psi.util.PsiModificationTracker;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.ArrayFactory;
import com.intellij.util.ArrayUtil;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.Icon;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class JSClassBase<StubT extends JSQualifiedStub<?>>
extends JSQualifiedNamedElementBaseImpl<StubT>
implements JSClass,
JSCachingNamespaceOwner {
    @Nullable
    private volatile Map<String, Object> myName2FunctionMap;
    @Nullable
    private volatile Map<String, JSField> myName2FieldsMap;
    public static final String ES6_CONSTRUCTOR = "constructor";
    @NotNull
    private static final TokenSet CLASS_KEYWORDS = TokenSet.create((IElementType[])new IElementType[]{JSTokenTypes.CLASS_KEYWORD, JSTokenTypes.INTERFACE_KEYWORD, JSTokenTypes.ENUM_KEYWORD, JSTokenTypes.TYPE_KEYWORD});

    protected JSClassBase(ASTNode node) {
        super(node);
    }

    public JSClassBase(StubT stub, IStubElementType<StubT, ?> aClass) {
        super(stub, aClass);
    }

    @Override
    public void accept(@NotNull PsiElementVisitor visitor) {
        if (visitor == null) {
            JSClassBase.$$$reportNull$$$0(0);
        }
        if (visitor instanceof JSElementVisitor) {
            ((JSElementVisitor)visitor).visitJSClass(this);
        } else {
            visitor.visitElement((PsiElement)this);
        }
    }

    protected Object clone() {
        JSClassBase o = (JSClassBase)super.clone();
        o.clearCaches();
        return o;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void clearCaches() {
        super.clearCaches();
        JSClassBase jSClassBase = this;
        synchronized (jSClassBase) {
            this.clearCachesSync();
        }
    }

    protected void clearCachesSync() {
        this.myName2FunctionMap = null;
        this.myName2FieldsMap = null;
    }

    @Override
    public JSFunction @NotNull [] getFunctions() {
        JSQualifiedStub classStub = (JSQualifiedStub)this.getGreenStub();
        if (classStub != null) {
            JSFunction[] jSFunctionArray = (JSFunction[])this.getStubChildrenByType(classStub, JSFunction.ARRAY_FACTORY, JSElementTypes.FUNCTION_DECLARATIONS);
            if (jSFunctionArray == null) {
                JSClassBase.$$$reportNull$$$0(1);
            }
            return jSFunctionArray;
        }
        ArrayList functions = new ArrayList();
        this.gatherDeclarations(functions, JSFunction.class);
        JSFunction[] jSFunctionArray = functions.toArray(JSFunction.EMPTY_ARRAY);
        if (jSFunctionArray == null) {
            JSClassBase.$$$reportNull$$$0(2);
        }
        return jSFunctionArray;
    }

    @Override
    @Nullable
    public JSFunction findFunctionByName(@Nullable String functionName) {
        if (functionName == null) {
            return null;
        }
        Map<String, Object> name2FunctionMap = this.getFunctionsMap();
        Object o = name2FunctionMap.get(functionName);
        if (o instanceof JSFunction) {
            return (JSFunction)o;
        }
        if (o instanceof JSFunction[]) {
            return ((JSFunction[])o)[0];
        }
        return null;
    }

    @Override
    public JSField @NotNull [] getFields() {
        JSQualifiedStub classStub = (JSQualifiedStub)this.getGreenStub();
        ArrayList fields = new ArrayList(3);
        if (classStub != null) {
            for (JSVarStatement var : (JSVarStatement[])this.getStubChildrenByType(classStub, JSVarStatement[]::new, JSElementTypes.VAR_STATEMENTS)) {
                JSVariable[] variables = var.getStubSafeVariables();
                Arrays.stream(variables).forEach(el -> {
                    if (el instanceof JSField) {
                        fields.add((JSField)((Object)el));
                    }
                });
            }
        } else {
            this.gatherDeclarations(fields, JSField.class);
        }
        JSField[] jSFieldArray = fields.toArray(JSField.EMPTY_ARRAY);
        if (jSFieldArray == null) {
            JSClassBase.$$$reportNull$$$0(3);
        }
        return jSFieldArray;
    }

    @Override
    @NotNull
    public Iterable<? extends JSElement> getMembers() {
        Iterable iterable = ContainerUtil.concat((Object[][])new JSQualifiedNamedElement[][]{this.getFields(), this.getFunctions()});
        if (iterable == null) {
            JSClassBase.$$$reportNull$$$0(4);
        }
        return iterable;
    }

    private <E extends PsiElement> void gatherDeclarations(final List<E> elements, final Class<E> clazz) {
        this.processDeclarations(new ResolveProcessor(null){
            {
                super(name);
                this.setToProcessHierarchy(false);
                this.setToProcessActionScriptImplicits(false);
                this.setLocalResolve(true);
            }

            public boolean execute(@NotNull PsiElement element, @NotNull ResolveState state) {
                if (element == null) {
                    1.$$$reportNull$$$0(0);
                }
                if (state == null) {
                    1.$$$reportNull$$$0(1);
                }
                if (clazz.isInstance(element)) {
                    elements.add((PsiElement)clazz.cast(element));
                }
                return true;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[3];
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[0] = "element";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[0] = "state";
                        break;
                    }
                }
                objectArray[1] = "com/intellij/lang/javascript/psi/ecmal4/impl/JSClassBase$1";
                objectArray[2] = "execute";
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        }, ResolveState.initial(), this, this);
    }

    @Override
    @Nullable
    public JSField findFieldByName(String name) {
        return this.initFields().get(name);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    protected final Map<String, JSField> initFields() {
        Map<String, JSField> name2FieldsMap = this.myName2FieldsMap;
        if (name2FieldsMap == null) {
            JSClassBase jSClassBase = this;
            synchronized (jSClassBase) {
                name2FieldsMap = this.myName2FieldsMap;
                if (name2FieldsMap == null) {
                    name2FieldsMap = new HashMap<String, JSField>();
                    for (JSField field : this.getFields()) {
                        String name = field.getName();
                        if (name != null) {
                            name2FieldsMap.put(name, field);
                        }
                        this.updateStateForField(field);
                    }
                    this.myName2FieldsMap = name2FieldsMap;
                }
            }
        }
        Map<String, JSField> map = name2FieldsMap;
        if (map == null) {
            JSClassBase.$$$reportNull$$$0(5);
        }
        return map;
    }

    protected Map<String, Object> getFunctionsMap() {
        return this.initFunctions();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    protected final Map<String, Object> initFunctions() {
        Map<String, Object> name2FunctionMap = this.myName2FunctionMap;
        if (name2FunctionMap == null) {
            JSClassBase jSClassBase = this;
            synchronized (jSClassBase) {
                name2FunctionMap = this.myName2FunctionMap;
                if (name2FunctionMap == null) {
                    name2FunctionMap = new HashMap<String, Object>();
                    for (JSFunction function2 : this.getFunctions()) {
                        String name = this.getMethodName(function2);
                        if (name != null) {
                            Object o = name2FunctionMap.get(name);
                            if (o == null) {
                                name2FunctionMap.put(name, function2);
                            } else if (o instanceof JSFunction) {
                                name2FunctionMap.put(name, new JSFunction[]{(JSFunction)o, function2});
                            } else if (o instanceof JSFunction[]) {
                                name2FunctionMap.put(name, ArrayUtil.append((Object[])((JSFunction[])o), (Object)function2));
                            }
                        }
                        this.updateStateForFunction(function2);
                    }
                    this.myName2FunctionMap = name2FunctionMap;
                }
            }
        }
        Map<String, Object> map = name2FunctionMap;
        if (map == null) {
            JSClassBase.$$$reportNull$$$0(6);
        }
        return map;
    }

    protected String getMethodName(@NotNull JSFunction function2) {
        if (function2 == null) {
            JSClassBase.$$$reportNull$$$0(7);
        }
        return function2.getName();
    }

    protected void updateStateForField(@NotNull JSField field) {
        if (field == null) {
            JSClassBase.$$$reportNull$$$0(8);
        }
    }

    protected void updateStateForFunction(@NotNull JSFunction function2) {
        if (function2 == null) {
            JSClassBase.$$$reportNull$$$0(9);
        }
    }

    @Override
    @Nullable
    public JSFunction findFunctionByNameAndKind(@Nullable String name, JSFunction.FunctionKind kind) {
        if (name == null) {
            return null;
        }
        Map<String, Object> name2FunctionMap = this.getFunctionsMap();
        Object o = name2FunctionMap.get(name);
        if (o instanceof JSFunction) {
            JSFunction function2 = (JSFunction)o;
            return function2.getKind() == kind ? function2 : null;
        }
        if (o instanceof JSFunction[]) {
            for (JSFunction fun : (JSFunction[])o) {
                if (fun.getKind() != kind) continue;
                return fun;
            }
        }
        return null;
    }

    @Override
    public JSClass @NotNull [] getSupers() {
        JSClass[] jSClassArray = (JSClass[])ArrayUtil.mergeArrays((Object[])this.getSuperClasses(), (Object[])this.getImplementedInterfaces());
        if (jSClassArray == null) {
            JSClassBase.$$$reportNull$$$0(10);
        }
        return jSClassArray;
    }

    @Override
    public String getName() {
        JSQualifiedStub classStub = (JSQualifiedStub)this.getGreenStub();
        if (classStub != null) {
            return classStub.getName();
        }
        PsiElement nameIdentifier = this.getNameIdentifier();
        if (nameIdentifier != null) {
            return JSPsiImplUtils.getNameFromIdentifier(nameIdentifier.getNode());
        }
        return null;
    }

    public PsiElement setName(@NotNull String newName) throws IncorrectOperationException {
        if (newName == null) {
            JSClassBase.$$$reportNull$$$0(11);
        }
        if (newName.equals(this.getName())) {
            return this;
        }
        PsiElement nameIdentifier = this.getNameIdentifier();
        if (nameIdentifier != null) {
            ASTNode newNameElement = JSChangeUtil.createPropertyNameWithContext(newName, nameIdentifier.getNode());
            if (newNameElement == null) {
                throw new IncorrectOperationException("Cannot set class name to " + newName);
            }
            nameIdentifier.replace(newNameElement.getPsi());
        }
        return this;
    }

    @Override
    @NonNls
    public String getQualifiedName() {
        return JSPsiImplUtils.buildQualifiedNameFromNamespaceAndName(this);
    }

    @Override
    public boolean useTypesFromJSDoc() {
        return true;
    }

    @Override
    @Nullable
    public JSQualifiedName getNamespace() {
        JSNamespace fromJSDoc;
        JSQualifiedStub stub = (JSQualifiedStub)this.getGreenStub();
        if (stub != null) {
            return stub.getNamespace();
        }
        JSNamespace jSNamespace = fromJSDoc = this.useTypesFromJSDoc() ? JSDocumentationUtils.getNamespaceFromJSDoc(this) : null;
        if (fromJSDoc != null) {
            return fromJSDoc.getQualifiedName();
        }
        return JSPsiImplUtils.getNamespace(this);
    }

    @Override
    public boolean isNamespaceExplicitlyDeclared() {
        return true;
    }

    @Override
    @Nullable
    public ASTNode findNameIdentifier() {
        return JSClassBase.findNameIdentifier(this.getNode());
    }

    public static ASTNode findNameIdentifier(ASTNode node) {
        JSQualifiedNamedElement initializedElement;
        ASTNode ownIdentifier = JSClassBase.findOwnNameIdentifier(node);
        if (ownIdentifier != null) {
            return ownIdentifier;
        }
        PsiElement psiElement = node.getPsi();
        if (psiElement instanceof JSClassExpression && (initializedElement = JSPsiImplUtils.getInitializedElement((JSExpression)psiElement)) != null) {
            return initializedElement.findNameIdentifier();
        }
        return null;
    }

    @Nullable
    public static ASTNode findOwnNameIdentifier(@NotNull ASTNode node) {
        ASTNode classKeyword;
        if (node == null) {
            JSClassBase.$$$reportNull$$$0(12);
        }
        if ((classKeyword = node.findChildByType(CLASS_KEYWORDS)) == null) {
            return null;
        }
        ASTNode name = TreeUtil.skipWhitespaceAndComments((ASTNode)classKeyword.getTreeNext(), (boolean)true);
        if (name == null) {
            return null;
        }
        IElementType nameElementType = name.getElementType();
        if (nameElementType == JSTokenTypes.IDENTIFIER) {
            return name;
        }
        if (nameElementType == JSTokenTypes.LBRACE) {
            return null;
        }
        if (nameElementType == JSElementTypes.REFERENCE_EXPRESSION) {
            nameElementType = null;
            if ((name = name.getTreeNext()) != null && name.getElementType() == JSTokenTypes.DOT && (name = name.getTreeNext()) != null) {
                nameElementType = name.getElementType();
            }
        }
        return JSPsiImplUtils.getIdentifiers(DialectDetector.dialectOfElement(node.getPsi())).contains(nameElementType) ? name : null;
    }

    @Override
    public JSAttributeList getAttributeList() {
        return JSUtils.getAttributeList(this);
    }

    @Override
    public boolean processDeclarations(@NotNull PsiScopeProcessor processor, @NotNull ResolveState substitutor, PsiElement lastParent, @NotNull PsiElement place) {
        boolean toProcessInHierarchy;
        boolean toProcessMembers;
        ResolveProcessor resolveProcessor;
        boolean toProcessClass;
        if (processor == null) {
            JSClassBase.$$$reportNull$$$0(13);
        }
        if (substitutor == null) {
            JSClassBase.$$$reportNull$$$0(14);
        }
        if (place == null) {
            JSClassBase.$$$reportNull$$$0(15);
        }
        if (((toProcessClass = this.needProcessClass(resolveProcessor = processor instanceof ResolveProcessor ? (ResolveProcessor)processor : null, place)) || lastParent == null) && !processor.execute((PsiElement)this, substitutor)) {
            return false;
        }
        if (lastParent == null) {
            return true;
        }
        processor.handleEvent(PsiScopeProcessor.Event.SET_DECLARATION_HOLDER, (Object)this);
        boolean bl = toProcessMembers = resolveProcessor == null || !resolveProcessor.isToSkipClassDeclarationOnce() && resolveProcessor.isToProcessMembers();
        if (toProcessMembers) {
            if (!this.processMembers(processor, substitutor, lastParent, place)) {
                return false;
            }
        } else {
            resolveProcessor.setToSkipClassDeclarationsOnce(false);
        }
        boolean bl2 = toProcessInHierarchy = processor instanceof ResolveProcessor && ((ResolveProcessor)processor).isToProcessHierarchy() && !JSUtils.isPrivateNameReference(place);
        if (!toProcessInHierarchy || ((ResolveProcessor)processor).checkVisited(this)) {
            return true;
        }
        JSClass[] superClasses = this.getSuperClassesForProcess(place);
        processor.handleEvent(ResolveProcessor.INHERITED_CLASSES_STARTED, (Object)this);
        for (JSClass clazz : superClasses) {
            if (clazz.processDeclarations(processor, substitutor, lastParent, place)) continue;
            return false;
        }
        processor.handleEvent(ResolveProcessor.INHERITED_CLASSES_FINISHED, (Object)this);
        return true;
    }

    protected JSClass[] getSuperClassesForProcess(@NotNull PsiElement place) {
        if (place == null) {
            JSClassBase.$$$reportNull$$$0(16);
        }
        return this.getSuperClasses();
    }

    protected boolean needProcessClass(@Nullable ResolveProcessor resolveProcessor, @Nullable PsiElement place) {
        return resolveProcessor != null && resolveProcessor.isTypeContext();
    }

    @Override
    public JSReferenceList getExtendsList() {
        return (JSReferenceList)this.getStubOrPsiChild(JSStubElementTypes.EXTENDS_LIST);
    }

    @Override
    public JSReferenceList getImplementsList() {
        return (JSReferenceList)this.getStubOrPsiChild(JSStubElementTypes.IMPLEMENTS_LIST);
    }

    protected boolean processMembers(PsiScopeProcessor processor, ResolveState substitutor, PsiElement lastParent, PsiElement place) {
        return JSResolveUtil.processDeclarationsInScope(this, processor, substitutor, lastParent, place);
    }

    @Override
    public JSClass @NotNull [] getSuperClasses() {
        JSClass[] jSClassArray = this.getClassesFromReferenceList(ListType.EXTEND);
        if (jSClassArray == null) {
            JSClassBase.$$$reportNull$$$0(17);
        }
        return jSClassArray;
    }

    protected Icon getBaseIcon() {
        JSIconProvider customIconProvider;
        PsiElement container = PsiTreeUtil.getContextOfType((PsiElement)this, (boolean)false, (Class[])new Class[]{PsiFile.class, JSEmbeddedContent.class});
        JSIconProvider iconProvider = JSIconProvider.DEFAULT_INSTANCE;
        if (container != null && (customIconProvider = (JSIconProvider)JSIconProvider.INSTANCE.forLanguage(container.getLanguage())) != null) {
            iconProvider = customIconProvider;
        }
        return this.isInterface() ? iconProvider.getInterfaceIcon() : iconProvider.getClassIcon();
    }

    @Nullable
    public Icon getIcon(int flags) {
        JSAttributeList attributeList = this.getAttributeList();
        Icon icon2 = this.isInterface() ? this.getBaseIcon() : JSStubElementImpl.blendModifierFlags(this.getBaseIcon(), attributeList, false, flags);
        Icon accessModifierIcon = JSVisibilityUtil.getAccessModifierIcon(this);
        return ElementBase.iconWithVisibilityIfNeeded((int)flags, (Icon)icon2, (Icon)accessModifierIcon);
    }

    @Override
    public JSClass @NotNull [] getImplementedInterfaces() {
        JSClass[] jSClassArray = this.getClassesFromReferenceList(ListType.IMPLEMENTS);
        if (jSClassArray == null) {
            JSClassBase.$$$reportNull$$$0(18);
        }
        return jSClassArray;
    }

    @Override
    public JSFunction getConstructor() {
        return this.findFunctionByName(ES6_CONSTRUCTOR);
    }

    public PsiElement getNameIdentifier() {
        ASTNode node = this.findNameIdentifier();
        return node != null ? node.getPsi() : null;
    }

    @NotNull
    private List<JSClass> computeExtendsClasses() {
        JSReferenceList extendsList = this.getExtendsList();
        if (extendsList == null) {
            if (!"Object".equals(this.getQualifiedName())) {
                if (DialectDetector.isTypeScript(this)) {
                    List<JSClass> list2 = TypeScriptClassResolver.getInstance().findObjectClasses(this);
                    if (list2 == null) {
                        JSClassBase.$$$reportNull$$$0(19);
                    }
                    return list2;
                }
                PsiElement element = JSClassResolver.findClassFromNamespace("Object", this);
                if (element instanceof JSClass) {
                    List<JSClass> list3 = Collections.singletonList((JSClass)element);
                    if (list3 == null) {
                        JSClassBase.$$$reportNull$$$0(20);
                    }
                    return list3;
                }
            }
            List<JSClass> list4 = Collections.emptyList();
            if (list4 == null) {
                JSClassBase.$$$reportNull$$$0(21);
            }
            return list4;
        }
        List<JSClass> list5 = Arrays.asList(extendsList.getReferencedClasses());
        if (list5 == null) {
            JSClassBase.$$$reportNull$$$0(22);
        }
        return list5;
    }

    @NotNull
    private List<JSClass> computeImplementsClasses() {
        PsiElement element;
        ArrayList<JSClass> clazzList = new ArrayList<JSClass>();
        JSReferenceList implementsList = this.getImplementsList();
        if (implementsList != null) {
            Collections.addAll(clazzList, implementsList.getReferencedClasses());
        }
        if (ActionScriptClassBase.isImplicitlyDeclaringEventDispatcher(this) && (element = JSClassResolver.findClassFromNamespace("flash.events.IEventDispatcher", this)) instanceof JSClass && !clazzList.contains(element)) {
            clazzList.add((JSClass)element);
        }
        ArrayList<JSClass> arrayList = clazzList;
        if (arrayList == null) {
            JSClassBase.$$$reportNull$$$0(23);
        }
        return arrayList;
    }

    private JSClass[] getClassesFromReferenceList(final ListType type2) {
        CachedValueProvider provider = () -> CachedValueProvider.Result.create((Object)new JSInheritanceUtil.CacheByEnforcedResolveScope<JSClass[]>(){

            @Override
            protected JSClass[] computeForScope(@Nullable GlobalSearchScope scope2) {
                return (type2 == ListType.EXTEND ? JSClassBase.this.computeExtendsClasses() : JSClassBase.this.computeImplementsClasses()).toArray(JSClass.EMPTY_ARRAY);
            }
        }, (Object[])new Object[]{PsiModificationTracker.MODIFICATION_COUNT});
        return (JSClass[])((JSClass[])((JSInheritanceUtil.CacheByEnforcedResolveScope)CachedValuesManager.getCachedValue((PsiElement)this, type2.cacheKey, (CachedValueProvider)provider)).compute()).clone();
    }

    protected <E extends PsiElement> E @NotNull [] getStubChildrenByType(StubElement<?> stub, ArrayFactory<? extends E> f, TokenSet set) {
        PsiElement[] psiElementArray = stub.getChildrenByType(set, f);
        if (psiElementArray == null) {
            JSClassBase.$$$reportNull$$$0(24);
        }
        return psiElementArray;
    }

    @Override
    @NotNull
    public JSAttributeList.AccessType getAccessType() {
        JSAttributeList list2 = this.getAttributeList();
        JSAttributeList.AccessType accessType = list2 != null ? list2.getAccessType() : JSAttributeList.AccessType.PACKAGE_LOCAL;
        if (accessType == null) {
            JSClassBase.$$$reportNull$$$0(25);
        }
        return accessType;
    }

    @Override
    @NotNull
    public JSContext getJSContext() {
        JSContext jSContext = JSContext.UNKNOWN;
        if (jSContext == null) {
            JSClassBase.$$$reportNull$$$0(26);
        }
        return jSContext;
    }

    @Override
    @NotNull
    public JSElementBase.ClassOrInterface isClassOrInterface() {
        JSElementBase.ClassOrInterface classOrInterface = JSElementBase.ClassOrInterface.CLASS;
        if (classOrInterface == null) {
            JSClassBase.$$$reportNull$$$0(27);
        }
        return classOrInterface;
    }

    @Override
    @NotNull
    public JSType getJSType() {
        return this.getType(false);
    }

    @Override
    public JSType getStaticJSType() {
        return this.getType(true);
    }

    @NotNull
    private JSType getType(boolean isStatic) {
        String qName = this.getName();
        JSTypeSource typeSource = JSTypeSourceFactory.createTypeSource(this, true);
        if (StringUtil.isEmpty((String)qName)) {
            JSRecordType jSRecordType = TypeScriptTypeParser.buildTypeFromClass(this, isStatic);
            if (jSRecordType == null) {
                JSClassBase.$$$reportNull$$$0(28);
            }
            return jSRecordType;
        }
        JSType jSType = JSNamedTypeFactory.createType(qName, typeSource, isStatic ? JSTypeContext.STATIC : JSTypeContext.INSTANCE, false);
        if (jSType == null) {
            JSClassBase.$$$reportNull$$$0(29);
        }
        return jSType;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 1, 2, 3, 4, 5, 6, 10, 17, 18, 19, 20, 21, 22, 23, 24, 25, 26, 27, 28, 29 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "visitor";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 10: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 26: 
            case 27: 
            case 28: 
            case 29: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/javascript/psi/ecmal4/impl/JSClassBase";
                break;
            }
            case 7: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "function";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "field";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "newName";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "node";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "processor";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "substitutor";
                break;
            }
            case 15: 
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "place";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/javascript/psi/ecmal4/impl/JSClassBase";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getFunctions";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getFields";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getMembers";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "initFields";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "initFunctions";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "getSupers";
                break;
            }
            case 17: {
                objectArray = objectArray2;
                objectArray2[1] = "getSuperClasses";
                break;
            }
            case 18: {
                objectArray = objectArray2;
                objectArray2[1] = "getImplementedInterfaces";
                break;
            }
            case 19: 
            case 20: 
            case 21: 
            case 22: {
                objectArray = objectArray2;
                objectArray2[1] = "computeExtendsClasses";
                break;
            }
            case 23: {
                objectArray = objectArray2;
                objectArray2[1] = "computeImplementsClasses";
                break;
            }
            case 24: {
                objectArray = objectArray2;
                objectArray2[1] = "getStubChildrenByType";
                break;
            }
            case 25: {
                objectArray = objectArray2;
                objectArray2[1] = "getAccessType";
                break;
            }
            case 26: {
                objectArray = objectArray2;
                objectArray2[1] = "getJSContext";
                break;
            }
            case 27: {
                objectArray = objectArray2;
                objectArray2[1] = "isClassOrInterface";
                break;
            }
            case 28: 
            case 29: {
                objectArray = objectArray2;
                objectArray2[1] = "getType";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "accept";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 10: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 26: 
            case 27: 
            case 28: 
            case 29: {
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "getMethodName";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "updateStateForField";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "updateStateForFunction";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "setName";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "findOwnNameIdentifier";
                break;
            }
            case 13: 
            case 14: 
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "processDeclarations";
                break;
            }
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "getSuperClassesForProcess";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 1, 2, 3, 4, 5, 6, 10, 17, 18, 19, 20, 21, 22, 23, 24, 25, 26, 27, 28, 29 -> new IllegalStateException(string);
        };
    }

    private static enum ListType {
        EXTEND,
        IMPLEMENTS;

        Key<CachedValue<JSInheritanceUtil.CacheByEnforcedResolveScope<JSClass[]>>> cacheKey = Key.create((String)this.toString());
    }
}

