/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.performanceTesting;

import com.intellij.lang.javascript.DialectDetector;
import com.intellij.lang.javascript.dialects.JSLanguageLevel;
import com.intellij.lang.javascript.flow.FlowJSGoToDeclaration;
import com.intellij.lang.javascript.flow.FlowJSServerManager;
import com.intellij.lang.javascript.flow.FlowJSServerService;
import com.intellij.lang.javascript.flow.FlowJSSettings;
import com.intellij.lang.javascript.flow.FlowJSSettingsManager;
import com.intellij.lang.javascript.performanceTesting.JSResolveReferencesCommandBase;
import com.intellij.lang.javascript.psi.JSReferenceExpression;
import com.intellij.lang.javascript.psi.resolve.JSResolveResult;
import com.intellij.lang.javascript.settings.JSRootConfiguration;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.WriteAction;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectUtil;
import com.intellij.openapi.ui.playback.PlaybackContext;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.ResolveResult;
import java.io.IOException;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.concurrency.AsyncPromise;
import org.jetbrains.concurrency.Promise;
import org.jetbrains.concurrency.Promises;

public class JSResolveReferencesUsingFlowCommand
extends JSResolveReferencesCommandBase {
    public static final String PREFIX = "%jsResolveReferencesUsingFlow";
    private static final String FLOW_EXECUTABLE_ENV = "FLOW_JS_EXECUTABLE";

    public JSResolveReferencesUsingFlowCommand(@NotNull String text2, int line) {
        if (text2 == null) {
            JSResolveReferencesUsingFlowCommand.$$$reportNull$$$0(0);
        }
        super(text2, line);
    }

    @Override
    @NotNull
    protected Promise<Object> _execute(@NotNull PlaybackContext context2) {
        String pathToFlow;
        if (context2 == null) {
            JSResolveReferencesUsingFlowCommand.$$$reportNull$$$0(1);
        }
        if ((pathToFlow = System.getenv(FLOW_EXECUTABLE_ENV)) == null) {
            Promise promise = Promises.rejectedPromise((String)"$FLOW_JS_EXECUTABLE is not specified");
            if (promise == null) {
                JSResolveReferencesUsingFlowCommand.$$$reportNull$$$0(2);
            }
            return promise;
        }
        @NotNull Project project = context2.getProject();
        String error = (String)WriteAction.computeAndWait(() -> {
            VirtualFile root = ProjectUtil.guessProjectDir((Project)project);
            if (root == null) {
                return "Can't find project root";
            }
            VirtualFile flowConfig = root.findChild(".flowconfig");
            if (flowConfig == null) {
                try {
                    root.createChildData((Object)project, ".flowconfig");
                }
                catch (IOException e) {
                    return e.toString();
                }
            }
            JSRootConfiguration.getInstance(project).storeLanguageLevelAndUpdateCaches(JSLanguageLevel.FLOW);
            FlowJSSettings settings2 = new FlowJSSettings();
            settings2.setFlowPath(pathToFlow);
            FlowJSSettingsManager.getInstance(project).loadState(settings2);
            return null;
        });
        if (error != null) {
            Promise promise = Promises.rejectedPromise((String)error);
            if (promise == null) {
                JSResolveReferencesUsingFlowCommand.$$$reportNull$$$0(3);
            }
            return promise;
        }
        AsyncPromise result2 = new AsyncPromise();
        DumbService.getInstance((Project)project).smartInvokeLater(() -> ApplicationManager.getApplication().executeOnPooledThread(() -> result2.setResult(null)));
        Promise promise = result2.thenAsync(it -> super._execute(context2));
        if (promise == null) {
            JSResolveReferencesUsingFlowCommand.$$$reportNull$$$0(4);
        }
        return promise;
    }

    @Override
    protected ResolveResult @NotNull [] getResolveResults(@NotNull JSReferenceExpression node) {
        Document document2;
        if (node == null) {
            JSResolveReferencesUsingFlowCommand.$$$reportNull$$$0(5);
        }
        if ((document2 = PsiDocumentManager.getInstance((Project)node.getProject()).getDocument(node.getContainingFile())) == null) {
            if (ResolveResult.EMPTY_ARRAY == null) {
                JSResolveReferencesUsingFlowCommand.$$$reportNull$$$0(6);
            }
            return ResolveResult.EMPTY_ARRAY;
        }
        if (DialectDetector.isJavaScript((PsiElement)node) && !DialectDetector.isFlow((PsiElement)node)) {
            Logger.getInstance(JSResolveReferencesUsingFlowCommand.class).error("Failed to switch language version to Flow for file " + node.getContainingFile().getName());
        }
        JSResolveReferencesUsingFlowCommand.waitForService(node.getContainingFile());
        PsiElement element = FlowJSGoToDeclaration.getGotoDeclarationTarget(node.getReferenceNameElement(), document2);
        if (element == null) {
            if (ResolveResult.EMPTY_ARRAY == null) {
                JSResolveReferencesUsingFlowCommand.$$$reportNull$$$0(7);
            }
            return ResolveResult.EMPTY_ARRAY;
        }
        JSResolveResult result2 = new JSResolveResult(element);
        ResolveResult[] resolveResultArray = new ResolveResult[]{result2};
        if (resolveResultArray == null) {
            JSResolveReferencesUsingFlowCommand.$$$reportNull$$$0(8);
        }
        return resolveResultArray;
    }

    private static void waitForService(@NotNull PsiFile file) {
        if (file == null) {
            JSResolveReferencesUsingFlowCommand.$$$reportNull$$$0(9);
        }
        FlowJSServerService service2 = FlowJSServerManager.getService(file, false);
        while (service2 != null && service2.checkCanUseService() && !service2.isServiceStarted()) {
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException e) {
                throw new RuntimeException(e.getMessage(), e);
            }
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 2, 3, 4, 6, 7, 8 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "text";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 6: 
            case 7: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/javascript/performanceTesting/JSResolveReferencesUsingFlowCommand";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "node";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/javascript/performanceTesting/JSResolveReferencesUsingFlowCommand";
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "_execute";
                break;
            }
            case 6: 
            case 7: 
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getResolveResults";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "_execute";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 6: 
            case 7: 
            case 8: {
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "getResolveResults";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "waitForService";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 2, 3, 4, 6, 7, 8 -> new IllegalStateException(string);
        };
    }
}

