/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.performanceTesting;

import com.intellij.lang.javascript.index.JavaScriptIndex;
import com.intellij.lang.javascript.library.JSCorePredefinedLibrariesProvider;
import com.intellij.lang.javascript.performanceTesting.VirtualFilesVisitorCommand;
import com.intellij.lang.javascript.psi.JSRecursiveWalkingElementVisitor;
import com.intellij.lang.javascript.psi.JSReferenceExpression;
import com.intellij.lang.javascript.psi.impl.JSReferenceExpressionImpl;
import com.intellij.lang.javascript.psi.resolve.JSResolveResult;
import com.intellij.lang.javascript.psi.resolve.JSResolveUtil;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.playback.PlaybackContext;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.ResolveResult;
import com.intellij.psi.impl.FakePsiElement;
import com.intellij.psi.impl.light.LightElement;
import java.util.Arrays;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public abstract class JSResolveReferencesCommandBase
extends VirtualFilesVisitorCommand {
    public JSResolveReferencesCommandBase(@NotNull String text2, int line) {
        if (text2 == null) {
            JSResolveReferencesCommandBase.$$$reportNull$$$0(0);
        }
        super(text2, line);
    }

    @Override
    protected boolean isContentOnly() {
        return true;
    }

    @Override
    protected boolean isAcceptable(@NotNull VirtualFile file) {
        if (file == null) {
            JSResolveReferencesCommandBase.$$$reportNull$$$0(1);
        }
        return JavaScriptIndex.isAcceptableFile(file) && !"coffee".equalsIgnoreCase(file.getExtension());
    }

    @Override
    @NotNull
    protected Runnable createTask(@NotNull List<VirtualFile> files, @NotNull VirtualFile root, @NotNull PlaybackContext context2) {
        if (files == null) {
            JSResolveReferencesCommandBase.$$$reportNull$$$0(2);
        }
        if (root == null) {
            JSResolveReferencesCommandBase.$$$reportNull$$$0(3);
        }
        if (context2 == null) {
            JSResolveReferencesCommandBase.$$$reportNull$$$0(4);
        }
        return new JSResolveReferencesTask(files, root, context2);
    }

    protected abstract ResolveResult @NotNull [] getResolveResults(@NotNull JSReferenceExpression var1);

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "text";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "files";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "root";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
        }
        objectArray2[1] = "com/intellij/lang/javascript/performanceTesting/JSResolveReferencesCommandBase";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "isAcceptable";
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "createTask";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    private final class JSResolveReferencesTask
    implements Runnable {
        @NotNull
        private final List<VirtualFile> myFiles;
        @NotNull
        private final VirtualFile myRoot;
        @NotNull
        private final PlaybackContext myContext;

        private JSResolveReferencesTask(@NotNull List<VirtualFile> files, @NotNull VirtualFile root, PlaybackContext context2) {
            if (files == null) {
                JSResolveReferencesTask.$$$reportNull$$$0(0);
            }
            if (root == null) {
                JSResolveReferencesTask.$$$reportNull$$$0(1);
            }
            if (context2 == null) {
                JSResolveReferencesTask.$$$reportNull$$$0(2);
            }
            this.myFiles = files;
            this.myRoot = root;
            this.myContext = context2;
        }

        @Override
        public void run() {
            ReadAction.run(() -> {
                for (VirtualFile file : this.myFiles) {
                    Document document2;
                    PsiFile psiFile;
                    final String path2 = VfsUtilCore.getRelativePath((VirtualFile)file, (VirtualFile)this.myRoot, (char)'/');
                    if (path2 == null || (psiFile = PsiManager.getInstance((Project)this.myContext.getProject()).findFile(file)) == null || (document2 = FileDocumentManager.getInstance().getDocument(file)) == null) continue;
                    new JSRecursiveWalkingElementVisitor(){

                        @Override
                        public void visitJSReferenceExpression(@NotNull JSReferenceExpression node) {
                            if (node == null) {
                                1.$$$reportNull$$$0(0);
                            }
                            if (!1.isAcceptableReference(node)) {
                                super.visitJSReferenceExpression(node);
                                return;
                            }
                            ResolveResult[] results = JSResolveReferencesCommandBase.this.getResolveResults(node);
                            int offset = node.getTextRange().getStartOffset() + node.getRangeInElement().getStartOffset();
                            int lineNumber = document2.getLineNumber(offset);
                            int offsetInLine = offset - document2.getLineStartOffset(lineNumber);
                            String result2 = JSResolveResult.isTooManyCandidatesResult(results) ? "too many candidates" : (Arrays.stream(results).noneMatch(ResolveResult::isValidResult) ? "unresolved" : (results.length > 1 ? "several results (" + results.length + ")" : JSResolveReferencesTask.this.formatUniqueValidResult(results[0].getElement())));
                            String message = String.format("jsref: %s:%d:%d %s -> %s", path2, lineNumber, offsetInLine, node.getReferenceName(), result2);
                            JSResolveReferencesTask.this.myContext.message(message, -1);
                            super.visitJSReferenceExpression(node);
                        }

                        private static boolean isAcceptableReference(JSReferenceExpression node) {
                            return node.getClass().equals(JSReferenceExpressionImpl.class) && !JSResolveUtil.isSelfReference((PsiElement)node);
                        }

                        private static /* synthetic */ void $$$reportNull$$$0(int n) {
                            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "node", "com/intellij/lang/javascript/performanceTesting/JSResolveReferencesCommandBase$JSResolveReferencesTask$1", "visitJSReferenceExpression"));
                        }
                    }.visitElement((PsiElement)psiFile);
                }
            });
        }

        private String formatUniqueValidResult(PsiElement element) {
            if (element == null) {
                return "unknown";
            }
            VirtualFile resolveFile = element.getContainingFile().getVirtualFile();
            if (resolveFile == null) {
                return "unknown";
            }
            Document resolveDocument = FileDocumentManager.getInstance().getDocument(resolveFile);
            if (resolveDocument == null) {
                return "unknown";
            }
            int offset = element.getTextOffset();
            if (offset == -1 || element instanceof FakePsiElement || element instanceof LightElement) {
                return "unknown";
            }
            int lineNumber = resolveDocument.getLineNumber(offset);
            int offsetInLine = offset - resolveDocument.getLineStartOffset(lineNumber);
            String relativePath = VfsUtilCore.getRelativePath((VirtualFile)resolveFile, (VirtualFile)this.myRoot, (char)'/');
            if (relativePath == null && JSCorePredefinedLibrariesProvider.isCoreLibraryFile(resolveFile)) {
                relativePath = resolveFile.getName();
            }
            if (relativePath == null) {
                return "unknown";
            }
            return String.format("%s:%d:%d", relativePath, lineNumber, offsetInLine);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "files";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "root";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[0] = "context";
                    break;
                }
            }
            objectArray[1] = "com/intellij/lang/javascript/performanceTesting/JSResolveReferencesCommandBase$JSResolveReferencesTask";
            objectArray[2] = "<init>";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

