/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.performanceTesting;

import com.intellij.lang.Language;
import com.intellij.lang.javascript.DialectDetector;
import com.intellij.lang.javascript.JSLanguageDialect;
import com.intellij.lang.javascript.dialects.JSLanguageLevel;
import com.intellij.lang.javascript.index.JavaScriptIndex;
import com.intellij.lang.javascript.performanceTesting.JSCompareParsersCommand;
import com.intellij.lang.javascript.performanceTesting.VirtualFilesVisitorCommand;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.playback.PlaybackContext;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiErrorElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiFileFactory;
import com.intellij.psi.util.PsiTreeUtil;
import java.util.List;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

public class JSCheckParseErrorsCommand
extends VirtualFilesVisitorCommand {
    @NonNls
    public static final String PREFIX = "%jsCheckParseErrors";

    public JSCheckParseErrorsCommand(@NotNull String text2, int line) {
        if (text2 == null) {
            JSCheckParseErrorsCommand.$$$reportNull$$$0(0);
        }
        super(text2, line);
    }

    @Override
    protected boolean isAcceptable(@NotNull VirtualFile file) {
        if (file == null) {
            JSCheckParseErrorsCommand.$$$reportNull$$$0(1);
        }
        return JavaScriptIndex.isAcceptableFile(file) && DialectDetector.JAVASCRIPT_FILE_TYPES.contains(file.getFileType());
    }

    @Override
    @NotNull
    protected Runnable createTask(@NotNull List<VirtualFile> files, @NotNull VirtualFile root, @NotNull PlaybackContext context2) {
        if (files == null) {
            JSCheckParseErrorsCommand.$$$reportNull$$$0(2);
        }
        if (root == null) {
            JSCheckParseErrorsCommand.$$$reportNull$$$0(3);
        }
        if (context2 == null) {
            JSCheckParseErrorsCommand.$$$reportNull$$$0(4);
        }
        Runnable runnable = () -> {
            for (VirtualFile file : files) {
                try {
                    JSCheckParseErrorsCommand.reportParseErrorCount(file, root, context2);
                }
                catch (Exception e) {
                    Logger.getInstance(JSCompareParsersCommand.class).error("Failed to process " + file.getPath(), (Throwable)e);
                }
            }
        };
        if (runnable == null) {
            JSCheckParseErrorsCommand.$$$reportNull$$$0(5);
        }
        return runnable;
    }

    private static void reportParseErrorCount(@NotNull VirtualFile file, @NotNull VirtualFile root, @NotNull PlaybackContext context2) throws Exception {
        PsiFileFactory fileFactory;
        PsiFile psiFile;
        Integer errors;
        String path2;
        if (file == null) {
            JSCheckParseErrorsCommand.$$$reportNull$$$0(6);
        }
        if (root == null) {
            JSCheckParseErrorsCommand.$$$reportNull$$$0(7);
        }
        if (context2 == null) {
            JSCheckParseErrorsCommand.$$$reportNull$$$0(8);
        }
        if ((path2 = VfsUtilCore.getRelativePath((VirtualFile)file, (VirtualFile)root, (char)'/')) == null) {
            return;
        }
        String code = VfsUtilCore.loadText((VirtualFile)file);
        Project project = context2.getProject();
        JSLanguageDialect dialect = (JSLanguageDialect)((Object)ReadAction.compute(() -> DialectDetector.getLanguageDialect(file, project)));
        if (dialect == null) {
            dialect = JSLanguageLevel.DEFAULT.getDialect();
        }
        if ((errors = (Integer)ReadAction.compute(() -> JSCheckParseErrorsCommand.lambda$reportParseErrorCount$2(psiFile = (fileFactory = PsiFileFactory.getInstance((Project)project)).createFileFromText("js.js", (Language)dialect, (CharSequence)code, false, false)))) != null && errors > 0) {
            String message = String.format("js-parse-errors: %s -> %d", path2, (int)errors);
            context2.message(message, -1);
        }
    }

    private static /* synthetic */ Integer lambda$reportParseErrorCount$2(PsiFile psiFile) throws RuntimeException {
        return PsiTreeUtil.collectElementsOfType((PsiElement)psiFile, (Class[])new Class[]{PsiErrorElement.class}).size();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 5 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "text";
                break;
            }
            case 1: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "files";
                break;
            }
            case 3: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "root";
                break;
            }
            case 4: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/javascript/performanceTesting/JSCheckParseErrorsCommand";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/javascript/performanceTesting/JSCheckParseErrorsCommand";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "createTask";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "isAcceptable";
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "createTask";
                break;
            }
            case 5: {
                break;
            }
            case 6: 
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "reportParseErrorCount";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 5 -> new IllegalStateException(string);
        };
    }
}

